package software.amazon.awscdk.services.connect;

/**
 * Properties for defining a `CfnUser`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.connect.*;
 * CfnUserProps cfnUserProps = CfnUserProps.builder()
 *         .instanceArn("instanceArn")
 *         .phoneConfig(UserPhoneConfigProperty.builder()
 *                 .phoneType("phoneType")
 *                 // the properties below are optional
 *                 .afterContactWorkTimeLimit(123)
 *                 .autoAccept(false)
 *                 .deskPhoneNumber("deskPhoneNumber")
 *                 .build())
 *         .routingProfileArn("routingProfileArn")
 *         .securityProfileArns(List.of("securityProfileArns"))
 *         .username("username")
 *         // the properties below are optional
 *         .directoryUserId("directoryUserId")
 *         .hierarchyGroupArn("hierarchyGroupArn")
 *         .identityInfo(UserIdentityInfoProperty.builder()
 *                 .email("email")
 *                 .firstName("firstName")
 *                 .lastName("lastName")
 *                 .build())
 *         .password("password")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-08-02T19:51:57.471Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnUserProps")
@software.amazon.jsii.Jsii.Proxy(CfnUserProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnUserProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Amazon Resource Name (ARN) of the instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getInstanceArn();

    /**
     * Information about the phone configuration for the user.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getPhoneConfig();

    /**
     * The Amazon Resource Name (ARN) of the user's routing profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRoutingProfileArn();

    /**
     * The Amazon Resource Name (ARN) of the user's security profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSecurityProfileArns();

    /**
     * The user name assigned to the user account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getUsername();

    /**
     * The identifier of the user account in the directory used for identity management.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDirectoryUserId() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the user's hierarchy group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getHierarchyGroupArn() {
        return null;
    }

    /**
     * Information about the user identity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getIdentityInfo() {
        return null;
    }

    /**
     * The user's password.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPassword() {
        return null;
    }

    /**
     * The tags.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnUserProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnUserProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnUserProps> {
        java.lang.String instanceArn;
        java.lang.Object phoneConfig;
        java.lang.String routingProfileArn;
        java.util.List<java.lang.String> securityProfileArns;
        java.lang.String username;
        java.lang.String directoryUserId;
        java.lang.String hierarchyGroupArn;
        java.lang.Object identityInfo;
        java.lang.String password;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnUserProps#getInstanceArn}
         * @param instanceArn The Amazon Resource Name (ARN) of the instance. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceArn(java.lang.String instanceArn) {
            this.instanceArn = instanceArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserProps#getPhoneConfig}
         * @param phoneConfig Information about the phone configuration for the user. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder phoneConfig(software.amazon.awscdk.services.connect.CfnUser.UserPhoneConfigProperty phoneConfig) {
            this.phoneConfig = phoneConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserProps#getPhoneConfig}
         * @param phoneConfig Information about the phone configuration for the user. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder phoneConfig(software.amazon.awscdk.IResolvable phoneConfig) {
            this.phoneConfig = phoneConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserProps#getRoutingProfileArn}
         * @param routingProfileArn The Amazon Resource Name (ARN) of the user's routing profile. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routingProfileArn(java.lang.String routingProfileArn) {
            this.routingProfileArn = routingProfileArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserProps#getSecurityProfileArns}
         * @param securityProfileArns The Amazon Resource Name (ARN) of the user's security profile. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityProfileArns(java.util.List<java.lang.String> securityProfileArns) {
            this.securityProfileArns = securityProfileArns;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserProps#getUsername}
         * @param username The user name assigned to the user account. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder username(java.lang.String username) {
            this.username = username;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserProps#getDirectoryUserId}
         * @param directoryUserId The identifier of the user account in the directory used for identity management.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder directoryUserId(java.lang.String directoryUserId) {
            this.directoryUserId = directoryUserId;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserProps#getHierarchyGroupArn}
         * @param hierarchyGroupArn The Amazon Resource Name (ARN) of the user's hierarchy group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hierarchyGroupArn(java.lang.String hierarchyGroupArn) {
            this.hierarchyGroupArn = hierarchyGroupArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserProps#getIdentityInfo}
         * @param identityInfo Information about the user identity.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identityInfo(software.amazon.awscdk.services.connect.CfnUser.UserIdentityInfoProperty identityInfo) {
            this.identityInfo = identityInfo;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserProps#getIdentityInfo}
         * @param identityInfo Information about the user identity.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identityInfo(software.amazon.awscdk.IResolvable identityInfo) {
            this.identityInfo = identityInfo;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserProps#getPassword}
         * @param password The user's password.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder password(java.lang.String password) {
            this.password = password;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserProps#getTags}
         * @param tags The tags.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnUserProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnUserProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnUserProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnUserProps {
        private final java.lang.String instanceArn;
        private final java.lang.Object phoneConfig;
        private final java.lang.String routingProfileArn;
        private final java.util.List<java.lang.String> securityProfileArns;
        private final java.lang.String username;
        private final java.lang.String directoryUserId;
        private final java.lang.String hierarchyGroupArn;
        private final java.lang.Object identityInfo;
        private final java.lang.String password;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.instanceArn = software.amazon.jsii.Kernel.get(this, "instanceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.phoneConfig = software.amazon.jsii.Kernel.get(this, "phoneConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.routingProfileArn = software.amazon.jsii.Kernel.get(this, "routingProfileArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.securityProfileArns = software.amazon.jsii.Kernel.get(this, "securityProfileArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.username = software.amazon.jsii.Kernel.get(this, "username", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.directoryUserId = software.amazon.jsii.Kernel.get(this, "directoryUserId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.hierarchyGroupArn = software.amazon.jsii.Kernel.get(this, "hierarchyGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.identityInfo = software.amazon.jsii.Kernel.get(this, "identityInfo", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.password = software.amazon.jsii.Kernel.get(this, "password", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.instanceArn = java.util.Objects.requireNonNull(builder.instanceArn, "instanceArn is required");
            this.phoneConfig = java.util.Objects.requireNonNull(builder.phoneConfig, "phoneConfig is required");
            this.routingProfileArn = java.util.Objects.requireNonNull(builder.routingProfileArn, "routingProfileArn is required");
            this.securityProfileArns = java.util.Objects.requireNonNull(builder.securityProfileArns, "securityProfileArns is required");
            this.username = java.util.Objects.requireNonNull(builder.username, "username is required");
            this.directoryUserId = builder.directoryUserId;
            this.hierarchyGroupArn = builder.hierarchyGroupArn;
            this.identityInfo = builder.identityInfo;
            this.password = builder.password;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getInstanceArn() {
            return this.instanceArn;
        }

        @Override
        public final java.lang.Object getPhoneConfig() {
            return this.phoneConfig;
        }

        @Override
        public final java.lang.String getRoutingProfileArn() {
            return this.routingProfileArn;
        }

        @Override
        public final java.util.List<java.lang.String> getSecurityProfileArns() {
            return this.securityProfileArns;
        }

        @Override
        public final java.lang.String getUsername() {
            return this.username;
        }

        @Override
        public final java.lang.String getDirectoryUserId() {
            return this.directoryUserId;
        }

        @Override
        public final java.lang.String getHierarchyGroupArn() {
            return this.hierarchyGroupArn;
        }

        @Override
        public final java.lang.Object getIdentityInfo() {
            return this.identityInfo;
        }

        @Override
        public final java.lang.String getPassword() {
            return this.password;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("instanceArn", om.valueToTree(this.getInstanceArn()));
            data.set("phoneConfig", om.valueToTree(this.getPhoneConfig()));
            data.set("routingProfileArn", om.valueToTree(this.getRoutingProfileArn()));
            data.set("securityProfileArns", om.valueToTree(this.getSecurityProfileArns()));
            data.set("username", om.valueToTree(this.getUsername()));
            if (this.getDirectoryUserId() != null) {
                data.set("directoryUserId", om.valueToTree(this.getDirectoryUserId()));
            }
            if (this.getHierarchyGroupArn() != null) {
                data.set("hierarchyGroupArn", om.valueToTree(this.getHierarchyGroupArn()));
            }
            if (this.getIdentityInfo() != null) {
                data.set("identityInfo", om.valueToTree(this.getIdentityInfo()));
            }
            if (this.getPassword() != null) {
                data.set("password", om.valueToTree(this.getPassword()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnUserProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnUserProps.Jsii$Proxy that = (CfnUserProps.Jsii$Proxy) o;

            if (!instanceArn.equals(that.instanceArn)) return false;
            if (!phoneConfig.equals(that.phoneConfig)) return false;
            if (!routingProfileArn.equals(that.routingProfileArn)) return false;
            if (!securityProfileArns.equals(that.securityProfileArns)) return false;
            if (!username.equals(that.username)) return false;
            if (this.directoryUserId != null ? !this.directoryUserId.equals(that.directoryUserId) : that.directoryUserId != null) return false;
            if (this.hierarchyGroupArn != null ? !this.hierarchyGroupArn.equals(that.hierarchyGroupArn) : that.hierarchyGroupArn != null) return false;
            if (this.identityInfo != null ? !this.identityInfo.equals(that.identityInfo) : that.identityInfo != null) return false;
            if (this.password != null ? !this.password.equals(that.password) : that.password != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.instanceArn.hashCode();
            result = 31 * result + (this.phoneConfig.hashCode());
            result = 31 * result + (this.routingProfileArn.hashCode());
            result = 31 * result + (this.securityProfileArns.hashCode());
            result = 31 * result + (this.username.hashCode());
            result = 31 * result + (this.directoryUserId != null ? this.directoryUserId.hashCode() : 0);
            result = 31 * result + (this.hierarchyGroupArn != null ? this.hierarchyGroupArn.hashCode() : 0);
            result = 31 * result + (this.identityInfo != null ? this.identityInfo.hashCode() : 0);
            result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
