package software.amazon.awscdk.services.cognito;

/**
 * Define a UserPool App Client.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * UserPool pool = new UserPool(this, "Pool");
 * UserPoolIdentityProviderAmazon provider = UserPoolIdentityProviderAmazon.Builder.create(this, "Amazon")
 *         .userPool(pool)
 *         .clientId("amzn-client-id")
 *         .clientSecret("amzn-client-secret")
 *         .build();
 * UserPoolClient client = pool.addClient("app-client", UserPoolClientOptions.builder()
 *         // ...
 *         .supportedIdentityProviders(List.of(UserPoolClientIdentityProvider.AMAZON))
 *         .build());
 * client.node.addDependency(provider);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-08-02T19:51:57.389Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.UserPoolClient")
public class UserPoolClient extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.cognito.IUserPoolClient {

    protected UserPoolClient(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected UserPoolClient(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public UserPoolClient(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.UserPoolClientProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Import a user pool client given its id.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param userPoolClientId This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.IUserPoolClient fromUserPoolClientId(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String userPoolClientId) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cognito.UserPoolClient.class, "fromUserPoolClientId", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.IUserPoolClient.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(userPoolClientId, "userPoolClientId is required") });
    }

    /**
     * The OAuth flows enabled for this client.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.OAuthFlows getOAuthFlows() {
        return software.amazon.jsii.Kernel.get(this, "oAuthFlows", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.OAuthFlows.class));
    }

    /**
     * Name of the application client.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getUserPoolClientId() {
        return software.amazon.jsii.Kernel.get(this, "userPoolClientId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The client name that was specified via the `userPoolClientName` property during initialization, throws an error otherwise.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getUserPoolClientName() {
        return software.amazon.jsii.Kernel.get(this, "userPoolClientName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cognito.UserPoolClient}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cognito.UserPoolClient> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.cognito.UserPoolClientProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.cognito.UserPoolClientProps.Builder();
        }

        /**
         * Validity of the access token.
         * <p>
         * Values between 5 minutes and 1 day are valid. The duration can not be longer than the refresh token validity.
         * <p>
         * Default: Duration.minutes(60)
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/en_us/cognito/latest/developerguide/amazon-cognito-user-pools-using-tokens-with-identity-providers.html#amazon-cognito-user-pools-using-the-access-token">https://docs.aws.amazon.com/en_us/cognito/latest/developerguide/amazon-cognito-user-pools-using-tokens-with-identity-providers.html#amazon-cognito-user-pools-using-the-access-token</a>
         * @param accessTokenValidity Validity of the access token. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessTokenValidity(final software.amazon.awscdk.Duration accessTokenValidity) {
            this.props.accessTokenValidity(accessTokenValidity);
            return this;
        }

        /**
         * The set of OAuth authentication flows to enable on the client.
         * <p>
         * Default: - all auth flows disabled
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-authentication-flow.html">https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-authentication-flow.html</a>
         * @param authFlows The set of OAuth authentication flows to enable on the client. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authFlows(final software.amazon.awscdk.services.cognito.AuthFlow authFlows) {
            this.props.authFlows(authFlows);
            return this;
        }

        /**
         * Turns off all OAuth interactions for this client.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param disableOAuth Turns off all OAuth interactions for this client. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disableOAuth(final java.lang.Boolean disableOAuth) {
            this.props.disableOAuth(disableOAuth);
            return this;
        }

        /**
         * Enable token revocation for this client.
         * <p>
         * Default: true for new user pool clients
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/token-revocation.html#enable-token-revocation">https://docs.aws.amazon.com/cognito/latest/developerguide/token-revocation.html#enable-token-revocation</a>
         * @param enableTokenRevocation Enable token revocation for this client. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableTokenRevocation(final java.lang.Boolean enableTokenRevocation) {
            this.props.enableTokenRevocation(enableTokenRevocation);
            return this;
        }

        /**
         * Whether to generate a client secret.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param generateSecret Whether to generate a client secret. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder generateSecret(final java.lang.Boolean generateSecret) {
            this.props.generateSecret(generateSecret);
            return this;
        }

        /**
         * Validity of the ID token.
         * <p>
         * Values between 5 minutes and 1 day are valid. The duration can not be longer than the refresh token validity.
         * <p>
         * Default: Duration.minutes(60)
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/en_us/cognito/latest/developerguide/amazon-cognito-user-pools-using-tokens-with-identity-providers.html#amazon-cognito-user-pools-using-the-id-token">https://docs.aws.amazon.com/en_us/cognito/latest/developerguide/amazon-cognito-user-pools-using-tokens-with-identity-providers.html#amazon-cognito-user-pools-using-the-id-token</a>
         * @param idTokenValidity Validity of the ID token. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder idTokenValidity(final software.amazon.awscdk.Duration idTokenValidity) {
            this.props.idTokenValidity(idTokenValidity);
            return this;
        }

        /**
         * OAuth settings for this client to interact with the app.
         * <p>
         * An error is thrown when this is specified and <code>disableOAuth</code> is set.
         * <p>
         * Default: - see defaults in `OAuthSettings`. meaningless if `disableOAuth` is set.
         * <p>
         * @return {@code this}
         * @param oAuth OAuth settings for this client to interact with the app. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder oAuth(final software.amazon.awscdk.services.cognito.OAuthSettings oAuth) {
            this.props.oAuth(oAuth);
            return this;
        }

        /**
         * Whether Cognito returns a UserNotFoundException exception when the user does not exist in the user pool (false), or whether it returns another type of error that doesn't reveal the user's absence.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-managing-errors.html">https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-managing-errors.html</a>
         * @param preventUserExistenceErrors Whether Cognito returns a UserNotFoundException exception when the user does not exist in the user pool (false), or whether it returns another type of error that doesn't reveal the user's absence. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preventUserExistenceErrors(final java.lang.Boolean preventUserExistenceErrors) {
            this.props.preventUserExistenceErrors(preventUserExistenceErrors);
            return this;
        }

        /**
         * The set of attributes this client will be able to read.
         * <p>
         * Default: - all standard and custom attributes
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html#user-pool-settings-attribute-permissions-and-scopes">https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html#user-pool-settings-attribute-permissions-and-scopes</a>
         * @param readAttributes The set of attributes this client will be able to read. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readAttributes(final software.amazon.awscdk.services.cognito.ClientAttributes readAttributes) {
            this.props.readAttributes(readAttributes);
            return this;
        }

        /**
         * Validity of the refresh token.
         * <p>
         * Values between 60 minutes and 10 years are valid.
         * <p>
         * Default: Duration.days(30)
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/en_us/cognito/latest/developerguide/amazon-cognito-user-pools-using-tokens-with-identity-providers.html#amazon-cognito-user-pools-using-the-refresh-token">https://docs.aws.amazon.com/en_us/cognito/latest/developerguide/amazon-cognito-user-pools-using-tokens-with-identity-providers.html#amazon-cognito-user-pools-using-the-refresh-token</a>
         * @param refreshTokenValidity Validity of the refresh token. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder refreshTokenValidity(final software.amazon.awscdk.Duration refreshTokenValidity) {
            this.props.refreshTokenValidity(refreshTokenValidity);
            return this;
        }

        /**
         * The list of identity providers that users should be able to use to sign in using this client.
         * <p>
         * Default: - supports all identity providers that are registered with the user pool. If the user pool and/or
         * identity providers are imported, either specify this option explicitly or ensure that the identity providers are
         * registered with the user pool using the `UserPool.registerIdentityProvider()` API.
         * <p>
         * @return {@code this}
         * @param supportedIdentityProviders The list of identity providers that users should be able to use to sign in using this client. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder supportedIdentityProviders(final java.util.List<? extends software.amazon.awscdk.services.cognito.UserPoolClientIdentityProvider> supportedIdentityProviders) {
            this.props.supportedIdentityProviders(supportedIdentityProviders);
            return this;
        }

        /**
         * Name of the application client.
         * <p>
         * Default: - cloudformation generated name
         * <p>
         * @return {@code this}
         * @param userPoolClientName Name of the application client. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPoolClientName(final java.lang.String userPoolClientName) {
            this.props.userPoolClientName(userPoolClientName);
            return this;
        }

        /**
         * The set of attributes this client will be able to write.
         * <p>
         * Default: - all standard and custom attributes
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html#user-pool-settings-attribute-permissions-and-scopes">https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html#user-pool-settings-attribute-permissions-and-scopes</a>
         * @param writeAttributes The set of attributes this client will be able to write. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder writeAttributes(final software.amazon.awscdk.services.cognito.ClientAttributes writeAttributes) {
            this.props.writeAttributes(writeAttributes);
            return this;
        }

        /**
         * The UserPool resource this client will have access to.
         * <p>
         * @return {@code this}
         * @param userPool The UserPool resource this client will have access to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPool(final software.amazon.awscdk.services.cognito.IUserPool userPool) {
            this.props.userPool(userPool);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.cognito.UserPoolClient}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cognito.UserPoolClient build() {
            return new software.amazon.awscdk.services.cognito.UserPoolClient(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
