package software.amazon.awscdk.pipelines;

/**
 * Properties for a `Pipeline`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.pipelines.*;
 * IFileSetProducer fileSetProducer;
 * PipelineBaseProps pipelineBaseProps = PipelineBaseProps.builder()
 *         .synth(fileSetProducer)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-08-02T19:52:03.007Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.pipelines.PipelineBaseProps")
@software.amazon.jsii.Jsii.Proxy(PipelineBaseProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface PipelineBaseProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The build step that produces the CDK Cloud Assembly.
     * <p>
     * The primary output of this step needs to be the <code>cdk.out</code> directory
     * generated by the <code>cdk synth</code> command.
     * <p>
     * If you use a <code>ShellStep</code> here and you don't configure an output directory,
     * the output directory will automatically be assumed to be <code>cdk.out</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.IFileSetProducer getSynth();

    /**
     * @return a {@link Builder} of {@link PipelineBaseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PipelineBaseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<PipelineBaseProps> {
        software.amazon.awscdk.pipelines.IFileSetProducer synth;

        /**
         * Sets the value of {@link PipelineBaseProps#getSynth}
         * @param synth The build step that produces the CDK Cloud Assembly. This parameter is required.
         *              The primary output of this step needs to be the <code>cdk.out</code> directory
         *              generated by the <code>cdk synth</code> command.
         *              <p>
         *              If you use a <code>ShellStep</code> here and you don't configure an output directory,
         *              the output directory will automatically be assumed to be <code>cdk.out</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder synth(software.amazon.awscdk.pipelines.IFileSetProducer synth) {
            this.synth = synth;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PipelineBaseProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public PipelineBaseProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link PipelineBaseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PipelineBaseProps {
        private final software.amazon.awscdk.pipelines.IFileSetProducer synth;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.synth = software.amazon.jsii.Kernel.get(this, "synth", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.IFileSetProducer.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.synth = java.util.Objects.requireNonNull(builder.synth, "synth is required");
        }

        @Override
        public final software.amazon.awscdk.pipelines.IFileSetProducer getSynth() {
            return this.synth;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("synth", om.valueToTree(this.getSynth()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.pipelines.PipelineBaseProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PipelineBaseProps.Jsii$Proxy that = (PipelineBaseProps.Jsii$Proxy) o;

            return this.synth.equals(that.synth);
        }

        @Override
        public final int hashCode() {
            int result = this.synth.hashCode();
            return result;
        }
    }
}
