/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.cognito;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.RemovalPolicy;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.services.cognito.AccountRecovery;
import software.amazon.awscdk.services.cognito.AutoVerifiedAttrs;
import software.amazon.awscdk.services.cognito.DeviceTracking;
import software.amazon.awscdk.services.cognito.ICustomAttribute;
import software.amazon.awscdk.services.cognito.IUserPool;
import software.amazon.awscdk.services.cognito.IUserPoolIdentityProvider;
import software.amazon.awscdk.services.cognito.Mfa;
import software.amazon.awscdk.services.cognito.MfaSecondFactor;
import software.amazon.awscdk.services.cognito.PasswordPolicy;
import software.amazon.awscdk.services.cognito.SignInAliases;
import software.amazon.awscdk.services.cognito.StandardAttributes;
import software.amazon.awscdk.services.cognito.UserInvitationConfig;
import software.amazon.awscdk.services.cognito.UserPoolClient;
import software.amazon.awscdk.services.cognito.UserPoolClientOptions;
import software.amazon.awscdk.services.cognito.UserPoolDomain;
import software.amazon.awscdk.services.cognito.UserPoolDomainOptions;
import software.amazon.awscdk.services.cognito.UserPoolEmail;
import software.amazon.awscdk.services.cognito.UserPoolOperation;
import software.amazon.awscdk.services.cognito.UserPoolProps;
import software.amazon.awscdk.services.cognito.UserPoolResourceServer;
import software.amazon.awscdk.services.cognito.UserPoolResourceServerOptions;
import software.amazon.awscdk.services.cognito.UserPoolTriggers;
import software.amazon.awscdk.services.cognito.UserVerificationConfig;
import software.amazon.awscdk.services.iam.Grant;
import software.amazon.awscdk.services.iam.IGrantable;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.awscdk.services.lambda.IFunction;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_cognito.UserPool")
public class UserPool
extends Resource
implements IUserPool {
    protected UserPool(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected UserPool(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public UserPool(@NotNull Construct scope, @NotNull String id, @Nullable UserPoolProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public UserPool(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @NotNull
    public static IUserPool fromUserPoolArn(@NotNull Construct scope, @NotNull String id, @NotNull String userPoolArn) {
        return (IUserPool)JsiiObject.jsiiStaticCall(UserPool.class, (String)"fromUserPoolArn", (NativeType)NativeType.forClass(IUserPool.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(userPoolArn, "userPoolArn is required")});
    }

    @NotNull
    public static IUserPool fromUserPoolId(@NotNull Construct scope, @NotNull String id, @NotNull String userPoolId) {
        return (IUserPool)JsiiObject.jsiiStaticCall(UserPool.class, (String)"fromUserPoolId", (NativeType)NativeType.forClass(IUserPool.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(userPoolId, "userPoolId is required")});
    }

    @Override
    @NotNull
    public UserPoolClient addClient(@NotNull String id, @Nullable UserPoolClientOptions options) {
        return (UserPoolClient)Kernel.call((Object)this, (String)"addClient", (NativeType)NativeType.forClass(UserPoolClient.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), options});
    }

    @Override
    @NotNull
    public UserPoolClient addClient(@NotNull String id) {
        return (UserPoolClient)Kernel.call((Object)this, (String)"addClient", (NativeType)NativeType.forClass(UserPoolClient.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    @Override
    @NotNull
    public UserPoolDomain addDomain(@NotNull String id, @NotNull UserPoolDomainOptions options) {
        return (UserPoolDomain)Kernel.call((Object)this, (String)"addDomain", (NativeType)NativeType.forClass(UserPoolDomain.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(options, "options is required")});
    }

    @Override
    @NotNull
    public UserPoolResourceServer addResourceServer(@NotNull String id, @NotNull UserPoolResourceServerOptions options) {
        return (UserPoolResourceServer)Kernel.call((Object)this, (String)"addResourceServer", (NativeType)NativeType.forClass(UserPoolResourceServer.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(options, "options is required")});
    }

    public void addTrigger(@NotNull UserPoolOperation operation, @NotNull IFunction fn) {
        Kernel.call((Object)this, (String)"addTrigger", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(operation, "operation is required"), Objects.requireNonNull(fn, "fn is required")});
    }

    @Override
    @NotNull
    public Grant grant(@NotNull IGrantable grantee, String ... actions) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grant", (NativeType)NativeType.forClass(Grant.class), (Object[])Stream.concat(Arrays.stream(new Object[]{Objects.requireNonNull(grantee, "grantee is required")}), Arrays.stream(actions)).toArray(Object[]::new)));
    }

    @Override
    public void registerIdentityProvider(@NotNull IUserPoolIdentityProvider provider) {
        Kernel.call((Object)this, (String)"registerIdentityProvider", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(provider, "provider is required")});
    }

    @Override
    @NotNull
    public List<IUserPoolIdentityProvider> getIdentityProviders() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"identityProviders", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(IUserPoolIdentityProvider.class))));
    }

    @Override
    @NotNull
    public String getUserPoolArn() {
        return (String)Kernel.get((Object)this, (String)"userPoolArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getUserPoolId() {
        return (String)Kernel.get((Object)this, (String)"userPoolId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getUserPoolProviderName() {
        return (String)Kernel.get((Object)this, (String)"userPoolProviderName", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getUserPoolProviderUrl() {
        return (String)Kernel.get((Object)this, (String)"userPoolProviderUrl", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<UserPool> {
        private final Construct scope;
        private final String id;
        private UserPoolProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder accountRecovery(AccountRecovery accountRecovery) {
            this.props().accountRecovery(accountRecovery);
            return this;
        }

        public Builder autoVerify(AutoVerifiedAttrs autoVerify) {
            this.props().autoVerify(autoVerify);
            return this;
        }

        public Builder customAttributes(Map<String, ? extends ICustomAttribute> customAttributes) {
            this.props().customAttributes(customAttributes);
            return this;
        }

        public Builder customSenderKmsKey(IKey customSenderKmsKey) {
            this.props().customSenderKmsKey(customSenderKmsKey);
            return this;
        }

        public Builder deviceTracking(DeviceTracking deviceTracking) {
            this.props().deviceTracking(deviceTracking);
            return this;
        }

        public Builder email(UserPoolEmail email) {
            this.props().email(email);
            return this;
        }

        public Builder enableSmsRole(Boolean enableSmsRole) {
            this.props().enableSmsRole(enableSmsRole);
            return this;
        }

        public Builder lambdaTriggers(UserPoolTriggers lambdaTriggers) {
            this.props().lambdaTriggers(lambdaTriggers);
            return this;
        }

        public Builder mfa(Mfa mfa) {
            this.props().mfa(mfa);
            return this;
        }

        public Builder mfaMessage(String mfaMessage) {
            this.props().mfaMessage(mfaMessage);
            return this;
        }

        public Builder mfaSecondFactor(MfaSecondFactor mfaSecondFactor) {
            this.props().mfaSecondFactor(mfaSecondFactor);
            return this;
        }

        public Builder passwordPolicy(PasswordPolicy passwordPolicy) {
            this.props().passwordPolicy(passwordPolicy);
            return this;
        }

        public Builder removalPolicy(RemovalPolicy removalPolicy) {
            this.props().removalPolicy(removalPolicy);
            return this;
        }

        public Builder selfSignUpEnabled(Boolean selfSignUpEnabled) {
            this.props().selfSignUpEnabled(selfSignUpEnabled);
            return this;
        }

        public Builder signInAliases(SignInAliases signInAliases) {
            this.props().signInAliases(signInAliases);
            return this;
        }

        public Builder signInCaseSensitive(Boolean signInCaseSensitive) {
            this.props().signInCaseSensitive(signInCaseSensitive);
            return this;
        }

        public Builder smsRole(IRole smsRole) {
            this.props().smsRole(smsRole);
            return this;
        }

        public Builder smsRoleExternalId(String smsRoleExternalId) {
            this.props().smsRoleExternalId(smsRoleExternalId);
            return this;
        }

        public Builder snsRegion(String snsRegion) {
            this.props().snsRegion(snsRegion);
            return this;
        }

        public Builder standardAttributes(StandardAttributes standardAttributes) {
            this.props().standardAttributes(standardAttributes);
            return this;
        }

        public Builder userInvitation(UserInvitationConfig userInvitation) {
            this.props().userInvitation(userInvitation);
            return this;
        }

        public Builder userPoolName(String userPoolName) {
            this.props().userPoolName(userPoolName);
            return this;
        }

        public Builder userVerification(UserVerificationConfig userVerification) {
            this.props().userVerification(userVerification);
            return this;
        }

        public UserPool build() {
            return new UserPool(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private UserPoolProps.Builder props() {
            if (this.props == null) {
                this.props = new UserPoolProps.Builder();
            }
            return this.props;
        }
    }
}

