package software.amazon.awscdk.services.stepfunctions;

/**
 * Interface for Writer Config props.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.stepfunctions.*;
 * WriterConfigProps writerConfigProps = WriterConfigProps.builder()
 *         .outputType(OutputType.JSON)
 *         .transformation(Transformation.NONE)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:21.394Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.WriterConfigProps")
@software.amazon.jsii.Jsii.Proxy(WriterConfigProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface WriterConfigProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The format of the Output of the child workflow executions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.OutputType getOutputType();

    /**
     * The transformation to be applied to the Output of the Child Workflow executions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Transformation getTransformation();

    /**
     * @return a {@link Builder} of {@link WriterConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link WriterConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<WriterConfigProps> {
        software.amazon.awscdk.services.stepfunctions.OutputType outputType;
        software.amazon.awscdk.services.stepfunctions.Transformation transformation;

        /**
         * Sets the value of {@link WriterConfigProps#getOutputType}
         * @param outputType The format of the Output of the child workflow executions. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputType(software.amazon.awscdk.services.stepfunctions.OutputType outputType) {
            this.outputType = outputType;
            return this;
        }

        /**
         * Sets the value of {@link WriterConfigProps#getTransformation}
         * @param transformation The transformation to be applied to the Output of the Child Workflow executions. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transformation(software.amazon.awscdk.services.stepfunctions.Transformation transformation) {
            this.transformation = transformation;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link WriterConfigProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public WriterConfigProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link WriterConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WriterConfigProps {
        private final software.amazon.awscdk.services.stepfunctions.OutputType outputType;
        private final software.amazon.awscdk.services.stepfunctions.Transformation transformation;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.outputType = software.amazon.jsii.Kernel.get(this, "outputType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.OutputType.class));
            this.transformation = software.amazon.jsii.Kernel.get(this, "transformation", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Transformation.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.outputType = java.util.Objects.requireNonNull(builder.outputType, "outputType is required");
            this.transformation = java.util.Objects.requireNonNull(builder.transformation, "transformation is required");
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.OutputType getOutputType() {
            return this.outputType;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.Transformation getTransformation() {
            return this.transformation;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("outputType", om.valueToTree(this.getOutputType()));
            data.set("transformation", om.valueToTree(this.getTransformation()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions.WriterConfigProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            WriterConfigProps.Jsii$Proxy that = (WriterConfigProps.Jsii$Proxy) o;

            if (!outputType.equals(that.outputType)) return false;
            return this.transformation.equals(that.transformation);
        }

        @Override
        public final int hashCode() {
            int result = this.outputType.hashCode();
            result = 31 * result + (this.transformation.hashCode());
            return result;
        }
    }
}
