package software.amazon.awscdk.services.stepfunctions;

/**
 * Two types of state machines are available in AWS Step Functions: EXPRESS AND STANDARD.
 * <p>
 * Default: STANDARD
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.kms.*;
 * import software.amazon.awscdk.*;
 * Key kmsKey = new Key(this, "Key");
 * StateMachine stateMachine = StateMachine.Builder.create(this, "StateMachineWithCMKEncryptionConfiguration")
 *         .stateMachineName("StateMachineWithCMKEncryptionConfiguration")
 *         .definitionBody(DefinitionBody.fromChainable(Chain.start(new Pass(this, "Pass"))))
 *         .stateMachineType(StateMachineType.STANDARD)
 *         .encryptionConfiguration(new CustomerManagedEncryptionConfiguration(kmsKey, Duration.seconds(60)))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-standard-vs-express.html">https://docs.aws.amazon.com/step-functions/latest/dg/concepts-standard-vs-express.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:21.380Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.StateMachineType")
public enum StateMachineType {
    /**
     * Express Workflows are ideal for high-volume, event processing workloads.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    EXPRESS,
    /**
     * Standard Workflows are ideal for long-running, durable, and auditable workflows.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD,
}
