package software.amazon.awscdk.services.stepfunctions;

/**
 * Base properties for defining a Map state that using JSONPath.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.stepfunctions.*;
 * Object resultSelector;
 * MapBaseJsonPathOptions mapBaseJsonPathOptions = MapBaseJsonPathOptions.builder()
 *         .inputPath("inputPath")
 *         .itemsPath("itemsPath")
 *         .maxConcurrencyPath("maxConcurrencyPath")
 *         .outputPath("outputPath")
 *         .resultPath("resultPath")
 *         .resultSelector(Map.of(
 *                 "resultSelectorKey", resultSelector))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:21.338Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.MapBaseJsonPathOptions")
@software.amazon.jsii.Jsii.Proxy(MapBaseJsonPathOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface MapBaseJsonPathOptions extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.stepfunctions.JsonPathCommonOptions {

    /**
     * JSONPath expression to select the array to iterate over.
     * <p>
     * Default: $
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getItemsPath() {
        return null;
    }

    /**
     * MaxConcurrencyPath.
     * <p>
     * A JsonPath that specifies the maximum concurrency dynamically from the state input.
     * <p>
     * Default: - full concurrency
     * <p>
     * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-asl-use-map-state-inline.html#map-state-inline-additional-fields">https://docs.aws.amazon.com/step-functions/latest/dg/concepts-asl-use-map-state-inline.html#map-state-inline-additional-fields</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMaxConcurrencyPath() {
        return null;
    }

    /**
     * JSONPath expression to indicate where to inject the state's output.
     * <p>
     * May also be the special value JsonPath.DISCARD, which will cause the state's
     * input to become its output.
     * <p>
     * Default: $
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getResultPath() {
        return null;
    }

    /**
     * The JSON that will replace the state's raw result and become the effective result before ResultPath is applied.
     * <p>
     * You can use ResultSelector to create a payload with values that are static
     * or selected from the state's raw result.
     * <p>
     * Default: - None
     * <p>
     * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/input-output-inputpath-params.html#input-output-resultselector">https://docs.aws.amazon.com/step-functions/latest/dg/input-output-inputpath-params.html#input-output-resultselector</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> getResultSelector() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link MapBaseJsonPathOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link MapBaseJsonPathOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<MapBaseJsonPathOptions> {
        java.lang.String itemsPath;
        java.lang.String maxConcurrencyPath;
        java.lang.String resultPath;
        java.util.Map<java.lang.String, java.lang.Object> resultSelector;
        java.lang.String inputPath;
        java.lang.String outputPath;

        /**
         * Sets the value of {@link MapBaseJsonPathOptions#getItemsPath}
         * @param itemsPath JSONPath expression to select the array to iterate over.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder itemsPath(java.lang.String itemsPath) {
            this.itemsPath = itemsPath;
            return this;
        }

        /**
         * Sets the value of {@link MapBaseJsonPathOptions#getMaxConcurrencyPath}
         * @param maxConcurrencyPath MaxConcurrencyPath.
         *                           A JsonPath that specifies the maximum concurrency dynamically from the state input.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxConcurrencyPath(java.lang.String maxConcurrencyPath) {
            this.maxConcurrencyPath = maxConcurrencyPath;
            return this;
        }

        /**
         * Sets the value of {@link MapBaseJsonPathOptions#getResultPath}
         * @param resultPath JSONPath expression to indicate where to inject the state's output.
         *                   May also be the special value JsonPath.DISCARD, which will cause the state's
         *                   input to become its output.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resultPath(java.lang.String resultPath) {
            this.resultPath = resultPath;
            return this;
        }

        /**
         * Sets the value of {@link MapBaseJsonPathOptions#getResultSelector}
         * @param resultSelector The JSON that will replace the state's raw result and become the effective result before ResultPath is applied.
         *                       You can use ResultSelector to create a payload with values that are static
         *                       or selected from the state's raw result.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder resultSelector(java.util.Map<java.lang.String, ? extends java.lang.Object> resultSelector) {
            this.resultSelector = (java.util.Map<java.lang.String, java.lang.Object>)resultSelector;
            return this;
        }

        /**
         * Sets the value of {@link MapBaseJsonPathOptions#getInputPath}
         * @param inputPath JSONPath expression to select part of the state to be the input to this state.
         *                  May also be the special value JsonPath.DISCARD, which will cause the effective
         *                  input to be the empty object {}.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputPath(java.lang.String inputPath) {
            this.inputPath = inputPath;
            return this;
        }

        /**
         * Sets the value of {@link MapBaseJsonPathOptions#getOutputPath}
         * @param outputPath JSONPath expression to select part of the state to be the output to this state.
         *                   May also be the special value JsonPath.DISCARD, which will cause the effective
         *                   output to be the empty object {}.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputPath(java.lang.String outputPath) {
            this.outputPath = outputPath;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link MapBaseJsonPathOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public MapBaseJsonPathOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link MapBaseJsonPathOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MapBaseJsonPathOptions {
        private final java.lang.String itemsPath;
        private final java.lang.String maxConcurrencyPath;
        private final java.lang.String resultPath;
        private final java.util.Map<java.lang.String, java.lang.Object> resultSelector;
        private final java.lang.String inputPath;
        private final java.lang.String outputPath;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.itemsPath = software.amazon.jsii.Kernel.get(this, "itemsPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.maxConcurrencyPath = software.amazon.jsii.Kernel.get(this, "maxConcurrencyPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.resultPath = software.amazon.jsii.Kernel.get(this, "resultPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.resultSelector = software.amazon.jsii.Kernel.get(this, "resultSelector", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.inputPath = software.amazon.jsii.Kernel.get(this, "inputPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.outputPath = software.amazon.jsii.Kernel.get(this, "outputPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.itemsPath = builder.itemsPath;
            this.maxConcurrencyPath = builder.maxConcurrencyPath;
            this.resultPath = builder.resultPath;
            this.resultSelector = (java.util.Map<java.lang.String, java.lang.Object>)builder.resultSelector;
            this.inputPath = builder.inputPath;
            this.outputPath = builder.outputPath;
        }

        @Override
        public final java.lang.String getItemsPath() {
            return this.itemsPath;
        }

        @Override
        public final java.lang.String getMaxConcurrencyPath() {
            return this.maxConcurrencyPath;
        }

        @Override
        public final java.lang.String getResultPath() {
            return this.resultPath;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getResultSelector() {
            return this.resultSelector;
        }

        @Override
        public final java.lang.String getInputPath() {
            return this.inputPath;
        }

        @Override
        public final java.lang.String getOutputPath() {
            return this.outputPath;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getItemsPath() != null) {
                data.set("itemsPath", om.valueToTree(this.getItemsPath()));
            }
            if (this.getMaxConcurrencyPath() != null) {
                data.set("maxConcurrencyPath", om.valueToTree(this.getMaxConcurrencyPath()));
            }
            if (this.getResultPath() != null) {
                data.set("resultPath", om.valueToTree(this.getResultPath()));
            }
            if (this.getResultSelector() != null) {
                data.set("resultSelector", om.valueToTree(this.getResultSelector()));
            }
            if (this.getInputPath() != null) {
                data.set("inputPath", om.valueToTree(this.getInputPath()));
            }
            if (this.getOutputPath() != null) {
                data.set("outputPath", om.valueToTree(this.getOutputPath()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions.MapBaseJsonPathOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            MapBaseJsonPathOptions.Jsii$Proxy that = (MapBaseJsonPathOptions.Jsii$Proxy) o;

            if (this.itemsPath != null ? !this.itemsPath.equals(that.itemsPath) : that.itemsPath != null) return false;
            if (this.maxConcurrencyPath != null ? !this.maxConcurrencyPath.equals(that.maxConcurrencyPath) : that.maxConcurrencyPath != null) return false;
            if (this.resultPath != null ? !this.resultPath.equals(that.resultPath) : that.resultPath != null) return false;
            if (this.resultSelector != null ? !this.resultSelector.equals(that.resultSelector) : that.resultSelector != null) return false;
            if (this.inputPath != null ? !this.inputPath.equals(that.inputPath) : that.inputPath != null) return false;
            return this.outputPath != null ? this.outputPath.equals(that.outputPath) : that.outputPath == null;
        }

        @Override
        public final int hashCode() {
            int result = this.itemsPath != null ? this.itemsPath.hashCode() : 0;
            result = 31 * result + (this.maxConcurrencyPath != null ? this.maxConcurrencyPath.hashCode() : 0);
            result = 31 * result + (this.resultPath != null ? this.resultPath.hashCode() : 0);
            result = 31 * result + (this.resultSelector != null ? this.resultSelector.hashCode() : 0);
            result = 31 * result + (this.inputPath != null ? this.inputPath.hashCode() : 0);
            result = 31 * result + (this.outputPath != null ? this.outputPath.hashCode() : 0);
            return result;
        }
    }
}
