package software.amazon.awscdk.services.signer;

/**
 * A reference to a Signing Profile.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.signer.*;
 * SigningProfileAttributes signingProfileAttributes = SigningProfileAttributes.builder()
 *         .signingProfileName("signingProfileName")
 *         .signingProfileVersion("signingProfileVersion")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:21.016Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_signer.SigningProfileAttributes")
@software.amazon.jsii.Jsii.Proxy(SigningProfileAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SigningProfileAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of signing profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSigningProfileName();

    /**
     * The version of signing profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSigningProfileVersion();

    /**
     * @return a {@link Builder} of {@link SigningProfileAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SigningProfileAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SigningProfileAttributes> {
        java.lang.String signingProfileName;
        java.lang.String signingProfileVersion;

        /**
         * Sets the value of {@link SigningProfileAttributes#getSigningProfileName}
         * @param signingProfileName The name of signing profile. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder signingProfileName(java.lang.String signingProfileName) {
            this.signingProfileName = signingProfileName;
            return this;
        }

        /**
         * Sets the value of {@link SigningProfileAttributes#getSigningProfileVersion}
         * @param signingProfileVersion The version of signing profile. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder signingProfileVersion(java.lang.String signingProfileVersion) {
            this.signingProfileVersion = signingProfileVersion;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SigningProfileAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SigningProfileAttributes build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SigningProfileAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SigningProfileAttributes {
        private final java.lang.String signingProfileName;
        private final java.lang.String signingProfileVersion;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.signingProfileName = software.amazon.jsii.Kernel.get(this, "signingProfileName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.signingProfileVersion = software.amazon.jsii.Kernel.get(this, "signingProfileVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.signingProfileName = java.util.Objects.requireNonNull(builder.signingProfileName, "signingProfileName is required");
            this.signingProfileVersion = java.util.Objects.requireNonNull(builder.signingProfileVersion, "signingProfileVersion is required");
        }

        @Override
        public final java.lang.String getSigningProfileName() {
            return this.signingProfileName;
        }

        @Override
        public final java.lang.String getSigningProfileVersion() {
            return this.signingProfileVersion;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("signingProfileName", om.valueToTree(this.getSigningProfileName()));
            data.set("signingProfileVersion", om.valueToTree(this.getSigningProfileVersion()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_signer.SigningProfileAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SigningProfileAttributes.Jsii$Proxy that = (SigningProfileAttributes.Jsii$Proxy) o;

            if (!signingProfileName.equals(that.signingProfileName)) return false;
            return this.signingProfileVersion.equals(that.signingProfileVersion);
        }

        @Override
        public final int hashCode() {
            int result = this.signingProfileName.hashCode();
            result = 31 * result + (this.signingProfileVersion.hashCode());
            return result;
        }
    }
}
