package software.amazon.awscdk.services.ses.actions;

/**
 * Publishes the email content within a notification to Amazon SNS.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.s3.*;
 * import software.amazon.awscdk.services.ses.actions.*;
 * Bucket bucket = new Bucket(this, "Bucket");
 * Topic topic = new Topic(this, "Topic");
 * ReceiptRuleSet.Builder.create(this, "RuleSet")
 *         .rules(List.of(ReceiptRuleOptions.builder()
 *                 .recipients(List.of("hello&#64;aws.com"))
 *                 .actions(List.of(
 *                     AddHeader.Builder.create()
 *                             .name("X-Special-Header")
 *                             .value("aws")
 *                             .build(),
 *                     S3.Builder.create()
 *                             .bucket(bucket)
 *                             .objectKeyPrefix("emails/")
 *                             .topic(topic)
 *                             .build()))
 *                 .build(), ReceiptRuleOptions.builder()
 *                 .recipients(List.of("aws.com"))
 *                 .actions(List.of(
 *                     Sns.Builder.create()
 *                             .topic(topic)
 *                             .build()))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:20.989Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses_actions.Sns")
public class Sns extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ses.IReceiptRuleAction {

    protected Sns(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Sns(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Sns(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ses.actions.SnsProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Returns the receipt rule action specification.
     * <p>
     * @param _rule This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ses.ReceiptRuleActionConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ses.IReceiptRule _rule) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ses.ReceiptRuleActionConfig.class), new Object[] { java.util.Objects.requireNonNull(_rule, "_rule is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ses.actions.Sns}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ses.actions.Sns> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.ses.actions.SnsProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.ses.actions.SnsProps.Builder();
        }

        /**
         * The SNS topic to notify.
         * <p>
         * @return {@code this}
         * @param topic The SNS topic to notify. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder topic(final software.amazon.awscdk.services.sns.ITopic topic) {
            this.props.topic(topic);
            return this;
        }

        /**
         * The encoding to use for the email within the Amazon SNS notification.
         * <p>
         * Default: UTF-8
         * <p>
         * @return {@code this}
         * @param encoding The encoding to use for the email within the Amazon SNS notification. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encoding(final software.amazon.awscdk.services.ses.actions.EmailEncoding encoding) {
            this.props.encoding(encoding);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ses.actions.Sns}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ses.actions.Sns build() {
            return new software.amazon.awscdk.services.ses.actions.Sns(
                this.props.build()
            );
        }
    }
}
