package software.amazon.awscdk.services.securityhub;

/**
 * The <code>AWS::SecurityHub::SecurityControl</code> resource specifies custom parameter values for an AWS Security Hub control.
 * <p>
 * For a list of controls that support custom parameters, see <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-controls-reference.html">Security Hub controls reference</a> . You can also use this resource to specify the use of default parameter values for a control. For more information about custom parameters, see <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/custom-control-parameters.html">Custom control parameters</a> in the <em>AWS Security Hub User Guide</em> .
 * <p>
 * Tags aren't supported for this resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.securityhub.*;
 * CfnSecurityControl cfnSecurityControl = CfnSecurityControl.Builder.create(this, "MyCfnSecurityControl")
 *         .parameters(Map.of(
 *                 "parametersKey", ParameterConfigurationProperty.builder()
 *                         .valueType("valueType")
 *                         // the properties below are optional
 *                         .value(ParameterValueProperty.builder()
 *                                 .boolean(false)
 *                                 .double(123)
 *                                 .enum("enum")
 *                                 .enumList(List.of("enumList"))
 *                                 .integer(123)
 *                                 .integerList(List.of(123))
 *                                 .string("string")
 *                                 .stringList(List.of("stringList"))
 *                                 .build())
 *                         .build()))
 *         // the properties below are optional
 *         .lastUpdateReason("lastUpdateReason")
 *         .securityControlArn("securityControlArn")
 *         .securityControlId("securityControlId")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-securitycontrol.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-securitycontrol.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:20.700Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_securityhub.CfnSecurityControl")
public class CfnSecurityControl extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnSecurityControl(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnSecurityControl(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.securityhub.CfnSecurityControl.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnSecurityControl(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.securityhub.CfnSecurityControlProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * An object that identifies the name of a control parameter, its current value, and whether it has been customized.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getParameters() {
        return software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An object that identifies the name of a control parameter, its current value, and whether it has been customized.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setParameters(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "parameters", java.util.Objects.requireNonNull(value, "parameters is required"));
    }

    /**
     * An object that identifies the name of a control parameter, its current value, and whether it has been customized.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setParameters(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            if (!(value.keySet().toArray()[0] instanceof String)) {
                throw new IllegalArgumentException(
                    new java.lang.StringBuilder("Expected ")
                        .append("value").append(".keySet()")
                        .append(" to contain class String; received ")
                        .append(value.keySet().toArray()[0].getClass()).toString());
            }
            for (final java.util.Map.Entry<String, java.lang.Object> __item_ac66f0: value.entrySet()) {
                final java.lang.Object __val_ac66f0 = __item_ac66f0.getValue();
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.securityhub.CfnSecurityControl.ParameterConfigurationProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(\"").append((__item_ac66f0.getKey())).append("\")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.securityhub.CfnSecurityControl.ParameterConfigurationProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "parameters", java.util.Objects.requireNonNull(value, "parameters is required"));
    }

    /**
     * The most recent reason for updating the customizable properties of a security control.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getLastUpdateReason() {
        return software.amazon.jsii.Kernel.get(this, "lastUpdateReason", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The most recent reason for updating the customizable properties of a security control.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLastUpdateReason(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "lastUpdateReason", value);
    }

    /**
     * The Amazon Resource Name (ARN) for a security control across standards, such as <code>arn:aws:securityhub:eu-central-1:123456789012:security-control/S3.1</code> . This parameter doesn't mention a specific standard.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSecurityControlArn() {
        return software.amazon.jsii.Kernel.get(this, "securityControlArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) for a security control across standards, such as <code>arn:aws:securityhub:eu-central-1:123456789012:security-control/S3.1</code> . This parameter doesn't mention a specific standard.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSecurityControlArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "securityControlArn", value);
    }

    /**
     * The unique identifier of a security control across standards.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSecurityControlId() {
        return software.amazon.jsii.Kernel.get(this, "securityControlId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique identifier of a security control across standards.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSecurityControlId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "securityControlId", value);
    }
    /**
     * An object that provides the current value of a security control parameter and identifies whether it has been customized.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.securityhub.*;
     * ParameterConfigurationProperty parameterConfigurationProperty = ParameterConfigurationProperty.builder()
     *         .valueType("valueType")
     *         // the properties below are optional
     *         .value(ParameterValueProperty.builder()
     *                 .boolean(false)
     *                 .double(123)
     *                 .enum("enum")
     *                 .enumList(List.of("enumList"))
     *                 .integer(123)
     *                 .integerList(List.of(123))
     *                 .string("string")
     *                 .stringList(List.of("stringList"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-securitycontrol-parameterconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-securitycontrol-parameterconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_securityhub.CfnSecurityControl.ParameterConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ParameterConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ParameterConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Identifies whether a control parameter uses a custom user-defined value or subscribes to the default AWS Security Hub behavior.
         * <p>
         * When <code>ValueType</code> is set equal to <code>DEFAULT</code> , the default behavior can be a specific Security Hub default value, or the default behavior can be to ignore a specific parameter. When <code>ValueType</code> is set equal to <code>DEFAULT</code> , Security Hub ignores user-provided input for the <code>Value</code> field.
         * <p>
         * When <code>ValueType</code> is set equal to <code>CUSTOM</code> , the <code>Value</code> field can't be empty.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-securitycontrol-parameterconfiguration.html#cfn-securityhub-securitycontrol-parameterconfiguration-valuetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-securitycontrol-parameterconfiguration.html#cfn-securityhub-securitycontrol-parameterconfiguration-valuetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValueType();

        /**
         * The current value of a control parameter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-securitycontrol-parameterconfiguration.html#cfn-securityhub-securitycontrol-parameterconfiguration-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-securitycontrol-parameterconfiguration.html#cfn-securityhub-securitycontrol-parameterconfiguration-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ParameterConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ParameterConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ParameterConfigurationProperty> {
            java.lang.String valueType;
            java.lang.Object value;

            /**
             * Sets the value of {@link ParameterConfigurationProperty#getValueType}
             * @param valueType Identifies whether a control parameter uses a custom user-defined value or subscribes to the default AWS Security Hub behavior. This parameter is required.
             *                  When <code>ValueType</code> is set equal to <code>DEFAULT</code> , the default behavior can be a specific Security Hub default value, or the default behavior can be to ignore a specific parameter. When <code>ValueType</code> is set equal to <code>DEFAULT</code> , Security Hub ignores user-provided input for the <code>Value</code> field.
             *                  <p>
             *                  When <code>ValueType</code> is set equal to <code>CUSTOM</code> , the <code>Value</code> field can't be empty.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder valueType(java.lang.String valueType) {
                this.valueType = valueType;
                return this;
            }

            /**
             * Sets the value of {@link ParameterConfigurationProperty#getValue}
             * @param value The current value of a control parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(software.amazon.awscdk.IResolvable value) {
                this.value = value;
                return this;
            }

            /**
             * Sets the value of {@link ParameterConfigurationProperty#getValue}
             * @param value The current value of a control parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(software.amazon.awscdk.services.securityhub.CfnSecurityControl.ParameterValueProperty value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ParameterConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ParameterConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ParameterConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ParameterConfigurationProperty {
            private final java.lang.String valueType;
            private final java.lang.Object value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.valueType = software.amazon.jsii.Kernel.get(this, "valueType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.valueType = java.util.Objects.requireNonNull(builder.valueType, "valueType is required");
                this.value = builder.value;
            }

            @Override
            public final java.lang.String getValueType() {
                return this.valueType;
            }

            @Override
            public final java.lang.Object getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("valueType", om.valueToTree(this.getValueType()));
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_securityhub.CfnSecurityControl.ParameterConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ParameterConfigurationProperty.Jsii$Proxy that = (ParameterConfigurationProperty.Jsii$Proxy) o;

                if (!valueType.equals(that.valueType)) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.valueType.hashCode();
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that includes the data type of a security control parameter and its current value.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.securityhub.*;
     * ParameterValueProperty parameterValueProperty = ParameterValueProperty.builder()
     *         .boolean(false)
     *         .double(123)
     *         .enum("enum")
     *         .enumList(List.of("enumList"))
     *         .integer(123)
     *         .integerList(List.of(123))
     *         .string("string")
     *         .stringList(List.of("stringList"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-securitycontrol-parametervalue.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-securitycontrol-parametervalue.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_securityhub.CfnSecurityControl.ParameterValueProperty")
    @software.amazon.jsii.Jsii.Proxy(ParameterValueProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ParameterValueProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A control parameter that is a boolean.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-securitycontrol-parametervalue.html#cfn-securityhub-securitycontrol-parametervalue-boolean">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-securitycontrol-parametervalue.html#cfn-securityhub-securitycontrol-parametervalue-boolean</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBooleanValue() {
            return null;
        }

        /**
         * A control parameter that is a double.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-securitycontrol-parametervalue.html#cfn-securityhub-securitycontrol-parametervalue-double">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-securitycontrol-parametervalue.html#cfn-securityhub-securitycontrol-parametervalue-double</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDoubleValue() {
            return null;
        }

        /**
         * A control parameter that is an enum.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-securitycontrol-parametervalue.html#cfn-securityhub-securitycontrol-parametervalue-enum">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-securitycontrol-parametervalue.html#cfn-securityhub-securitycontrol-parametervalue-enum</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEnumValue() {
            return null;
        }

        /**
         * A control parameter that is a list of enums.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-securitycontrol-parametervalue.html#cfn-securityhub-securitycontrol-parametervalue-enumlist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-securitycontrol-parametervalue.html#cfn-securityhub-securitycontrol-parametervalue-enumlist</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getEnumList() {
            return null;
        }

        /**
         * A control parameter that is an integer.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-securitycontrol-parametervalue.html#cfn-securityhub-securitycontrol-parametervalue-integer">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-securitycontrol-parametervalue.html#cfn-securityhub-securitycontrol-parametervalue-integer</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getInteger() {
            return null;
        }

        /**
         * A control parameter that is a list of integers.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-securitycontrol-parametervalue.html#cfn-securityhub-securitycontrol-parametervalue-integerlist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-securitycontrol-parametervalue.html#cfn-securityhub-securitycontrol-parametervalue-integerlist</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIntegerList() {
            return null;
        }

        /**
         * A control parameter that is a string.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-securitycontrol-parametervalue.html#cfn-securityhub-securitycontrol-parametervalue-string">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-securitycontrol-parametervalue.html#cfn-securityhub-securitycontrol-parametervalue-string</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getString() {
            return null;
        }

        /**
         * A control parameter that is a list of strings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-securitycontrol-parametervalue.html#cfn-securityhub-securitycontrol-parametervalue-stringlist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-securitycontrol-parametervalue.html#cfn-securityhub-securitycontrol-parametervalue-stringlist</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getStringList() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ParameterValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ParameterValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ParameterValueProperty> {
            java.lang.Object booleanValue;
            java.lang.Number doubleValue;
            java.lang.String enumValue;
            java.util.List<java.lang.String> enumList;
            java.lang.Number integer;
            java.lang.Object integerList;
            java.lang.String string;
            java.util.List<java.lang.String> stringList;

            /**
             * Sets the value of {@link ParameterValueProperty#getBooleanValue}
             * @param booleanValue A control parameter that is a boolean.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder booleanValue(java.lang.Boolean booleanValue) {
                this.booleanValue = booleanValue;
                return this;
            }

            /**
             * Sets the value of {@link ParameterValueProperty#getBooleanValue}
             * @param booleanValue A control parameter that is a boolean.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder booleanValue(software.amazon.awscdk.IResolvable booleanValue) {
                this.booleanValue = booleanValue;
                return this;
            }

            /**
             * Sets the value of {@link ParameterValueProperty#getDoubleValue}
             * @param doubleValue A control parameter that is a double.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder doubleValue(java.lang.Number doubleValue) {
                this.doubleValue = doubleValue;
                return this;
            }

            /**
             * Sets the value of {@link ParameterValueProperty#getEnumValue}
             * @param enumValue A control parameter that is an enum.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enumValue(java.lang.String enumValue) {
                this.enumValue = enumValue;
                return this;
            }

            /**
             * Sets the value of {@link ParameterValueProperty#getEnumList}
             * @param enumList A control parameter that is a list of enums.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enumList(java.util.List<java.lang.String> enumList) {
                this.enumList = enumList;
                return this;
            }

            /**
             * Sets the value of {@link ParameterValueProperty#getInteger}
             * @param integer A control parameter that is an integer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder integer(java.lang.Number integer) {
                this.integer = integer;
                return this;
            }

            /**
             * Sets the value of {@link ParameterValueProperty#getIntegerList}
             * @param integerList A control parameter that is a list of integers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder integerList(java.util.List<? extends java.lang.Number> integerList) {
                this.integerList = integerList;
                return this;
            }

            /**
             * Sets the value of {@link ParameterValueProperty#getIntegerList}
             * @param integerList A control parameter that is a list of integers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder integerList(software.amazon.awscdk.IResolvable integerList) {
                this.integerList = integerList;
                return this;
            }

            /**
             * Sets the value of {@link ParameterValueProperty#getString}
             * @param string A control parameter that is a string.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder string(java.lang.String string) {
                this.string = string;
                return this;
            }

            /**
             * Sets the value of {@link ParameterValueProperty#getStringList}
             * @param stringList A control parameter that is a list of strings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stringList(java.util.List<java.lang.String> stringList) {
                this.stringList = stringList;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ParameterValueProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ParameterValueProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ParameterValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ParameterValueProperty {
            private final java.lang.Object booleanValue;
            private final java.lang.Number doubleValue;
            private final java.lang.String enumValue;
            private final java.util.List<java.lang.String> enumList;
            private final java.lang.Number integer;
            private final java.lang.Object integerList;
            private final java.lang.String string;
            private final java.util.List<java.lang.String> stringList;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.booleanValue = software.amazon.jsii.Kernel.get(this, "boolean", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.doubleValue = software.amazon.jsii.Kernel.get(this, "double", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.enumValue = software.amazon.jsii.Kernel.get(this, "enum", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.enumList = software.amazon.jsii.Kernel.get(this, "enumList", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.integer = software.amazon.jsii.Kernel.get(this, "integer", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.integerList = software.amazon.jsii.Kernel.get(this, "integerList", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.string = software.amazon.jsii.Kernel.get(this, "string", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.stringList = software.amazon.jsii.Kernel.get(this, "stringList", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.booleanValue = builder.booleanValue;
                this.doubleValue = builder.doubleValue;
                this.enumValue = builder.enumValue;
                this.enumList = builder.enumList;
                this.integer = builder.integer;
                this.integerList = builder.integerList;
                this.string = builder.string;
                this.stringList = builder.stringList;
            }

            @Override
            public final java.lang.Object getBooleanValue() {
                return this.booleanValue;
            }

            @Override
            public final java.lang.Number getDoubleValue() {
                return this.doubleValue;
            }

            @Override
            public final java.lang.String getEnumValue() {
                return this.enumValue;
            }

            @Override
            public final java.util.List<java.lang.String> getEnumList() {
                return this.enumList;
            }

            @Override
            public final java.lang.Number getInteger() {
                return this.integer;
            }

            @Override
            public final java.lang.Object getIntegerList() {
                return this.integerList;
            }

            @Override
            public final java.lang.String getString() {
                return this.string;
            }

            @Override
            public final java.util.List<java.lang.String> getStringList() {
                return this.stringList;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBooleanValue() != null) {
                    data.set("boolean", om.valueToTree(this.getBooleanValue()));
                }
                if (this.getDoubleValue() != null) {
                    data.set("double", om.valueToTree(this.getDoubleValue()));
                }
                if (this.getEnumValue() != null) {
                    data.set("enum", om.valueToTree(this.getEnumValue()));
                }
                if (this.getEnumList() != null) {
                    data.set("enumList", om.valueToTree(this.getEnumList()));
                }
                if (this.getInteger() != null) {
                    data.set("integer", om.valueToTree(this.getInteger()));
                }
                if (this.getIntegerList() != null) {
                    data.set("integerList", om.valueToTree(this.getIntegerList()));
                }
                if (this.getString() != null) {
                    data.set("string", om.valueToTree(this.getString()));
                }
                if (this.getStringList() != null) {
                    data.set("stringList", om.valueToTree(this.getStringList()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_securityhub.CfnSecurityControl.ParameterValueProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ParameterValueProperty.Jsii$Proxy that = (ParameterValueProperty.Jsii$Proxy) o;

                if (this.booleanValue != null ? !this.booleanValue.equals(that.booleanValue) : that.booleanValue != null) return false;
                if (this.doubleValue != null ? !this.doubleValue.equals(that.doubleValue) : that.doubleValue != null) return false;
                if (this.enumValue != null ? !this.enumValue.equals(that.enumValue) : that.enumValue != null) return false;
                if (this.enumList != null ? !this.enumList.equals(that.enumList) : that.enumList != null) return false;
                if (this.integer != null ? !this.integer.equals(that.integer) : that.integer != null) return false;
                if (this.integerList != null ? !this.integerList.equals(that.integerList) : that.integerList != null) return false;
                if (this.string != null ? !this.string.equals(that.string) : that.string != null) return false;
                return this.stringList != null ? this.stringList.equals(that.stringList) : that.stringList == null;
            }

            @Override
            public final int hashCode() {
                int result = this.booleanValue != null ? this.booleanValue.hashCode() : 0;
                result = 31 * result + (this.doubleValue != null ? this.doubleValue.hashCode() : 0);
                result = 31 * result + (this.enumValue != null ? this.enumValue.hashCode() : 0);
                result = 31 * result + (this.enumList != null ? this.enumList.hashCode() : 0);
                result = 31 * result + (this.integer != null ? this.integer.hashCode() : 0);
                result = 31 * result + (this.integerList != null ? this.integerList.hashCode() : 0);
                result = 31 * result + (this.string != null ? this.string.hashCode() : 0);
                result = 31 * result + (this.stringList != null ? this.stringList.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.securityhub.CfnSecurityControl}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.securityhub.CfnSecurityControl> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.securityhub.CfnSecurityControlProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.securityhub.CfnSecurityControlProps.Builder();
        }

        /**
         * An object that identifies the name of a control parameter, its current value, and whether it has been customized.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-securitycontrol.html#cfn-securityhub-securitycontrol-parameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-securitycontrol.html#cfn-securityhub-securitycontrol-parameters</a>
         * @param parameters An object that identifies the name of a control parameter, its current value, and whether it has been customized. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(final software.amazon.awscdk.IResolvable parameters) {
            this.props.parameters(parameters);
            return this;
        }
        /**
         * An object that identifies the name of a control parameter, its current value, and whether it has been customized.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-securitycontrol.html#cfn-securityhub-securitycontrol-parameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-securitycontrol.html#cfn-securityhub-securitycontrol-parameters</a>
         * @param parameters An object that identifies the name of a control parameter, its current value, and whether it has been customized. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(final java.util.Map<java.lang.String, ? extends java.lang.Object> parameters) {
            this.props.parameters(parameters);
            return this;
        }

        /**
         * The most recent reason for updating the customizable properties of a security control.
         * <p>
         * This differs from the <code>UpdateReason</code> field of the <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_BatchUpdateStandardsControlAssociations.html"><code>BatchUpdateStandardsControlAssociations</code></a> API, which tracks the reason for updating the enablement status of a control. This field accepts alphanumeric characters in addition to white spaces, dashes, and underscores.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-securitycontrol.html#cfn-securityhub-securitycontrol-lastupdatereason">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-securitycontrol.html#cfn-securityhub-securitycontrol-lastupdatereason</a>
         * @param lastUpdateReason The most recent reason for updating the customizable properties of a security control. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lastUpdateReason(final java.lang.String lastUpdateReason) {
            this.props.lastUpdateReason(lastUpdateReason);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) for a security control across standards, such as <code>arn:aws:securityhub:eu-central-1:123456789012:security-control/S3.1</code> . This parameter doesn't mention a specific standard.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-securitycontrol.html#cfn-securityhub-securitycontrol-securitycontrolarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-securitycontrol.html#cfn-securityhub-securitycontrol-securitycontrolarn</a>
         * @param securityControlArn The Amazon Resource Name (ARN) for a security control across standards, such as <code>arn:aws:securityhub:eu-central-1:123456789012:security-control/S3.1</code> . This parameter doesn't mention a specific standard. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityControlArn(final java.lang.String securityControlArn) {
            this.props.securityControlArn(securityControlArn);
            return this;
        }

        /**
         * The unique identifier of a security control across standards.
         * <p>
         * Values for this field typically consist of an AWS service name and a number, such as APIGateway.3.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-securitycontrol.html#cfn-securityhub-securitycontrol-securitycontrolid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-securitycontrol.html#cfn-securityhub-securitycontrol-securitycontrolid</a>
         * @param securityControlId The unique identifier of a security control across standards. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityControlId(final java.lang.String securityControlId) {
            this.props.securityControlId(securityControlId);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.securityhub.CfnSecurityControl}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.securityhub.CfnSecurityControl build() {
            return new software.amazon.awscdk.services.securityhub.CfnSecurityControl(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
