package software.amazon.awscdk.services.mediapackage;

/**
 * Properties for defining a <code>CfnChannel</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.mediapackage.*;
 * CfnChannelProps cfnChannelProps = CfnChannelProps.builder()
 *         .id("id")
 *         // the properties below are optional
 *         .description("description")
 *         .egressAccessLogs(LogConfigurationProperty.builder()
 *                 .logGroupName("logGroupName")
 *                 .build())
 *         .hlsIngest(HlsIngestProperty.builder()
 *                 .ingestEndpoints(List.of(IngestEndpointProperty.builder()
 *                         .id("id")
 *                         .password("password")
 *                         .url("url")
 *                         .username("username")
 *                         .build()))
 *                 .build())
 *         .ingressAccessLogs(LogConfigurationProperty.builder()
 *                 .logGroupName("logGroupName")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-channel.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-channel.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:16.412Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediapackage.CfnChannelProps")
@software.amazon.jsii.Jsii.Proxy(CfnChannelProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnChannelProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Unique identifier that you assign to the channel.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-channel.html#cfn-mediapackage-channel-id">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-channel.html#cfn-mediapackage-channel-id</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getId();

    /**
     * Any descriptive information that you want to add to the channel for future identification purposes.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-channel.html#cfn-mediapackage-channel-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-channel.html#cfn-mediapackage-channel-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Configures egress access logs.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-channel.html#cfn-mediapackage-channel-egressaccesslogs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-channel.html#cfn-mediapackage-channel-egressaccesslogs</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEgressAccessLogs() {
        return null;
    }

    /**
     * The input URL where the source stream should be sent.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-channel.html#cfn-mediapackage-channel-hlsingest">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-channel.html#cfn-mediapackage-channel-hlsingest</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getHlsIngest() {
        return null;
    }

    /**
     * Configures ingress access logs.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-channel.html#cfn-mediapackage-channel-ingressaccesslogs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-channel.html#cfn-mediapackage-channel-ingressaccesslogs</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getIngressAccessLogs() {
        return null;
    }

    /**
     * The tags to assign to the channel.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-channel.html#cfn-mediapackage-channel-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-channel.html#cfn-mediapackage-channel-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnChannelProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnChannelProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnChannelProps> {
        java.lang.String id;
        java.lang.String description;
        java.lang.Object egressAccessLogs;
        java.lang.Object hlsIngest;
        java.lang.Object ingressAccessLogs;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnChannelProps#getId}
         * @param id Unique identifier that you assign to the channel. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder id(java.lang.String id) {
            this.id = id;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getDescription}
         * @param description Any descriptive information that you want to add to the channel for future identification purposes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getEgressAccessLogs}
         * @param egressAccessLogs Configures egress access logs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder egressAccessLogs(software.amazon.awscdk.IResolvable egressAccessLogs) {
            this.egressAccessLogs = egressAccessLogs;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getEgressAccessLogs}
         * @param egressAccessLogs Configures egress access logs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder egressAccessLogs(software.amazon.awscdk.services.mediapackage.CfnChannel.LogConfigurationProperty egressAccessLogs) {
            this.egressAccessLogs = egressAccessLogs;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getHlsIngest}
         * @param hlsIngest The input URL where the source stream should be sent.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hlsIngest(software.amazon.awscdk.IResolvable hlsIngest) {
            this.hlsIngest = hlsIngest;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getHlsIngest}
         * @param hlsIngest The input URL where the source stream should be sent.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hlsIngest(software.amazon.awscdk.services.mediapackage.CfnChannel.HlsIngestProperty hlsIngest) {
            this.hlsIngest = hlsIngest;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getIngressAccessLogs}
         * @param ingressAccessLogs Configures ingress access logs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ingressAccessLogs(software.amazon.awscdk.IResolvable ingressAccessLogs) {
            this.ingressAccessLogs = ingressAccessLogs;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getIngressAccessLogs}
         * @param ingressAccessLogs Configures ingress access logs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ingressAccessLogs(software.amazon.awscdk.services.mediapackage.CfnChannel.LogConfigurationProperty ingressAccessLogs) {
            this.ingressAccessLogs = ingressAccessLogs;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getTags}
         * @param tags The tags to assign to the channel.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnChannelProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnChannelProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnChannelProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnChannelProps {
        private final java.lang.String id;
        private final java.lang.String description;
        private final java.lang.Object egressAccessLogs;
        private final java.lang.Object hlsIngest;
        private final java.lang.Object ingressAccessLogs;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.egressAccessLogs = software.amazon.jsii.Kernel.get(this, "egressAccessLogs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.hlsIngest = software.amazon.jsii.Kernel.get(this, "hlsIngest", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.ingressAccessLogs = software.amazon.jsii.Kernel.get(this, "ingressAccessLogs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.id = java.util.Objects.requireNonNull(builder.id, "id is required");
            this.description = builder.description;
            this.egressAccessLogs = builder.egressAccessLogs;
            this.hlsIngest = builder.hlsIngest;
            this.ingressAccessLogs = builder.ingressAccessLogs;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getId() {
            return this.id;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getEgressAccessLogs() {
            return this.egressAccessLogs;
        }

        @Override
        public final java.lang.Object getHlsIngest() {
            return this.hlsIngest;
        }

        @Override
        public final java.lang.Object getIngressAccessLogs() {
            return this.ingressAccessLogs;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("id", om.valueToTree(this.getId()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEgressAccessLogs() != null) {
                data.set("egressAccessLogs", om.valueToTree(this.getEgressAccessLogs()));
            }
            if (this.getHlsIngest() != null) {
                data.set("hlsIngest", om.valueToTree(this.getHlsIngest()));
            }
            if (this.getIngressAccessLogs() != null) {
                data.set("ingressAccessLogs", om.valueToTree(this.getIngressAccessLogs()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediapackage.CfnChannelProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnChannelProps.Jsii$Proxy that = (CfnChannelProps.Jsii$Proxy) o;

            if (!id.equals(that.id)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.egressAccessLogs != null ? !this.egressAccessLogs.equals(that.egressAccessLogs) : that.egressAccessLogs != null) return false;
            if (this.hlsIngest != null ? !this.hlsIngest.equals(that.hlsIngest) : that.hlsIngest != null) return false;
            if (this.ingressAccessLogs != null ? !this.ingressAccessLogs.equals(that.ingressAccessLogs) : that.ingressAccessLogs != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.id.hashCode();
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.egressAccessLogs != null ? this.egressAccessLogs.hashCode() : 0);
            result = 31 * result + (this.hlsIngest != null ? this.hlsIngest.hashCode() : 0);
            result = 31 * result + (this.ingressAccessLogs != null ? this.ingressAccessLogs.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
