package software.amazon.awscdk.services.kms;

/**
 * Properties of a reference to an existing KMS Alias.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.kms.*;
 * Key key;
 * AliasAttributes aliasAttributes = AliasAttributes.builder()
 *         .aliasName("aliasName")
 *         .aliasTargetKey(key)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:15.416Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kms.AliasAttributes")
@software.amazon.jsii.Jsii.Proxy(AliasAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AliasAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specifies the alias name.
     * <p>
     * This value must begin with alias/ followed by a name (i.e. alias/ExampleAlias)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAliasName();

    /**
     * The customer master key (CMK) to which the Alias refers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kms.IKey getAliasTargetKey();

    /**
     * @return a {@link Builder} of {@link AliasAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AliasAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AliasAttributes> {
        java.lang.String aliasName;
        software.amazon.awscdk.services.kms.IKey aliasTargetKey;

        /**
         * Sets the value of {@link AliasAttributes#getAliasName}
         * @param aliasName Specifies the alias name. This parameter is required.
         *                  This value must begin with alias/ followed by a name (i.e. alias/ExampleAlias)
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder aliasName(java.lang.String aliasName) {
            this.aliasName = aliasName;
            return this;
        }

        /**
         * Sets the value of {@link AliasAttributes#getAliasTargetKey}
         * @param aliasTargetKey The customer master key (CMK) to which the Alias refers. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder aliasTargetKey(software.amazon.awscdk.services.kms.IKey aliasTargetKey) {
            this.aliasTargetKey = aliasTargetKey;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AliasAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AliasAttributes build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AliasAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AliasAttributes {
        private final java.lang.String aliasName;
        private final software.amazon.awscdk.services.kms.IKey aliasTargetKey;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.aliasName = software.amazon.jsii.Kernel.get(this, "aliasName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.aliasTargetKey = software.amazon.jsii.Kernel.get(this, "aliasTargetKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.aliasName = java.util.Objects.requireNonNull(builder.aliasName, "aliasName is required");
            this.aliasTargetKey = java.util.Objects.requireNonNull(builder.aliasTargetKey, "aliasTargetKey is required");
        }

        @Override
        public final java.lang.String getAliasName() {
            return this.aliasName;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getAliasTargetKey() {
            return this.aliasTargetKey;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("aliasName", om.valueToTree(this.getAliasName()));
            data.set("aliasTargetKey", om.valueToTree(this.getAliasTargetKey()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kms.AliasAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AliasAttributes.Jsii$Proxy that = (AliasAttributes.Jsii$Proxy) o;

            if (!aliasName.equals(that.aliasName)) return false;
            return this.aliasTargetKey.equals(that.aliasTargetKey);
        }

        @Override
        public final int hashCode() {
            int result = this.aliasName.hashCode();
            result = 31 * result + (this.aliasTargetKey.hashCode());
            return result;
        }
    }
}
