package software.amazon.awscdk.services.glue;

/**
 * Properties for defining a <code>CfnDatabase</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.glue.*;
 * Object parameters;
 * CfnDatabaseProps cfnDatabaseProps = CfnDatabaseProps.builder()
 *         .catalogId("catalogId")
 *         .databaseInput(DatabaseInputProperty.builder()
 *                 .createTableDefaultPermissions(List.of(PrincipalPrivilegesProperty.builder()
 *                         .permissions(List.of("permissions"))
 *                         .principal(DataLakePrincipalProperty.builder()
 *                                 .dataLakePrincipalIdentifier("dataLakePrincipalIdentifier")
 *                                 .build())
 *                         .build()))
 *                 .description("description")
 *                 .federatedDatabase(FederatedDatabaseProperty.builder()
 *                         .connectionName("connectionName")
 *                         .identifier("identifier")
 *                         .build())
 *                 .locationUri("locationUri")
 *                 .name("name")
 *                 .parameters(parameters)
 *                 .targetDatabase(DatabaseIdentifierProperty.builder()
 *                         .catalogId("catalogId")
 *                         .databaseName("databaseName")
 *                         .region("region")
 *                         .build())
 *                 .build())
 *         // the properties below are optional
 *         .databaseName("databaseName")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-database.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-database.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:14.117Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnDatabaseProps")
@software.amazon.jsii.Jsii.Proxy(CfnDatabaseProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDatabaseProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The AWS account ID for the account in which to create the catalog object.
     * <p>
     * <blockquote>
     * <p>
     * To specify the account ID, you can use the <code>Ref</code> intrinsic function with the <code>AWS::AccountId</code> pseudo parameter. For example: <code>!Ref AWS::AccountId</code>
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-database.html#cfn-glue-database-catalogid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-database.html#cfn-glue-database-catalogid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCatalogId();

    /**
     * The metadata for the database.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-database.html#cfn-glue-database-databaseinput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-database.html#cfn-glue-database-databaseinput</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getDatabaseInput();

    /**
     * The name of the catalog database.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-database.html#cfn-glue-database-databasename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-database.html#cfn-glue-database-databasename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDatabaseName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDatabaseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDatabaseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDatabaseProps> {
        java.lang.String catalogId;
        java.lang.Object databaseInput;
        java.lang.String databaseName;

        /**
         * Sets the value of {@link CfnDatabaseProps#getCatalogId}
         * @param catalogId The AWS account ID for the account in which to create the catalog object. This parameter is required.
         *                  <blockquote>
         *                  <p>
         *                  To specify the account ID, you can use the <code>Ref</code> intrinsic function with the <code>AWS::AccountId</code> pseudo parameter. For example: <code>!Ref AWS::AccountId</code>
         *                  <p>
         *                  </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder catalogId(java.lang.String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        /**
         * Sets the value of {@link CfnDatabaseProps#getDatabaseInput}
         * @param databaseInput The metadata for the database. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder databaseInput(software.amazon.awscdk.IResolvable databaseInput) {
            this.databaseInput = databaseInput;
            return this;
        }

        /**
         * Sets the value of {@link CfnDatabaseProps#getDatabaseInput}
         * @param databaseInput The metadata for the database. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder databaseInput(software.amazon.awscdk.services.glue.CfnDatabase.DatabaseInputProperty databaseInput) {
            this.databaseInput = databaseInput;
            return this;
        }

        /**
         * Sets the value of {@link CfnDatabaseProps#getDatabaseName}
         * @param databaseName The name of the catalog database.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder databaseName(java.lang.String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDatabaseProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDatabaseProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDatabaseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDatabaseProps {
        private final java.lang.String catalogId;
        private final java.lang.Object databaseInput;
        private final java.lang.String databaseName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.catalogId = software.amazon.jsii.Kernel.get(this, "catalogId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.databaseInput = software.amazon.jsii.Kernel.get(this, "databaseInput", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.databaseName = software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.catalogId = java.util.Objects.requireNonNull(builder.catalogId, "catalogId is required");
            this.databaseInput = java.util.Objects.requireNonNull(builder.databaseInput, "databaseInput is required");
            this.databaseName = builder.databaseName;
        }

        @Override
        public final java.lang.String getCatalogId() {
            return this.catalogId;
        }

        @Override
        public final java.lang.Object getDatabaseInput() {
            return this.databaseInput;
        }

        @Override
        public final java.lang.String getDatabaseName() {
            return this.databaseName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("catalogId", om.valueToTree(this.getCatalogId()));
            data.set("databaseInput", om.valueToTree(this.getDatabaseInput()));
            if (this.getDatabaseName() != null) {
                data.set("databaseName", om.valueToTree(this.getDatabaseName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_glue.CfnDatabaseProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDatabaseProps.Jsii$Proxy that = (CfnDatabaseProps.Jsii$Proxy) o;

            if (!catalogId.equals(that.catalogId)) return false;
            if (!databaseInput.equals(that.databaseInput)) return false;
            return this.databaseName != null ? this.databaseName.equals(that.databaseName) : that.databaseName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.catalogId.hashCode();
            result = 31 * result + (this.databaseInput.hashCode());
            result = 31 * result + (this.databaseName != null ? this.databaseName.hashCode() : 0);
            return result;
        }
    }
}
