package software.amazon.awscdk.services.fsx;

/**
 * Properties for defining a <code>CfnVolume</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.fsx.*;
 * CfnVolumeProps cfnVolumeProps = CfnVolumeProps.builder()
 *         .name("name")
 *         // the properties below are optional
 *         .backupId("backupId")
 *         .ontapConfiguration(OntapConfigurationProperty.builder()
 *                 .storageVirtualMachineId("storageVirtualMachineId")
 *                 // the properties below are optional
 *                 .aggregateConfiguration(AggregateConfigurationProperty.builder()
 *                         .aggregates(List.of("aggregates"))
 *                         .constituentsPerAggregate(123)
 *                         .build())
 *                 .copyTagsToBackups("copyTagsToBackups")
 *                 .junctionPath("junctionPath")
 *                 .ontapVolumeType("ontapVolumeType")
 *                 .securityStyle("securityStyle")
 *                 .sizeInBytes("sizeInBytes")
 *                 .sizeInMegabytes("sizeInMegabytes")
 *                 .snaplockConfiguration(SnaplockConfigurationProperty.builder()
 *                         .snaplockType("snaplockType")
 *                         // the properties below are optional
 *                         .auditLogVolume("auditLogVolume")
 *                         .autocommitPeriod(AutocommitPeriodProperty.builder()
 *                                 .type("type")
 *                                 // the properties below are optional
 *                                 .value(123)
 *                                 .build())
 *                         .privilegedDelete("privilegedDelete")
 *                         .retentionPeriod(SnaplockRetentionPeriodProperty.builder()
 *                                 .defaultRetention(RetentionPeriodProperty.builder()
 *                                         .type("type")
 *                                         // the properties below are optional
 *                                         .value(123)
 *                                         .build())
 *                                 .maximumRetention(RetentionPeriodProperty.builder()
 *                                         .type("type")
 *                                         // the properties below are optional
 *                                         .value(123)
 *                                         .build())
 *                                 .minimumRetention(RetentionPeriodProperty.builder()
 *                                         .type("type")
 *                                         // the properties below are optional
 *                                         .value(123)
 *                                         .build())
 *                                 .build())
 *                         .volumeAppendModeEnabled("volumeAppendModeEnabled")
 *                         .build())
 *                 .snapshotPolicy("snapshotPolicy")
 *                 .storageEfficiencyEnabled("storageEfficiencyEnabled")
 *                 .tieringPolicy(TieringPolicyProperty.builder()
 *                         .coolingPeriod(123)
 *                         .name("name")
 *                         .build())
 *                 .volumeStyle("volumeStyle")
 *                 .build())
 *         .openZfsConfiguration(OpenZFSConfigurationProperty.builder()
 *                 .parentVolumeId("parentVolumeId")
 *                 // the properties below are optional
 *                 .copyTagsToSnapshots(false)
 *                 .dataCompressionType("dataCompressionType")
 *                 .nfsExports(List.of(NfsExportsProperty.builder()
 *                         .clientConfigurations(List.of(ClientConfigurationsProperty.builder()
 *                                 .clients("clients")
 *                                 .options(List.of("options"))
 *                                 .build()))
 *                         .build()))
 *                 .options(List.of("options"))
 *                 .originSnapshot(OriginSnapshotProperty.builder()
 *                         .copyStrategy("copyStrategy")
 *                         .snapshotArn("snapshotArn")
 *                         .build())
 *                 .readOnly(false)
 *                 .recordSizeKiB(123)
 *                 .storageCapacityQuotaGiB(123)
 *                 .storageCapacityReservationGiB(123)
 *                 .userAndGroupQuotas(List.of(UserAndGroupQuotasProperty.builder()
 *                         .id(123)
 *                         .storageCapacityQuotaGiB(123)
 *                         .type("type")
 *                         .build()))
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .volumeType("volumeType")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-volume.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-volume.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:13.908Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fsx.CfnVolumeProps")
@software.amazon.jsii.Jsii.Proxy(CfnVolumeProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnVolumeProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the volume.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-volume.html#cfn-fsx-volume-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-volume.html#cfn-fsx-volume-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * Specifies the ID of the volume backup to use to create a new volume.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-volume.html#cfn-fsx-volume-backupid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-volume.html#cfn-fsx-volume-backupid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getBackupId() {
        return null;
    }

    /**
     * The configuration of an Amazon FSx for NetApp ONTAP volume.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-volume.html#cfn-fsx-volume-ontapconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-volume.html#cfn-fsx-volume-ontapconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getOntapConfiguration() {
        return null;
    }

    /**
     * The configuration of an Amazon FSx for OpenZFS volume.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-volume.html#cfn-fsx-volume-openzfsconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-volume.html#cfn-fsx-volume-openzfsconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getOpenZfsConfiguration() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-volume.html#cfn-fsx-volume-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-volume.html#cfn-fsx-volume-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The type of the volume.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-volume.html#cfn-fsx-volume-volumetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-volume.html#cfn-fsx-volume-volumetype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVolumeType() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnVolumeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnVolumeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnVolumeProps> {
        java.lang.String name;
        java.lang.String backupId;
        java.lang.Object ontapConfiguration;
        java.lang.Object openZfsConfiguration;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.String volumeType;

        /**
         * Sets the value of {@link CfnVolumeProps#getName}
         * @param name The name of the volume. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnVolumeProps#getBackupId}
         * @param backupId Specifies the ID of the volume backup to use to create a new volume.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupId(java.lang.String backupId) {
            this.backupId = backupId;
            return this;
        }

        /**
         * Sets the value of {@link CfnVolumeProps#getOntapConfiguration}
         * @param ontapConfiguration The configuration of an Amazon FSx for NetApp ONTAP volume.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ontapConfiguration(software.amazon.awscdk.IResolvable ontapConfiguration) {
            this.ontapConfiguration = ontapConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnVolumeProps#getOntapConfiguration}
         * @param ontapConfiguration The configuration of an Amazon FSx for NetApp ONTAP volume.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ontapConfiguration(software.amazon.awscdk.services.fsx.CfnVolume.OntapConfigurationProperty ontapConfiguration) {
            this.ontapConfiguration = ontapConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnVolumeProps#getOpenZfsConfiguration}
         * @param openZfsConfiguration The configuration of an Amazon FSx for OpenZFS volume.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder openZfsConfiguration(software.amazon.awscdk.IResolvable openZfsConfiguration) {
            this.openZfsConfiguration = openZfsConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnVolumeProps#getOpenZfsConfiguration}
         * @param openZfsConfiguration The configuration of an Amazon FSx for OpenZFS volume.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder openZfsConfiguration(software.amazon.awscdk.services.fsx.CfnVolume.OpenZFSConfigurationProperty openZfsConfiguration) {
            this.openZfsConfiguration = openZfsConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnVolumeProps#getTags}
         * @param tags An array of key-value pairs to apply to this resource.
         *             For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnVolumeProps#getVolumeType}
         * @param volumeType The type of the volume.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder volumeType(java.lang.String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnVolumeProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnVolumeProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnVolumeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnVolumeProps {
        private final java.lang.String name;
        private final java.lang.String backupId;
        private final java.lang.Object ontapConfiguration;
        private final java.lang.Object openZfsConfiguration;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.String volumeType;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.backupId = software.amazon.jsii.Kernel.get(this, "backupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ontapConfiguration = software.amazon.jsii.Kernel.get(this, "ontapConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.openZfsConfiguration = software.amazon.jsii.Kernel.get(this, "openZfsConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.volumeType = software.amazon.jsii.Kernel.get(this, "volumeType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.backupId = builder.backupId;
            this.ontapConfiguration = builder.ontapConfiguration;
            this.openZfsConfiguration = builder.openZfsConfiguration;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.volumeType = builder.volumeType;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getBackupId() {
            return this.backupId;
        }

        @Override
        public final java.lang.Object getOntapConfiguration() {
            return this.ontapConfiguration;
        }

        @Override
        public final java.lang.Object getOpenZfsConfiguration() {
            return this.openZfsConfiguration;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getVolumeType() {
            return this.volumeType;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            if (this.getBackupId() != null) {
                data.set("backupId", om.valueToTree(this.getBackupId()));
            }
            if (this.getOntapConfiguration() != null) {
                data.set("ontapConfiguration", om.valueToTree(this.getOntapConfiguration()));
            }
            if (this.getOpenZfsConfiguration() != null) {
                data.set("openZfsConfiguration", om.valueToTree(this.getOpenZfsConfiguration()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getVolumeType() != null) {
                data.set("volumeType", om.valueToTree(this.getVolumeType()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fsx.CfnVolumeProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnVolumeProps.Jsii$Proxy that = (CfnVolumeProps.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (this.backupId != null ? !this.backupId.equals(that.backupId) : that.backupId != null) return false;
            if (this.ontapConfiguration != null ? !this.ontapConfiguration.equals(that.ontapConfiguration) : that.ontapConfiguration != null) return false;
            if (this.openZfsConfiguration != null ? !this.openZfsConfiguration.equals(that.openZfsConfiguration) : that.openZfsConfiguration != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.volumeType != null ? this.volumeType.equals(that.volumeType) : that.volumeType == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.backupId != null ? this.backupId.hashCode() : 0);
            result = 31 * result + (this.ontapConfiguration != null ? this.ontapConfiguration.hashCode() : 0);
            result = 31 * result + (this.openZfsConfiguration != null ? this.openZfsConfiguration.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.volumeType != null ? this.volumeType.hashCode() : 0);
            return result;
        }
    }
}
