package software.amazon.awscdk.services.frauddetector;

/**
 * Properties for defining a <code>CfnDetector</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.frauddetector.*;
 * CfnDetectorProps cfnDetectorProps = CfnDetectorProps.builder()
 *         .detectorId("detectorId")
 *         .eventType(EventTypeProperty.builder()
 *                 .arn("arn")
 *                 .createdTime("createdTime")
 *                 .description("description")
 *                 .entityTypes(List.of(EntityTypeProperty.builder()
 *                         .arn("arn")
 *                         .createdTime("createdTime")
 *                         .description("description")
 *                         .inline(false)
 *                         .lastUpdatedTime("lastUpdatedTime")
 *                         .name("name")
 *                         .tags(List.of(CfnTag.builder()
 *                                 .key("key")
 *                                 .value("value")
 *                                 .build()))
 *                         .build()))
 *                 .eventVariables(List.of(EventVariableProperty.builder()
 *                         .arn("arn")
 *                         .createdTime("createdTime")
 *                         .dataSource("dataSource")
 *                         .dataType("dataType")
 *                         .defaultValue("defaultValue")
 *                         .description("description")
 *                         .inline(false)
 *                         .lastUpdatedTime("lastUpdatedTime")
 *                         .name("name")
 *                         .tags(List.of(CfnTag.builder()
 *                                 .key("key")
 *                                 .value("value")
 *                                 .build()))
 *                         .variableType("variableType")
 *                         .build()))
 *                 .inline(false)
 *                 .labels(List.of(LabelProperty.builder()
 *                         .arn("arn")
 *                         .createdTime("createdTime")
 *                         .description("description")
 *                         .inline(false)
 *                         .lastUpdatedTime("lastUpdatedTime")
 *                         .name("name")
 *                         .tags(List.of(CfnTag.builder()
 *                                 .key("key")
 *                                 .value("value")
 *                                 .build()))
 *                         .build()))
 *                 .lastUpdatedTime("lastUpdatedTime")
 *                 .name("name")
 *                 .tags(List.of(CfnTag.builder()
 *                         .key("key")
 *                         .value("value")
 *                         .build()))
 *                 .build())
 *         .rules(List.of(RuleProperty.builder()
 *                 .arn("arn")
 *                 .createdTime("createdTime")
 *                 .description("description")
 *                 .detectorId("detectorId")
 *                 .expression("expression")
 *                 .language("language")
 *                 .lastUpdatedTime("lastUpdatedTime")
 *                 .outcomes(List.of(OutcomeProperty.builder()
 *                         .arn("arn")
 *                         .createdTime("createdTime")
 *                         .description("description")
 *                         .inline(false)
 *                         .lastUpdatedTime("lastUpdatedTime")
 *                         .name("name")
 *                         .tags(List.of(CfnTag.builder()
 *                                 .key("key")
 *                                 .value("value")
 *                                 .build()))
 *                         .build()))
 *                 .ruleId("ruleId")
 *                 .ruleVersion("ruleVersion")
 *                 .tags(List.of(CfnTag.builder()
 *                         .key("key")
 *                         .value("value")
 *                         .build()))
 *                 .build()))
 *         // the properties below are optional
 *         .associatedModels(List.of(ModelProperty.builder()
 *                 .arn("arn")
 *                 .build()))
 *         .description("description")
 *         .detectorVersionStatus("detectorVersionStatus")
 *         .ruleExecutionMode("ruleExecutionMode")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-frauddetector-detector.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-frauddetector-detector.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:13.811Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_frauddetector.CfnDetectorProps")
@software.amazon.jsii.Jsii.Proxy(CfnDetectorProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDetectorProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the detector.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-frauddetector-detector.html#cfn-frauddetector-detector-detectorid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-frauddetector-detector.html#cfn-frauddetector-detector-detectorid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDetectorId();

    /**
     * The event type associated with this detector.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-frauddetector-detector.html#cfn-frauddetector-detector-eventtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-frauddetector-detector.html#cfn-frauddetector-detector-eventtype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getEventType();

    /**
     * The rules to include in the detector version.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-frauddetector-detector.html#cfn-frauddetector-detector-rules">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-frauddetector-detector.html#cfn-frauddetector-detector-rules</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getRules();

    /**
     * The models to associate with this detector.
     * <p>
     * You must provide the ARNs of all the models you want to associate.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-frauddetector-detector.html#cfn-frauddetector-detector-associatedmodels">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-frauddetector-detector.html#cfn-frauddetector-detector-associatedmodels</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAssociatedModels() {
        return null;
    }

    /**
     * The detector description.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-frauddetector-detector.html#cfn-frauddetector-detector-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-frauddetector-detector.html#cfn-frauddetector-detector-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The status of the detector version.
     * <p>
     * If a value is not provided for this property, AWS CloudFormation assumes <code>DRAFT</code> status.
     * <p>
     * Valid values: <code>ACTIVE | DRAFT</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-frauddetector-detector.html#cfn-frauddetector-detector-detectorversionstatus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-frauddetector-detector.html#cfn-frauddetector-detector-detectorversionstatus</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDetectorVersionStatus() {
        return null;
    }

    /**
     * The rule execution mode for the rules included in the detector version.
     * <p>
     * Valid values: <code>FIRST_MATCHED | ALL_MATCHED</code> Default value: <code>FIRST_MATCHED</code>
     * <p>
     * You can define and edit the rule mode at the detector version level, when it is in draft status.
     * <p>
     * If you specify <code>FIRST_MATCHED</code> , Amazon Fraud Detector evaluates rules sequentially, first to last, stopping at the first matched rule. Amazon Fraud dectector then provides the outcomes for that single rule.
     * <p>
     * If you specifiy <code>ALL_MATCHED</code> , Amazon Fraud Detector evaluates all rules and returns the outcomes for all matched rules.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-frauddetector-detector.html#cfn-frauddetector-detector-ruleexecutionmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-frauddetector-detector.html#cfn-frauddetector-detector-ruleexecutionmode</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRuleExecutionMode() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-frauddetector-detector.html#cfn-frauddetector-detector-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-frauddetector-detector.html#cfn-frauddetector-detector-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDetectorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDetectorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDetectorProps> {
        java.lang.String detectorId;
        java.lang.Object eventType;
        java.lang.Object rules;
        java.lang.Object associatedModels;
        java.lang.String description;
        java.lang.String detectorVersionStatus;
        java.lang.String ruleExecutionMode;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnDetectorProps#getDetectorId}
         * @param detectorId The name of the detector. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder detectorId(java.lang.String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        /**
         * Sets the value of {@link CfnDetectorProps#getEventType}
         * @param eventType The event type associated with this detector. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventType(software.amazon.awscdk.IResolvable eventType) {
            this.eventType = eventType;
            return this;
        }

        /**
         * Sets the value of {@link CfnDetectorProps#getEventType}
         * @param eventType The event type associated with this detector. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventType(software.amazon.awscdk.services.frauddetector.CfnDetector.EventTypeProperty eventType) {
            this.eventType = eventType;
            return this;
        }

        /**
         * Sets the value of {@link CfnDetectorProps#getRules}
         * @param rules The rules to include in the detector version. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rules(software.amazon.awscdk.IResolvable rules) {
            this.rules = rules;
            return this;
        }

        /**
         * Sets the value of {@link CfnDetectorProps#getRules}
         * @param rules The rules to include in the detector version. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rules(java.util.List<? extends java.lang.Object> rules) {
            this.rules = rules;
            return this;
        }

        /**
         * Sets the value of {@link CfnDetectorProps#getAssociatedModels}
         * @param associatedModels The models to associate with this detector.
         *                         You must provide the ARNs of all the models you want to associate.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder associatedModels(software.amazon.awscdk.IResolvable associatedModels) {
            this.associatedModels = associatedModels;
            return this;
        }

        /**
         * Sets the value of {@link CfnDetectorProps#getAssociatedModels}
         * @param associatedModels The models to associate with this detector.
         *                         You must provide the ARNs of all the models you want to associate.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder associatedModels(java.util.List<? extends java.lang.Object> associatedModels) {
            this.associatedModels = associatedModels;
            return this;
        }

        /**
         * Sets the value of {@link CfnDetectorProps#getDescription}
         * @param description The detector description.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnDetectorProps#getDetectorVersionStatus}
         * @param detectorVersionStatus The status of the detector version.
         *                              If a value is not provided for this property, AWS CloudFormation assumes <code>DRAFT</code> status.
         *                              <p>
         *                              Valid values: <code>ACTIVE | DRAFT</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder detectorVersionStatus(java.lang.String detectorVersionStatus) {
            this.detectorVersionStatus = detectorVersionStatus;
            return this;
        }

        /**
         * Sets the value of {@link CfnDetectorProps#getRuleExecutionMode}
         * @param ruleExecutionMode The rule execution mode for the rules included in the detector version.
         *                          Valid values: <code>FIRST_MATCHED | ALL_MATCHED</code> Default value: <code>FIRST_MATCHED</code>
         *                          <p>
         *                          You can define and edit the rule mode at the detector version level, when it is in draft status.
         *                          <p>
         *                          If you specify <code>FIRST_MATCHED</code> , Amazon Fraud Detector evaluates rules sequentially, first to last, stopping at the first matched rule. Amazon Fraud dectector then provides the outcomes for that single rule.
         *                          <p>
         *                          If you specifiy <code>ALL_MATCHED</code> , Amazon Fraud Detector evaluates all rules and returns the outcomes for all matched rules.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleExecutionMode(java.lang.String ruleExecutionMode) {
            this.ruleExecutionMode = ruleExecutionMode;
            return this;
        }

        /**
         * Sets the value of {@link CfnDetectorProps#getTags}
         * @param tags An array of key-value pairs to apply to this resource.
         *             For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDetectorProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDetectorProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDetectorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDetectorProps {
        private final java.lang.String detectorId;
        private final java.lang.Object eventType;
        private final java.lang.Object rules;
        private final java.lang.Object associatedModels;
        private final java.lang.String description;
        private final java.lang.String detectorVersionStatus;
        private final java.lang.String ruleExecutionMode;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.detectorId = software.amazon.jsii.Kernel.get(this, "detectorId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.eventType = software.amazon.jsii.Kernel.get(this, "eventType", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.rules = software.amazon.jsii.Kernel.get(this, "rules", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.associatedModels = software.amazon.jsii.Kernel.get(this, "associatedModels", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.detectorVersionStatus = software.amazon.jsii.Kernel.get(this, "detectorVersionStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ruleExecutionMode = software.amazon.jsii.Kernel.get(this, "ruleExecutionMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.detectorId = java.util.Objects.requireNonNull(builder.detectorId, "detectorId is required");
            this.eventType = java.util.Objects.requireNonNull(builder.eventType, "eventType is required");
            this.rules = java.util.Objects.requireNonNull(builder.rules, "rules is required");
            this.associatedModels = builder.associatedModels;
            this.description = builder.description;
            this.detectorVersionStatus = builder.detectorVersionStatus;
            this.ruleExecutionMode = builder.ruleExecutionMode;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getDetectorId() {
            return this.detectorId;
        }

        @Override
        public final java.lang.Object getEventType() {
            return this.eventType;
        }

        @Override
        public final java.lang.Object getRules() {
            return this.rules;
        }

        @Override
        public final java.lang.Object getAssociatedModels() {
            return this.associatedModels;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getDetectorVersionStatus() {
            return this.detectorVersionStatus;
        }

        @Override
        public final java.lang.String getRuleExecutionMode() {
            return this.ruleExecutionMode;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("detectorId", om.valueToTree(this.getDetectorId()));
            data.set("eventType", om.valueToTree(this.getEventType()));
            data.set("rules", om.valueToTree(this.getRules()));
            if (this.getAssociatedModels() != null) {
                data.set("associatedModels", om.valueToTree(this.getAssociatedModels()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getDetectorVersionStatus() != null) {
                data.set("detectorVersionStatus", om.valueToTree(this.getDetectorVersionStatus()));
            }
            if (this.getRuleExecutionMode() != null) {
                data.set("ruleExecutionMode", om.valueToTree(this.getRuleExecutionMode()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_frauddetector.CfnDetectorProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDetectorProps.Jsii$Proxy that = (CfnDetectorProps.Jsii$Proxy) o;

            if (!detectorId.equals(that.detectorId)) return false;
            if (!eventType.equals(that.eventType)) return false;
            if (!rules.equals(that.rules)) return false;
            if (this.associatedModels != null ? !this.associatedModels.equals(that.associatedModels) : that.associatedModels != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.detectorVersionStatus != null ? !this.detectorVersionStatus.equals(that.detectorVersionStatus) : that.detectorVersionStatus != null) return false;
            if (this.ruleExecutionMode != null ? !this.ruleExecutionMode.equals(that.ruleExecutionMode) : that.ruleExecutionMode != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.detectorId.hashCode();
            result = 31 * result + (this.eventType.hashCode());
            result = 31 * result + (this.rules.hashCode());
            result = 31 * result + (this.associatedModels != null ? this.associatedModels.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.detectorVersionStatus != null ? this.detectorVersionStatus.hashCode() : 0);
            result = 31 * result + (this.ruleExecutionMode != null ? this.ruleExecutionMode.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
