package software.amazon.awscdk.services.events.targets;

/**
 * Customize the EventBridge Api Destinations Target.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.events.*;
 * import software.amazon.awscdk.services.events.targets.*;
 * import software.amazon.awscdk.services.iam.*;
 * import software.amazon.awscdk.services.sqs.*;
 * Queue queue;
 * Role role;
 * RuleTargetInput ruleTargetInput;
 * ApiDestinationProps apiDestinationProps = ApiDestinationProps.builder()
 *         .deadLetterQueue(queue)
 *         .event(ruleTargetInput)
 *         .eventRole(role)
 *         .headerParameters(Map.of(
 *                 "headerParametersKey", "headerParameters"))
 *         .maxEventAge(Duration.minutes(30))
 *         .pathParameterValues(List.of("pathParameterValues"))
 *         .queryStringParameters(Map.of(
 *                 "queryStringParametersKey", "queryStringParameters"))
 *         .retryAttempts(123)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:13.640Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events_targets.ApiDestinationProps")
@software.amazon.jsii.Jsii.Proxy(ApiDestinationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ApiDestinationProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.events.targets.TargetBaseProps {

    /**
     * The event to send.
     * <p>
     * Default: - the entire EventBridge event
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.RuleTargetInput getEvent() {
        return null;
    }

    /**
     * The role to assume before invoking the target.
     * <p>
     * Default: - a new role will be created
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getEventRole() {
        return null;
    }

    /**
     * Additional headers sent to the API Destination.
     * <p>
     * These are merged with headers specified on the Connection, with
     * the headers on the Connection taking precedence.
     * <p>
     * You can only specify secret values on the Connection.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getHeaderParameters() {
        return null;
    }

    /**
     * Path parameters to insert in place of path wildcards (<code>*</code>).
     * <p>
     * If the API destination has a wilcard in the path, these path parts
     * will be inserted in that place.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPathParameterValues() {
        return null;
    }

    /**
     * Additional query string parameters sent to the API Destination.
     * <p>
     * These are merged with headers specified on the Connection, with
     * the headers on the Connection taking precedence.
     * <p>
     * You can only specify secret values on the Connection.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getQueryStringParameters() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ApiDestinationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ApiDestinationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ApiDestinationProps> {
        software.amazon.awscdk.services.events.RuleTargetInput event;
        software.amazon.awscdk.services.iam.IRole eventRole;
        java.util.Map<java.lang.String, java.lang.String> headerParameters;
        java.util.List<java.lang.String> pathParameterValues;
        java.util.Map<java.lang.String, java.lang.String> queryStringParameters;
        software.amazon.awscdk.services.sqs.IQueue deadLetterQueue;
        software.amazon.awscdk.Duration maxEventAge;
        java.lang.Number retryAttempts;

        /**
         * Sets the value of {@link ApiDestinationProps#getEvent}
         * @param event The event to send.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder event(software.amazon.awscdk.services.events.RuleTargetInput event) {
            this.event = event;
            return this;
        }

        /**
         * Sets the value of {@link ApiDestinationProps#getEventRole}
         * @param eventRole The role to assume before invoking the target.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventRole(software.amazon.awscdk.services.iam.IRole eventRole) {
            this.eventRole = eventRole;
            return this;
        }

        /**
         * Sets the value of {@link ApiDestinationProps#getHeaderParameters}
         * @param headerParameters Additional headers sent to the API Destination.
         *                         These are merged with headers specified on the Connection, with
         *                         the headers on the Connection taking precedence.
         *                         <p>
         *                         You can only specify secret values on the Connection.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder headerParameters(java.util.Map<java.lang.String, java.lang.String> headerParameters) {
            this.headerParameters = headerParameters;
            return this;
        }

        /**
         * Sets the value of {@link ApiDestinationProps#getPathParameterValues}
         * @param pathParameterValues Path parameters to insert in place of path wildcards (<code>*</code>).
         *                            If the API destination has a wilcard in the path, these path parts
         *                            will be inserted in that place.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pathParameterValues(java.util.List<java.lang.String> pathParameterValues) {
            this.pathParameterValues = pathParameterValues;
            return this;
        }

        /**
         * Sets the value of {@link ApiDestinationProps#getQueryStringParameters}
         * @param queryStringParameters Additional query string parameters sent to the API Destination.
         *                              These are merged with headers specified on the Connection, with
         *                              the headers on the Connection taking precedence.
         *                              <p>
         *                              You can only specify secret values on the Connection.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryStringParameters(java.util.Map<java.lang.String, java.lang.String> queryStringParameters) {
            this.queryStringParameters = queryStringParameters;
            return this;
        }

        /**
         * Sets the value of {@link ApiDestinationProps#getDeadLetterQueue}
         * @param deadLetterQueue The SQS queue to be used as deadLetterQueue. Check out the <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/rule-dlq.html#dlq-considerations">considerations for using a dead-letter queue</a>.
         *                        The events not successfully delivered are automatically retried for a specified period of time,
         *                        depending on the retry policy of the target.
         *                        If an event is not delivered before all retry attempts are exhausted, it will be sent to the dead letter queue.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deadLetterQueue(software.amazon.awscdk.services.sqs.IQueue deadLetterQueue) {
            this.deadLetterQueue = deadLetterQueue;
            return this;
        }

        /**
         * Sets the value of {@link ApiDestinationProps#getMaxEventAge}
         * @param maxEventAge The maximum age of a request that Lambda sends to a function for processing.
         *                    Minimum value of 60.
         *                    Maximum value of 86400.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxEventAge(software.amazon.awscdk.Duration maxEventAge) {
            this.maxEventAge = maxEventAge;
            return this;
        }

        /**
         * Sets the value of {@link ApiDestinationProps#getRetryAttempts}
         * @param retryAttempts The maximum number of times to retry when the function returns an error.
         *                      Minimum value of 0.
         *                      Maximum value of 185.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retryAttempts(java.lang.Number retryAttempts) {
            this.retryAttempts = retryAttempts;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ApiDestinationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ApiDestinationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ApiDestinationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApiDestinationProps {
        private final software.amazon.awscdk.services.events.RuleTargetInput event;
        private final software.amazon.awscdk.services.iam.IRole eventRole;
        private final java.util.Map<java.lang.String, java.lang.String> headerParameters;
        private final java.util.List<java.lang.String> pathParameterValues;
        private final java.util.Map<java.lang.String, java.lang.String> queryStringParameters;
        private final software.amazon.awscdk.services.sqs.IQueue deadLetterQueue;
        private final software.amazon.awscdk.Duration maxEventAge;
        private final java.lang.Number retryAttempts;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.event = software.amazon.jsii.Kernel.get(this, "event", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.RuleTargetInput.class));
            this.eventRole = software.amazon.jsii.Kernel.get(this, "eventRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.headerParameters = software.amazon.jsii.Kernel.get(this, "headerParameters", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.pathParameterValues = software.amazon.jsii.Kernel.get(this, "pathParameterValues", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.queryStringParameters = software.amazon.jsii.Kernel.get(this, "queryStringParameters", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.deadLetterQueue = software.amazon.jsii.Kernel.get(this, "deadLetterQueue", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sqs.IQueue.class));
            this.maxEventAge = software.amazon.jsii.Kernel.get(this, "maxEventAge", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.retryAttempts = software.amazon.jsii.Kernel.get(this, "retryAttempts", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.event = builder.event;
            this.eventRole = builder.eventRole;
            this.headerParameters = builder.headerParameters;
            this.pathParameterValues = builder.pathParameterValues;
            this.queryStringParameters = builder.queryStringParameters;
            this.deadLetterQueue = builder.deadLetterQueue;
            this.maxEventAge = builder.maxEventAge;
            this.retryAttempts = builder.retryAttempts;
        }

        @Override
        public final software.amazon.awscdk.services.events.RuleTargetInput getEvent() {
            return this.event;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getEventRole() {
            return this.eventRole;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getHeaderParameters() {
            return this.headerParameters;
        }

        @Override
        public final java.util.List<java.lang.String> getPathParameterValues() {
            return this.pathParameterValues;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getQueryStringParameters() {
            return this.queryStringParameters;
        }

        @Override
        public final software.amazon.awscdk.services.sqs.IQueue getDeadLetterQueue() {
            return this.deadLetterQueue;
        }

        @Override
        public final software.amazon.awscdk.Duration getMaxEventAge() {
            return this.maxEventAge;
        }

        @Override
        public final java.lang.Number getRetryAttempts() {
            return this.retryAttempts;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getEvent() != null) {
                data.set("event", om.valueToTree(this.getEvent()));
            }
            if (this.getEventRole() != null) {
                data.set("eventRole", om.valueToTree(this.getEventRole()));
            }
            if (this.getHeaderParameters() != null) {
                data.set("headerParameters", om.valueToTree(this.getHeaderParameters()));
            }
            if (this.getPathParameterValues() != null) {
                data.set("pathParameterValues", om.valueToTree(this.getPathParameterValues()));
            }
            if (this.getQueryStringParameters() != null) {
                data.set("queryStringParameters", om.valueToTree(this.getQueryStringParameters()));
            }
            if (this.getDeadLetterQueue() != null) {
                data.set("deadLetterQueue", om.valueToTree(this.getDeadLetterQueue()));
            }
            if (this.getMaxEventAge() != null) {
                data.set("maxEventAge", om.valueToTree(this.getMaxEventAge()));
            }
            if (this.getRetryAttempts() != null) {
                data.set("retryAttempts", om.valueToTree(this.getRetryAttempts()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_events_targets.ApiDestinationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ApiDestinationProps.Jsii$Proxy that = (ApiDestinationProps.Jsii$Proxy) o;

            if (this.event != null ? !this.event.equals(that.event) : that.event != null) return false;
            if (this.eventRole != null ? !this.eventRole.equals(that.eventRole) : that.eventRole != null) return false;
            if (this.headerParameters != null ? !this.headerParameters.equals(that.headerParameters) : that.headerParameters != null) return false;
            if (this.pathParameterValues != null ? !this.pathParameterValues.equals(that.pathParameterValues) : that.pathParameterValues != null) return false;
            if (this.queryStringParameters != null ? !this.queryStringParameters.equals(that.queryStringParameters) : that.queryStringParameters != null) return false;
            if (this.deadLetterQueue != null ? !this.deadLetterQueue.equals(that.deadLetterQueue) : that.deadLetterQueue != null) return false;
            if (this.maxEventAge != null ? !this.maxEventAge.equals(that.maxEventAge) : that.maxEventAge != null) return false;
            return this.retryAttempts != null ? this.retryAttempts.equals(that.retryAttempts) : that.retryAttempts == null;
        }

        @Override
        public final int hashCode() {
            int result = this.event != null ? this.event.hashCode() : 0;
            result = 31 * result + (this.eventRole != null ? this.eventRole.hashCode() : 0);
            result = 31 * result + (this.headerParameters != null ? this.headerParameters.hashCode() : 0);
            result = 31 * result + (this.pathParameterValues != null ? this.pathParameterValues.hashCode() : 0);
            result = 31 * result + (this.queryStringParameters != null ? this.queryStringParameters.hashCode() : 0);
            result = 31 * result + (this.deadLetterQueue != null ? this.deadLetterQueue.hashCode() : 0);
            result = 31 * result + (this.maxEventAge != null ? this.maxEventAge.hashCode() : 0);
            result = 31 * result + (this.retryAttempts != null ? this.retryAttempts.hashCode() : 0);
            return result;
        }
    }
}
