package software.amazon.awscdk.services.efs;

/**
 * Properties that describe an existing EFS file system.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.iam.*;
 * IFileSystem importedFileSystem = FileSystem.fromFileSystemAttributes(this, "existingFS", FileSystemAttributes.builder()
 *         .fileSystemId("fs-12345678") // You can also use fileSystemArn instead of fileSystemId.
 *         .securityGroup(SecurityGroup.fromSecurityGroupId(this, "SG", "sg-123456789", SecurityGroupImportOptions.builder()
 *                 .allowAllOutbound(false)
 *                 .build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:11.981Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_efs.FileSystemAttributes")
@software.amazon.jsii.Jsii.Proxy(FileSystemAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface FileSystemAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * The security group of the file system.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup();

    /**
     * The File System's Arn.
     * <p>
     * Default: - determined based on fileSystemId
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFileSystemArn() {
        return null;
    }

    /**
     * The File System's ID.
     * <p>
     * Default: - determined based on fileSystemArn
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFileSystemId() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link FileSystemAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FileSystemAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<FileSystemAttributes> {
        software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup;
        java.lang.String fileSystemArn;
        java.lang.String fileSystemId;

        /**
         * Sets the value of {@link FileSystemAttributes#getSecurityGroup}
         * @param securityGroup The security group of the file system. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroup(software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
            this.securityGroup = securityGroup;
            return this;
        }

        /**
         * Sets the value of {@link FileSystemAttributes#getFileSystemArn}
         * @param fileSystemArn The File System's Arn.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileSystemArn(java.lang.String fileSystemArn) {
            this.fileSystemArn = fileSystemArn;
            return this;
        }

        /**
         * Sets the value of {@link FileSystemAttributes#getFileSystemId}
         * @param fileSystemId The File System's ID.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileSystemId(java.lang.String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FileSystemAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public FileSystemAttributes build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link FileSystemAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FileSystemAttributes {
        private final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup;
        private final java.lang.String fileSystemArn;
        private final java.lang.String fileSystemId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.securityGroup = software.amazon.jsii.Kernel.get(this, "securityGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class));
            this.fileSystemArn = software.amazon.jsii.Kernel.get(this, "fileSystemArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.fileSystemId = software.amazon.jsii.Kernel.get(this, "fileSystemId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.securityGroup = java.util.Objects.requireNonNull(builder.securityGroup, "securityGroup is required");
            this.fileSystemArn = builder.fileSystemArn;
            this.fileSystemId = builder.fileSystemId;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup() {
            return this.securityGroup;
        }

        @Override
        public final java.lang.String getFileSystemArn() {
            return this.fileSystemArn;
        }

        @Override
        public final java.lang.String getFileSystemId() {
            return this.fileSystemId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("securityGroup", om.valueToTree(this.getSecurityGroup()));
            if (this.getFileSystemArn() != null) {
                data.set("fileSystemArn", om.valueToTree(this.getFileSystemArn()));
            }
            if (this.getFileSystemId() != null) {
                data.set("fileSystemId", om.valueToTree(this.getFileSystemId()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_efs.FileSystemAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FileSystemAttributes.Jsii$Proxy that = (FileSystemAttributes.Jsii$Proxy) o;

            if (!securityGroup.equals(that.securityGroup)) return false;
            if (this.fileSystemArn != null ? !this.fileSystemArn.equals(that.fileSystemArn) : that.fileSystemArn != null) return false;
            return this.fileSystemId != null ? this.fileSystemId.equals(that.fileSystemId) : that.fileSystemId == null;
        }

        @Override
        public final int hashCode() {
            int result = this.securityGroup.hashCode();
            result = 31 * result + (this.fileSystemArn != null ? this.fileSystemArn.hashCode() : 0);
            result = 31 * result + (this.fileSystemId != null ? this.fileSystemId.hashCode() : 0);
            return result;
        }
    }
}
