package software.amazon.awscdk.services.ecs;

/**
 * PortMap ValueObjectClass having by ContainerDefinition.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ecs.*;
 * AppProtocol appProtocol;
 * PortMap portMap = PortMap.Builder.create(NetworkMode.NONE)
 *         .containerPort(123)
 *         // the properties below are optional
 *         .appProtocol(appProtocol)
 *         .containerPortRange("containerPortRange")
 *         .hostPort(123)
 *         .name("name")
 *         .protocol(Protocol.TCP)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:11.735Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.PortMap")
public class PortMap extends software.amazon.jsii.JsiiObject {

    protected PortMap(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected PortMap(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param networkmode This parameter is required.
     * @param pm This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public PortMap(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.NetworkMode networkmode, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.PortMapping pm) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(networkmode, "networkmode is required"), java.util.Objects.requireNonNull(pm, "pm is required") });
    }

    /**
     * validate invalid portmapping and networkmode parameters.
     * <p>
     * throw Error when invalid parameters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void validate() {
        software.amazon.jsii.Kernel.call(this, "validate", software.amazon.jsii.NativeType.VOID);
    }

    /**
     * The networking mode to use for the containers in the task.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.NetworkMode getNetworkmode() {
        return software.amazon.jsii.Kernel.get(this, "networkmode", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.NetworkMode.class));
    }

    /**
     * Port mappings allow containers to access ports on the host container instance to send or receive traffic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.PortMapping getPortmapping() {
        return software.amazon.jsii.Kernel.get(this, "portmapping", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.PortMapping.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ecs.PortMap}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ecs.PortMap> {
        /**
         * @return a new instance of {@link Builder}.
         * @param networkmode This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.services.ecs.NetworkMode networkmode) {
            return new Builder(networkmode);
        }

        private final software.amazon.awscdk.services.ecs.NetworkMode networkmode;
        private final software.amazon.awscdk.services.ecs.PortMapping.Builder pm;

        private Builder(final software.amazon.awscdk.services.ecs.NetworkMode networkmode) {
            this.networkmode = networkmode;
            this.pm = new software.amazon.awscdk.services.ecs.PortMapping.Builder();
        }

        /**
         * The port number on the container that is bound to the user-specified or automatically assigned host port.
         * <p>
         * If you are using containers in a task with the awsvpc or host network mode, exposed ports should be specified using containerPort.
         * If you are using containers in a task with the bridge network mode and you specify a container port and not a host port,
         * your container automatically receives a host port in the ephemeral port range.
         * <p>
         * For more information, see hostPort.
         * Port mappings that are automatically assigned in this way do not count toward the 100 reserved ports limit of a container instance.
         * <p>
         * If you want to expose a port range, you must specify <code>CONTAINER_PORT_USE_RANGE</code> as container port.
         * <p>
         * @return {@code this}
         * @param containerPort The port number on the container that is bound to the user-specified or automatically assigned host port. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerPort(final java.lang.Number containerPort) {
            this.pm.containerPort(containerPort);
            return this;
        }

        /**
         * The protocol used by Service Connect.
         * <p>
         * Valid values are AppProtocol.http, AppProtocol.http2, and
         * AppProtocol.grpc. The protocol determines what telemetry will be shown in the ECS Console for
         * Service Connect services using this port mapping.
         * <p>
         * This field may only be set when the task definition uses Bridge or Awsvpc network modes.
         * <p>
         * Default: - no app protocol
         * <p>
         * @return {@code this}
         * @param appProtocol The protocol used by Service Connect. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder appProtocol(final software.amazon.awscdk.services.ecs.AppProtocol appProtocol) {
            this.pm.appProtocol(appProtocol);
            return this;
        }

        /**
         * The port number range on the container that's bound to the dynamically mapped host port range.
         * <p>
         * The following rules apply when you specify a <code>containerPortRange</code>:
         * <p>
         * <ul>
         * <li>You must specify <code>CONTAINER_PORT_USE_RANGE</code> as <code>containerPort</code></li>
         * <li>You must use either the <code>bridge</code> network mode or the <code>awsvpc</code> network mode.</li>
         * <li>The container instance must have at least version 1.67.0 of the container agent and at least version 1.67.0-1 of the <code>ecs-init</code> package</li>
         * <li>You can specify a maximum of 100 port ranges per container.</li>
         * <li>A port can only be included in one port mapping per container.</li>
         * <li>You cannot specify overlapping port ranges.</li>
         * <li>The first port in the range must be less than last port in the range.</li>
         * </ul>
         * <p>
         * If you want to expose a single port, you must not set a range.
         * <p>
         * @return {@code this}
         * @param containerPortRange The port number range on the container that's bound to the dynamically mapped host port range. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerPortRange(final java.lang.String containerPortRange) {
            this.pm.containerPortRange(containerPortRange);
            return this;
        }

        /**
         * The port number on the container instance to reserve for your container.
         * <p>
         * If you are using containers in a task with the awsvpc or host network mode,
         * the hostPort can either be left blank or set to the same value as the containerPort.
         * <p>
         * If you are using containers in a task with the bridge network mode,
         * you can specify a non-reserved host port for your container port mapping, or
         * you can omit the hostPort (or set it to 0) while specifying a containerPort and
         * your container automatically receives a port in the ephemeral port range for
         * your container instance operating system and Docker version.
         * <p>
         * @return {@code this}
         * @param hostPort The port number on the container instance to reserve for your container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostPort(final java.lang.Number hostPort) {
            this.pm.hostPort(hostPort);
            return this;
        }

        /**
         * The name to give the port mapping.
         * <p>
         * Name is required in order to use the port mapping with ECS Service Connect.
         * This field may only be set when the task definition uses Bridge or Awsvpc network modes.
         * <p>
         * Default: - no port mapping name
         * <p>
         * @return {@code this}
         * @param name The name to give the port mapping. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.pm.name(name);
            return this;
        }

        /**
         * The protocol used for the port mapping.
         * <p>
         * Valid values are Protocol.TCP and Protocol.UDP.
         * <p>
         * Default: TCP
         * <p>
         * @return {@code this}
         * @param protocol The protocol used for the port mapping. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocol(final software.amazon.awscdk.services.ecs.Protocol protocol) {
            this.pm.protocol(protocol);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ecs.PortMap}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ecs.PortMap build() {
            return new software.amazon.awscdk.services.ecs.PortMap(
                this.networkmode,
                this.pm.build()
            );
        }
    }
}
