package software.amazon.awscdk.services.dynamodb;

/**
 * Options used to configure a DynamoDB table.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.dynamodb.*;
 * import software.amazon.awscdk.services.iam.*;
 * import software.amazon.awscdk.services.kinesis.*;
 * PolicyDocument policyDocument;
 * Stream stream;
 * TableOptionsV2 tableOptionsV2 = TableOptionsV2.builder()
 *         .contributorInsights(false)
 *         .deletionProtection(false)
 *         .kinesisStream(stream)
 *         .pointInTimeRecovery(false)
 *         .pointInTimeRecoverySpecification(PointInTimeRecoverySpecification.builder()
 *                 .pointInTimeRecoveryEnabled(false)
 *                 // the properties below are optional
 *                 .recoveryPeriodInDays(123)
 *                 .build())
 *         .resourcePolicy(policyDocument)
 *         .tableClass(TableClass.STANDARD)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:10.591Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.TableOptionsV2")
@software.amazon.jsii.Jsii.Proxy(TableOptionsV2.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface TableOptionsV2 extends software.amazon.jsii.JsiiSerializable {

    /**
     * Whether CloudWatch contributor insights is enabled.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getContributorInsights() {
        return null;
    }

    /**
     * Whether deletion protection is enabled.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getDeletionProtection() {
        return null;
    }

    /**
     * Kinesis Data Stream to capture item level changes.
     * <p>
     * Default: - no Kinesis Data Stream
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesis.IStream getKinesisStream() {
        return null;
    }

    /**
     * (deprecated) Whether point-in-time recovery is enabled.
     * <p>
     * Default: false - point in time recovery is not enabled.
     * <p>
     * @deprecated use <code>pointInTimeRecoverySpecification</code> instead
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPointInTimeRecovery() {
        return null;
    }

    /**
     * Whether point-in-time recovery is enabled and recoveryPeriodInDays is set.
     * <p>
     * Default: - point in time recovery is not enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dynamodb.PointInTimeRecoverySpecification getPointInTimeRecoverySpecification() {
        return null;
    }

    /**
     * Resource policy to assign to DynamoDB Table.
     * <p>
     * Default: - No resource policy statements are added to the created table.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-replicaspecification.html#cfn-dynamodb-globaltable-replicaspecification-resourcepolicy">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-globaltable-replicaspecification.html#cfn-dynamodb-globaltable-replicaspecification-resourcepolicy</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.PolicyDocument getResourcePolicy() {
        return null;
    }

    /**
     * The table class.
     * <p>
     * Default: TableClass.STANDARD
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dynamodb.TableClass getTableClass() {
        return null;
    }

    /**
     * Tags to be applied to the primary table (default replica table).
     * <p>
     * Default: - no tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link TableOptionsV2}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TableOptionsV2}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<TableOptionsV2> {
        java.lang.Boolean contributorInsights;
        java.lang.Boolean deletionProtection;
        software.amazon.awscdk.services.kinesis.IStream kinesisStream;
        java.lang.Boolean pointInTimeRecovery;
        software.amazon.awscdk.services.dynamodb.PointInTimeRecoverySpecification pointInTimeRecoverySpecification;
        software.amazon.awscdk.services.iam.PolicyDocument resourcePolicy;
        software.amazon.awscdk.services.dynamodb.TableClass tableClass;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link TableOptionsV2#getContributorInsights}
         * @param contributorInsights Whether CloudWatch contributor insights is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contributorInsights(java.lang.Boolean contributorInsights) {
            this.contributorInsights = contributorInsights;
            return this;
        }

        /**
         * Sets the value of {@link TableOptionsV2#getDeletionProtection}
         * @param deletionProtection Whether deletion protection is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtection(java.lang.Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        /**
         * Sets the value of {@link TableOptionsV2#getKinesisStream}
         * @param kinesisStream Kinesis Data Stream to capture item level changes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kinesisStream(software.amazon.awscdk.services.kinesis.IStream kinesisStream) {
            this.kinesisStream = kinesisStream;
            return this;
        }

        /**
         * Sets the value of {@link TableOptionsV2#getPointInTimeRecovery}
         * @param pointInTimeRecovery Whether point-in-time recovery is enabled.
         * @return {@code this}
         * @deprecated use `pointInTimeRecoverySpecification` instead
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder pointInTimeRecovery(java.lang.Boolean pointInTimeRecovery) {
            this.pointInTimeRecovery = pointInTimeRecovery;
            return this;
        }

        /**
         * Sets the value of {@link TableOptionsV2#getPointInTimeRecoverySpecification}
         * @param pointInTimeRecoverySpecification Whether point-in-time recovery is enabled and recoveryPeriodInDays is set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pointInTimeRecoverySpecification(software.amazon.awscdk.services.dynamodb.PointInTimeRecoverySpecification pointInTimeRecoverySpecification) {
            this.pointInTimeRecoverySpecification = pointInTimeRecoverySpecification;
            return this;
        }

        /**
         * Sets the value of {@link TableOptionsV2#getResourcePolicy}
         * @param resourcePolicy Resource policy to assign to DynamoDB Table.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourcePolicy(software.amazon.awscdk.services.iam.PolicyDocument resourcePolicy) {
            this.resourcePolicy = resourcePolicy;
            return this;
        }

        /**
         * Sets the value of {@link TableOptionsV2#getTableClass}
         * @param tableClass The table class.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableClass(software.amazon.awscdk.services.dynamodb.TableClass tableClass) {
            this.tableClass = tableClass;
            return this;
        }

        /**
         * Sets the value of {@link TableOptionsV2#getTags}
         * @param tags Tags to be applied to the primary table (default replica table).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TableOptionsV2}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public TableOptionsV2 build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link TableOptionsV2}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TableOptionsV2 {
        private final java.lang.Boolean contributorInsights;
        private final java.lang.Boolean deletionProtection;
        private final software.amazon.awscdk.services.kinesis.IStream kinesisStream;
        private final java.lang.Boolean pointInTimeRecovery;
        private final software.amazon.awscdk.services.dynamodb.PointInTimeRecoverySpecification pointInTimeRecoverySpecification;
        private final software.amazon.awscdk.services.iam.PolicyDocument resourcePolicy;
        private final software.amazon.awscdk.services.dynamodb.TableClass tableClass;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.contributorInsights = software.amazon.jsii.Kernel.get(this, "contributorInsights", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.deletionProtection = software.amazon.jsii.Kernel.get(this, "deletionProtection", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.kinesisStream = software.amazon.jsii.Kernel.get(this, "kinesisStream", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesis.IStream.class));
            this.pointInTimeRecovery = software.amazon.jsii.Kernel.get(this, "pointInTimeRecovery", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.pointInTimeRecoverySpecification = software.amazon.jsii.Kernel.get(this, "pointInTimeRecoverySpecification", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.PointInTimeRecoverySpecification.class));
            this.resourcePolicy = software.amazon.jsii.Kernel.get(this, "resourcePolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyDocument.class));
            this.tableClass = software.amazon.jsii.Kernel.get(this, "tableClass", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.TableClass.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.contributorInsights = builder.contributorInsights;
            this.deletionProtection = builder.deletionProtection;
            this.kinesisStream = builder.kinesisStream;
            this.pointInTimeRecovery = builder.pointInTimeRecovery;
            this.pointInTimeRecoverySpecification = builder.pointInTimeRecoverySpecification;
            this.resourcePolicy = builder.resourcePolicy;
            this.tableClass = builder.tableClass;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Boolean getContributorInsights() {
            return this.contributorInsights;
        }

        @Override
        public final java.lang.Boolean getDeletionProtection() {
            return this.deletionProtection;
        }

        @Override
        public final software.amazon.awscdk.services.kinesis.IStream getKinesisStream() {
            return this.kinesisStream;
        }

        @Override
        public final java.lang.Boolean getPointInTimeRecovery() {
            return this.pointInTimeRecovery;
        }

        @Override
        public final software.amazon.awscdk.services.dynamodb.PointInTimeRecoverySpecification getPointInTimeRecoverySpecification() {
            return this.pointInTimeRecoverySpecification;
        }

        @Override
        public final software.amazon.awscdk.services.iam.PolicyDocument getResourcePolicy() {
            return this.resourcePolicy;
        }

        @Override
        public final software.amazon.awscdk.services.dynamodb.TableClass getTableClass() {
            return this.tableClass;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getContributorInsights() != null) {
                data.set("contributorInsights", om.valueToTree(this.getContributorInsights()));
            }
            if (this.getDeletionProtection() != null) {
                data.set("deletionProtection", om.valueToTree(this.getDeletionProtection()));
            }
            if (this.getKinesisStream() != null) {
                data.set("kinesisStream", om.valueToTree(this.getKinesisStream()));
            }
            if (this.getPointInTimeRecovery() != null) {
                data.set("pointInTimeRecovery", om.valueToTree(this.getPointInTimeRecovery()));
            }
            if (this.getPointInTimeRecoverySpecification() != null) {
                data.set("pointInTimeRecoverySpecification", om.valueToTree(this.getPointInTimeRecoverySpecification()));
            }
            if (this.getResourcePolicy() != null) {
                data.set("resourcePolicy", om.valueToTree(this.getResourcePolicy()));
            }
            if (this.getTableClass() != null) {
                data.set("tableClass", om.valueToTree(this.getTableClass()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dynamodb.TableOptionsV2"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TableOptionsV2.Jsii$Proxy that = (TableOptionsV2.Jsii$Proxy) o;

            if (this.contributorInsights != null ? !this.contributorInsights.equals(that.contributorInsights) : that.contributorInsights != null) return false;
            if (this.deletionProtection != null ? !this.deletionProtection.equals(that.deletionProtection) : that.deletionProtection != null) return false;
            if (this.kinesisStream != null ? !this.kinesisStream.equals(that.kinesisStream) : that.kinesisStream != null) return false;
            if (this.pointInTimeRecovery != null ? !this.pointInTimeRecovery.equals(that.pointInTimeRecovery) : that.pointInTimeRecovery != null) return false;
            if (this.pointInTimeRecoverySpecification != null ? !this.pointInTimeRecoverySpecification.equals(that.pointInTimeRecoverySpecification) : that.pointInTimeRecoverySpecification != null) return false;
            if (this.resourcePolicy != null ? !this.resourcePolicy.equals(that.resourcePolicy) : that.resourcePolicy != null) return false;
            if (this.tableClass != null ? !this.tableClass.equals(that.tableClass) : that.tableClass != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.contributorInsights != null ? this.contributorInsights.hashCode() : 0;
            result = 31 * result + (this.deletionProtection != null ? this.deletionProtection.hashCode() : 0);
            result = 31 * result + (this.kinesisStream != null ? this.kinesisStream.hashCode() : 0);
            result = 31 * result + (this.pointInTimeRecovery != null ? this.pointInTimeRecovery.hashCode() : 0);
            result = 31 * result + (this.pointInTimeRecoverySpecification != null ? this.pointInTimeRecoverySpecification.hashCode() : 0);
            result = 31 * result + (this.resourcePolicy != null ? this.resourcePolicy.hashCode() : 0);
            result = 31 * result + (this.tableClass != null ? this.tableClass.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
