package software.amazon.awscdk.services.docdb;

/**
 * A database instance.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.docdb.*;
 * import software.amazon.awscdk.services.ec2.*;
 * import software.amazon.awscdk.services.rds.*;
 * CaCertificate caCertificate;
 * DatabaseCluster databaseCluster;
 * InstanceType instanceType;
 * DatabaseInstance databaseInstance = DatabaseInstance.Builder.create(this, "MyDatabaseInstance")
 *         .cluster(databaseCluster)
 *         .instanceType(instanceType)
 *         // the properties below are optional
 *         .autoMinorVersionUpgrade(false)
 *         .availabilityZone("availabilityZone")
 *         .caCertificate(caCertificate)
 *         .dbInstanceName("dbInstanceName")
 *         .enablePerformanceInsights(false)
 *         .preferredMaintenanceWindow("preferredMaintenanceWindow")
 *         .removalPolicy(RemovalPolicy.DESTROY)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:10.457Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_docdb.DatabaseInstance")
public class DatabaseInstance extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.docdb.IDatabaseInstance {

    protected DatabaseInstance(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DatabaseInstance(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public DatabaseInstance(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.docdb.DatabaseInstanceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Import an existing database instance.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.docdb.IDatabaseInstance fromDatabaseInstanceAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.docdb.DatabaseInstanceAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.docdb.DatabaseInstance.class, "fromDatabaseInstanceAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.docdb.IDatabaseInstance.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * The instance's database cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.docdb.IDatabaseCluster getCluster() {
        return software.amazon.jsii.Kernel.get(this, "cluster", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.docdb.IDatabaseCluster.class));
    }

    /**
     * The instance endpoint address.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDbInstanceEndpointAddress() {
        return software.amazon.jsii.Kernel.get(this, "dbInstanceEndpointAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The instance endpoint port.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDbInstanceEndpointPort() {
        return software.amazon.jsii.Kernel.get(this, "dbInstanceEndpointPort", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The instance arn.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getInstanceArn() {
        return software.amazon.jsii.Kernel.get(this, "instanceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The instance endpoint.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.docdb.Endpoint getInstanceEndpoint() {
        return software.amazon.jsii.Kernel.get(this, "instanceEndpoint", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.docdb.Endpoint.class));
    }

    /**
     * The instance identifier.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getInstanceIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "instanceIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.docdb.DatabaseInstance}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.docdb.DatabaseInstance> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.docdb.DatabaseInstanceProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.docdb.DatabaseInstanceProps.Builder();
        }

        /**
         * The DocumentDB database cluster the instance should launch into.
         * <p>
         * @return {@code this}
         * @param cluster The DocumentDB database cluster the instance should launch into. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cluster(final software.amazon.awscdk.services.docdb.IDatabaseCluster cluster) {
            this.props.cluster(cluster);
            return this;
        }

        /**
         * The name of the compute and memory capacity classes.
         * <p>
         * @return {@code this}
         * @param instanceType The name of the compute and memory capacity classes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceType(final software.amazon.awscdk.services.ec2.InstanceType instanceType) {
            this.props.instanceType(instanceType);
            return this;
        }

        /**
         * Indicates that minor engine upgrades are applied automatically to the DB instance during the maintenance window.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param autoMinorVersionUpgrade Indicates that minor engine upgrades are applied automatically to the DB instance during the maintenance window. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoMinorVersionUpgrade(final java.lang.Boolean autoMinorVersionUpgrade) {
            this.props.autoMinorVersionUpgrade(autoMinorVersionUpgrade);
            return this;
        }

        /**
         * The name of the Availability Zone where the DB instance will be located.
         * <p>
         * Default: - no preference
         * <p>
         * @return {@code this}
         * @param availabilityZone The name of the Availability Zone where the DB instance will be located. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZone(final java.lang.String availabilityZone) {
            this.props.availabilityZone(availabilityZone);
            return this;
        }

        /**
         * The identifier of the CA certificate for this DB instance.
         * <p>
         * Specifying or updating this property triggers a reboot.
         * <p>
         * Default: - DocumentDB will choose a certificate authority
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/ca_cert_rotation.html">https://docs.aws.amazon.com/documentdb/latest/developerguide/ca_cert_rotation.html</a>
         * @param caCertificate The identifier of the CA certificate for this DB instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder caCertificate(final software.amazon.awscdk.services.rds.CaCertificate caCertificate) {
            this.props.caCertificate(caCertificate);
            return this;
        }

        /**
         * A name for the DB instance.
         * <p>
         * If you specify a name, AWS CloudFormation
         * converts it to lowercase.
         * <p>
         * Default: - a CloudFormation generated name
         * <p>
         * @return {@code this}
         * @param dbInstanceName A name for the DB instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbInstanceName(final java.lang.String dbInstanceName) {
            this.props.dbInstanceName(dbInstanceName);
            return this;
        }

        /**
         * A value that indicates whether to enable Performance Insights for the DB Instance.
         * <p>
         * Default: - false
         * <p>
         * @return {@code this}
         * @param enablePerformanceInsights A value that indicates whether to enable Performance Insights for the DB Instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enablePerformanceInsights(final java.lang.Boolean enablePerformanceInsights) {
            this.props.enablePerformanceInsights(enablePerformanceInsights);
            return this;
        }

        /**
         * The weekly time range (in UTC) during which system maintenance can occur.
         * <p>
         * Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
         * Constraint: Minimum 30-minute window
         * <p>
         * Default: - a 30-minute window selected at random from an 8-hour block of
         * time for each AWS Region, occurring on a random day of the week. To see
         * the time blocks available, see https://docs.aws.amazon.com/documentdb/latest/developerguide/db-instance-maintain.html#maintenance-window
         * <p>
         * @return {@code this}
         * @param preferredMaintenanceWindow The weekly time range (in UTC) during which system maintenance can occur. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preferredMaintenanceWindow(final java.lang.String preferredMaintenanceWindow) {
            this.props.preferredMaintenanceWindow(preferredMaintenanceWindow);
            return this;
        }

        /**
         * The CloudFormation policy to apply when the instance is removed from the stack or replaced during an update.
         * <p>
         * Default: RemovalPolicy.Retain
         * <p>
         * @return {@code this}
         * @param removalPolicy The CloudFormation policy to apply when the instance is removed from the stack or replaced during an update. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(final software.amazon.awscdk.RemovalPolicy removalPolicy) {
            this.props.removalPolicy(removalPolicy);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.docdb.DatabaseInstance}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.docdb.DatabaseInstance build() {
            return new software.amazon.awscdk.services.docdb.DatabaseInstance(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
