package software.amazon.awscdk.services.connect;

/**
 * Properties for defining a <code>CfnIntegrationAssociation</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.connect.*;
 * CfnIntegrationAssociationProps cfnIntegrationAssociationProps = CfnIntegrationAssociationProps.builder()
 *         .instanceId("instanceId")
 *         .integrationArn("integrationArn")
 *         .integrationType("integrationType")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-integrationassociation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-integrationassociation.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:09.809Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnIntegrationAssociationProps")
@software.amazon.jsii.Jsii.Proxy(CfnIntegrationAssociationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnIntegrationAssociationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Amazon Resource Name (ARN) of the instance.
     * <p>
     * <em>Minimum</em> : <code>1</code>
     * <p>
     * <em>Maximum</em> : <code>100</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-integrationassociation.html#cfn-connect-integrationassociation-instanceid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-integrationassociation.html#cfn-connect-integrationassociation-instanceid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getInstanceId();

    /**
     * ARN of the integration being associated with the instance.
     * <p>
     * <em>Minimum</em> : <code>1</code>
     * <p>
     * <em>Maximum</em> : <code>140</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-integrationassociation.html#cfn-connect-integrationassociation-integrationarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-integrationassociation.html#cfn-connect-integrationassociation-integrationarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIntegrationArn();

    /**
     * Specifies the integration type to be associated with the instance.
     * <p>
     * <em>Allowed Values</em> : <code>LEX_BOT</code> | <code>LAMBDA_FUNCTION</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-integrationassociation.html#cfn-connect-integrationassociation-integrationtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-integrationassociation.html#cfn-connect-integrationassociation-integrationtype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIntegrationType();

    /**
     * @return a {@link Builder} of {@link CfnIntegrationAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnIntegrationAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnIntegrationAssociationProps> {
        java.lang.String instanceId;
        java.lang.String integrationArn;
        java.lang.String integrationType;

        /**
         * Sets the value of {@link CfnIntegrationAssociationProps#getInstanceId}
         * @param instanceId The Amazon Resource Name (ARN) of the instance. This parameter is required.
         *                   <em>Minimum</em> : <code>1</code>
         *                   <p>
         *                   <em>Maximum</em> : <code>100</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceId(java.lang.String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        /**
         * Sets the value of {@link CfnIntegrationAssociationProps#getIntegrationArn}
         * @param integrationArn ARN of the integration being associated with the instance. This parameter is required.
         *                       <em>Minimum</em> : <code>1</code>
         *                       <p>
         *                       <em>Maximum</em> : <code>140</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationArn(java.lang.String integrationArn) {
            this.integrationArn = integrationArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnIntegrationAssociationProps#getIntegrationType}
         * @param integrationType Specifies the integration type to be associated with the instance. This parameter is required.
         *                        <em>Allowed Values</em> : <code>LEX_BOT</code> | <code>LAMBDA_FUNCTION</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationType(java.lang.String integrationType) {
            this.integrationType = integrationType;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnIntegrationAssociationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnIntegrationAssociationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnIntegrationAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnIntegrationAssociationProps {
        private final java.lang.String instanceId;
        private final java.lang.String integrationArn;
        private final java.lang.String integrationType;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.instanceId = software.amazon.jsii.Kernel.get(this, "instanceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.integrationArn = software.amazon.jsii.Kernel.get(this, "integrationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.integrationType = software.amazon.jsii.Kernel.get(this, "integrationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.instanceId = java.util.Objects.requireNonNull(builder.instanceId, "instanceId is required");
            this.integrationArn = java.util.Objects.requireNonNull(builder.integrationArn, "integrationArn is required");
            this.integrationType = java.util.Objects.requireNonNull(builder.integrationType, "integrationType is required");
        }

        @Override
        public final java.lang.String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final java.lang.String getIntegrationArn() {
            return this.integrationArn;
        }

        @Override
        public final java.lang.String getIntegrationType() {
            return this.integrationType;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("instanceId", om.valueToTree(this.getInstanceId()));
            data.set("integrationArn", om.valueToTree(this.getIntegrationArn()));
            data.set("integrationType", om.valueToTree(this.getIntegrationType()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnIntegrationAssociationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnIntegrationAssociationProps.Jsii$Proxy that = (CfnIntegrationAssociationProps.Jsii$Proxy) o;

            if (!instanceId.equals(that.instanceId)) return false;
            if (!integrationArn.equals(that.integrationArn)) return false;
            return this.integrationType.equals(that.integrationType);
        }

        @Override
        public final int hashCode() {
            int result = this.instanceId.hashCode();
            result = 31 * result + (this.integrationArn.hashCode());
            result = 31 * result + (this.integrationType.hashCode());
            return result;
        }
    }
}
