package software.amazon.awscdk.services.cognito;

/**
 * Standard attribute that can be marked as required or mutable.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * UserPool.Builder.create(this, "myuserpool")
 *         // ...
 *         .standardAttributes(StandardAttributes.builder()
 *                 .fullname(StandardAttribute.builder()
 *                         .required(true)
 *                         .mutable(false)
 *                         .build())
 *                 .address(StandardAttribute.builder()
 *                         .required(false)
 *                         .mutable(true)
 *                         .build())
 *                 .build())
 *         .customAttributes(Map.of(
 *                 "myappid", StringAttribute.Builder.create().minLen(5).maxLen(15).mutable(false).build(),
 *                 "callingcode", NumberAttribute.Builder.create().min(1).max(3).mutable(true).build(),
 *                 "isEmployee", BooleanAttribute.Builder.create().mutable(true).build(),
 *                 "joinedOn", new DateTimeAttribute()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html#cognito-user-pools-standard-attributes">https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html#cognito-user-pools-standard-attributes</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:09.581Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.StandardAttribute")
@software.amazon.jsii.Jsii.Proxy(StandardAttribute.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface StandardAttribute extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specifies whether the value of the attribute can be changed.
     * <p>
     * For any user pool attribute that's mapped to an identity provider attribute, this must be set to <code>true</code>.
     * Amazon Cognito updates mapped attributes when users sign in to your application through an identity provider.
     * If an attribute is immutable, Amazon Cognito throws an error when it attempts to update the attribute.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getMutable() {
        return null;
    }

    /**
     * Specifies whether the attribute is required upon user registration.
     * <p>
     * If the attribute is required and the user does not provide a value, registration or sign-in will fail.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getRequired() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link StandardAttribute}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link StandardAttribute}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<StandardAttribute> {
        java.lang.Boolean mutable;
        java.lang.Boolean required;

        /**
         * Sets the value of {@link StandardAttribute#getMutable}
         * @param mutable Specifies whether the value of the attribute can be changed.
         *                For any user pool attribute that's mapped to an identity provider attribute, this must be set to <code>true</code>.
         *                Amazon Cognito updates mapped attributes when users sign in to your application through an identity provider.
         *                If an attribute is immutable, Amazon Cognito throws an error when it attempts to update the attribute.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mutable(java.lang.Boolean mutable) {
            this.mutable = mutable;
            return this;
        }

        /**
         * Sets the value of {@link StandardAttribute#getRequired}
         * @param required Specifies whether the attribute is required upon user registration.
         *                 If the attribute is required and the user does not provide a value, registration or sign-in will fail.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder required(java.lang.Boolean required) {
            this.required = required;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link StandardAttribute}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public StandardAttribute build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link StandardAttribute}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StandardAttribute {
        private final java.lang.Boolean mutable;
        private final java.lang.Boolean required;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.mutable = software.amazon.jsii.Kernel.get(this, "mutable", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.required = software.amazon.jsii.Kernel.get(this, "required", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.mutable = builder.mutable;
            this.required = builder.required;
        }

        @Override
        public final java.lang.Boolean getMutable() {
            return this.mutable;
        }

        @Override
        public final java.lang.Boolean getRequired() {
            return this.required;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getMutable() != null) {
                data.set("mutable", om.valueToTree(this.getMutable()));
            }
            if (this.getRequired() != null) {
                data.set("required", om.valueToTree(this.getRequired()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cognito.StandardAttribute"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            StandardAttribute.Jsii$Proxy that = (StandardAttribute.Jsii$Proxy) o;

            if (this.mutable != null ? !this.mutable.equals(that.mutable) : that.mutable != null) return false;
            return this.required != null ? this.required.equals(that.required) : that.required == null;
        }

        @Override
        public final int hashCode() {
            int result = this.mutable != null ? this.mutable.hashCode() : 0;
            result = 31 * result + (this.required != null ? this.required.hashCode() : 0);
            return result;
        }
    }
}
