package software.amazon.awscdk.services.codepipeline.actions;

/**
 * How should the S3 Action detect changes.
 * <p>
 * This is the type of the <code>S3SourceAction.trigger</code> property.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.cloudtrail.*;
 * Bucket sourceBucket;
 * Artifact sourceOutput = new Artifact();
 * String key = "some/key.zip";
 * Trail trail = new Trail(this, "CloudTrail");
 * trail.addS3EventSelector(List.of(S3EventSelector.builder()
 *         .bucket(sourceBucket)
 *         .objectPrefix(key)
 *         .build()), AddEventSelectorOptions.builder()
 *         .readWriteType(ReadWriteType.WRITE_ONLY)
 *         .build());
 * S3SourceAction sourceAction = S3SourceAction.Builder.create()
 *         .actionName("S3Source")
 *         .bucketKey(key)
 *         .bucket(sourceBucket)
 *         .output(sourceOutput)
 *         .trigger(S3Trigger.EVENTS)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:09.397Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline_actions.S3Trigger")
public enum S3Trigger {
    /**
     * The Action will never detect changes - the Pipeline it's part of will only begin a run when explicitly started.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NONE,
    /**
     * CodePipeline will poll S3 to detect changes.
     * <p>
     * This is the default method of detecting changes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    POLL,
    /**
     * CodePipeline will use CloudWatch Events to be notified of changes.
     * <p>
     * Note that the Bucket that the Action uses needs to be part of a CloudTrail Trail
     * for the events to be delivered.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    EVENTS,
}
