package software.amazon.awscdk.services.cloudwatch;

/**
 * A math expression built with metric(s) emitted by a service.
 * <p>
 * The math expression is a combination of an expression (x+y) and metrics to apply expression on.
 * It also contains metadata which is used only in graphs, such as color and label.
 * It makes sense to embed this in here, so that compound constructs can attach
 * that metadata to metrics they expose.
 * <p>
 * MathExpression can also be used for search expressions. In this case,
 * it also optionally accepts a searchRegion and searchAccount property for cross-environment
 * search expressions.
 * <p>
 * This class does not represent a resource, so hence is not a construct. Instead,
 * MathExpression is an abstraction that makes it easy to specify metrics for use in both
 * alarms and graphs.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * MatchmakingRuleSet matchmakingRuleSet;
 * // Alarm that triggers when the per-second average of not placed matches exceed 10%
 * MathExpression ruleEvaluationRatio = MathExpression.Builder.create()
 *         .expression("1 - (ruleEvaluationsPassed / ruleEvaluationsFailed)")
 *         .usingMetrics(Map.of(
 *                 "ruleEvaluationsPassed", matchmakingRuleSet.metricRuleEvaluationsPassed(MetricOptions.builder().statistic(Statistic.SUM).build()),
 *                 "ruleEvaluationsFailed", matchmakingRuleSet.metric("ruleEvaluationsFailed")))
 *         .build();
 * Alarm.Builder.create(this, "Alarm")
 *         .metric(ruleEvaluationRatio)
 *         .threshold(0.1)
 *         .evaluationPeriods(3)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:08.888Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch.MathExpression")
public class MathExpression extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.cloudwatch.IMetric {

    protected MathExpression(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected MathExpression(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public MathExpression(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.MathExpressionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Make a new Alarm for this metric.
     * <p>
     * Combines both properties that may adjust the metric (aggregation) as well
     * as alarm properties.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Alarm createAlarm(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.CreateAlarmOptions props) {
        return software.amazon.jsii.Kernel.call(this, "createAlarm", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Alarm.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Inspect the details of the metric object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.MetricConfig toMetricConfig() {
        return software.amazon.jsii.Kernel.call(this, "toMetricConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.MetricConfig.class));
    }

    /**
     * Returns a string representation of an object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String toString() {
        return software.amazon.jsii.Kernel.call(this, "toString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Return a copy of Metric with properties changed.
     * <p>
     * All properties except namespace and metricName can be changed.
     * <p>
     * @param props The set of properties to change. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.MathExpression with(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.MathExpressionOptions props) {
        return software.amazon.jsii.Kernel.call(this, "with", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.MathExpression.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * The expression defining the metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getExpression() {
        return software.amazon.jsii.Kernel.get(this, "expression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Aggregation period of this metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.Duration getPeriod() {
        return software.amazon.jsii.Kernel.get(this, "period", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
    }

    /**
     * The metrics used in the expression as KeyValuePair &lt;id, metric&gt;.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, software.amazon.awscdk.services.cloudwatch.IMetric> getUsingMetrics() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "usingMetrics", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.IMetric.class))));
    }

    /**
     * The hex color code, prefixed with '#' (e.g. '#00ff00'), to use when this metric is rendered on a graph. The <code>Color</code> class has a set of standard colors that can be used here.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getColor() {
        return software.amazon.jsii.Kernel.get(this, "color", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Label for this metric when added to a Graph.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getLabel() {
        return software.amazon.jsii.Kernel.get(this, "label", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Account to evaluate search expressions within.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSearchAccount() {
        return software.amazon.jsii.Kernel.get(this, "searchAccount", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Region to evaluate search expressions within.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSearchRegion() {
        return software.amazon.jsii.Kernel.get(this, "searchRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (deprecated) Warnings generated by this math expression.
     * <p>
     * @deprecated <ul>
     * <li>use warningsV2</li>
     * </ul>
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getWarnings() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "warnings", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Warnings generated by this math expression.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getWarningsV2() {
        return java.util.Optional.ofNullable((java.util.Map<java.lang.String, java.lang.String>)(software.amazon.jsii.Kernel.get(this, "warningsV2", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableMap).orElse(null);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cloudwatch.MathExpression}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cloudwatch.MathExpression> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.cloudwatch.MathExpressionProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.cloudwatch.MathExpressionProps.Builder();
        }

        /**
         * Color for this metric when added to a Graph in a Dashboard.
         * <p>
         * Default: - Automatic color
         * <p>
         * @return {@code this}
         * @param color Color for this metric when added to a Graph in a Dashboard. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder color(final java.lang.String color) {
            this.props.color(color);
            return this;
        }

        /**
         * Label for this expression when added to a Graph in a Dashboard.
         * <p>
         * If this expression evaluates to more than one time series (for
         * example, through the use of <code>METRICS()</code> or <code>SEARCH()</code> expressions),
         * each time series will appear in the graph using a combination of the
         * expression label and the individual metric label. Specify the empty
         * string (<code>''</code>) to suppress the expression label and only keep the
         * metric label.
         * <p>
         * You can use <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/graph-dynamic-labels.html">dynamic labels</a>
         * to show summary information about the displayed time series
         * in the legend. For example, if you use:
         * <p>
         * <blockquote><pre>
         * [max: ${MAX}] MyMetric
         * </pre></blockquote>
         * <p>
         * As the metric label, the maximum value in the visible range will
         * be shown next to the time series name in the graph's legend. If the
         * math expression produces more than one time series, the maximum
         * will be shown for each individual time series produce by this
         * math expression.
         * <p>
         * Default: - Expression value is used as label
         * <p>
         * @return {@code this}
         * @param label Label for this expression when added to a Graph in a Dashboard. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder label(final java.lang.String label) {
            this.props.label(label);
            return this;
        }

        /**
         * The period over which the expression's statistics are applied.
         * <p>
         * This period overrides all periods in the metrics used in this
         * math expression.
         * <p>
         * Default: Duration.minutes(5)
         * <p>
         * @return {@code this}
         * @param period The period over which the expression's statistics are applied. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder period(final software.amazon.awscdk.Duration period) {
            this.props.period(period);
            return this;
        }

        /**
         * Account to evaluate search expressions within.
         * <p>
         * Specifying a searchAccount has no effect to the account used
         * for metrics within the expression (passed via usingMetrics).
         * <p>
         * Default: - Deployment account.
         * <p>
         * @return {@code this}
         * @param searchAccount Account to evaluate search expressions within. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder searchAccount(final java.lang.String searchAccount) {
            this.props.searchAccount(searchAccount);
            return this;
        }

        /**
         * Region to evaluate search expressions within.
         * <p>
         * Specifying a searchRegion has no effect to the region used
         * for metrics within the expression (passed via usingMetrics).
         * <p>
         * Default: - Deployment region.
         * <p>
         * @return {@code this}
         * @param searchRegion Region to evaluate search expressions within. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder searchRegion(final java.lang.String searchRegion) {
            this.props.searchRegion(searchRegion);
            return this;
        }

        /**
         * The expression defining the metric.
         * <p>
         * When an expression contains a SEARCH function, it cannot be used
         * within an Alarm.
         * <p>
         * @return {@code this}
         * @param expression The expression defining the metric. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder expression(final java.lang.String expression) {
            this.props.expression(expression);
            return this;
        }

        /**
         * The metrics used in the expression, in a map.
         * <p>
         * The key is the identifier that represents the given metric in the
         * expression, and the value is the actual Metric object.
         * <p>
         * The <code>period</code> of each metric in <code>usingMetrics</code> is ignored and instead overridden
         * by the <code>period</code> specified for the <code>MathExpression</code> construct. Even if no <code>period</code>
         * is specified for the <code>MathExpression</code>, it will be overridden by the default
         * value (<code>Duration.minutes(5)</code>).
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>
         * IApplicationLoadBalancerMetrics metrics;
         * MathExpression.Builder.create()
         *         .expression("m1+m2")
         *         .label("AlbErrors")
         *         .usingMetrics(Map.of(
         *                 "m1", metrics.custom("HTTPCode_ELB_500_Count", MetricOptions.builder()
         *                         .period(Duration.minutes(1)) // &lt;- This period will be ignored
         *                         .statistic("Sum")
         *                         .label("HTTPCode_ELB_500_Count")
         *                         .build()),
         *                 "m2", metrics.custom("HTTPCode_ELB_502_Count", MetricOptions.builder()
         *                         .period(Duration.minutes(1)) // &lt;- This period will be ignored
         *                         .statistic("Sum")
         *                         .label("HTTPCode_ELB_502_Count")
         *                         .build())))
         *         .period(Duration.minutes(3))
         *         .build();
         * </pre></blockquote>
         * <p>
         * Default: - Empty map.
         * <p>
         * @return {@code this}
         * @param usingMetrics The metrics used in the expression, in a map. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder usingMetrics(final java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.cloudwatch.IMetric> usingMetrics) {
            this.props.usingMetrics(usingMetrics);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.cloudwatch.MathExpression}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cloudwatch.MathExpression build() {
            return new software.amazon.awscdk.services.cloudwatch.MathExpression(
                this.props.build()
            );
        }
    }
}
