package software.amazon.awscdk.services.batch;

/**
 * A container that can be run with ECS orchestration.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:07.925Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.IEcsContainerDefinition")
@software.amazon.jsii.Jsii.Proxy(IEcsContainerDefinition.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IEcsContainerDefinition extends software.amazon.jsii.JsiiSerializable, software.constructs.IConstruct {

    /**
     * The number of vCPUs reserved for the container.
     * <p>
     * Each vCPU is equivalent to 1,024 CPU shares.
     * For containers running on EC2 resources, you must specify at least one vCPU.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getCpu();

    /**
     * The role used by Amazon ECS container and AWS Fargate agents to make AWS API calls on your behalf.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/batch/latest/userguide/execution-IAM-role.html">https://docs.aws.amazon.com/batch/latest/userguide/execution-IAM-role.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole getExecutionRole();

    /**
     * The image that this container will run.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ContainerImage getImage();

    /**
     * The memory hard limit present to the container.
     * <p>
     * If your container attempts to exceed the memory specified, the container is terminated.
     * You must specify at least 4 MiB of memory for a job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.Size getMemory();

    /**
     * The volumes to mount to this container.
     * <p>
     * Automatically added to the job definition.
     * <p>
     * Default: - no volumes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.batch.EcsVolume> getVolumes();

    /**
     * The command that's passed to the container.
     * <p>
     * @see <a href="https://docs.docker.com/engine/reference/builder/#cmd">https://docs.docker.com/engine/reference/builder/#cmd</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCommand() {
        return null;
    }

    /**
     * The environment variables to pass to a container.
     * <p>
     * Cannot start with <code>AWS_BATCH</code>.
     * We don't recommend using plaintext environment variables for sensitive information, such as credential data.
     * <p>
     * Default: - no environment variables
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getEnvironment() {
        return null;
    }

    /**
     * The role that the container can assume.
     * <p>
     * Default: - no jobRole
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html">https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getJobRole() {
        return null;
    }

    /**
     * Linux-specific modifications that are applied to the container, such as details for device mappings.
     * <p>
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.batch.LinuxParameters getLinuxParameters() {
        return null;
    }

    /**
     * The configuration of the log driver.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.LogDriverConfig getLogDriverConfig() {
        return null;
    }

    /**
     * Gives the container readonly access to its root filesystem.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getReadonlyRootFilesystem() {
        return null;
    }

    /**
     * A map from environment variable names to the secrets for the container.
     * <p>
     * Allows your job definitions
     * to reference the secret by the environment variable name defined in this property.
     * <p>
     * Default: - no secrets
     * <p>
     * @see <a href="https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data.html">https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, software.amazon.awscdk.services.batch.Secret> getSecrets() {
        return null;
    }

    /**
     * The user name to use inside the container.
     * <p>
     * Default: - no user
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getUser() {
        return null;
    }

    /**
     * Add a Volume to this container.
     * <p>
     * @param volume This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void addVolume(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.EcsVolume volume);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.batch.IEcsContainerDefinition.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * The tree node.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.constructs.Node getNode() {
            return software.amazon.jsii.Kernel.get(this, "node", software.amazon.jsii.NativeType.forClass(software.constructs.Node.class));
        }

        /**
         * The number of vCPUs reserved for the container.
         * <p>
         * Each vCPU is equivalent to 1,024 CPU shares.
         * For containers running on EC2 resources, you must specify at least one vCPU.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.Number getCpu() {
            return software.amazon.jsii.Kernel.get(this, "cpu", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * The role used by Amazon ECS container and AWS Fargate agents to make AWS API calls on your behalf.
         * <p>
         * @see <a href="https://docs.aws.amazon.com/batch/latest/userguide/execution-IAM-role.html">https://docs.aws.amazon.com/batch/latest/userguide/execution-IAM-role.html</a>
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole getExecutionRole() {
            return software.amazon.jsii.Kernel.get(this, "executionRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
        }

        /**
         * The image that this container will run.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ContainerImage getImage() {
            return software.amazon.jsii.Kernel.get(this, "image", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ContainerImage.class));
        }

        /**
         * The memory hard limit present to the container.
         * <p>
         * If your container attempts to exceed the memory specified, the container is terminated.
         * You must specify at least 4 MiB of memory for a job.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Size getMemory() {
            return software.amazon.jsii.Kernel.get(this, "memory", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Size.class));
        }

        /**
         * The volumes to mount to this container.
         * <p>
         * Automatically added to the job definition.
         * <p>
         * Default: - no volumes
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.batch.EcsVolume> getVolumes() {
            return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "volumes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.EcsVolume.class))));
        }

        /**
         * The command that's passed to the container.
         * <p>
         * @see <a href="https://docs.docker.com/engine/reference/builder/#cmd">https://docs.docker.com/engine/reference/builder/#cmd</a>
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCommand() {
            return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "command", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
        }

        /**
         * The environment variables to pass to a container.
         * <p>
         * Cannot start with <code>AWS_BATCH</code>.
         * We don't recommend using plaintext environment variables for sensitive information, such as credential data.
         * <p>
         * Default: - no environment variables
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getEnvironment() {
            return java.util.Optional.ofNullable((java.util.Map<java.lang.String, java.lang.String>)(software.amazon.jsii.Kernel.get(this, "environment", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableMap).orElse(null);
        }

        /**
         * The role that the container can assume.
         * <p>
         * Default: - no jobRole
         * <p>
         * @see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html">https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html</a>
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getJobRole() {
            return software.amazon.jsii.Kernel.get(this, "jobRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
        }

        /**
         * Linux-specific modifications that are applied to the container, such as details for device mappings.
         * <p>
         * Default: none
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.batch.LinuxParameters getLinuxParameters() {
            return software.amazon.jsii.Kernel.get(this, "linuxParameters", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.LinuxParameters.class));
        }

        /**
         * The configuration of the log driver.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.LogDriverConfig getLogDriverConfig() {
            return software.amazon.jsii.Kernel.get(this, "logDriverConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.LogDriverConfig.class));
        }

        /**
         * Gives the container readonly access to its root filesystem.
         * <p>
         * Default: false
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable java.lang.Boolean getReadonlyRootFilesystem() {
            return software.amazon.jsii.Kernel.get(this, "readonlyRootFilesystem", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * A map from environment variable names to the secrets for the container.
         * <p>
         * Allows your job definitions
         * to reference the secret by the environment variable name defined in this property.
         * <p>
         * Default: - no secrets
         * <p>
         * @see <a href="https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data.html">https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data.html</a>
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, software.amazon.awscdk.services.batch.Secret> getSecrets() {
            return java.util.Optional.ofNullable((java.util.Map<java.lang.String, software.amazon.awscdk.services.batch.Secret>)(software.amazon.jsii.Kernel.get(this, "secrets", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.Secret.class))))).map(java.util.Collections::unmodifiableMap).orElse(null);
        }

        /**
         * The user name to use inside the container.
         * <p>
         * Default: - no user
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable java.lang.String getUser() {
            return software.amazon.jsii.Kernel.get(this, "user", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Add a Volume to this container.
         * <p>
         * @param volume This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void addVolume(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.EcsVolume volume) {
            software.amazon.jsii.Kernel.call(this, "addVolume", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(volume, "volume is required") });
        }
    }

    /**
     * Internal default implementation for {@link IEcsContainerDefinition}.
     */
    @software.amazon.jsii.Internal
    interface Jsii$Default extends IEcsContainerDefinition, software.constructs.IConstruct.Jsii$Default {

        /**
         * The tree node.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.constructs.Node getNode() {
            return software.amazon.jsii.Kernel.get(this, "node", software.amazon.jsii.NativeType.forClass(software.constructs.Node.class));
        }

        /**
         * The number of vCPUs reserved for the container.
         * <p>
         * Each vCPU is equivalent to 1,024 CPU shares.
         * For containers running on EC2 resources, you must specify at least one vCPU.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.lang.Number getCpu() {
            return software.amazon.jsii.Kernel.get(this, "cpu", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * The role used by Amazon ECS container and AWS Fargate agents to make AWS API calls on your behalf.
         * <p>
         * @see <a href="https://docs.aws.amazon.com/batch/latest/userguide/execution-IAM-role.html">https://docs.aws.amazon.com/batch/latest/userguide/execution-IAM-role.html</a>
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole getExecutionRole() {
            return software.amazon.jsii.Kernel.get(this, "executionRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
        }

        /**
         * The image that this container will run.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ContainerImage getImage() {
            return software.amazon.jsii.Kernel.get(this, "image", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ContainerImage.class));
        }

        /**
         * The memory hard limit present to the container.
         * <p>
         * If your container attempts to exceed the memory specified, the container is terminated.
         * You must specify at least 4 MiB of memory for a job.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.Size getMemory() {
            return software.amazon.jsii.Kernel.get(this, "memory", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Size.class));
        }

        /**
         * The volumes to mount to this container.
         * <p>
         * Automatically added to the job definition.
         * <p>
         * Default: - no volumes
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.batch.EcsVolume> getVolumes() {
            return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "volumes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.EcsVolume.class))));
        }

        /**
         * The command that's passed to the container.
         * <p>
         * @see <a href="https://docs.docker.com/engine/reference/builder/#cmd">https://docs.docker.com/engine/reference/builder/#cmd</a>
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCommand() {
            return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "command", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
        }

        /**
         * The environment variables to pass to a container.
         * <p>
         * Cannot start with <code>AWS_BATCH</code>.
         * We don't recommend using plaintext environment variables for sensitive information, such as credential data.
         * <p>
         * Default: - no environment variables
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getEnvironment() {
            return java.util.Optional.ofNullable((java.util.Map<java.lang.String, java.lang.String>)(software.amazon.jsii.Kernel.get(this, "environment", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableMap).orElse(null);
        }

        /**
         * The role that the container can assume.
         * <p>
         * Default: - no jobRole
         * <p>
         * @see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html">https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html</a>
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getJobRole() {
            return software.amazon.jsii.Kernel.get(this, "jobRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
        }

        /**
         * Linux-specific modifications that are applied to the container, such as details for device mappings.
         * <p>
         * Default: none
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.batch.LinuxParameters getLinuxParameters() {
            return software.amazon.jsii.Kernel.get(this, "linuxParameters", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.LinuxParameters.class));
        }

        /**
         * The configuration of the log driver.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.LogDriverConfig getLogDriverConfig() {
            return software.amazon.jsii.Kernel.get(this, "logDriverConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.LogDriverConfig.class));
        }

        /**
         * Gives the container readonly access to its root filesystem.
         * <p>
         * Default: false
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Boolean getReadonlyRootFilesystem() {
            return software.amazon.jsii.Kernel.get(this, "readonlyRootFilesystem", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * A map from environment variable names to the secrets for the container.
         * <p>
         * Allows your job definitions
         * to reference the secret by the environment variable name defined in this property.
         * <p>
         * Default: - no secrets
         * <p>
         * @see <a href="https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data.html">https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data.html</a>
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, software.amazon.awscdk.services.batch.Secret> getSecrets() {
            return java.util.Optional.ofNullable((java.util.Map<java.lang.String, software.amazon.awscdk.services.batch.Secret>)(software.amazon.jsii.Kernel.get(this, "secrets", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.Secret.class))))).map(java.util.Collections::unmodifiableMap).orElse(null);
        }

        /**
         * The user name to use inside the container.
         * <p>
         * Default: - no user
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUser() {
            return software.amazon.jsii.Kernel.get(this, "user", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Add a Volume to this container.
         * <p>
         * @param volume This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default void addVolume(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.EcsVolume volume) {
            software.amazon.jsii.Kernel.call(this, "addVolume", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(volume, "volume is required") });
        }
    }
}
