package software.amazon.awscdk.services.backup;

/**
 * A backup selection.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.backup.*;
 * import software.amazon.awscdk.services.iam.*;
 * BackupPlan backupPlan;
 * BackupResource backupResource;
 * Role role;
 * BackupSelection backupSelection = BackupSelection.Builder.create(this, "MyBackupSelection")
 *         .backupPlan(backupPlan)
 *         .resources(List.of(backupResource))
 *         // the properties below are optional
 *         .allowRestores(false)
 *         .backupSelectionName("backupSelectionName")
 *         .disableDefaultBackupPolicy(false)
 *         .role(role)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:07.727Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_backup.BackupSelection")
public class BackupSelection extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.iam.IGrantable {

    protected BackupSelection(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected BackupSelection(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public BackupSelection(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.backup.BackupSelectionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * The identifier of the backup plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getBackupPlanId() {
        return software.amazon.jsii.Kernel.get(this, "backupPlanId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The principal to grant permissions to.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IPrincipal getGrantPrincipal() {
        return software.amazon.jsii.Kernel.get(this, "grantPrincipal", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IPrincipal.class));
    }

    /**
     * The identifier of the backup selection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getSelectionId() {
        return software.amazon.jsii.Kernel.get(this, "selectionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.backup.BackupSelection}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.backup.BackupSelection> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.backup.BackupSelectionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.backup.BackupSelectionProps.Builder();
        }

        /**
         * The resources to backup.
         * <p>
         * Use the helper static methods defined on <code>BackupResource</code>.
         * <p>
         * @return {@code this}
         * @param resources The resources to backup. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resources(final java.util.List<? extends software.amazon.awscdk.services.backup.BackupResource> resources) {
            this.props.resources(resources);
            return this;
        }

        /**
         * Whether to automatically give restores permissions to the role that AWS Backup uses.
         * <p>
         * If <code>true</code>, the <code>AWSBackupServiceRolePolicyForRestores</code> managed
         * policy will be attached to the role.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param allowRestores Whether to automatically give restores permissions to the role that AWS Backup uses. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowRestores(final java.lang.Boolean allowRestores) {
            this.props.allowRestores(allowRestores);
            return this;
        }

        /**
         * The name for this selection.
         * <p>
         * Default: - a CDK generated name
         * <p>
         * @return {@code this}
         * @param backupSelectionName The name for this selection. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupSelectionName(final java.lang.String backupSelectionName) {
            this.props.backupSelectionName(backupSelectionName);
            return this;
        }

        /**
         * Whether to disable automatically assigning default backup permissions to the role that AWS Backup uses.
         * <p>
         * If <code>false</code>, the <code>AWSBackupServiceRolePolicyForBackup</code> managed policy will be
         * attached to the role.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param disableDefaultBackupPolicy Whether to disable automatically assigning default backup permissions to the role that AWS Backup uses. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disableDefaultBackupPolicy(final java.lang.Boolean disableDefaultBackupPolicy) {
            this.props.disableDefaultBackupPolicy(disableDefaultBackupPolicy);
            return this;
        }

        /**
         * The role that AWS Backup uses to authenticate when backuping or restoring the resources.
         * <p>
         * The <code>AWSBackupServiceRolePolicyForBackup</code> managed policy
         * will be attached to this role unless <code>disableDefaultBackupPolicy</code>
         * is set to <code>true</code>.
         * <p>
         * Default: - a new role will be created
         * <p>
         * @return {@code this}
         * @param role The role that AWS Backup uses to authenticate when backuping or restoring the resources. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props.role(role);
            return this;
        }

        /**
         * The backup plan for this selection.
         * <p>
         * @return {@code this}
         * @param backupPlan The backup plan for this selection. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupPlan(final software.amazon.awscdk.services.backup.IBackupPlan backupPlan) {
            this.props.backupPlan(backupPlan);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.backup.BackupSelection}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.backup.BackupSelection build() {
            return new software.amazon.awscdk.services.backup.BackupSelection(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
