package software.amazon.awscdk.services.appsync;

/**
 * Properties for an AppSync GraphQL API.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * GraphqlApi sourceApi = GraphqlApi.Builder.create(this, "FirstSourceAPI")
 *         .name("FirstSourceAPI")
 *         .definition(Definition.fromFile(join(__dirname, "appsync.merged-api-1.graphql")))
 *         .build();
 * IGraphqlApi importedMergedApi = GraphqlApi.fromGraphqlApiAttributes(this, "ImportedMergedApi", GraphqlApiAttributes.builder()
 *         .graphqlApiId("MyApiId")
 *         .graphqlApiArn("MyApiArn")
 *         .build());
 * IRole importedExecutionRole = Role.fromRoleArn(this, "ExecutionRole", "arn:aws:iam::ACCOUNT:role/MyExistingRole");
 * SourceApiAssociation.Builder.create(this, "SourceApiAssociation2")
 *         .sourceApi(sourceApi)
 *         .mergedApi(importedMergedApi)
 *         .mergeType(MergeType.MANUAL_MERGE)
 *         .mergedApiExecutionRole(importedExecutionRole)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:07.381Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.GraphqlApiProps")
@software.amazon.jsii.Jsii.Proxy(GraphqlApiProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface GraphqlApiProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * the name of the GraphQL API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * Optional authorization configuration.
     * <p>
     * Default: - API Key authorization
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.AuthorizationConfig getAuthorizationConfig() {
        return null;
    }

    /**
     * Definition (schema file or source APIs) for this GraphQL Api.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.Definition getDefinition() {
        return null;
    }

    /**
     * The domain name configuration for the GraphQL API.
     * <p>
     * The Route 53 hosted zone and CName DNS record must be configured in addition to this setting to
     * enable custom domain URL
     * <p>
     * Default: - no domain name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.DomainOptions getDomainName() {
        return null;
    }

    /**
     * A map containing the list of resources with their properties and environment variables.
     * <p>
     * There are a few rules you must follow when creating keys and values:
     * <p>
     * <ul>
     * <li>Keys must begin with a letter.</li>
     * <li>Keys must be between 2 and 64 characters long.</li>
     * <li>Keys can only contain letters, numbers, and the underscore character (_).</li>
     * <li>Values can be up to 512 characters long.</li>
     * <li>You can configure up to 50 key-value pairs in a GraphQL API.</li>
     * </ul>
     * <p>
     * Default: - No environment variables.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getEnvironmentVariables() {
        return null;
    }

    /**
     * A value indicating whether the API to enable (ENABLED) or disable (DISABLED) introspection.
     * <p>
     * Default: IntrospectionConfig.ENABLED
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.IntrospectionConfig getIntrospectionConfig() {
        return null;
    }

    /**
     * Logging configuration for this api.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.LogConfig getLogConfig() {
        return null;
    }

    /**
     * The owner contact information for an API resource.
     * <p>
     * This field accepts any string input with a length of 0 - 256 characters.
     * <p>
     * Default: - No owner contact.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getOwnerContact() {
        return null;
    }

    /**
     * A number indicating the maximum depth resolvers should be accepted when handling queries.
     * <p>
     * Value must be withing range of 0 to 75
     * <p>
     * Default: - The default value is 0 (or unspecified) which indicates no maximum depth.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getQueryDepthLimit() {
        return null;
    }

    /**
     * A number indicating the maximum number of resolvers that should be accepted when handling queries.
     * <p>
     * Value must be withing range of 0 to 10000
     * <p>
     * Default: - The default value is 0 (or unspecified), which will set the limit to 10000
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getResolverCountLimit() {
        return null;
    }

    /**
     * (deprecated) GraphQL schema definition. Specify how you want to define your schema.
     * <p>
     * SchemaFile.fromAsset(filePath: string) allows schema definition through schema.graphql file
     * <p>
     * Default: - schema will be generated code-first (i.e. addType, addObjectType, etc.)
     * <p>
     * @deprecated use Definition.schema instead
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.ISchema getSchema() {
        return null;
    }

    /**
     * A value indicating whether the API is accessible from anywhere (GLOBAL) or can only be access from a VPC (PRIVATE).
     * <p>
     * Default: - GLOBAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.Visibility getVisibility() {
        return null;
    }

    /**
     * A flag indicating whether or not X-Ray tracing is enabled for the GraphQL API.
     * <p>
     * Default: - false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getXrayEnabled() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link GraphqlApiProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link GraphqlApiProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<GraphqlApiProps> {
        java.lang.String name;
        software.amazon.awscdk.services.appsync.AuthorizationConfig authorizationConfig;
        software.amazon.awscdk.services.appsync.Definition definition;
        software.amazon.awscdk.services.appsync.DomainOptions domainName;
        java.util.Map<java.lang.String, java.lang.String> environmentVariables;
        software.amazon.awscdk.services.appsync.IntrospectionConfig introspectionConfig;
        software.amazon.awscdk.services.appsync.LogConfig logConfig;
        java.lang.String ownerContact;
        java.lang.Number queryDepthLimit;
        java.lang.Number resolverCountLimit;
        software.amazon.awscdk.services.appsync.ISchema schema;
        software.amazon.awscdk.services.appsync.Visibility visibility;
        java.lang.Boolean xrayEnabled;

        /**
         * Sets the value of {@link GraphqlApiProps#getName}
         * @param name the name of the GraphQL API. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link GraphqlApiProps#getAuthorizationConfig}
         * @param authorizationConfig Optional authorization configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizationConfig(software.amazon.awscdk.services.appsync.AuthorizationConfig authorizationConfig) {
            this.authorizationConfig = authorizationConfig;
            return this;
        }

        /**
         * Sets the value of {@link GraphqlApiProps#getDefinition}
         * @param definition Definition (schema file or source APIs) for this GraphQL Api.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definition(software.amazon.awscdk.services.appsync.Definition definition) {
            this.definition = definition;
            return this;
        }

        /**
         * Sets the value of {@link GraphqlApiProps#getDomainName}
         * @param domainName The domain name configuration for the GraphQL API.
         *                   The Route 53 hosted zone and CName DNS record must be configured in addition to this setting to
         *                   enable custom domain URL
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(software.amazon.awscdk.services.appsync.DomainOptions domainName) {
            this.domainName = domainName;
            return this;
        }

        /**
         * Sets the value of {@link GraphqlApiProps#getEnvironmentVariables}
         * @param environmentVariables A map containing the list of resources with their properties and environment variables.
         *                             There are a few rules you must follow when creating keys and values:
         *                             <p>
         *                             <ul>
         *                             <li>Keys must begin with a letter.</li>
         *                             <li>Keys must be between 2 and 64 characters long.</li>
         *                             <li>Keys can only contain letters, numbers, and the underscore character (_).</li>
         *                             <li>Values can be up to 512 characters long.</li>
         *                             <li>You can configure up to 50 key-value pairs in a GraphQL API.</li>
         *                             </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentVariables(java.util.Map<java.lang.String, java.lang.String> environmentVariables) {
            this.environmentVariables = environmentVariables;
            return this;
        }

        /**
         * Sets the value of {@link GraphqlApiProps#getIntrospectionConfig}
         * @param introspectionConfig A value indicating whether the API to enable (ENABLED) or disable (DISABLED) introspection.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder introspectionConfig(software.amazon.awscdk.services.appsync.IntrospectionConfig introspectionConfig) {
            this.introspectionConfig = introspectionConfig;
            return this;
        }

        /**
         * Sets the value of {@link GraphqlApiProps#getLogConfig}
         * @param logConfig Logging configuration for this api.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logConfig(software.amazon.awscdk.services.appsync.LogConfig logConfig) {
            this.logConfig = logConfig;
            return this;
        }

        /**
         * Sets the value of {@link GraphqlApiProps#getOwnerContact}
         * @param ownerContact The owner contact information for an API resource.
         *                     This field accepts any string input with a length of 0 - 256 characters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ownerContact(java.lang.String ownerContact) {
            this.ownerContact = ownerContact;
            return this;
        }

        /**
         * Sets the value of {@link GraphqlApiProps#getQueryDepthLimit}
         * @param queryDepthLimit A number indicating the maximum depth resolvers should be accepted when handling queries.
         *                        Value must be withing range of 0 to 75
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryDepthLimit(java.lang.Number queryDepthLimit) {
            this.queryDepthLimit = queryDepthLimit;
            return this;
        }

        /**
         * Sets the value of {@link GraphqlApiProps#getResolverCountLimit}
         * @param resolverCountLimit A number indicating the maximum number of resolvers that should be accepted when handling queries.
         *                           Value must be withing range of 0 to 10000
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resolverCountLimit(java.lang.Number resolverCountLimit) {
            this.resolverCountLimit = resolverCountLimit;
            return this;
        }

        /**
         * Sets the value of {@link GraphqlApiProps#getSchema}
         * @param schema GraphQL schema definition. Specify how you want to define your schema.
         *               SchemaFile.fromAsset(filePath: string) allows schema definition through schema.graphql file
         * @return {@code this}
         * @deprecated use Definition.schema instead
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder schema(software.amazon.awscdk.services.appsync.ISchema schema) {
            this.schema = schema;
            return this;
        }

        /**
         * Sets the value of {@link GraphqlApiProps#getVisibility}
         * @param visibility A value indicating whether the API is accessible from anywhere (GLOBAL) or can only be access from a VPC (PRIVATE).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder visibility(software.amazon.awscdk.services.appsync.Visibility visibility) {
            this.visibility = visibility;
            return this;
        }

        /**
         * Sets the value of {@link GraphqlApiProps#getXrayEnabled}
         * @param xrayEnabled A flag indicating whether or not X-Ray tracing is enabled for the GraphQL API.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder xrayEnabled(java.lang.Boolean xrayEnabled) {
            this.xrayEnabled = xrayEnabled;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link GraphqlApiProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public GraphqlApiProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link GraphqlApiProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GraphqlApiProps {
        private final java.lang.String name;
        private final software.amazon.awscdk.services.appsync.AuthorizationConfig authorizationConfig;
        private final software.amazon.awscdk.services.appsync.Definition definition;
        private final software.amazon.awscdk.services.appsync.DomainOptions domainName;
        private final java.util.Map<java.lang.String, java.lang.String> environmentVariables;
        private final software.amazon.awscdk.services.appsync.IntrospectionConfig introspectionConfig;
        private final software.amazon.awscdk.services.appsync.LogConfig logConfig;
        private final java.lang.String ownerContact;
        private final java.lang.Number queryDepthLimit;
        private final java.lang.Number resolverCountLimit;
        private final software.amazon.awscdk.services.appsync.ISchema schema;
        private final software.amazon.awscdk.services.appsync.Visibility visibility;
        private final java.lang.Boolean xrayEnabled;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.authorizationConfig = software.amazon.jsii.Kernel.get(this, "authorizationConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.AuthorizationConfig.class));
            this.definition = software.amazon.jsii.Kernel.get(this, "definition", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.Definition.class));
            this.domainName = software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.DomainOptions.class));
            this.environmentVariables = software.amazon.jsii.Kernel.get(this, "environmentVariables", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.introspectionConfig = software.amazon.jsii.Kernel.get(this, "introspectionConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.IntrospectionConfig.class));
            this.logConfig = software.amazon.jsii.Kernel.get(this, "logConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.LogConfig.class));
            this.ownerContact = software.amazon.jsii.Kernel.get(this, "ownerContact", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.queryDepthLimit = software.amazon.jsii.Kernel.get(this, "queryDepthLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.resolverCountLimit = software.amazon.jsii.Kernel.get(this, "resolverCountLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.schema = software.amazon.jsii.Kernel.get(this, "schema", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.ISchema.class));
            this.visibility = software.amazon.jsii.Kernel.get(this, "visibility", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.Visibility.class));
            this.xrayEnabled = software.amazon.jsii.Kernel.get(this, "xrayEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.authorizationConfig = builder.authorizationConfig;
            this.definition = builder.definition;
            this.domainName = builder.domainName;
            this.environmentVariables = builder.environmentVariables;
            this.introspectionConfig = builder.introspectionConfig;
            this.logConfig = builder.logConfig;
            this.ownerContact = builder.ownerContact;
            this.queryDepthLimit = builder.queryDepthLimit;
            this.resolverCountLimit = builder.resolverCountLimit;
            this.schema = builder.schema;
            this.visibility = builder.visibility;
            this.xrayEnabled = builder.xrayEnabled;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final software.amazon.awscdk.services.appsync.AuthorizationConfig getAuthorizationConfig() {
            return this.authorizationConfig;
        }

        @Override
        public final software.amazon.awscdk.services.appsync.Definition getDefinition() {
            return this.definition;
        }

        @Override
        public final software.amazon.awscdk.services.appsync.DomainOptions getDomainName() {
            return this.domainName;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getEnvironmentVariables() {
            return this.environmentVariables;
        }

        @Override
        public final software.amazon.awscdk.services.appsync.IntrospectionConfig getIntrospectionConfig() {
            return this.introspectionConfig;
        }

        @Override
        public final software.amazon.awscdk.services.appsync.LogConfig getLogConfig() {
            return this.logConfig;
        }

        @Override
        public final java.lang.String getOwnerContact() {
            return this.ownerContact;
        }

        @Override
        public final java.lang.Number getQueryDepthLimit() {
            return this.queryDepthLimit;
        }

        @Override
        public final java.lang.Number getResolverCountLimit() {
            return this.resolverCountLimit;
        }

        @Override
        public final software.amazon.awscdk.services.appsync.ISchema getSchema() {
            return this.schema;
        }

        @Override
        public final software.amazon.awscdk.services.appsync.Visibility getVisibility() {
            return this.visibility;
        }

        @Override
        public final java.lang.Boolean getXrayEnabled() {
            return this.xrayEnabled;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            if (this.getAuthorizationConfig() != null) {
                data.set("authorizationConfig", om.valueToTree(this.getAuthorizationConfig()));
            }
            if (this.getDefinition() != null) {
                data.set("definition", om.valueToTree(this.getDefinition()));
            }
            if (this.getDomainName() != null) {
                data.set("domainName", om.valueToTree(this.getDomainName()));
            }
            if (this.getEnvironmentVariables() != null) {
                data.set("environmentVariables", om.valueToTree(this.getEnvironmentVariables()));
            }
            if (this.getIntrospectionConfig() != null) {
                data.set("introspectionConfig", om.valueToTree(this.getIntrospectionConfig()));
            }
            if (this.getLogConfig() != null) {
                data.set("logConfig", om.valueToTree(this.getLogConfig()));
            }
            if (this.getOwnerContact() != null) {
                data.set("ownerContact", om.valueToTree(this.getOwnerContact()));
            }
            if (this.getQueryDepthLimit() != null) {
                data.set("queryDepthLimit", om.valueToTree(this.getQueryDepthLimit()));
            }
            if (this.getResolverCountLimit() != null) {
                data.set("resolverCountLimit", om.valueToTree(this.getResolverCountLimit()));
            }
            if (this.getSchema() != null) {
                data.set("schema", om.valueToTree(this.getSchema()));
            }
            if (this.getVisibility() != null) {
                data.set("visibility", om.valueToTree(this.getVisibility()));
            }
            if (this.getXrayEnabled() != null) {
                data.set("xrayEnabled", om.valueToTree(this.getXrayEnabled()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.GraphqlApiProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            GraphqlApiProps.Jsii$Proxy that = (GraphqlApiProps.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (this.authorizationConfig != null ? !this.authorizationConfig.equals(that.authorizationConfig) : that.authorizationConfig != null) return false;
            if (this.definition != null ? !this.definition.equals(that.definition) : that.definition != null) return false;
            if (this.domainName != null ? !this.domainName.equals(that.domainName) : that.domainName != null) return false;
            if (this.environmentVariables != null ? !this.environmentVariables.equals(that.environmentVariables) : that.environmentVariables != null) return false;
            if (this.introspectionConfig != null ? !this.introspectionConfig.equals(that.introspectionConfig) : that.introspectionConfig != null) return false;
            if (this.logConfig != null ? !this.logConfig.equals(that.logConfig) : that.logConfig != null) return false;
            if (this.ownerContact != null ? !this.ownerContact.equals(that.ownerContact) : that.ownerContact != null) return false;
            if (this.queryDepthLimit != null ? !this.queryDepthLimit.equals(that.queryDepthLimit) : that.queryDepthLimit != null) return false;
            if (this.resolverCountLimit != null ? !this.resolverCountLimit.equals(that.resolverCountLimit) : that.resolverCountLimit != null) return false;
            if (this.schema != null ? !this.schema.equals(that.schema) : that.schema != null) return false;
            if (this.visibility != null ? !this.visibility.equals(that.visibility) : that.visibility != null) return false;
            return this.xrayEnabled != null ? this.xrayEnabled.equals(that.xrayEnabled) : that.xrayEnabled == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.authorizationConfig != null ? this.authorizationConfig.hashCode() : 0);
            result = 31 * result + (this.definition != null ? this.definition.hashCode() : 0);
            result = 31 * result + (this.domainName != null ? this.domainName.hashCode() : 0);
            result = 31 * result + (this.environmentVariables != null ? this.environmentVariables.hashCode() : 0);
            result = 31 * result + (this.introspectionConfig != null ? this.introspectionConfig.hashCode() : 0);
            result = 31 * result + (this.logConfig != null ? this.logConfig.hashCode() : 0);
            result = 31 * result + (this.ownerContact != null ? this.ownerContact.hashCode() : 0);
            result = 31 * result + (this.queryDepthLimit != null ? this.queryDepthLimit.hashCode() : 0);
            result = 31 * result + (this.resolverCountLimit != null ? this.resolverCountLimit.hashCode() : 0);
            result = 31 * result + (this.schema != null ? this.schema.hashCode() : 0);
            result = 31 * result + (this.visibility != null ? this.visibility.hashCode() : 0);
            result = 31 * result + (this.xrayEnabled != null ? this.xrayEnabled.hashCode() : 0);
            return result;
        }
    }
}
