package software.amazon.awscdk.services.appsync;

/**
 * the base properties for a channel namespace.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appsync.*;
 * Code code;
 * BaseChannelNamespaceProps baseChannelNamespaceProps = BaseChannelNamespaceProps.builder()
 *         .authorizationConfig(NamespaceAuthConfig.builder()
 *                 .publishAuthModeTypes(List.of(AppSyncAuthorizationType.API_KEY))
 *                 .subscribeAuthModeTypes(List.of(AppSyncAuthorizationType.API_KEY))
 *                 .build())
 *         .channelNamespaceName("channelNamespaceName")
 *         .code(code)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:07.291Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.BaseChannelNamespaceProps")
@software.amazon.jsii.Jsii.Proxy(BaseChannelNamespaceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BaseChannelNamespaceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Authorization config for channel namespace.
     * <p>
     * Default: - defaults to Event API default auth config
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.NamespaceAuthConfig getAuthorizationConfig() {
        return null;
    }

    /**
     * the name of the channel namespace.
     * <p>
     * Default: - the construct's id will be used
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getChannelNamespaceName() {
        return null;
    }

    /**
     * The Event Handler code.
     * <p>
     * Default: - no code is used
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.Code getCode() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BaseChannelNamespaceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BaseChannelNamespaceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BaseChannelNamespaceProps> {
        software.amazon.awscdk.services.appsync.NamespaceAuthConfig authorizationConfig;
        java.lang.String channelNamespaceName;
        software.amazon.awscdk.services.appsync.Code code;

        /**
         * Sets the value of {@link BaseChannelNamespaceProps#getAuthorizationConfig}
         * @param authorizationConfig Authorization config for channel namespace.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizationConfig(software.amazon.awscdk.services.appsync.NamespaceAuthConfig authorizationConfig) {
            this.authorizationConfig = authorizationConfig;
            return this;
        }

        /**
         * Sets the value of {@link BaseChannelNamespaceProps#getChannelNamespaceName}
         * @param channelNamespaceName the name of the channel namespace.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder channelNamespaceName(java.lang.String channelNamespaceName) {
            this.channelNamespaceName = channelNamespaceName;
            return this;
        }

        /**
         * Sets the value of {@link BaseChannelNamespaceProps#getCode}
         * @param code The Event Handler code.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder code(software.amazon.awscdk.services.appsync.Code code) {
            this.code = code;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BaseChannelNamespaceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BaseChannelNamespaceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BaseChannelNamespaceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BaseChannelNamespaceProps {
        private final software.amazon.awscdk.services.appsync.NamespaceAuthConfig authorizationConfig;
        private final java.lang.String channelNamespaceName;
        private final software.amazon.awscdk.services.appsync.Code code;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.authorizationConfig = software.amazon.jsii.Kernel.get(this, "authorizationConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.NamespaceAuthConfig.class));
            this.channelNamespaceName = software.amazon.jsii.Kernel.get(this, "channelNamespaceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.code = software.amazon.jsii.Kernel.get(this, "code", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.Code.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.authorizationConfig = builder.authorizationConfig;
            this.channelNamespaceName = builder.channelNamespaceName;
            this.code = builder.code;
        }

        @Override
        public final software.amazon.awscdk.services.appsync.NamespaceAuthConfig getAuthorizationConfig() {
            return this.authorizationConfig;
        }

        @Override
        public final java.lang.String getChannelNamespaceName() {
            return this.channelNamespaceName;
        }

        @Override
        public final software.amazon.awscdk.services.appsync.Code getCode() {
            return this.code;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAuthorizationConfig() != null) {
                data.set("authorizationConfig", om.valueToTree(this.getAuthorizationConfig()));
            }
            if (this.getChannelNamespaceName() != null) {
                data.set("channelNamespaceName", om.valueToTree(this.getChannelNamespaceName()));
            }
            if (this.getCode() != null) {
                data.set("code", om.valueToTree(this.getCode()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.BaseChannelNamespaceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BaseChannelNamespaceProps.Jsii$Proxy that = (BaseChannelNamespaceProps.Jsii$Proxy) o;

            if (this.authorizationConfig != null ? !this.authorizationConfig.equals(that.authorizationConfig) : that.authorizationConfig != null) return false;
            if (this.channelNamespaceName != null ? !this.channelNamespaceName.equals(that.channelNamespaceName) : that.channelNamespaceName != null) return false;
            return this.code != null ? this.code.equals(that.code) : that.code == null;
        }

        @Override
        public final int hashCode() {
            int result = this.authorizationConfig != null ? this.authorizationConfig.hashCode() : 0;
            result = 31 * result + (this.channelNamespaceName != null ? this.channelNamespaceName.hashCode() : 0);
            result = 31 * result + (this.code != null ? this.code.hashCode() : 0);
            return result;
        }
    }
}
