package software.amazon.awscdk.services.appconfig;

/**
 * Defines the hosted configuration content.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Application app = new Application(this, "MyApp");
 * Environment env = Environment.Builder.create(this, "MyEnv")
 *         .application(app)
 *         .build();
 * HostedConfiguration.Builder.create(this, "MyHostedConfig")
 *         .application(app)
 *         .deployTo(List.of(env))
 *         .content(ConfigurationContent.fromInlineText("This is my configuration content."))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:06.692Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appconfig.ConfigurationContent")
public abstract class ConfigurationContent extends software.amazon.jsii.JsiiObject {

    protected ConfigurationContent(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ConfigurationContent(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected ConfigurationContent() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Defines the hosted configuration content from a file.
     * <p>
     * @param inputPath The path to the file that defines configuration content. This parameter is required.
     * @param contentType The content type of the configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.ConfigurationContent fromFile(final @org.jetbrains.annotations.NotNull java.lang.String inputPath, final @org.jetbrains.annotations.Nullable java.lang.String contentType) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appconfig.ConfigurationContent.class, "fromFile", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.ConfigurationContent.class), new Object[] { java.util.Objects.requireNonNull(inputPath, "inputPath is required"), contentType });
    }

    /**
     * Defines the hosted configuration content from a file.
     * <p>
     * @param inputPath The path to the file that defines configuration content. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.ConfigurationContent fromFile(final @org.jetbrains.annotations.NotNull java.lang.String inputPath) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appconfig.ConfigurationContent.class, "fromFile", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.ConfigurationContent.class), new Object[] { java.util.Objects.requireNonNull(inputPath, "inputPath is required") });
    }

    /**
     * Defines the hosted configuration content from inline code.
     * <p>
     * @param content The inline code that defines the configuration content. This parameter is required.
     * @param contentType The content type of the configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.ConfigurationContent fromInline(final @org.jetbrains.annotations.NotNull java.lang.String content, final @org.jetbrains.annotations.Nullable java.lang.String contentType) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appconfig.ConfigurationContent.class, "fromInline", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.ConfigurationContent.class), new Object[] { java.util.Objects.requireNonNull(content, "content is required"), contentType });
    }

    /**
     * Defines the hosted configuration content from inline code.
     * <p>
     * @param content The inline code that defines the configuration content. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.ConfigurationContent fromInline(final @org.jetbrains.annotations.NotNull java.lang.String content) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appconfig.ConfigurationContent.class, "fromInline", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.ConfigurationContent.class), new Object[] { java.util.Objects.requireNonNull(content, "content is required") });
    }

    /**
     * Defines the hosted configuration content as JSON from inline code.
     * <p>
     * @param content The inline code that defines the configuration content. This parameter is required.
     * @param contentType The content type of the configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.ConfigurationContent fromInlineJson(final @org.jetbrains.annotations.NotNull java.lang.String content, final @org.jetbrains.annotations.Nullable java.lang.String contentType) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appconfig.ConfigurationContent.class, "fromInlineJson", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.ConfigurationContent.class), new Object[] { java.util.Objects.requireNonNull(content, "content is required"), contentType });
    }

    /**
     * Defines the hosted configuration content as JSON from inline code.
     * <p>
     * @param content The inline code that defines the configuration content. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.ConfigurationContent fromInlineJson(final @org.jetbrains.annotations.NotNull java.lang.String content) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appconfig.ConfigurationContent.class, "fromInlineJson", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.ConfigurationContent.class), new Object[] { java.util.Objects.requireNonNull(content, "content is required") });
    }

    /**
     * Defines the hosted configuration content as text from inline code.
     * <p>
     * @param content The inline code that defines the configuration content. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.ConfigurationContent fromInlineText(final @org.jetbrains.annotations.NotNull java.lang.String content) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appconfig.ConfigurationContent.class, "fromInlineText", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.ConfigurationContent.class), new Object[] { java.util.Objects.requireNonNull(content, "content is required") });
    }

    /**
     * Defines the hosted configuration content as YAML from inline code.
     * <p>
     * @param content The inline code that defines the configuration content. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.ConfigurationContent fromInlineYaml(final @org.jetbrains.annotations.NotNull java.lang.String content) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appconfig.ConfigurationContent.class, "fromInlineYaml", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.ConfigurationContent.class), new Object[] { java.util.Objects.requireNonNull(content, "content is required") });
    }

    /**
     * The configuration content.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull java.lang.String getContent();

    /**
     * The configuration content type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull java.lang.String getContentType();

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.appconfig.ConfigurationContent {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * The configuration content.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getContent() {
            return software.amazon.jsii.Kernel.get(this, "content", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The configuration content type.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getContentType() {
            return software.amazon.jsii.Kernel.get(this, "contentType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }
    }
}
