package software.amazon.awscdk.services.apigateway;

/**
 * Options when configuring Step Functions synchronous integration with Rest API.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.apigateway.*;
 * import software.amazon.awscdk.services.iam.*;
 * Role role;
 * VpcLink vpcLink;
 * StepFunctionsExecutionIntegrationOptions stepFunctionsExecutionIntegrationOptions = StepFunctionsExecutionIntegrationOptions.builder()
 *         .authorizer(false)
 *         .cacheKeyParameters(List.of("cacheKeyParameters"))
 *         .cacheNamespace("cacheNamespace")
 *         .connectionType(ConnectionType.INTERNET)
 *         .contentHandling(ContentHandling.CONVERT_TO_BINARY)
 *         .credentialsPassthrough(false)
 *         .credentialsRole(role)
 *         .headers(false)
 *         .integrationResponses(List.of(IntegrationResponse.builder()
 *                 .statusCode("statusCode")
 *                 // the properties below are optional
 *                 .contentHandling(ContentHandling.CONVERT_TO_BINARY)
 *                 .responseParameters(Map.of(
 *                         "responseParametersKey", "responseParameters"))
 *                 .responseTemplates(Map.of(
 *                         "responseTemplatesKey", "responseTemplates"))
 *                 .selectionPattern("selectionPattern")
 *                 .build()))
 *         .passthroughBehavior(PassthroughBehavior.WHEN_NO_MATCH)
 *         .path(false)
 *         .querystring(false)
 *         .requestContext(RequestContext.builder()
 *                 .accountId(false)
 *                 .apiId(false)
 *                 .apiKey(false)
 *                 .authorizerPrincipalId(false)
 *                 .caller(false)
 *                 .cognitoAuthenticationProvider(false)
 *                 .cognitoAuthenticationType(false)
 *                 .cognitoIdentityId(false)
 *                 .cognitoIdentityPoolId(false)
 *                 .httpMethod(false)
 *                 .requestId(false)
 *                 .resourceId(false)
 *                 .resourcePath(false)
 *                 .sourceIp(false)
 *                 .stage(false)
 *                 .user(false)
 *                 .userAgent(false)
 *                 .userArn(false)
 *                 .build())
 *         .requestParameters(Map.of(
 *                 "requestParametersKey", "requestParameters"))
 *         .requestTemplates(Map.of(
 *                 "requestTemplatesKey", "requestTemplates"))
 *         .timeout(Duration.minutes(30))
 *         .useDefaultMethodResponses(false)
 *         .vpcLink(vpcLink)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:06.456Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigateway.StepFunctionsExecutionIntegrationOptions")
@software.amazon.jsii.Jsii.Proxy(StepFunctionsExecutionIntegrationOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface StepFunctionsExecutionIntegrationOptions extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.apigateway.IntegrationOptions {

    /**
     * If the whole authorizer object, including custom context values should be in the execution input.
     * <p>
     * The execution input will include a new key <code>authorizer</code>:
     * <p>
     * {
     * "body": {},
     * "authorizer": {
     * "key": "value"
     * }
     * }
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAuthorizer() {
        return null;
    }

    /**
     * Check if header is to be included inside the execution input.
     * <p>
     * The execution input will include a new key <code>headers</code>:
     * <p>
     * {
     * "body": {},
     * "headers": {
     * "header1": "value",
     * "header2": "value"
     * }
     * }
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getHeaders() {
        return null;
    }

    /**
     * Check if path is to be included inside the execution input.
     * <p>
     * The execution input will include a new key <code>path</code>:
     * <p>
     * {
     * "body": {},
     * "path": {
     * "resourceName": "resourceValue"
     * }
     * }
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPath() {
        return null;
    }

    /**
     * Check if querystring is to be included inside the execution input.
     * <p>
     * The execution input will include a new key <code>queryString</code>:
     * <p>
     * {
     * "body": {},
     * "querystring": {
     * "key": "value"
     * }
     * }
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getQuerystring() {
        return null;
    }

    /**
     * Which details of the incoming request must be passed onto the underlying state machine, such as, account id, user identity, request id, etc.
     * <p>
     * The execution input will include a new key <code>requestContext</code>:
     * <p>
     * {
     * "body": {},
     * "requestContext": {
     * "key": "value"
     * }
     * }
     * <p>
     * Default: - all parameters within request context will be set as false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.RequestContext getRequestContext() {
        return null;
    }

    /**
     * Whether to add default response models with 200, 400, and 500 status codes to the method.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getUseDefaultMethodResponses() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link StepFunctionsExecutionIntegrationOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link StepFunctionsExecutionIntegrationOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<StepFunctionsExecutionIntegrationOptions> {
        java.lang.Boolean authorizer;
        java.lang.Boolean headers;
        java.lang.Boolean path;
        java.lang.Boolean querystring;
        software.amazon.awscdk.services.apigateway.RequestContext requestContext;
        java.lang.Boolean useDefaultMethodResponses;
        java.util.List<java.lang.String> cacheKeyParameters;
        java.lang.String cacheNamespace;
        software.amazon.awscdk.services.apigateway.ConnectionType connectionType;
        software.amazon.awscdk.services.apigateway.ContentHandling contentHandling;
        java.lang.Boolean credentialsPassthrough;
        software.amazon.awscdk.services.iam.IRole credentialsRole;
        java.util.List<software.amazon.awscdk.services.apigateway.IntegrationResponse> integrationResponses;
        software.amazon.awscdk.services.apigateway.PassthroughBehavior passthroughBehavior;
        java.util.Map<java.lang.String, java.lang.String> requestParameters;
        java.util.Map<java.lang.String, java.lang.String> requestTemplates;
        software.amazon.awscdk.Duration timeout;
        software.amazon.awscdk.services.apigateway.IVpcLink vpcLink;

        /**
         * Sets the value of {@link StepFunctionsExecutionIntegrationOptions#getAuthorizer}
         * @param authorizer If the whole authorizer object, including custom context values should be in the execution input.
         *                   The execution input will include a new key <code>authorizer</code>:
         *                   <p>
         *                   {
         *                   "body": {},
         *                   "authorizer": {
         *                   "key": "value"
         *                   }
         *                   }
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizer(java.lang.Boolean authorizer) {
            this.authorizer = authorizer;
            return this;
        }

        /**
         * Sets the value of {@link StepFunctionsExecutionIntegrationOptions#getHeaders}
         * @param headers Check if header is to be included inside the execution input.
         *                The execution input will include a new key <code>headers</code>:
         *                <p>
         *                {
         *                "body": {},
         *                "headers": {
         *                "header1": "value",
         *                "header2": "value"
         *                }
         *                }
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder headers(java.lang.Boolean headers) {
            this.headers = headers;
            return this;
        }

        /**
         * Sets the value of {@link StepFunctionsExecutionIntegrationOptions#getPath}
         * @param path Check if path is to be included inside the execution input.
         *             The execution input will include a new key <code>path</code>:
         *             <p>
         *             {
         *             "body": {},
         *             "path": {
         *             "resourceName": "resourceValue"
         *             }
         *             }
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder path(java.lang.Boolean path) {
            this.path = path;
            return this;
        }

        /**
         * Sets the value of {@link StepFunctionsExecutionIntegrationOptions#getQuerystring}
         * @param querystring Check if querystring is to be included inside the execution input.
         *                    The execution input will include a new key <code>queryString</code>:
         *                    <p>
         *                    {
         *                    "body": {},
         *                    "querystring": {
         *                    "key": "value"
         *                    }
         *                    }
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder querystring(java.lang.Boolean querystring) {
            this.querystring = querystring;
            return this;
        }

        /**
         * Sets the value of {@link StepFunctionsExecutionIntegrationOptions#getRequestContext}
         * @param requestContext Which details of the incoming request must be passed onto the underlying state machine, such as, account id, user identity, request id, etc.
         *                       The execution input will include a new key <code>requestContext</code>:
         *                       <p>
         *                       {
         *                       "body": {},
         *                       "requestContext": {
         *                       "key": "value"
         *                       }
         *                       }
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestContext(software.amazon.awscdk.services.apigateway.RequestContext requestContext) {
            this.requestContext = requestContext;
            return this;
        }

        /**
         * Sets the value of {@link StepFunctionsExecutionIntegrationOptions#getUseDefaultMethodResponses}
         * @param useDefaultMethodResponses Whether to add default response models with 200, 400, and 500 status codes to the method.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useDefaultMethodResponses(java.lang.Boolean useDefaultMethodResponses) {
            this.useDefaultMethodResponses = useDefaultMethodResponses;
            return this;
        }

        /**
         * Sets the value of {@link StepFunctionsExecutionIntegrationOptions#getCacheKeyParameters}
         * @param cacheKeyParameters A list of request parameters whose values are to be cached.
         *                           It determines
         *                           request parameters that will make it into the cache key.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheKeyParameters(java.util.List<java.lang.String> cacheKeyParameters) {
            this.cacheKeyParameters = cacheKeyParameters;
            return this;
        }

        /**
         * Sets the value of {@link StepFunctionsExecutionIntegrationOptions#getCacheNamespace}
         * @param cacheNamespace An API-specific tag group of related cached parameters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheNamespace(java.lang.String cacheNamespace) {
            this.cacheNamespace = cacheNamespace;
            return this;
        }

        /**
         * Sets the value of {@link StepFunctionsExecutionIntegrationOptions#getConnectionType}
         * @param connectionType The type of network connection to the integration endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionType(software.amazon.awscdk.services.apigateway.ConnectionType connectionType) {
            this.connectionType = connectionType;
            return this;
        }

        /**
         * Sets the value of {@link StepFunctionsExecutionIntegrationOptions#getContentHandling}
         * @param contentHandling Specifies how to handle request payload content type conversions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contentHandling(software.amazon.awscdk.services.apigateway.ContentHandling contentHandling) {
            this.contentHandling = contentHandling;
            return this;
        }

        /**
         * Sets the value of {@link StepFunctionsExecutionIntegrationOptions#getCredentialsPassthrough}
         * @param credentialsPassthrough Requires that the caller's identity be passed through from the request.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder credentialsPassthrough(java.lang.Boolean credentialsPassthrough) {
            this.credentialsPassthrough = credentialsPassthrough;
            return this;
        }

        /**
         * Sets the value of {@link StepFunctionsExecutionIntegrationOptions#getCredentialsRole}
         * @param credentialsRole An IAM role that API Gateway assumes.
         *                        Mutually exclusive with <code>credentialsPassThrough</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder credentialsRole(software.amazon.awscdk.services.iam.IRole credentialsRole) {
            this.credentialsRole = credentialsRole;
            return this;
        }

        /**
         * Sets the value of {@link StepFunctionsExecutionIntegrationOptions#getIntegrationResponses}
         * @param integrationResponses The response that API Gateway provides after a method's backend completes processing a request.
         *                             API Gateway intercepts the response from the
         *                             backend so that you can control how API Gateway surfaces backend
         *                             responses. For example, you can map the backend status codes to codes
         *                             that you define.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder integrationResponses(java.util.List<? extends software.amazon.awscdk.services.apigateway.IntegrationResponse> integrationResponses) {
            this.integrationResponses = (java.util.List<software.amazon.awscdk.services.apigateway.IntegrationResponse>)integrationResponses;
            return this;
        }

        /**
         * Sets the value of {@link StepFunctionsExecutionIntegrationOptions#getPassthroughBehavior}
         * @param passthroughBehavior Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource.
         *                            There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and
         *                            NEVER.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder passthroughBehavior(software.amazon.awscdk.services.apigateway.PassthroughBehavior passthroughBehavior) {
            this.passthroughBehavior = passthroughBehavior;
            return this;
        }

        /**
         * Sets the value of {@link StepFunctionsExecutionIntegrationOptions#getRequestParameters}
         * @param requestParameters The request parameters that API Gateway sends with the backend request.
         *                          Specify request parameters as key-value pairs (string-to-string
         *                          mappings), with a destination as the key and a source as the value.
         *                          <p>
         *                          Specify the destination by using the following pattern
         *                          integration.request.location.name, where location is querystring, path,
         *                          or header, and name is a valid, unique parameter name.
         *                          <p>
         *                          The source must be an existing method request parameter or a static
         *                          value. You must enclose static values in single quotation marks and
         *                          pre-encode these values based on their destination in the request.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestParameters(java.util.Map<java.lang.String, java.lang.String> requestParameters) {
            this.requestParameters = requestParameters;
            return this;
        }

        /**
         * Sets the value of {@link StepFunctionsExecutionIntegrationOptions#getRequestTemplates}
         * @param requestTemplates A map of Apache Velocity templates that are applied on the request payload.
         *                         The template that API Gateway uses is based on the value of the
         *                         Content-Type header that's sent by the client. The content type value is
         *                         the key, and the template is the value (specified as a string), such as
         *                         the following snippet:
         *                         <p>
         *                         <blockquote><pre>
         *                           { "application/json": "{ \"statusCode\": 200 }" }
         *                         </pre></blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestTemplates(java.util.Map<java.lang.String, java.lang.String> requestTemplates) {
            this.requestTemplates = requestTemplates;
            return this;
        }

        /**
         * Sets the value of {@link StepFunctionsExecutionIntegrationOptions#getTimeout}
         * @param timeout The maximum amount of time an integration will run before it returns without a response.
         *                By default, the value must be between 50 milliseconds and 29 seconds.
         *                The upper bound can be increased for regional and private Rest APIs only,
         *                via a quota increase request for your acccount.
         *                This increase might require a reduction in your account-level throttle quota limit.
         *                
         *                See {@link https://docs.aws.amazon.com/apigateway/latest/developerguide/limits.html Amazon API Gateway quotas} for more details.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(software.amazon.awscdk.Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Sets the value of {@link StepFunctionsExecutionIntegrationOptions#getVpcLink}
         * @param vpcLink The VpcLink used for the integration.
         *                Required if connectionType is VPC_LINK
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcLink(software.amazon.awscdk.services.apigateway.IVpcLink vpcLink) {
            this.vpcLink = vpcLink;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link StepFunctionsExecutionIntegrationOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public StepFunctionsExecutionIntegrationOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link StepFunctionsExecutionIntegrationOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StepFunctionsExecutionIntegrationOptions {
        private final java.lang.Boolean authorizer;
        private final java.lang.Boolean headers;
        private final java.lang.Boolean path;
        private final java.lang.Boolean querystring;
        private final software.amazon.awscdk.services.apigateway.RequestContext requestContext;
        private final java.lang.Boolean useDefaultMethodResponses;
        private final java.util.List<java.lang.String> cacheKeyParameters;
        private final java.lang.String cacheNamespace;
        private final software.amazon.awscdk.services.apigateway.ConnectionType connectionType;
        private final software.amazon.awscdk.services.apigateway.ContentHandling contentHandling;
        private final java.lang.Boolean credentialsPassthrough;
        private final software.amazon.awscdk.services.iam.IRole credentialsRole;
        private final java.util.List<software.amazon.awscdk.services.apigateway.IntegrationResponse> integrationResponses;
        private final software.amazon.awscdk.services.apigateway.PassthroughBehavior passthroughBehavior;
        private final java.util.Map<java.lang.String, java.lang.String> requestParameters;
        private final java.util.Map<java.lang.String, java.lang.String> requestTemplates;
        private final software.amazon.awscdk.Duration timeout;
        private final software.amazon.awscdk.services.apigateway.IVpcLink vpcLink;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.authorizer = software.amazon.jsii.Kernel.get(this, "authorizer", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.headers = software.amazon.jsii.Kernel.get(this, "headers", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.path = software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.querystring = software.amazon.jsii.Kernel.get(this, "querystring", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.requestContext = software.amazon.jsii.Kernel.get(this, "requestContext", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.RequestContext.class));
            this.useDefaultMethodResponses = software.amazon.jsii.Kernel.get(this, "useDefaultMethodResponses", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.cacheKeyParameters = software.amazon.jsii.Kernel.get(this, "cacheKeyParameters", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.cacheNamespace = software.amazon.jsii.Kernel.get(this, "cacheNamespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.connectionType = software.amazon.jsii.Kernel.get(this, "connectionType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.ConnectionType.class));
            this.contentHandling = software.amazon.jsii.Kernel.get(this, "contentHandling", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.ContentHandling.class));
            this.credentialsPassthrough = software.amazon.jsii.Kernel.get(this, "credentialsPassthrough", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.credentialsRole = software.amazon.jsii.Kernel.get(this, "credentialsRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.integrationResponses = software.amazon.jsii.Kernel.get(this, "integrationResponses", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.IntegrationResponse.class)));
            this.passthroughBehavior = software.amazon.jsii.Kernel.get(this, "passthroughBehavior", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.PassthroughBehavior.class));
            this.requestParameters = software.amazon.jsii.Kernel.get(this, "requestParameters", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.requestTemplates = software.amazon.jsii.Kernel.get(this, "requestTemplates", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.vpcLink = software.amazon.jsii.Kernel.get(this, "vpcLink", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.IVpcLink.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.authorizer = builder.authorizer;
            this.headers = builder.headers;
            this.path = builder.path;
            this.querystring = builder.querystring;
            this.requestContext = builder.requestContext;
            this.useDefaultMethodResponses = builder.useDefaultMethodResponses;
            this.cacheKeyParameters = builder.cacheKeyParameters;
            this.cacheNamespace = builder.cacheNamespace;
            this.connectionType = builder.connectionType;
            this.contentHandling = builder.contentHandling;
            this.credentialsPassthrough = builder.credentialsPassthrough;
            this.credentialsRole = builder.credentialsRole;
            this.integrationResponses = (java.util.List<software.amazon.awscdk.services.apigateway.IntegrationResponse>)builder.integrationResponses;
            this.passthroughBehavior = builder.passthroughBehavior;
            this.requestParameters = builder.requestParameters;
            this.requestTemplates = builder.requestTemplates;
            this.timeout = builder.timeout;
            this.vpcLink = builder.vpcLink;
        }

        @Override
        public final java.lang.Boolean getAuthorizer() {
            return this.authorizer;
        }

        @Override
        public final java.lang.Boolean getHeaders() {
            return this.headers;
        }

        @Override
        public final java.lang.Boolean getPath() {
            return this.path;
        }

        @Override
        public final java.lang.Boolean getQuerystring() {
            return this.querystring;
        }

        @Override
        public final software.amazon.awscdk.services.apigateway.RequestContext getRequestContext() {
            return this.requestContext;
        }

        @Override
        public final java.lang.Boolean getUseDefaultMethodResponses() {
            return this.useDefaultMethodResponses;
        }

        @Override
        public final java.util.List<java.lang.String> getCacheKeyParameters() {
            return this.cacheKeyParameters;
        }

        @Override
        public final java.lang.String getCacheNamespace() {
            return this.cacheNamespace;
        }

        @Override
        public final software.amazon.awscdk.services.apigateway.ConnectionType getConnectionType() {
            return this.connectionType;
        }

        @Override
        public final software.amazon.awscdk.services.apigateway.ContentHandling getContentHandling() {
            return this.contentHandling;
        }

        @Override
        public final java.lang.Boolean getCredentialsPassthrough() {
            return this.credentialsPassthrough;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getCredentialsRole() {
            return this.credentialsRole;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.apigateway.IntegrationResponse> getIntegrationResponses() {
            return this.integrationResponses;
        }

        @Override
        public final software.amazon.awscdk.services.apigateway.PassthroughBehavior getPassthroughBehavior() {
            return this.passthroughBehavior;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getRequestParameters() {
            return this.requestParameters;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getRequestTemplates() {
            return this.requestTemplates;
        }

        @Override
        public final software.amazon.awscdk.Duration getTimeout() {
            return this.timeout;
        }

        @Override
        public final software.amazon.awscdk.services.apigateway.IVpcLink getVpcLink() {
            return this.vpcLink;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAuthorizer() != null) {
                data.set("authorizer", om.valueToTree(this.getAuthorizer()));
            }
            if (this.getHeaders() != null) {
                data.set("headers", om.valueToTree(this.getHeaders()));
            }
            if (this.getPath() != null) {
                data.set("path", om.valueToTree(this.getPath()));
            }
            if (this.getQuerystring() != null) {
                data.set("querystring", om.valueToTree(this.getQuerystring()));
            }
            if (this.getRequestContext() != null) {
                data.set("requestContext", om.valueToTree(this.getRequestContext()));
            }
            if (this.getUseDefaultMethodResponses() != null) {
                data.set("useDefaultMethodResponses", om.valueToTree(this.getUseDefaultMethodResponses()));
            }
            if (this.getCacheKeyParameters() != null) {
                data.set("cacheKeyParameters", om.valueToTree(this.getCacheKeyParameters()));
            }
            if (this.getCacheNamespace() != null) {
                data.set("cacheNamespace", om.valueToTree(this.getCacheNamespace()));
            }
            if (this.getConnectionType() != null) {
                data.set("connectionType", om.valueToTree(this.getConnectionType()));
            }
            if (this.getContentHandling() != null) {
                data.set("contentHandling", om.valueToTree(this.getContentHandling()));
            }
            if (this.getCredentialsPassthrough() != null) {
                data.set("credentialsPassthrough", om.valueToTree(this.getCredentialsPassthrough()));
            }
            if (this.getCredentialsRole() != null) {
                data.set("credentialsRole", om.valueToTree(this.getCredentialsRole()));
            }
            if (this.getIntegrationResponses() != null) {
                data.set("integrationResponses", om.valueToTree(this.getIntegrationResponses()));
            }
            if (this.getPassthroughBehavior() != null) {
                data.set("passthroughBehavior", om.valueToTree(this.getPassthroughBehavior()));
            }
            if (this.getRequestParameters() != null) {
                data.set("requestParameters", om.valueToTree(this.getRequestParameters()));
            }
            if (this.getRequestTemplates() != null) {
                data.set("requestTemplates", om.valueToTree(this.getRequestTemplates()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }
            if (this.getVpcLink() != null) {
                data.set("vpcLink", om.valueToTree(this.getVpcLink()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigateway.StepFunctionsExecutionIntegrationOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            StepFunctionsExecutionIntegrationOptions.Jsii$Proxy that = (StepFunctionsExecutionIntegrationOptions.Jsii$Proxy) o;

            if (this.authorizer != null ? !this.authorizer.equals(that.authorizer) : that.authorizer != null) return false;
            if (this.headers != null ? !this.headers.equals(that.headers) : that.headers != null) return false;
            if (this.path != null ? !this.path.equals(that.path) : that.path != null) return false;
            if (this.querystring != null ? !this.querystring.equals(that.querystring) : that.querystring != null) return false;
            if (this.requestContext != null ? !this.requestContext.equals(that.requestContext) : that.requestContext != null) return false;
            if (this.useDefaultMethodResponses != null ? !this.useDefaultMethodResponses.equals(that.useDefaultMethodResponses) : that.useDefaultMethodResponses != null) return false;
            if (this.cacheKeyParameters != null ? !this.cacheKeyParameters.equals(that.cacheKeyParameters) : that.cacheKeyParameters != null) return false;
            if (this.cacheNamespace != null ? !this.cacheNamespace.equals(that.cacheNamespace) : that.cacheNamespace != null) return false;
            if (this.connectionType != null ? !this.connectionType.equals(that.connectionType) : that.connectionType != null) return false;
            if (this.contentHandling != null ? !this.contentHandling.equals(that.contentHandling) : that.contentHandling != null) return false;
            if (this.credentialsPassthrough != null ? !this.credentialsPassthrough.equals(that.credentialsPassthrough) : that.credentialsPassthrough != null) return false;
            if (this.credentialsRole != null ? !this.credentialsRole.equals(that.credentialsRole) : that.credentialsRole != null) return false;
            if (this.integrationResponses != null ? !this.integrationResponses.equals(that.integrationResponses) : that.integrationResponses != null) return false;
            if (this.passthroughBehavior != null ? !this.passthroughBehavior.equals(that.passthroughBehavior) : that.passthroughBehavior != null) return false;
            if (this.requestParameters != null ? !this.requestParameters.equals(that.requestParameters) : that.requestParameters != null) return false;
            if (this.requestTemplates != null ? !this.requestTemplates.equals(that.requestTemplates) : that.requestTemplates != null) return false;
            if (this.timeout != null ? !this.timeout.equals(that.timeout) : that.timeout != null) return false;
            return this.vpcLink != null ? this.vpcLink.equals(that.vpcLink) : that.vpcLink == null;
        }

        @Override
        public final int hashCode() {
            int result = this.authorizer != null ? this.authorizer.hashCode() : 0;
            result = 31 * result + (this.headers != null ? this.headers.hashCode() : 0);
            result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
            result = 31 * result + (this.querystring != null ? this.querystring.hashCode() : 0);
            result = 31 * result + (this.requestContext != null ? this.requestContext.hashCode() : 0);
            result = 31 * result + (this.useDefaultMethodResponses != null ? this.useDefaultMethodResponses.hashCode() : 0);
            result = 31 * result + (this.cacheKeyParameters != null ? this.cacheKeyParameters.hashCode() : 0);
            result = 31 * result + (this.cacheNamespace != null ? this.cacheNamespace.hashCode() : 0);
            result = 31 * result + (this.connectionType != null ? this.connectionType.hashCode() : 0);
            result = 31 * result + (this.contentHandling != null ? this.contentHandling.hashCode() : 0);
            result = 31 * result + (this.credentialsPassthrough != null ? this.credentialsPassthrough.hashCode() : 0);
            result = 31 * result + (this.credentialsRole != null ? this.credentialsRole.hashCode() : 0);
            result = 31 * result + (this.integrationResponses != null ? this.integrationResponses.hashCode() : 0);
            result = 31 * result + (this.passthroughBehavior != null ? this.passthroughBehavior.hashCode() : 0);
            result = 31 * result + (this.requestParameters != null ? this.requestParameters.hashCode() : 0);
            result = 31 * result + (this.requestTemplates != null ? this.requestTemplates.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            result = 31 * result + (this.vpcLink != null ? this.vpcLink.hashCode() : 0);
            return result;
        }
    }
}
