package software.amazon.awscdk.pipelines;

/**
 * A generic Step which can be added to a Pipeline.
 * <p>
 * Steps can be used to add Sources, Build Actions and Validations
 * to your pipeline.
 * <p>
 * This class is abstract. See specific subclasses of Step for
 * useful steps to add to your Pipeline
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * public class MyJenkinsStep extends Step implements ICodePipelineActionFactory {
 *     public MyJenkinsStep(JenkinsProvider provider, FileSet input) {
 *         super("MyJenkinsStep");
 *         // This is necessary if your step accepts parameters, like environment variables,
 *         // that may contain outputs from other steps. It doesn't matter what the
 *         // structure is, as long as it contains the values that may contain outputs.
 *         this.discoverReferencedOutputs(Map.of(
 *                 "env", Map.of()));
 *     }
 *     public CodePipelineActionFactoryResult produceAction(IStage stage, ProduceActionOptions options) {
 *         // This is where you control what type of Action gets added to the
 *         // CodePipeline
 *         stage.addAction(
 *         JenkinsAction.Builder.create()
 *                 // Copy 'actionName' and 'runOrder' from the options
 *                 .actionName(options.getActionName())
 *                 .runOrder(options.getRunOrder())
 *                 // Jenkins-specific configuration
 *                 .type(JenkinsActionType.TEST)
 *                 .jenkinsProvider(this.provider)
 *                 .projectName("MyJenkinsProject")
 *                 // Translate the FileSet into a codepipeline.Artifact
 *                 .inputs(List.of(options.artifacts.toCodePipeline(this.input)))
 *                 .build());
 *         return CodePipelineActionFactoryResult.builder().runOrdersConsumed(1).build();
 *     }
 * }
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:22.658Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.pipelines.Step")
public abstract class Step extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.pipelines.IFileSetProducer {

    protected Step(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Step(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param id Identifier for this step. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected Step(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Define a sequence of steps to be executed in order.
     * <p>
     * If you need more fine-grained step ordering, use the <code>addStepDependency()</code>
     * API. For example, if you want <code>secondStep</code> to occur after <code>firstStep</code>, call
     * <code>secondStep.addStepDependency(firstStep)</code>.
     * <p>
     * @param steps This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.pipelines.Step> sequence(final @org.jetbrains.annotations.NotNull java.util.List<? extends software.amazon.awscdk.pipelines.Step> steps) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.pipelines.Step.class, "sequence", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.Step.class)), new Object[] { java.util.Objects.requireNonNull(steps, "steps is required") }));
    }

    /**
     * Add an additional FileSet to the set of file sets required by this step.
     * <p>
     * This will lead to a dependency on the producer of that file set.
     * <p>
     * @param fs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void addDependencyFileSet(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.FileSet fs) {
        software.amazon.jsii.Kernel.call(this, "addDependencyFileSet", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(fs, "fs is required") });
    }

    /**
     * Add a dependency on another step.
     * <p>
     * @param step This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addStepDependency(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.Step step) {
        software.amazon.jsii.Kernel.call(this, "addStepDependency", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(step, "step is required") });
    }

    /**
     * Configure the given FileSet as the primary output of this step.
     * <p>
     * @param fs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void configurePrimaryOutput(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.FileSet fs) {
        software.amazon.jsii.Kernel.call(this, "configurePrimaryOutput", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(fs, "fs is required") });
    }

    /**
     * Crawl the given structure for references to StepOutputs and add dependencies on all steps found.
     * <p>
     * Should be called in the constructor of subclasses based on what the user
     * passes in as construction properties. The format of the structure passed in
     * here does not have to correspond exactly to what gets rendered into the
     * engine, it just needs to contain the same data.
     * <p>
     * @param structure This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void discoverReferencedOutputs(final @org.jetbrains.annotations.NotNull java.lang.Object structure) {
        software.amazon.jsii.Kernel.call(this, "discoverReferencedOutputs", software.amazon.jsii.NativeType.VOID, new Object[] { structure });
    }

    /**
     * Return a string representation of this Step.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String toString() {
        return software.amazon.jsii.Kernel.call(this, "toString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * StackOutputReferences this step consumes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.pipelines.StackOutputReference> getConsumedStackOutputs() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "consumedStackOutputs", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.StackOutputReference.class))));
    }

    /**
     * Return the steps this step depends on, based on the FileSets it requires.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.pipelines.Step> getDependencies() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "dependencies", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.Step.class))));
    }

    /**
     * The list of FileSets consumed by this Step.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.pipelines.FileSet> getDependencyFileSets() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "dependencyFileSets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.FileSet.class))));
    }

    /**
     * Identifier for this step.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getId() {
        return software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Whether or not this is a Source step.
     * <p>
     * What it means to be a Source step depends on the engine.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getIsSource() {
        return software.amazon.jsii.Kernel.get(this, "isSource", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * The primary FileSet produced by this Step.
     * <p>
     * Not all steps produce an output FileSet--if they do
     * you can substitute the <code>Step</code> object for the <code>FileSet</code> object.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.pipelines.FileSet getPrimaryOutput() {
        return software.amazon.jsii.Kernel.get(this, "primaryOutput", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.FileSet.class));
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.pipelines.Step implements software.amazon.awscdk.pipelines.IFileSetProducer.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }
    }
}
