package software.amazon.awscdk;

/**
 * Options for assembly synthesis.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * StageSynthesisOptions stageSynthesisOptions = StageSynthesisOptions.builder()
 *         .aspectStabilization(false)
 *         .errorOnDuplicateSynth(false)
 *         .force(false)
 *         .skipValidation(false)
 *         .validateOnSynthesis(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:06.017Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.StageSynthesisOptions")
@software.amazon.jsii.Jsii.Proxy(StageSynthesisOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface StageSynthesisOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Whether or not run the stabilization loop while invoking Aspects.
     * <p>
     * The stabilization loop runs multiple passes of the construct tree when invoking
     * Aspects. Without the stabilization loop, Aspects that are created by other Aspects
     * are not run and new nodes that are created at higher points on the construct tree by
     * an Aspect will not inherit their parent aspects.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAspectStabilization() {
        return null;
    }

    /**
     * Whether or not to throw a warning instead of an error if the construct tree has been mutated since the last synth.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getErrorOnDuplicateSynth() {
        return null;
    }

    /**
     * Force a re-synth, even if the stage has already been synthesized.
     * <p>
     * This is used by tests to allow for incremental verification of the output.
     * Do not use in production.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getForce() {
        return null;
    }

    /**
     * Should we skip construct validation.
     * <p>
     * Default: - false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getSkipValidation() {
        return null;
    }

    /**
     * Whether the stack should be validated after synthesis to check for error metadata.
     * <p>
     * Default: - false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getValidateOnSynthesis() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link StageSynthesisOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link StageSynthesisOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<StageSynthesisOptions> {
        java.lang.Boolean aspectStabilization;
        java.lang.Boolean errorOnDuplicateSynth;
        java.lang.Boolean force;
        java.lang.Boolean skipValidation;
        java.lang.Boolean validateOnSynthesis;

        /**
         * Sets the value of {@link StageSynthesisOptions#getAspectStabilization}
         * @param aspectStabilization Whether or not run the stabilization loop while invoking Aspects.
         *                            The stabilization loop runs multiple passes of the construct tree when invoking
         *                            Aspects. Without the stabilization loop, Aspects that are created by other Aspects
         *                            are not run and new nodes that are created at higher points on the construct tree by
         *                            an Aspect will not inherit their parent aspects.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder aspectStabilization(java.lang.Boolean aspectStabilization) {
            this.aspectStabilization = aspectStabilization;
            return this;
        }

        /**
         * Sets the value of {@link StageSynthesisOptions#getErrorOnDuplicateSynth}
         * @param errorOnDuplicateSynth Whether or not to throw a warning instead of an error if the construct tree has been mutated since the last synth.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder errorOnDuplicateSynth(java.lang.Boolean errorOnDuplicateSynth) {
            this.errorOnDuplicateSynth = errorOnDuplicateSynth;
            return this;
        }

        /**
         * Sets the value of {@link StageSynthesisOptions#getForce}
         * @param force Force a re-synth, even if the stage has already been synthesized.
         *              This is used by tests to allow for incremental verification of the output.
         *              Do not use in production.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder force(java.lang.Boolean force) {
            this.force = force;
            return this;
        }

        /**
         * Sets the value of {@link StageSynthesisOptions#getSkipValidation}
         * @param skipValidation Should we skip construct validation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder skipValidation(java.lang.Boolean skipValidation) {
            this.skipValidation = skipValidation;
            return this;
        }

        /**
         * Sets the value of {@link StageSynthesisOptions#getValidateOnSynthesis}
         * @param validateOnSynthesis Whether the stack should be validated after synthesis to check for error metadata.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validateOnSynthesis(java.lang.Boolean validateOnSynthesis) {
            this.validateOnSynthesis = validateOnSynthesis;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link StageSynthesisOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public StageSynthesisOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link StageSynthesisOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StageSynthesisOptions {
        private final java.lang.Boolean aspectStabilization;
        private final java.lang.Boolean errorOnDuplicateSynth;
        private final java.lang.Boolean force;
        private final java.lang.Boolean skipValidation;
        private final java.lang.Boolean validateOnSynthesis;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.aspectStabilization = software.amazon.jsii.Kernel.get(this, "aspectStabilization", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.errorOnDuplicateSynth = software.amazon.jsii.Kernel.get(this, "errorOnDuplicateSynth", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.force = software.amazon.jsii.Kernel.get(this, "force", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.skipValidation = software.amazon.jsii.Kernel.get(this, "skipValidation", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.validateOnSynthesis = software.amazon.jsii.Kernel.get(this, "validateOnSynthesis", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.aspectStabilization = builder.aspectStabilization;
            this.errorOnDuplicateSynth = builder.errorOnDuplicateSynth;
            this.force = builder.force;
            this.skipValidation = builder.skipValidation;
            this.validateOnSynthesis = builder.validateOnSynthesis;
        }

        @Override
        public final java.lang.Boolean getAspectStabilization() {
            return this.aspectStabilization;
        }

        @Override
        public final java.lang.Boolean getErrorOnDuplicateSynth() {
            return this.errorOnDuplicateSynth;
        }

        @Override
        public final java.lang.Boolean getForce() {
            return this.force;
        }

        @Override
        public final java.lang.Boolean getSkipValidation() {
            return this.skipValidation;
        }

        @Override
        public final java.lang.Boolean getValidateOnSynthesis() {
            return this.validateOnSynthesis;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAspectStabilization() != null) {
                data.set("aspectStabilization", om.valueToTree(this.getAspectStabilization()));
            }
            if (this.getErrorOnDuplicateSynth() != null) {
                data.set("errorOnDuplicateSynth", om.valueToTree(this.getErrorOnDuplicateSynth()));
            }
            if (this.getForce() != null) {
                data.set("force", om.valueToTree(this.getForce()));
            }
            if (this.getSkipValidation() != null) {
                data.set("skipValidation", om.valueToTree(this.getSkipValidation()));
            }
            if (this.getValidateOnSynthesis() != null) {
                data.set("validateOnSynthesis", om.valueToTree(this.getValidateOnSynthesis()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.StageSynthesisOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            StageSynthesisOptions.Jsii$Proxy that = (StageSynthesisOptions.Jsii$Proxy) o;

            if (this.aspectStabilization != null ? !this.aspectStabilization.equals(that.aspectStabilization) : that.aspectStabilization != null) return false;
            if (this.errorOnDuplicateSynth != null ? !this.errorOnDuplicateSynth.equals(that.errorOnDuplicateSynth) : that.errorOnDuplicateSynth != null) return false;
            if (this.force != null ? !this.force.equals(that.force) : that.force != null) return false;
            if (this.skipValidation != null ? !this.skipValidation.equals(that.skipValidation) : that.skipValidation != null) return false;
            return this.validateOnSynthesis != null ? this.validateOnSynthesis.equals(that.validateOnSynthesis) : that.validateOnSynthesis == null;
        }

        @Override
        public final int hashCode() {
            int result = this.aspectStabilization != null ? this.aspectStabilization.hashCode() : 0;
            result = 31 * result + (this.errorOnDuplicateSynth != null ? this.errorOnDuplicateSynth.hashCode() : 0);
            result = 31 * result + (this.force != null ? this.force.hashCode() : 0);
            result = 31 * result + (this.skipValidation != null ? this.skipValidation.hashCode() : 0);
            result = 31 * result + (this.validateOnSynthesis != null ? this.validateOnSynthesis.hashCode() : 0);
            return result;
        }
    }
}
