package software.amazon.awscdk;

/**
 * Manages removal policies for all resources within a construct scope, overriding any existing policies by default.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * RemovalPolicies removalPolicies = RemovalPolicies.of(this);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:05.995Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.RemovalPolicies")
public class RemovalPolicies extends software.amazon.jsii.JsiiObject {

    protected RemovalPolicies(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected RemovalPolicies(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Returns the removal policies API for the given scope.
     * <p>
     * @param scope The scope. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.RemovalPolicies of(final @org.jetbrains.annotations.NotNull software.constructs.IConstruct scope) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.RemovalPolicies.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.RemovalPolicies.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required") });
    }

    /**
     * Apply a removal policy to all resources within this scope, overriding any existing policies.
     * <p>
     * @param policy The removal policy to apply. This parameter is required.
     * @param props Configuration options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void apply(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.RemovalPolicy policy, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.RemovalPolicyProps props) {
        software.amazon.jsii.Kernel.call(this, "apply", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(policy, "policy is required"), props });
    }

    /**
     * Apply a removal policy to all resources within this scope, overriding any existing policies.
     * <p>
     * @param policy The removal policy to apply. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void apply(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.RemovalPolicy policy) {
        software.amazon.jsii.Kernel.call(this, "apply", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(policy, "policy is required") });
    }

    /**
     * Apply DESTROY removal policy to all resources within this scope.
     * <p>
     * @param props Configuration options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void destroy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.RemovalPolicyProps props) {
        software.amazon.jsii.Kernel.call(this, "destroy", software.amazon.jsii.NativeType.VOID, new Object[] { props });
    }

    /**
     * Apply DESTROY removal policy to all resources within this scope.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void destroy() {
        software.amazon.jsii.Kernel.call(this, "destroy", software.amazon.jsii.NativeType.VOID);
    }

    /**
     * Apply RETAIN removal policy to all resources within this scope.
     * <p>
     * @param props Configuration options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void retain(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.RemovalPolicyProps props) {
        software.amazon.jsii.Kernel.call(this, "retain", software.amazon.jsii.NativeType.VOID, new Object[] { props });
    }

    /**
     * Apply RETAIN removal policy to all resources within this scope.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void retain() {
        software.amazon.jsii.Kernel.call(this, "retain", software.amazon.jsii.NativeType.VOID);
    }

    /**
     * Apply RETAIN_ON_UPDATE_OR_DELETE removal policy to all resources within this scope.
     * <p>
     * @param props Configuration options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void retainOnUpdateOrDelete(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.RemovalPolicyProps props) {
        software.amazon.jsii.Kernel.call(this, "retainOnUpdateOrDelete", software.amazon.jsii.NativeType.VOID, new Object[] { props });
    }

    /**
     * Apply RETAIN_ON_UPDATE_OR_DELETE removal policy to all resources within this scope.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void retainOnUpdateOrDelete() {
        software.amazon.jsii.Kernel.call(this, "retainOnUpdateOrDelete", software.amazon.jsii.NativeType.VOID);
    }

    /**
     * Apply SNAPSHOT removal policy to all resources within this scope.
     * <p>
     * @param props Configuration options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void snapshot(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.RemovalPolicyProps props) {
        software.amazon.jsii.Kernel.call(this, "snapshot", software.amazon.jsii.NativeType.VOID, new Object[] { props });
    }

    /**
     * Apply SNAPSHOT removal policy to all resources within this scope.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void snapshot() {
        software.amazon.jsii.Kernel.call(this, "snapshot", software.amazon.jsii.NativeType.VOID);
    }
}
