package software.amazon.awscdk;

/**
 * Functions for devising unique names for constructs.
 * <p>
 * For example, those can be
 * used to allocate unique physical names for resources.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:05.975Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.Names")
public class Names extends software.amazon.jsii.JsiiObject {

    protected Names(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Names(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Returns a CloudFormation-compatible unique identifier for a construct based on its path.
     * <p>
     * The identifier includes a human readable portion rendered
     * from the path components and a hash suffix.
     * <p>
     * TODO (v2): replace with API to use <code>constructs.Node</code>.
     * <p>
     * @return a unique id based on the construct path
     * @param node The construct node. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String nodeUniqueId(final @org.jetbrains.annotations.NotNull software.constructs.Node node) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.Names.class, "nodeUniqueId", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(node, "node is required") });
    }

    /**
     * Return the construct path of the given construct, starting at the nearest enclosing Stack.
     * <p>
     * Skips over Nested Stacks, in other words Nested Stacks are included in the construct
     * paths.
     * <p>
     * @param construct This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String stackRelativeConstructPath(final @org.jetbrains.annotations.NotNull software.constructs.IConstruct construct) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.Names.class, "stackRelativeConstructPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(construct, "construct is required") });
    }

    /**
     * Returns a CloudFormation-compatible unique identifier for a construct based on its path.
     * <p>
     * The identifier includes a human readable portion rendered
     * from the path components and a hash suffix. uniqueId is not unique if multiple
     * copies of the stack are deployed. Prefer using uniqueResourceName().
     * <p>
     * @return a unique id based on the construct path
     * @param construct The construct. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String uniqueId(final @org.jetbrains.annotations.NotNull software.constructs.IConstruct construct) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.Names.class, "uniqueId", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(construct, "construct is required") });
    }

    /**
     * Returns a CloudFormation-compatible unique identifier for a construct based on its path.
     * <p>
     * This function finds the stackName of the parent stack (non-nested)
     * to the construct, and the ids of the components in the construct path.
     * <p>
     * The user can define allowed special characters, a separator between the elements,
     * and the maximum length of the resource name. The name includes a human readable portion rendered
     * from the path components, with or without user defined separators, and a hash suffix.
     * If the resource name is longer than the maximum length, it is trimmed in the middle.
     * <p>
     * @return a unique resource name based on the construct path
     * @param construct The construct. This parameter is required.
     * @param options Options for defining the unique resource name. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String uniqueResourceName(final @org.jetbrains.annotations.NotNull software.constructs.IConstruct construct, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.UniqueResourceNameOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.Names.class, "uniqueResourceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(construct, "construct is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }
}
