package software.amazon.awscdk;

/**
 * The lambda runtime to use for the resource provider.
 * <p>
 * This also indicates
 * which language is used for the handler.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * CustomResourceProvider provider = CustomResourceProvider.getOrCreateProvider(this, "Custom::MyCustomResourceType", CustomResourceProviderProps.builder()
 *         .codeDirectory(String.format("%s/my-handler", __dirname))
 *         .runtime(CustomResourceProviderRuntime.NODEJS_18_X)
 *         .build());
 * provider.addToRolePolicy(Map.of(
 *         "Effect", "Allow",
 *         "Action", "s3:GetObject",
 *         "Resource", "*"));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:05.921Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.CustomResourceProviderRuntime")
public enum CustomResourceProviderRuntime {
    /**
     * (deprecated) Node.js 12.x.
     * <p>
     * @deprecated Use latest version
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    NODEJS_12_X,
    /**
     * (deprecated) Node.js 14.x.
     * <p>
     * @deprecated Use latest version
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    NODEJS_14_X,
    /**
     * Node.js 16.x.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NODEJS_16_X,
    /**
     * Node.js 18.x.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NODEJS_18_X,
    /**
     * Node.js 20.x.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NODEJS_20_X,
}
