/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.ec2.CfnLaunchTemplate;
import software.amazon.awscdk.services.ec2.CfnLaunchTemplateProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_ec2.CfnLaunchTemplate")
public class CfnLaunchTemplate
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnLaunchTemplate.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnLaunchTemplate(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnLaunchTemplate(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnLaunchTemplate(@NotNull Construct scope, @NotNull String id, @Nullable CfnLaunchTemplateProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public CfnLaunchTemplate(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrDefaultVersionNumber() {
        return (String)Kernel.get((Object)this, (String)"attrDefaultVersionNumber", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrLatestVersionNumber() {
        return (String)Kernel.get((Object)this, (String)"attrLatestVersionNumber", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @Nullable
    public Object getLaunchTemplateData() {
        return Kernel.get((Object)this, (String)"launchTemplateData", (NativeType)NativeType.forClass(Object.class));
    }

    public void setLaunchTemplateData(@Nullable LaunchTemplateDataProperty value) {
        Kernel.set((Object)this, (String)"launchTemplateData", (Object)value);
    }

    public void setLaunchTemplateData(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"launchTemplateData", (Object)value);
    }

    @Nullable
    public String getLaunchTemplateName() {
        return (String)Kernel.get((Object)this, (String)"launchTemplateName", (NativeType)NativeType.forClass(String.class));
    }

    public void setLaunchTemplateName(@Nullable String value) {
        Kernel.set((Object)this, (String)"launchTemplateName", (Object)value);
    }

    @Nullable
    public Object getTagSpecifications() {
        return Kernel.get((Object)this, (String)"tagSpecifications", (NativeType)NativeType.forClass(Object.class));
    }

    public void setTagSpecifications(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"tagSpecifications", (Object)value);
    }

    public void setTagSpecifications(@Nullable List<Object> value) {
        Kernel.set((Object)this, (String)"tagSpecifications", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnLaunchTemplate> {
        private final Construct scope;
        private final String id;
        private CfnLaunchTemplateProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder launchTemplateData(LaunchTemplateDataProperty launchTemplateData) {
            this.props().launchTemplateData(launchTemplateData);
            return this;
        }

        public Builder launchTemplateData(IResolvable launchTemplateData) {
            this.props().launchTemplateData(launchTemplateData);
            return this;
        }

        public Builder launchTemplateName(String launchTemplateName) {
            this.props().launchTemplateName(launchTemplateName);
            return this;
        }

        public Builder tagSpecifications(IResolvable tagSpecifications) {
            this.props().tagSpecifications(tagSpecifications);
            return this;
        }

        public Builder tagSpecifications(List<? extends Object> tagSpecifications) {
            this.props().tagSpecifications(tagSpecifications);
            return this;
        }

        public CfnLaunchTemplate build() {
            return new CfnLaunchTemplate(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private CfnLaunchTemplateProps.Builder props() {
            if (this.props == null) {
                this.props = new CfnLaunchTemplateProps.Builder();
            }
            return this.props;
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_ec2.CfnLaunchTemplate.VCpuCountProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface VCpuCountProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getMax() {
            return null;
        }

        @Nullable
        default public Number getMin() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<VCpuCountProperty> {
            Number max;
            Number min;

            public Builder max(Number max) {
                this.max = max;
                return this;
            }

            public Builder min(Number min) {
                this.min = min;
                return this;
            }

            public VCpuCountProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_ec2.CfnLaunchTemplate.TotalLocalStorageGBProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TotalLocalStorageGBProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getMax() {
            return null;
        }

        @Nullable
        default public Number getMin() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TotalLocalStorageGBProperty> {
            Number max;
            Number min;

            public Builder max(Number max) {
                this.max = max;
                return this;
            }

            public Builder min(Number min) {
                this.min = min;
                return this;
            }

            public TotalLocalStorageGBProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_ec2.CfnLaunchTemplate.TagSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TagSpecificationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getResourceType() {
            return null;
        }

        @Nullable
        default public List<CfnTag> getTags() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TagSpecificationProperty> {
            String resourceType;
            List<CfnTag> tags;

            public Builder resourceType(String resourceType) {
                this.resourceType = resourceType;
                return this;
            }

            public Builder tags(List<? extends CfnTag> tags) {
                this.tags = tags;
                return this;
            }

            public TagSpecificationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_ec2.CfnLaunchTemplate.SpotOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SpotOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getBlockDurationMinutes() {
            return null;
        }

        @Nullable
        default public String getInstanceInterruptionBehavior() {
            return null;
        }

        @Nullable
        default public String getMaxPrice() {
            return null;
        }

        @Nullable
        default public String getSpotInstanceType() {
            return null;
        }

        @Nullable
        default public String getValidUntil() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SpotOptionsProperty> {
            Number blockDurationMinutes;
            String instanceInterruptionBehavior;
            String maxPrice;
            String spotInstanceType;
            String validUntil;

            public Builder blockDurationMinutes(Number blockDurationMinutes) {
                this.blockDurationMinutes = blockDurationMinutes;
                return this;
            }

            public Builder instanceInterruptionBehavior(String instanceInterruptionBehavior) {
                this.instanceInterruptionBehavior = instanceInterruptionBehavior;
                return this;
            }

            public Builder maxPrice(String maxPrice) {
                this.maxPrice = maxPrice;
                return this;
            }

            public Builder spotInstanceType(String spotInstanceType) {
                this.spotInstanceType = spotInstanceType;
                return this;
            }

            public Builder validUntil(String validUntil) {
                this.validUntil = validUntil;
                return this;
            }

            public SpotOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_ec2.CfnLaunchTemplate.PrivateIpAddProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PrivateIpAddProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getPrimary() {
            return null;
        }

        @Nullable
        default public String getPrivateIpAddress() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PrivateIpAddProperty> {
            Object primary;
            String privateIpAddress;

            public Builder primary(Boolean primary) {
                this.primary = primary;
                return this;
            }

            public Builder primary(IResolvable primary) {
                this.primary = primary;
                return this;
            }

            public Builder privateIpAddress(String privateIpAddress) {
                this.privateIpAddress = privateIpAddress;
                return this;
            }

            public PrivateIpAddProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_ec2.CfnLaunchTemplate.PrivateDnsNameOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PrivateDnsNameOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getEnableResourceNameDnsAaaaRecord() {
            return null;
        }

        @Nullable
        default public Object getEnableResourceNameDnsARecord() {
            return null;
        }

        @Nullable
        default public String getHostnameType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PrivateDnsNameOptionsProperty> {
            Object enableResourceNameDnsAaaaRecord;
            Object enableResourceNameDnsARecord;
            String hostnameType;

            public Builder enableResourceNameDnsAaaaRecord(Boolean enableResourceNameDnsAaaaRecord) {
                this.enableResourceNameDnsAaaaRecord = enableResourceNameDnsAaaaRecord;
                return this;
            }

            public Builder enableResourceNameDnsAaaaRecord(IResolvable enableResourceNameDnsAaaaRecord) {
                this.enableResourceNameDnsAaaaRecord = enableResourceNameDnsAaaaRecord;
                return this;
            }

            public Builder enableResourceNameDnsARecord(Boolean enableResourceNameDnsARecord) {
                this.enableResourceNameDnsARecord = enableResourceNameDnsARecord;
                return this;
            }

            public Builder enableResourceNameDnsARecord(IResolvable enableResourceNameDnsARecord) {
                this.enableResourceNameDnsARecord = enableResourceNameDnsARecord;
                return this;
            }

            public Builder hostnameType(String hostnameType) {
                this.hostnameType = hostnameType;
                return this;
            }

            public PrivateDnsNameOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_ec2.CfnLaunchTemplate.PlacementProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PlacementProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAffinity() {
            return null;
        }

        @Nullable
        default public String getAvailabilityZone() {
            return null;
        }

        @Nullable
        default public String getGroupName() {
            return null;
        }

        @Nullable
        default public String getHostId() {
            return null;
        }

        @Nullable
        default public String getHostResourceGroupArn() {
            return null;
        }

        @Nullable
        default public Number getPartitionNumber() {
            return null;
        }

        @Nullable
        default public String getSpreadDomain() {
            return null;
        }

        @Nullable
        default public String getTenancy() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PlacementProperty> {
            String affinity;
            String availabilityZone;
            String groupName;
            String hostId;
            String hostResourceGroupArn;
            Number partitionNumber;
            String spreadDomain;
            String tenancy;

            public Builder affinity(String affinity) {
                this.affinity = affinity;
                return this;
            }

            public Builder availabilityZone(String availabilityZone) {
                this.availabilityZone = availabilityZone;
                return this;
            }

            public Builder groupName(String groupName) {
                this.groupName = groupName;
                return this;
            }

            public Builder hostId(String hostId) {
                this.hostId = hostId;
                return this;
            }

            public Builder hostResourceGroupArn(String hostResourceGroupArn) {
                this.hostResourceGroupArn = hostResourceGroupArn;
                return this;
            }

            public Builder partitionNumber(Number partitionNumber) {
                this.partitionNumber = partitionNumber;
                return this;
            }

            public Builder spreadDomain(String spreadDomain) {
                this.spreadDomain = spreadDomain;
                return this;
            }

            public Builder tenancy(String tenancy) {
                this.tenancy = tenancy;
                return this;
            }

            public PlacementProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_ec2.CfnLaunchTemplate.NetworkInterfaceProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface NetworkInterfaceProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAssociateCarrierIpAddress() {
            return null;
        }

        @Nullable
        default public Object getAssociatePublicIpAddress() {
            return null;
        }

        @Nullable
        default public Object getDeleteOnTermination() {
            return null;
        }

        @Nullable
        default public String getDescription() {
            return null;
        }

        @Nullable
        default public Number getDeviceIndex() {
            return null;
        }

        @Nullable
        default public List<String> getGroups() {
            return null;
        }

        @Nullable
        default public String getInterfaceType() {
            return null;
        }

        @Nullable
        default public Number getIpv6AddressCount() {
            return null;
        }

        @Nullable
        default public Object getIpv6Addresses() {
            return null;
        }

        @Nullable
        default public Number getNetworkCardIndex() {
            return null;
        }

        @Nullable
        default public String getNetworkInterfaceId() {
            return null;
        }

        @Nullable
        default public String getPrivateIpAddress() {
            return null;
        }

        @Nullable
        default public Object getPrivateIpAddresses() {
            return null;
        }

        @Nullable
        default public Number getSecondaryPrivateIpAddressCount() {
            return null;
        }

        @Nullable
        default public String getSubnetId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<NetworkInterfaceProperty> {
            Object associateCarrierIpAddress;
            Object associatePublicIpAddress;
            Object deleteOnTermination;
            String description;
            Number deviceIndex;
            List<String> groups;
            String interfaceType;
            Number ipv6AddressCount;
            Object ipv6Addresses;
            Number networkCardIndex;
            String networkInterfaceId;
            String privateIpAddress;
            Object privateIpAddresses;
            Number secondaryPrivateIpAddressCount;
            String subnetId;

            public Builder associateCarrierIpAddress(Boolean associateCarrierIpAddress) {
                this.associateCarrierIpAddress = associateCarrierIpAddress;
                return this;
            }

            public Builder associateCarrierIpAddress(IResolvable associateCarrierIpAddress) {
                this.associateCarrierIpAddress = associateCarrierIpAddress;
                return this;
            }

            public Builder associatePublicIpAddress(Boolean associatePublicIpAddress) {
                this.associatePublicIpAddress = associatePublicIpAddress;
                return this;
            }

            public Builder associatePublicIpAddress(IResolvable associatePublicIpAddress) {
                this.associatePublicIpAddress = associatePublicIpAddress;
                return this;
            }

            public Builder deleteOnTermination(Boolean deleteOnTermination) {
                this.deleteOnTermination = deleteOnTermination;
                return this;
            }

            public Builder deleteOnTermination(IResolvable deleteOnTermination) {
                this.deleteOnTermination = deleteOnTermination;
                return this;
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public Builder deviceIndex(Number deviceIndex) {
                this.deviceIndex = deviceIndex;
                return this;
            }

            public Builder groups(List<String> groups) {
                this.groups = groups;
                return this;
            }

            public Builder interfaceType(String interfaceType) {
                this.interfaceType = interfaceType;
                return this;
            }

            public Builder ipv6AddressCount(Number ipv6AddressCount) {
                this.ipv6AddressCount = ipv6AddressCount;
                return this;
            }

            public Builder ipv6Addresses(IResolvable ipv6Addresses) {
                this.ipv6Addresses = ipv6Addresses;
                return this;
            }

            public Builder ipv6Addresses(List<? extends Object> ipv6Addresses) {
                this.ipv6Addresses = ipv6Addresses;
                return this;
            }

            public Builder networkCardIndex(Number networkCardIndex) {
                this.networkCardIndex = networkCardIndex;
                return this;
            }

            public Builder networkInterfaceId(String networkInterfaceId) {
                this.networkInterfaceId = networkInterfaceId;
                return this;
            }

            public Builder privateIpAddress(String privateIpAddress) {
                this.privateIpAddress = privateIpAddress;
                return this;
            }

            public Builder privateIpAddresses(IResolvable privateIpAddresses) {
                this.privateIpAddresses = privateIpAddresses;
                return this;
            }

            public Builder privateIpAddresses(List<? extends Object> privateIpAddresses) {
                this.privateIpAddresses = privateIpAddresses;
                return this;
            }

            public Builder secondaryPrivateIpAddressCount(Number secondaryPrivateIpAddressCount) {
                this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
                return this;
            }

            public Builder subnetId(String subnetId) {
                this.subnetId = subnetId;
                return this;
            }

            public NetworkInterfaceProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_ec2.CfnLaunchTemplate.NetworkInterfaceCountProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface NetworkInterfaceCountProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getMax() {
            return null;
        }

        @Nullable
        default public Number getMin() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<NetworkInterfaceCountProperty> {
            Number max;
            Number min;

            public Builder max(Number max) {
                this.max = max;
                return this;
            }

            public Builder min(Number min) {
                this.min = min;
                return this;
            }

            public NetworkInterfaceCountProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_ec2.CfnLaunchTemplate.MonitoringProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MonitoringProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getEnabled() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MonitoringProperty> {
            Object enabled;

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public MonitoringProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_ec2.CfnLaunchTemplate.MetadataOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MetadataOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getHttpEndpoint() {
            return null;
        }

        @Nullable
        default public String getHttpProtocolIpv6() {
            return null;
        }

        @Nullable
        default public Number getHttpPutResponseHopLimit() {
            return null;
        }

        @Nullable
        default public String getHttpTokens() {
            return null;
        }

        @Nullable
        default public String getInstanceMetadataTags() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MetadataOptionsProperty> {
            String httpEndpoint;
            String httpProtocolIpv6;
            Number httpPutResponseHopLimit;
            String httpTokens;
            String instanceMetadataTags;

            public Builder httpEndpoint(String httpEndpoint) {
                this.httpEndpoint = httpEndpoint;
                return this;
            }

            public Builder httpProtocolIpv6(String httpProtocolIpv6) {
                this.httpProtocolIpv6 = httpProtocolIpv6;
                return this;
            }

            public Builder httpPutResponseHopLimit(Number httpPutResponseHopLimit) {
                this.httpPutResponseHopLimit = httpPutResponseHopLimit;
                return this;
            }

            public Builder httpTokens(String httpTokens) {
                this.httpTokens = httpTokens;
                return this;
            }

            public Builder instanceMetadataTags(String instanceMetadataTags) {
                this.instanceMetadataTags = instanceMetadataTags;
                return this;
            }

            public MetadataOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_ec2.CfnLaunchTemplate.MemoryMiBProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MemoryMiBProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getMax() {
            return null;
        }

        @Nullable
        default public Number getMin() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MemoryMiBProperty> {
            Number max;
            Number min;

            public Builder max(Number max) {
                this.max = max;
                return this;
            }

            public Builder min(Number min) {
                this.min = min;
                return this;
            }

            public MemoryMiBProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_ec2.CfnLaunchTemplate.MemoryGiBPerVCpuProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MemoryGiBPerVCpuProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getMax() {
            return null;
        }

        @Nullable
        default public Number getMin() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MemoryGiBPerVCpuProperty> {
            Number max;
            Number min;

            public Builder max(Number max) {
                this.max = max;
                return this;
            }

            public Builder min(Number min) {
                this.min = min;
                return this;
            }

            public MemoryGiBPerVCpuProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_ec2.CfnLaunchTemplate.LicenseSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LicenseSpecificationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getLicenseConfigurationArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LicenseSpecificationProperty> {
            String licenseConfigurationArn;

            public Builder licenseConfigurationArn(String licenseConfigurationArn) {
                this.licenseConfigurationArn = licenseConfigurationArn;
                return this;
            }

            public LicenseSpecificationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_ec2.CfnLaunchTemplate.LaunchTemplateTagSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LaunchTemplateTagSpecificationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getResourceType() {
            return null;
        }

        @Nullable
        default public List<CfnTag> getTags() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LaunchTemplateTagSpecificationProperty> {
            String resourceType;
            List<CfnTag> tags;

            public Builder resourceType(String resourceType) {
                this.resourceType = resourceType;
                return this;
            }

            public Builder tags(List<? extends CfnTag> tags) {
                this.tags = tags;
                return this;
            }

            public LaunchTemplateTagSpecificationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_ec2.CfnLaunchTemplate.LaunchTemplateElasticInferenceAcceleratorProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LaunchTemplateElasticInferenceAcceleratorProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getCount() {
            return null;
        }

        @Nullable
        default public String getType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LaunchTemplateElasticInferenceAcceleratorProperty> {
            Number count;
            String type;

            public Builder count(Number count) {
                this.count = count;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public LaunchTemplateElasticInferenceAcceleratorProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_ec2.CfnLaunchTemplate.LaunchTemplateDataProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LaunchTemplateDataProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getBlockDeviceMappings() {
            return null;
        }

        @Nullable
        default public Object getCapacityReservationSpecification() {
            return null;
        }

        @Nullable
        default public Object getCpuOptions() {
            return null;
        }

        @Nullable
        default public Object getCreditSpecification() {
            return null;
        }

        @Nullable
        default public Object getDisableApiTermination() {
            return null;
        }

        @Nullable
        default public Object getEbsOptimized() {
            return null;
        }

        @Nullable
        default public Object getElasticGpuSpecifications() {
            return null;
        }

        @Nullable
        default public Object getElasticInferenceAccelerators() {
            return null;
        }

        @Nullable
        default public Object getEnclaveOptions() {
            return null;
        }

        @Nullable
        default public Object getHibernationOptions() {
            return null;
        }

        @Nullable
        default public Object getIamInstanceProfile() {
            return null;
        }

        @Nullable
        default public String getImageId() {
            return null;
        }

        @Nullable
        default public String getInstanceInitiatedShutdownBehavior() {
            return null;
        }

        @Nullable
        default public Object getInstanceMarketOptions() {
            return null;
        }

        @Nullable
        default public Object getInstanceRequirements() {
            return null;
        }

        @Nullable
        default public String getInstanceType() {
            return null;
        }

        @Nullable
        default public String getKernelId() {
            return null;
        }

        @Nullable
        default public String getKeyName() {
            return null;
        }

        @Nullable
        default public Object getLicenseSpecifications() {
            return null;
        }

        @Nullable
        default public Object getMetadataOptions() {
            return null;
        }

        @Nullable
        default public Object getMonitoring() {
            return null;
        }

        @Nullable
        default public Object getNetworkInterfaces() {
            return null;
        }

        @Nullable
        default public Object getPlacement() {
            return null;
        }

        @Nullable
        default public Object getPrivateDnsNameOptions() {
            return null;
        }

        @Nullable
        default public String getRamDiskId() {
            return null;
        }

        @Nullable
        default public List<String> getSecurityGroupIds() {
            return null;
        }

        @Nullable
        default public List<String> getSecurityGroups() {
            return null;
        }

        @Nullable
        default public Object getTagSpecifications() {
            return null;
        }

        @Nullable
        default public String getUserData() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LaunchTemplateDataProperty> {
            Object blockDeviceMappings;
            Object capacityReservationSpecification;
            Object cpuOptions;
            Object creditSpecification;
            Object disableApiTermination;
            Object ebsOptimized;
            Object elasticGpuSpecifications;
            Object elasticInferenceAccelerators;
            Object enclaveOptions;
            Object hibernationOptions;
            Object iamInstanceProfile;
            String imageId;
            String instanceInitiatedShutdownBehavior;
            Object instanceMarketOptions;
            Object instanceRequirements;
            String instanceType;
            String kernelId;
            String keyName;
            Object licenseSpecifications;
            Object metadataOptions;
            Object monitoring;
            Object networkInterfaces;
            Object placement;
            Object privateDnsNameOptions;
            String ramDiskId;
            List<String> securityGroupIds;
            List<String> securityGroups;
            Object tagSpecifications;
            String userData;

            public Builder blockDeviceMappings(IResolvable blockDeviceMappings) {
                this.blockDeviceMappings = blockDeviceMappings;
                return this;
            }

            public Builder blockDeviceMappings(List<? extends Object> blockDeviceMappings) {
                this.blockDeviceMappings = blockDeviceMappings;
                return this;
            }

            public Builder capacityReservationSpecification(CapacityReservationSpecificationProperty capacityReservationSpecification) {
                this.capacityReservationSpecification = capacityReservationSpecification;
                return this;
            }

            public Builder capacityReservationSpecification(IResolvable capacityReservationSpecification) {
                this.capacityReservationSpecification = capacityReservationSpecification;
                return this;
            }

            public Builder cpuOptions(CpuOptionsProperty cpuOptions) {
                this.cpuOptions = cpuOptions;
                return this;
            }

            public Builder cpuOptions(IResolvable cpuOptions) {
                this.cpuOptions = cpuOptions;
                return this;
            }

            public Builder creditSpecification(CreditSpecificationProperty creditSpecification) {
                this.creditSpecification = creditSpecification;
                return this;
            }

            public Builder creditSpecification(IResolvable creditSpecification) {
                this.creditSpecification = creditSpecification;
                return this;
            }

            public Builder disableApiTermination(Boolean disableApiTermination) {
                this.disableApiTermination = disableApiTermination;
                return this;
            }

            public Builder disableApiTermination(IResolvable disableApiTermination) {
                this.disableApiTermination = disableApiTermination;
                return this;
            }

            public Builder ebsOptimized(Boolean ebsOptimized) {
                this.ebsOptimized = ebsOptimized;
                return this;
            }

            public Builder ebsOptimized(IResolvable ebsOptimized) {
                this.ebsOptimized = ebsOptimized;
                return this;
            }

            public Builder elasticGpuSpecifications(IResolvable elasticGpuSpecifications) {
                this.elasticGpuSpecifications = elasticGpuSpecifications;
                return this;
            }

            public Builder elasticGpuSpecifications(List<? extends Object> elasticGpuSpecifications) {
                this.elasticGpuSpecifications = elasticGpuSpecifications;
                return this;
            }

            public Builder elasticInferenceAccelerators(IResolvable elasticInferenceAccelerators) {
                this.elasticInferenceAccelerators = elasticInferenceAccelerators;
                return this;
            }

            public Builder elasticInferenceAccelerators(List<? extends Object> elasticInferenceAccelerators) {
                this.elasticInferenceAccelerators = elasticInferenceAccelerators;
                return this;
            }

            public Builder enclaveOptions(EnclaveOptionsProperty enclaveOptions) {
                this.enclaveOptions = enclaveOptions;
                return this;
            }

            public Builder enclaveOptions(IResolvable enclaveOptions) {
                this.enclaveOptions = enclaveOptions;
                return this;
            }

            public Builder hibernationOptions(HibernationOptionsProperty hibernationOptions) {
                this.hibernationOptions = hibernationOptions;
                return this;
            }

            public Builder hibernationOptions(IResolvable hibernationOptions) {
                this.hibernationOptions = hibernationOptions;
                return this;
            }

            public Builder iamInstanceProfile(IamInstanceProfileProperty iamInstanceProfile) {
                this.iamInstanceProfile = iamInstanceProfile;
                return this;
            }

            public Builder iamInstanceProfile(IResolvable iamInstanceProfile) {
                this.iamInstanceProfile = iamInstanceProfile;
                return this;
            }

            public Builder imageId(String imageId) {
                this.imageId = imageId;
                return this;
            }

            public Builder instanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
                this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
                return this;
            }

            public Builder instanceMarketOptions(InstanceMarketOptionsProperty instanceMarketOptions) {
                this.instanceMarketOptions = instanceMarketOptions;
                return this;
            }

            public Builder instanceMarketOptions(IResolvable instanceMarketOptions) {
                this.instanceMarketOptions = instanceMarketOptions;
                return this;
            }

            public Builder instanceRequirements(InstanceRequirementsProperty instanceRequirements) {
                this.instanceRequirements = instanceRequirements;
                return this;
            }

            public Builder instanceRequirements(IResolvable instanceRequirements) {
                this.instanceRequirements = instanceRequirements;
                return this;
            }

            public Builder instanceType(String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            public Builder kernelId(String kernelId) {
                this.kernelId = kernelId;
                return this;
            }

            public Builder keyName(String keyName) {
                this.keyName = keyName;
                return this;
            }

            public Builder licenseSpecifications(IResolvable licenseSpecifications) {
                this.licenseSpecifications = licenseSpecifications;
                return this;
            }

            public Builder licenseSpecifications(List<? extends Object> licenseSpecifications) {
                this.licenseSpecifications = licenseSpecifications;
                return this;
            }

            public Builder metadataOptions(MetadataOptionsProperty metadataOptions) {
                this.metadataOptions = metadataOptions;
                return this;
            }

            public Builder metadataOptions(IResolvable metadataOptions) {
                this.metadataOptions = metadataOptions;
                return this;
            }

            public Builder monitoring(MonitoringProperty monitoring) {
                this.monitoring = monitoring;
                return this;
            }

            public Builder monitoring(IResolvable monitoring) {
                this.monitoring = monitoring;
                return this;
            }

            public Builder networkInterfaces(IResolvable networkInterfaces) {
                this.networkInterfaces = networkInterfaces;
                return this;
            }

            public Builder networkInterfaces(List<? extends Object> networkInterfaces) {
                this.networkInterfaces = networkInterfaces;
                return this;
            }

            public Builder placement(PlacementProperty placement) {
                this.placement = placement;
                return this;
            }

            public Builder placement(IResolvable placement) {
                this.placement = placement;
                return this;
            }

            public Builder privateDnsNameOptions(PrivateDnsNameOptionsProperty privateDnsNameOptions) {
                this.privateDnsNameOptions = privateDnsNameOptions;
                return this;
            }

            public Builder privateDnsNameOptions(IResolvable privateDnsNameOptions) {
                this.privateDnsNameOptions = privateDnsNameOptions;
                return this;
            }

            public Builder ramDiskId(String ramDiskId) {
                this.ramDiskId = ramDiskId;
                return this;
            }

            public Builder securityGroupIds(List<String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            public Builder securityGroups(List<String> securityGroups) {
                this.securityGroups = securityGroups;
                return this;
            }

            public Builder tagSpecifications(IResolvable tagSpecifications) {
                this.tagSpecifications = tagSpecifications;
                return this;
            }

            public Builder tagSpecifications(List<? extends Object> tagSpecifications) {
                this.tagSpecifications = tagSpecifications;
                return this;
            }

            public Builder userData(String userData) {
                this.userData = userData;
                return this;
            }

            public LaunchTemplateDataProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_ec2.CfnLaunchTemplate.Ipv6AddProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface Ipv6AddProperty
    extends JsiiSerializable {
        @Nullable
        default public String getIpv6Address() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<Ipv6AddProperty> {
            String ipv6Address;

            public Builder ipv6Address(String ipv6Address) {
                this.ipv6Address = ipv6Address;
                return this;
            }

            public Ipv6AddProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_ec2.CfnLaunchTemplate.InstanceRequirementsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InstanceRequirementsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAcceleratorCount() {
            return null;
        }

        @Nullable
        default public List<String> getAcceleratorManufacturers() {
            return null;
        }

        @Nullable
        default public List<String> getAcceleratorNames() {
            return null;
        }

        @Nullable
        default public Object getAcceleratorTotalMemoryMiB() {
            return null;
        }

        @Nullable
        default public List<String> getAcceleratorTypes() {
            return null;
        }

        @Nullable
        default public String getBareMetal() {
            return null;
        }

        @Nullable
        default public Object getBaselineEbsBandwidthMbps() {
            return null;
        }

        @Nullable
        default public String getBurstablePerformance() {
            return null;
        }

        @Nullable
        default public List<String> getCpuManufacturers() {
            return null;
        }

        @Nullable
        default public List<String> getExcludedInstanceTypes() {
            return null;
        }

        @Nullable
        default public List<String> getInstanceGenerations() {
            return null;
        }

        @Nullable
        default public String getLocalStorage() {
            return null;
        }

        @Nullable
        default public List<String> getLocalStorageTypes() {
            return null;
        }

        @Nullable
        default public Object getMemoryGiBPerVCpu() {
            return null;
        }

        @Nullable
        default public Object getMemoryMiB() {
            return null;
        }

        @Nullable
        default public Object getNetworkInterfaceCount() {
            return null;
        }

        @Nullable
        default public Number getOnDemandMaxPricePercentageOverLowestPrice() {
            return null;
        }

        @Nullable
        default public Object getRequireHibernateSupport() {
            return null;
        }

        @Nullable
        default public Number getSpotMaxPricePercentageOverLowestPrice() {
            return null;
        }

        @Nullable
        default public Object getTotalLocalStorageGb() {
            return null;
        }

        @Nullable
        default public Object getVCpuCount() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<InstanceRequirementsProperty> {
            Object acceleratorCount;
            List<String> acceleratorManufacturers;
            List<String> acceleratorNames;
            Object acceleratorTotalMemoryMiB;
            List<String> acceleratorTypes;
            String bareMetal;
            Object baselineEbsBandwidthMbps;
            String burstablePerformance;
            List<String> cpuManufacturers;
            List<String> excludedInstanceTypes;
            List<String> instanceGenerations;
            String localStorage;
            List<String> localStorageTypes;
            Object memoryGiBPerVCpu;
            Object memoryMiB;
            Object networkInterfaceCount;
            Number onDemandMaxPricePercentageOverLowestPrice;
            Object requireHibernateSupport;
            Number spotMaxPricePercentageOverLowestPrice;
            Object totalLocalStorageGb;
            Object vCpuCount;

            public Builder acceleratorCount(AcceleratorCountProperty acceleratorCount) {
                this.acceleratorCount = acceleratorCount;
                return this;
            }

            public Builder acceleratorCount(IResolvable acceleratorCount) {
                this.acceleratorCount = acceleratorCount;
                return this;
            }

            public Builder acceleratorManufacturers(List<String> acceleratorManufacturers) {
                this.acceleratorManufacturers = acceleratorManufacturers;
                return this;
            }

            public Builder acceleratorNames(List<String> acceleratorNames) {
                this.acceleratorNames = acceleratorNames;
                return this;
            }

            public Builder acceleratorTotalMemoryMiB(AcceleratorTotalMemoryMiBProperty acceleratorTotalMemoryMiB) {
                this.acceleratorTotalMemoryMiB = acceleratorTotalMemoryMiB;
                return this;
            }

            public Builder acceleratorTotalMemoryMiB(IResolvable acceleratorTotalMemoryMiB) {
                this.acceleratorTotalMemoryMiB = acceleratorTotalMemoryMiB;
                return this;
            }

            public Builder acceleratorTypes(List<String> acceleratorTypes) {
                this.acceleratorTypes = acceleratorTypes;
                return this;
            }

            public Builder bareMetal(String bareMetal) {
                this.bareMetal = bareMetal;
                return this;
            }

            public Builder baselineEbsBandwidthMbps(BaselineEbsBandwidthMbpsProperty baselineEbsBandwidthMbps) {
                this.baselineEbsBandwidthMbps = baselineEbsBandwidthMbps;
                return this;
            }

            public Builder baselineEbsBandwidthMbps(IResolvable baselineEbsBandwidthMbps) {
                this.baselineEbsBandwidthMbps = baselineEbsBandwidthMbps;
                return this;
            }

            public Builder burstablePerformance(String burstablePerformance) {
                this.burstablePerformance = burstablePerformance;
                return this;
            }

            public Builder cpuManufacturers(List<String> cpuManufacturers) {
                this.cpuManufacturers = cpuManufacturers;
                return this;
            }

            public Builder excludedInstanceTypes(List<String> excludedInstanceTypes) {
                this.excludedInstanceTypes = excludedInstanceTypes;
                return this;
            }

            public Builder instanceGenerations(List<String> instanceGenerations) {
                this.instanceGenerations = instanceGenerations;
                return this;
            }

            public Builder localStorage(String localStorage) {
                this.localStorage = localStorage;
                return this;
            }

            public Builder localStorageTypes(List<String> localStorageTypes) {
                this.localStorageTypes = localStorageTypes;
                return this;
            }

            public Builder memoryGiBPerVCpu(MemoryGiBPerVCpuProperty memoryGiBPerVCpu) {
                this.memoryGiBPerVCpu = memoryGiBPerVCpu;
                return this;
            }

            public Builder memoryGiBPerVCpu(IResolvable memoryGiBPerVCpu) {
                this.memoryGiBPerVCpu = memoryGiBPerVCpu;
                return this;
            }

            public Builder memoryMiB(MemoryMiBProperty memoryMiB) {
                this.memoryMiB = memoryMiB;
                return this;
            }

            public Builder memoryMiB(IResolvable memoryMiB) {
                this.memoryMiB = memoryMiB;
                return this;
            }

            public Builder networkInterfaceCount(NetworkInterfaceCountProperty networkInterfaceCount) {
                this.networkInterfaceCount = networkInterfaceCount;
                return this;
            }

            public Builder networkInterfaceCount(IResolvable networkInterfaceCount) {
                this.networkInterfaceCount = networkInterfaceCount;
                return this;
            }

            public Builder onDemandMaxPricePercentageOverLowestPrice(Number onDemandMaxPricePercentageOverLowestPrice) {
                this.onDemandMaxPricePercentageOverLowestPrice = onDemandMaxPricePercentageOverLowestPrice;
                return this;
            }

            public Builder requireHibernateSupport(Boolean requireHibernateSupport) {
                this.requireHibernateSupport = requireHibernateSupport;
                return this;
            }

            public Builder requireHibernateSupport(IResolvable requireHibernateSupport) {
                this.requireHibernateSupport = requireHibernateSupport;
                return this;
            }

            public Builder spotMaxPricePercentageOverLowestPrice(Number spotMaxPricePercentageOverLowestPrice) {
                this.spotMaxPricePercentageOverLowestPrice = spotMaxPricePercentageOverLowestPrice;
                return this;
            }

            public Builder totalLocalStorageGb(TotalLocalStorageGBProperty totalLocalStorageGb) {
                this.totalLocalStorageGb = totalLocalStorageGb;
                return this;
            }

            public Builder totalLocalStorageGb(IResolvable totalLocalStorageGb) {
                this.totalLocalStorageGb = totalLocalStorageGb;
                return this;
            }

            public Builder vCpuCount(VCpuCountProperty vCpuCount) {
                this.vCpuCount = vCpuCount;
                return this;
            }

            public Builder vCpuCount(IResolvable vCpuCount) {
                this.vCpuCount = vCpuCount;
                return this;
            }

            public InstanceRequirementsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_ec2.CfnLaunchTemplate.InstanceMarketOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InstanceMarketOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getMarketType() {
            return null;
        }

        @Nullable
        default public Object getSpotOptions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<InstanceMarketOptionsProperty> {
            String marketType;
            Object spotOptions;

            public Builder marketType(String marketType) {
                this.marketType = marketType;
                return this;
            }

            public Builder spotOptions(SpotOptionsProperty spotOptions) {
                this.spotOptions = spotOptions;
                return this;
            }

            public Builder spotOptions(IResolvable spotOptions) {
                this.spotOptions = spotOptions;
                return this;
            }

            public InstanceMarketOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_ec2.CfnLaunchTemplate.IamInstanceProfileProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface IamInstanceProfileProperty
    extends JsiiSerializable {
        @Nullable
        default public String getArn() {
            return null;
        }

        @Nullable
        default public String getName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<IamInstanceProfileProperty> {
            String arn;
            String name;

            public Builder arn(String arn) {
                this.arn = arn;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public IamInstanceProfileProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_ec2.CfnLaunchTemplate.HibernationOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface HibernationOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getConfigured() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<HibernationOptionsProperty> {
            Object configured;

            public Builder configured(Boolean configured) {
                this.configured = configured;
                return this;
            }

            public Builder configured(IResolvable configured) {
                this.configured = configured;
                return this;
            }

            public HibernationOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_ec2.CfnLaunchTemplate.EnclaveOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EnclaveOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getEnabled() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EnclaveOptionsProperty> {
            Object enabled;

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public EnclaveOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_ec2.CfnLaunchTemplate.ElasticGpuSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ElasticGpuSpecificationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ElasticGpuSpecificationProperty> {
            String type;

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public ElasticGpuSpecificationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_ec2.CfnLaunchTemplate.EbsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EbsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDeleteOnTermination() {
            return null;
        }

        @Nullable
        default public Object getEncrypted() {
            return null;
        }

        @Nullable
        default public Number getIops() {
            return null;
        }

        @Nullable
        default public String getKmsKeyId() {
            return null;
        }

        @Nullable
        default public String getSnapshotId() {
            return null;
        }

        @Nullable
        default public Number getThroughput() {
            return null;
        }

        @Nullable
        default public Number getVolumeSize() {
            return null;
        }

        @Nullable
        default public String getVolumeType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EbsProperty> {
            Object deleteOnTermination;
            Object encrypted;
            Number iops;
            String kmsKeyId;
            String snapshotId;
            Number throughput;
            Number volumeSize;
            String volumeType;

            public Builder deleteOnTermination(Boolean deleteOnTermination) {
                this.deleteOnTermination = deleteOnTermination;
                return this;
            }

            public Builder deleteOnTermination(IResolvable deleteOnTermination) {
                this.deleteOnTermination = deleteOnTermination;
                return this;
            }

            public Builder encrypted(Boolean encrypted) {
                this.encrypted = encrypted;
                return this;
            }

            public Builder encrypted(IResolvable encrypted) {
                this.encrypted = encrypted;
                return this;
            }

            public Builder iops(Number iops) {
                this.iops = iops;
                return this;
            }

            public Builder kmsKeyId(String kmsKeyId) {
                this.kmsKeyId = kmsKeyId;
                return this;
            }

            public Builder snapshotId(String snapshotId) {
                this.snapshotId = snapshotId;
                return this;
            }

            public Builder throughput(Number throughput) {
                this.throughput = throughput;
                return this;
            }

            public Builder volumeSize(Number volumeSize) {
                this.volumeSize = volumeSize;
                return this;
            }

            public Builder volumeType(String volumeType) {
                this.volumeType = volumeType;
                return this;
            }

            public EbsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_ec2.CfnLaunchTemplate.CreditSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CreditSpecificationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getCpuCredits() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CreditSpecificationProperty> {
            String cpuCredits;

            public Builder cpuCredits(String cpuCredits) {
                this.cpuCredits = cpuCredits;
                return this;
            }

            public CreditSpecificationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_ec2.CfnLaunchTemplate.CpuOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CpuOptionsProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getCoreCount() {
            return null;
        }

        @Nullable
        default public Number getThreadsPerCore() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CpuOptionsProperty> {
            Number coreCount;
            Number threadsPerCore;

            public Builder coreCount(Number coreCount) {
                this.coreCount = coreCount;
                return this;
            }

            public Builder threadsPerCore(Number threadsPerCore) {
                this.threadsPerCore = threadsPerCore;
                return this;
            }

            public CpuOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_ec2.CfnLaunchTemplate.CapacityReservationTargetProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CapacityReservationTargetProperty
    extends JsiiSerializable {
        @Nullable
        default public String getCapacityReservationId() {
            return null;
        }

        @Nullable
        default public String getCapacityReservationResourceGroupArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CapacityReservationTargetProperty> {
            String capacityReservationId;
            String capacityReservationResourceGroupArn;

            public Builder capacityReservationId(String capacityReservationId) {
                this.capacityReservationId = capacityReservationId;
                return this;
            }

            public Builder capacityReservationResourceGroupArn(String capacityReservationResourceGroupArn) {
                this.capacityReservationResourceGroupArn = capacityReservationResourceGroupArn;
                return this;
            }

            public CapacityReservationTargetProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_ec2.CfnLaunchTemplate.CapacityReservationSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CapacityReservationSpecificationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getCapacityReservationPreference() {
            return null;
        }

        @Nullable
        default public Object getCapacityReservationTarget() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CapacityReservationSpecificationProperty> {
            String capacityReservationPreference;
            Object capacityReservationTarget;

            public Builder capacityReservationPreference(String capacityReservationPreference) {
                this.capacityReservationPreference = capacityReservationPreference;
                return this;
            }

            public Builder capacityReservationTarget(CapacityReservationTargetProperty capacityReservationTarget) {
                this.capacityReservationTarget = capacityReservationTarget;
                return this;
            }

            public Builder capacityReservationTarget(IResolvable capacityReservationTarget) {
                this.capacityReservationTarget = capacityReservationTarget;
                return this;
            }

            public CapacityReservationSpecificationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_ec2.CfnLaunchTemplate.BlockDeviceMappingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BlockDeviceMappingProperty
    extends JsiiSerializable {
        @Nullable
        default public String getDeviceName() {
            return null;
        }

        @Nullable
        default public Object getEbs() {
            return null;
        }

        @Nullable
        default public String getNoDevice() {
            return null;
        }

        @Nullable
        default public String getVirtualName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BlockDeviceMappingProperty> {
            String deviceName;
            Object ebs;
            String noDevice;
            String virtualName;

            public Builder deviceName(String deviceName) {
                this.deviceName = deviceName;
                return this;
            }

            public Builder ebs(EbsProperty ebs) {
                this.ebs = ebs;
                return this;
            }

            public Builder ebs(IResolvable ebs) {
                this.ebs = ebs;
                return this;
            }

            public Builder noDevice(String noDevice) {
                this.noDevice = noDevice;
                return this;
            }

            public Builder virtualName(String virtualName) {
                this.virtualName = virtualName;
                return this;
            }

            public BlockDeviceMappingProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_ec2.CfnLaunchTemplate.BaselineEbsBandwidthMbpsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BaselineEbsBandwidthMbpsProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getMax() {
            return null;
        }

        @Nullable
        default public Number getMin() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BaselineEbsBandwidthMbpsProperty> {
            Number max;
            Number min;

            public Builder max(Number max) {
                this.max = max;
                return this;
            }

            public Builder min(Number min) {
                this.min = min;
                return this;
            }

            public BaselineEbsBandwidthMbpsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_ec2.CfnLaunchTemplate.AcceleratorTotalMemoryMiBProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AcceleratorTotalMemoryMiBProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getMax() {
            return null;
        }

        @Nullable
        default public Number getMin() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AcceleratorTotalMemoryMiBProperty> {
            Number max;
            Number min;

            public Builder max(Number max) {
                this.max = max;
                return this;
            }

            public Builder min(Number min) {
                this.min = min;
                return this;
            }

            public AcceleratorTotalMemoryMiBProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_ec2.CfnLaunchTemplate.AcceleratorCountProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AcceleratorCountProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getMax() {
            return null;
        }

        @Nullable
        default public Number getMin() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AcceleratorCountProperty> {
            Number max;
            Number min;

            public Builder max(Number max) {
                this.max = max;
                return this;
            }

            public Builder min(Number min) {
                this.min = min;
                return this;
            }

            public AcceleratorCountProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

