/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.cognito;

import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.services.cognito.AuthFlow;
import software.amazon.awscdk.services.cognito.ClientAttributes;
import software.amazon.awscdk.services.cognito.IUserPool;
import software.amazon.awscdk.services.cognito.IUserPoolClient;
import software.amazon.awscdk.services.cognito.OAuthFlows;
import software.amazon.awscdk.services.cognito.OAuthSettings;
import software.amazon.awscdk.services.cognito.UserPoolClientIdentityProvider;
import software.amazon.awscdk.services.cognito.UserPoolClientProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_cognito.UserPoolClient")
public class UserPoolClient
extends Resource
implements IUserPoolClient {
    protected UserPoolClient(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected UserPoolClient(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public UserPoolClient(@NotNull Construct scope, @NotNull String id, @NotNull UserPoolClientProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IUserPoolClient fromUserPoolClientId(@NotNull Construct scope, @NotNull String id, @NotNull String userPoolClientId) {
        return (IUserPoolClient)JsiiObject.jsiiStaticCall(UserPoolClient.class, (String)"fromUserPoolClientId", (NativeType)NativeType.forClass(IUserPoolClient.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(userPoolClientId, "userPoolClientId is required")});
    }

    @NotNull
    public OAuthFlows getOAuthFlows() {
        return (OAuthFlows)Kernel.get((Object)this, (String)"oAuthFlows", (NativeType)NativeType.forClass(OAuthFlows.class));
    }

    @Override
    @NotNull
    public String getUserPoolClientId() {
        return (String)Kernel.get((Object)this, (String)"userPoolClientId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getUserPoolClientName() {
        return (String)Kernel.get((Object)this, (String)"userPoolClientName", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<UserPoolClient> {
        private final Construct scope;
        private final String id;
        private final UserPoolClientProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new UserPoolClientProps.Builder();
        }

        public Builder accessTokenValidity(Duration accessTokenValidity) {
            this.props.accessTokenValidity(accessTokenValidity);
            return this;
        }

        public Builder authFlows(AuthFlow authFlows) {
            this.props.authFlows(authFlows);
            return this;
        }

        public Builder disableOAuth(Boolean disableOAuth) {
            this.props.disableOAuth(disableOAuth);
            return this;
        }

        public Builder enableTokenRevocation(Boolean enableTokenRevocation) {
            this.props.enableTokenRevocation(enableTokenRevocation);
            return this;
        }

        public Builder generateSecret(Boolean generateSecret) {
            this.props.generateSecret(generateSecret);
            return this;
        }

        public Builder idTokenValidity(Duration idTokenValidity) {
            this.props.idTokenValidity(idTokenValidity);
            return this;
        }

        public Builder oAuth(OAuthSettings oAuth) {
            this.props.oAuth(oAuth);
            return this;
        }

        public Builder preventUserExistenceErrors(Boolean preventUserExistenceErrors) {
            this.props.preventUserExistenceErrors(preventUserExistenceErrors);
            return this;
        }

        public Builder readAttributes(ClientAttributes readAttributes) {
            this.props.readAttributes(readAttributes);
            return this;
        }

        public Builder refreshTokenValidity(Duration refreshTokenValidity) {
            this.props.refreshTokenValidity(refreshTokenValidity);
            return this;
        }

        public Builder supportedIdentityProviders(List<? extends UserPoolClientIdentityProvider> supportedIdentityProviders) {
            this.props.supportedIdentityProviders(supportedIdentityProviders);
            return this;
        }

        public Builder userPoolClientName(String userPoolClientName) {
            this.props.userPoolClientName(userPoolClientName);
            return this;
        }

        public Builder writeAttributes(ClientAttributes writeAttributes) {
            this.props.writeAttributes(writeAttributes);
            return this;
        }

        public Builder userPool(IUserPool userPool) {
            this.props.userPool(userPool);
            return this;
        }

        public UserPoolClient build() {
            return new UserPoolClient(this.scope, this.id, this.props.build());
        }
    }
}

