package software.amazon.awscdk.services.wafv2;

/**
 * A CloudFormation `AWS::WAFv2::LoggingConfiguration`.
 * <p>
 * Defines an association between logging destinations and a web ACL resource, for logging from AWS WAF . As part of the association, you can specify parts of the standard logging fields to keep out of the logs and you can specify filters so that you log only a subset of the logging records.
 * <p>
 * For information about configuring web ACL logging destinations, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/logging.html">Logging web ACL traffic information</a> in the <em>AWS WAF Developer Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.wafv2.*;
 * Object jsonBody;
 * Object loggingFilter;
 * Object method;
 * Object queryString;
 * Object singleHeader;
 * Object uriPath;
 * CfnLoggingConfiguration cfnLoggingConfiguration = CfnLoggingConfiguration.Builder.create(this, "MyCfnLoggingConfiguration")
 *         .logDestinationConfigs(List.of("logDestinationConfigs"))
 *         .resourceArn("resourceArn")
 *         // the properties below are optional
 *         .loggingFilter(loggingFilter)
 *         .redactedFields(List.of(FieldToMatchProperty.builder()
 *                 .jsonBody(jsonBody)
 *                 .method(method)
 *                 .queryString(queryString)
 *                 .singleHeader(singleHeader)
 *                 .uriPath(uriPath)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-29T04:34:13.394Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnLoggingConfiguration")
public class CfnLoggingConfiguration extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnLoggingConfiguration(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnLoggingConfiguration(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.wafv2.CfnLoggingConfiguration.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::WAFv2::LoggingConfiguration`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnLoggingConfiguration(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.wafv2.CfnLoggingConfigurationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * Indicates whether the logging configuration was created by AWS Firewall Manager , as part of an AWS WAF policy configuration.
     * <p>
     * If true, only Firewall Manager can modify or delete the configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrManagedByFirewallManager() {
        return software.amazon.jsii.Kernel.get(this, "attrManagedByFirewallManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The Amazon Resource Names (ARNs) of the logging destinations that you want to associate with the web ACL.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getLogDestinationConfigs() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "logDestinationConfigs", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The Amazon Resource Names (ARNs) of the logging destinations that you want to associate with the web ACL.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLogDestinationConfigs(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "logDestinationConfigs", java.util.Objects.requireNonNull(value, "logDestinationConfigs is required"));
    }

    /**
     * Filtering that specifies which web requests are kept in the logs and which are dropped.
     * <p>
     * You can filter on the rule action and on the web request labels that were applied by matching rules during web ACL evaluation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getLoggingFilter() {
        return software.amazon.jsii.Kernel.get(this, "loggingFilter", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Filtering that specifies which web requests are kept in the logs and which are dropped.
     * <p>
     * You can filter on the rule action and on the web request labels that were applied by matching rules during web ACL evaluation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLoggingFilter(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "loggingFilter", java.util.Objects.requireNonNull(value, "loggingFilter is required"));
    }

    /**
     * The Amazon Resource Name (ARN) of the web ACL that you want to associate with `LogDestinationConfigs` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getResourceArn() {
        return software.amazon.jsii.Kernel.get(this, "resourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the web ACL that you want to associate with `LogDestinationConfigs` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourceArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "resourceArn", java.util.Objects.requireNonNull(value, "resourceArn is required"));
    }

    /**
     * The parts of the request that you want to keep out of the logs.
     * <p>
     * For example, if you redact the <code>SingleHeader</code> field, the <code>HEADER</code> field in the firehose will be <code>xxx</code> .
     * <p>
     * <blockquote>
     * <p>
     * You can specify only the following fields for redaction: <code>UriPath</code> , <code>QueryString</code> , <code>SingleHeader</code> , <code>Method</code> , and <code>JsonBody</code> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRedactedFields() {
        return software.amazon.jsii.Kernel.get(this, "redactedFields", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The parts of the request that you want to keep out of the logs.
     * <p>
     * For example, if you redact the <code>SingleHeader</code> field, the <code>HEADER</code> field in the firehose will be <code>xxx</code> .
     * <p>
     * <blockquote>
     * <p>
     * You can specify only the following fields for redaction: <code>UriPath</code> , <code>QueryString</code> , <code>SingleHeader</code> , <code>Method</code> , and <code>JsonBody</code> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRedactedFields(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "redactedFields", value);
    }

    /**
     * The parts of the request that you want to keep out of the logs.
     * <p>
     * For example, if you redact the <code>SingleHeader</code> field, the <code>HEADER</code> field in the firehose will be <code>xxx</code> .
     * <p>
     * <blockquote>
     * <p>
     * You can specify only the following fields for redaction: <code>UriPath</code> , <code>QueryString</code> , <code>SingleHeader</code> , <code>Method</code> , and <code>JsonBody</code> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRedactedFields(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        software.amazon.jsii.Kernel.set(this, "redactedFields", value);
    }
    /**
     * The parts of the request that you want to keep out of the logs.
     * <p>
     * For example, if you redact the <code>SingleHeader</code> field, the <code>HEADER</code> field in the firehose will be <code>xxx</code> .
     * <p>
     * JSON specification for a <code>QueryString</code> field to match:
     * <p>
     * <code>"FieldToMatch": { "QueryString": {} }</code>
     * <p>
     * Example JSON for a <code>Method</code> field to match specification:
     * <p>
     * <code>"FieldToMatch": { "Method": { "Name": "DELETE" } }</code>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * Object jsonBody;
     * Object method;
     * Object queryString;
     * Object singleHeader;
     * Object uriPath;
     * FieldToMatchProperty fieldToMatchProperty = FieldToMatchProperty.builder()
     *         .jsonBody(jsonBody)
     *         .method(method)
     *         .queryString(queryString)
     *         .singleHeader(singleHeader)
     *         .uriPath(uriPath)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnLoggingConfiguration.FieldToMatchProperty")
    @software.amazon.jsii.Jsii.Proxy(FieldToMatchProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FieldToMatchProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Redact the JSON body from the logs.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getJsonBody() {
            return null;
        }

        /**
         * Redact the method from the logs.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMethod() {
            return null;
        }

        /**
         * Redact the query string from the logs.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getQueryString() {
            return null;
        }

        /**
         * Redact the header from the logs.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSingleHeader() {
            return null;
        }

        /**
         * Redact the URI path from the logs.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUriPath() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FieldToMatchProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FieldToMatchProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FieldToMatchProperty> {
            java.lang.Object jsonBody;
            java.lang.Object method;
            java.lang.Object queryString;
            java.lang.Object singleHeader;
            java.lang.Object uriPath;

            /**
             * Sets the value of {@link FieldToMatchProperty#getJsonBody}
             * @param jsonBody Redact the JSON body from the logs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jsonBody(java.lang.Object jsonBody) {
                this.jsonBody = jsonBody;
                return this;
            }

            /**
             * Sets the value of {@link FieldToMatchProperty#getMethod}
             * @param method Redact the method from the logs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder method(java.lang.Object method) {
                this.method = method;
                return this;
            }

            /**
             * Sets the value of {@link FieldToMatchProperty#getQueryString}
             * @param queryString Redact the query string from the logs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryString(java.lang.Object queryString) {
                this.queryString = queryString;
                return this;
            }

            /**
             * Sets the value of {@link FieldToMatchProperty#getSingleHeader}
             * @param singleHeader Redact the header from the logs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder singleHeader(java.lang.Object singleHeader) {
                this.singleHeader = singleHeader;
                return this;
            }

            /**
             * Sets the value of {@link FieldToMatchProperty#getUriPath}
             * @param uriPath Redact the URI path from the logs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder uriPath(java.lang.Object uriPath) {
                this.uriPath = uriPath;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FieldToMatchProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FieldToMatchProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FieldToMatchProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FieldToMatchProperty {
            private final java.lang.Object jsonBody;
            private final java.lang.Object method;
            private final java.lang.Object queryString;
            private final java.lang.Object singleHeader;
            private final java.lang.Object uriPath;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.jsonBody = software.amazon.jsii.Kernel.get(this, "jsonBody", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.method = software.amazon.jsii.Kernel.get(this, "method", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.queryString = software.amazon.jsii.Kernel.get(this, "queryString", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.singleHeader = software.amazon.jsii.Kernel.get(this, "singleHeader", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.uriPath = software.amazon.jsii.Kernel.get(this, "uriPath", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.jsonBody = builder.jsonBody;
                this.method = builder.method;
                this.queryString = builder.queryString;
                this.singleHeader = builder.singleHeader;
                this.uriPath = builder.uriPath;
            }

            @Override
            public final java.lang.Object getJsonBody() {
                return this.jsonBody;
            }

            @Override
            public final java.lang.Object getMethod() {
                return this.method;
            }

            @Override
            public final java.lang.Object getQueryString() {
                return this.queryString;
            }

            @Override
            public final java.lang.Object getSingleHeader() {
                return this.singleHeader;
            }

            @Override
            public final java.lang.Object getUriPath() {
                return this.uriPath;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getJsonBody() != null) {
                    data.set("jsonBody", om.valueToTree(this.getJsonBody()));
                }
                if (this.getMethod() != null) {
                    data.set("method", om.valueToTree(this.getMethod()));
                }
                if (this.getQueryString() != null) {
                    data.set("queryString", om.valueToTree(this.getQueryString()));
                }
                if (this.getSingleHeader() != null) {
                    data.set("singleHeader", om.valueToTree(this.getSingleHeader()));
                }
                if (this.getUriPath() != null) {
                    data.set("uriPath", om.valueToTree(this.getUriPath()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnLoggingConfiguration.FieldToMatchProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FieldToMatchProperty.Jsii$Proxy that = (FieldToMatchProperty.Jsii$Proxy) o;

                if (this.jsonBody != null ? !this.jsonBody.equals(that.jsonBody) : that.jsonBody != null) return false;
                if (this.method != null ? !this.method.equals(that.method) : that.method != null) return false;
                if (this.queryString != null ? !this.queryString.equals(that.queryString) : that.queryString != null) return false;
                if (this.singleHeader != null ? !this.singleHeader.equals(that.singleHeader) : that.singleHeader != null) return false;
                return this.uriPath != null ? this.uriPath.equals(that.uriPath) : that.uriPath == null;
            }

            @Override
            public final int hashCode() {
                int result = this.jsonBody != null ? this.jsonBody.hashCode() : 0;
                result = 31 * result + (this.method != null ? this.method.hashCode() : 0);
                result = 31 * result + (this.queryString != null ? this.queryString.hashCode() : 0);
                result = 31 * result + (this.singleHeader != null ? this.singleHeader.hashCode() : 0);
                result = 31 * result + (this.uriPath != null ? this.uriPath.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.wafv2.CfnLoggingConfiguration}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.wafv2.CfnLoggingConfiguration> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.wafv2.CfnLoggingConfigurationProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.wafv2.CfnLoggingConfigurationProps.Builder();
        }

        /**
         * The Amazon Resource Names (ARNs) of the logging destinations that you want to associate with the web ACL.
         * <p>
         * @return {@code this}
         * @param logDestinationConfigs The Amazon Resource Names (ARNs) of the logging destinations that you want to associate with the web ACL. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logDestinationConfigs(final java.util.List<java.lang.String> logDestinationConfigs) {
            this.props.logDestinationConfigs(logDestinationConfigs);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the web ACL that you want to associate with `LogDestinationConfigs` .
         * <p>
         * @return {@code this}
         * @param resourceArn The Amazon Resource Name (ARN) of the web ACL that you want to associate with `LogDestinationConfigs` . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceArn(final java.lang.String resourceArn) {
            this.props.resourceArn(resourceArn);
            return this;
        }

        /**
         * Filtering that specifies which web requests are kept in the logs and which are dropped.
         * <p>
         * You can filter on the rule action and on the web request labels that were applied by matching rules during web ACL evaluation.
         * <p>
         * @return {@code this}
         * @param loggingFilter Filtering that specifies which web requests are kept in the logs and which are dropped. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loggingFilter(final java.lang.Object loggingFilter) {
            this.props.loggingFilter(loggingFilter);
            return this;
        }

        /**
         * The parts of the request that you want to keep out of the logs.
         * <p>
         * For example, if you redact the <code>SingleHeader</code> field, the <code>HEADER</code> field in the firehose will be <code>xxx</code> .
         * <p>
         * <blockquote>
         * <p>
         * You can specify only the following fields for redaction: <code>UriPath</code> , <code>QueryString</code> , <code>SingleHeader</code> , <code>Method</code> , and <code>JsonBody</code> .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param redactedFields The parts of the request that you want to keep out of the logs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder redactedFields(final software.amazon.awscdk.IResolvable redactedFields) {
            this.props.redactedFields(redactedFields);
            return this;
        }
        /**
         * The parts of the request that you want to keep out of the logs.
         * <p>
         * For example, if you redact the <code>SingleHeader</code> field, the <code>HEADER</code> field in the firehose will be <code>xxx</code> .
         * <p>
         * <blockquote>
         * <p>
         * You can specify only the following fields for redaction: <code>UriPath</code> , <code>QueryString</code> , <code>SingleHeader</code> , <code>Method</code> , and <code>JsonBody</code> .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param redactedFields The parts of the request that you want to keep out of the logs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder redactedFields(final java.util.List<? extends java.lang.Object> redactedFields) {
            this.props.redactedFields(redactedFields);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.wafv2.CfnLoggingConfiguration}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.wafv2.CfnLoggingConfiguration build() {
            return new software.amazon.awscdk.services.wafv2.CfnLoggingConfiguration(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
