package software.amazon.awscdk.services.ssm;

/**
 * Attributes for parameters of various types of string.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ssm.*;
 * StringParameterAttributes stringParameterAttributes = StringParameterAttributes.builder()
 *         .parameterName("parameterName")
 *         // the properties below are optional
 *         .simpleName(false)
 *         .type(ParameterType.STRING)
 *         .version(123)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see ParameterType
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-29T04:34:13.058Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssm.StringParameterAttributes")
@software.amazon.jsii.Jsii.Proxy(StringParameterAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface StringParameterAttributes extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.ssm.CommonStringParameterAttributes {

    /**
     * The type of the string parameter.
     * <p>
     * Default: ParameterType.STRING
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ssm.ParameterType getType() {
        return null;
    }

    /**
     * The version number of the value you wish to retrieve.
     * <p>
     * Default: The latest version will be retrieved.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getVersion() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link StringParameterAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link StringParameterAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<StringParameterAttributes> {
        software.amazon.awscdk.services.ssm.ParameterType type;
        java.lang.Number version;
        java.lang.String parameterName;
        java.lang.Boolean simpleName;

        /**
         * Sets the value of {@link StringParameterAttributes#getType}
         * @param type The type of the string parameter.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(software.amazon.awscdk.services.ssm.ParameterType type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link StringParameterAttributes#getVersion}
         * @param version The version number of the value you wish to retrieve.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder version(java.lang.Number version) {
            this.version = version;
            return this;
        }

        /**
         * Sets the value of {@link StringParameterAttributes#getParameterName}
         * @param parameterName The name of the parameter store value. This parameter is required.
         *                      This value can be a token or a concrete string. If it is a concrete string
         *                      and includes "/" it must also be prefixed with a "/" (fully-qualified).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameterName(java.lang.String parameterName) {
            this.parameterName = parameterName;
            return this;
        }

        /**
         * Sets the value of {@link StringParameterAttributes#getSimpleName}
         * @param simpleName Indicates of the parameter name is a simple name (i.e. does not include "/" separators).
         *                   This is only required only if <code>parameterName</code> is a token, which means we
         *                   are unable to detect if the name is simple or "path-like" for the purpose
         *                   of rendering SSM parameter ARNs.
         *                   <p>
         *                   If <code>parameterName</code> is not specified, <code>simpleName</code> must be <code>true</code> (or
         *                   undefined) since the name generated by AWS CloudFormation is always a
         *                   simple name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder simpleName(java.lang.Boolean simpleName) {
            this.simpleName = simpleName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link StringParameterAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public StringParameterAttributes build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link StringParameterAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StringParameterAttributes {
        private final software.amazon.awscdk.services.ssm.ParameterType type;
        private final java.lang.Number version;
        private final java.lang.String parameterName;
        private final java.lang.Boolean simpleName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ssm.ParameterType.class));
            this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.parameterName = software.amazon.jsii.Kernel.get(this, "parameterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.simpleName = software.amazon.jsii.Kernel.get(this, "simpleName", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.type = builder.type;
            this.version = builder.version;
            this.parameterName = java.util.Objects.requireNonNull(builder.parameterName, "parameterName is required");
            this.simpleName = builder.simpleName;
        }

        @Override
        public final software.amazon.awscdk.services.ssm.ParameterType getType() {
            return this.type;
        }

        @Override
        public final java.lang.Number getVersion() {
            return this.version;
        }

        @Override
        public final java.lang.String getParameterName() {
            return this.parameterName;
        }

        @Override
        public final java.lang.Boolean getSimpleName() {
            return this.simpleName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getType() != null) {
                data.set("type", om.valueToTree(this.getType()));
            }
            if (this.getVersion() != null) {
                data.set("version", om.valueToTree(this.getVersion()));
            }
            data.set("parameterName", om.valueToTree(this.getParameterName()));
            if (this.getSimpleName() != null) {
                data.set("simpleName", om.valueToTree(this.getSimpleName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ssm.StringParameterAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            StringParameterAttributes.Jsii$Proxy that = (StringParameterAttributes.Jsii$Proxy) o;

            if (this.type != null ? !this.type.equals(that.type) : that.type != null) return false;
            if (this.version != null ? !this.version.equals(that.version) : that.version != null) return false;
            if (!parameterName.equals(that.parameterName)) return false;
            return this.simpleName != null ? this.simpleName.equals(that.simpleName) : that.simpleName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.type != null ? this.type.hashCode() : 0;
            result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
            result = 31 * result + (this.parameterName.hashCode());
            result = 31 * result + (this.simpleName != null ? this.simpleName.hashCode() : 0);
            return result;
        }
    }
}
