package software.amazon.awscdk.services.secretsmanager;

/**
 * A CloudFormation `AWS::SecretsManager::RotationSchedule`.
 * <p>
 * Configures rotation for a secret. You must already configure the secret with the details of the database or service. If you define both the secret and the database or service in an AWS CloudFormation template, then define the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-secretsmanager-secrettargetattachment.html">AWS::SecretsManager::SecretTargetAttachment</a> resource to populate the secret with the connection details of the database or service before you attempt to configure rotation.
 * <p>
 * <blockquote>
 * <p>
 * When you configure rotation for a secret, AWS CloudFormation automatically rotates the secret one time.
 * <p>
 * </blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.secretsmanager.*;
 * CfnRotationSchedule cfnRotationSchedule = CfnRotationSchedule.Builder.create(this, "MyCfnRotationSchedule")
 *         .secretId("secretId")
 *         // the properties below are optional
 *         .hostedRotationLambda(HostedRotationLambdaProperty.builder()
 *                 .rotationType("rotationType")
 *                 // the properties below are optional
 *                 .kmsKeyArn("kmsKeyArn")
 *                 .masterSecretArn("masterSecretArn")
 *                 .masterSecretKmsKeyArn("masterSecretKmsKeyArn")
 *                 .rotationLambdaName("rotationLambdaName")
 *                 .superuserSecretArn("superuserSecretArn")
 *                 .superuserSecretKmsKeyArn("superuserSecretKmsKeyArn")
 *                 .vpcSecurityGroupIds("vpcSecurityGroupIds")
 *                 .vpcSubnetIds("vpcSubnetIds")
 *                 .build())
 *         .rotationLambdaArn("rotationLambdaArn")
 *         .rotationRules(RotationRulesProperty.builder()
 *                 .automaticallyAfterDays(123)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-29T04:34:12.777Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_secretsmanager.CfnRotationSchedule")
public class CfnRotationSchedule extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnRotationSchedule(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnRotationSchedule(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.secretsmanager.CfnRotationSchedule.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::SecretsManager::RotationSchedule`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnRotationSchedule(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.CfnRotationScheduleProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The ARN or name of the secret to rotate.
     * <p>
     * To reference a secret also created in this template, use the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-ref.html">Ref</a> function with the secret's logical ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getSecretId() {
        return software.amazon.jsii.Kernel.get(this, "secretId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN or name of the secret to rotate.
     * <p>
     * To reference a secret also created in this template, use the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-ref.html">Ref</a> function with the secret's logical ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSecretId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "secretId", java.util.Objects.requireNonNull(value, "secretId is required"));
    }

    /**
     * To use these values, you must specify `Transform: AWS::SecretsManager-2020-07-23` at the beginning of the CloudFormation template.
     * <p>
     * When you enter valid values for <code>RotationSchedule.HostedRotationLambda</code> , Secrets Manager launches a Lambda that performs rotation on the secret specified in the <code>secret-id</code> property. The template creates a Lambda as part of a nested stack within the current stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getHostedRotationLambda() {
        return software.amazon.jsii.Kernel.get(this, "hostedRotationLambda", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * To use these values, you must specify `Transform: AWS::SecretsManager-2020-07-23` at the beginning of the CloudFormation template.
     * <p>
     * When you enter valid values for <code>RotationSchedule.HostedRotationLambda</code> , Secrets Manager launches a Lambda that performs rotation on the secret specified in the <code>secret-id</code> property. The template creates a Lambda as part of a nested stack within the current stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHostedRotationLambda(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.secretsmanager.CfnRotationSchedule.HostedRotationLambdaProperty value) {
        software.amazon.jsii.Kernel.set(this, "hostedRotationLambda", value);
    }

    /**
     * To use these values, you must specify `Transform: AWS::SecretsManager-2020-07-23` at the beginning of the CloudFormation template.
     * <p>
     * When you enter valid values for <code>RotationSchedule.HostedRotationLambda</code> , Secrets Manager launches a Lambda that performs rotation on the secret specified in the <code>secret-id</code> property. The template creates a Lambda as part of a nested stack within the current stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHostedRotationLambda(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "hostedRotationLambda", value);
    }

    /**
     * The ARN of the Lambda function that can rotate the secret.
     * <p>
     * If you don't specify this parameter, then the secret must already have the ARN of a Lambda function configured.
     * <p>
     * To reference a Lambda function also created in this template, use the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-ref.html">Ref</a> function with the function's logical ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRotationLambdaArn() {
        return software.amazon.jsii.Kernel.get(this, "rotationLambdaArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the Lambda function that can rotate the secret.
     * <p>
     * If you don't specify this parameter, then the secret must already have the ARN of a Lambda function configured.
     * <p>
     * To reference a Lambda function also created in this template, use the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-ref.html">Ref</a> function with the function's logical ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRotationLambdaArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "rotationLambdaArn", value);
    }

    /**
     * A structure that defines the rotation configuration for this secret.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRotationRules() {
        return software.amazon.jsii.Kernel.get(this, "rotationRules", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A structure that defines the rotation configuration for this secret.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRotationRules(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.secretsmanager.CfnRotationSchedule.RotationRulesProperty value) {
        software.amazon.jsii.Kernel.set(this, "rotationRules", value);
    }

    /**
     * A structure that defines the rotation configuration for this secret.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRotationRules(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "rotationRules", value);
    }
    /**
     * Specifies that you want to create a hosted Lambda rotation function.
     * <p>
     * To use these values, you must specify <code>Transform: AWS::SecretsManager-2020-07-23</code> at the beginning of the CloudFormation template.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.secretsmanager.*;
     * HostedRotationLambdaProperty hostedRotationLambdaProperty = HostedRotationLambdaProperty.builder()
     *         .rotationType("rotationType")
     *         // the properties below are optional
     *         .kmsKeyArn("kmsKeyArn")
     *         .masterSecretArn("masterSecretArn")
     *         .masterSecretKmsKeyArn("masterSecretKmsKeyArn")
     *         .rotationLambdaName("rotationLambdaName")
     *         .superuserSecretArn("superuserSecretArn")
     *         .superuserSecretKmsKeyArn("superuserSecretKmsKeyArn")
     *         .vpcSecurityGroupIds("vpcSecurityGroupIds")
     *         .vpcSubnetIds("vpcSubnetIds")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_secretsmanager.CfnRotationSchedule.HostedRotationLambdaProperty")
    @software.amazon.jsii.Jsii.Proxy(HostedRotationLambdaProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HostedRotationLambdaProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of rotation template to use. For more information, see [Secrets Manager rotation function templates](https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_available-rotation-templates.html) .
         * <p>
         * You can specify one of the following <code>RotationTypes</code> :
         * <p>
         * <ul>
         * <li>MySQLSingleUser</li>
         * <li>MySQLMultiUser</li>
         * <li>PostgreSQLSingleUser</li>
         * <li>PostgreSQLMultiUser</li>
         * <li>OracleSingleUser</li>
         * <li>OracleMultiUser</li>
         * <li>MariaDBSingleUser</li>
         * <li>MariaDBMultiUser</li>
         * <li>SQLServerSingleUser</li>
         * <li>SQLServerMultiUser</li>
         * <li>RedshiftSingleUser</li>
         * <li>RedshiftMultiUser</li>
         * <li>MongoDBSingleUser</li>
         * <li>MongoDBMultiUser</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRotationType();

        /**
         * The ARN of the KMS key that Secrets Manager uses to encrypt the secret.
         * <p>
         * If you don't specify this value, then Secrets Manager uses the key <code>aws/secretsmanager</code> . If <code>aws/secretsmanager</code> doesn't yet exist, then Secrets Manager creates it for you automatically the first time it encrypts the secret value.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyArn() {
            return null;
        }

        /**
         * The ARN of the secret that contains elevated credentials.
         * <p>
         * The Lambda rotation function uses this secret for the <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotating-secrets_strategies.html#rotating-secrets-two-users">Alternating users rotation strategy</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMasterSecretArn() {
            return null;
        }

        /**
         * The ARN of the KMS key that Secrets Manager uses to encrypt the elevated secret if you use the [alternating users strategy](https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotating-secrets_strategies.html#rotating-secrets-two-users) . If you don't specify this value and you use the alternating users strategy, then Secrets Manager uses the key `aws/secretsmanager` . If `aws/secretsmanager` doesn't yet exist, then Secrets Manager creates it for you automatically the first time it encrypts the secret value.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMasterSecretKmsKeyArn() {
            return null;
        }

        /**
         * The name of the Lambda rotation function.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRotationLambdaName() {
            return null;
        }

        /**
         * The ARN of the secret that contains elevated credentials.
         * <p>
         * The Lambda rotation function uses this secret for the <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotating-secrets_strategies.html#rotating-secrets-two-users">Alternating users rotation strategy</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSuperuserSecretArn() {
            return null;
        }

        /**
         * The ARN of the KMS key that Secrets Manager uses to encrypt the elevated secret if you use the [alternating users strategy](https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotating-secrets_strategies.html#rotating-secrets-two-users) . If you don't specify this value and you use the alternating users strategy, then Secrets Manager uses the key `aws/secretsmanager` . If `aws/secretsmanager` doesn't yet exist, then Secrets Manager creates it for you automatically the first time it encrypts the secret value.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSuperuserSecretKmsKeyArn() {
            return null;
        }

        /**
         * A comma-separated list of security group IDs applied to the target database.
         * <p>
         * The templates applies the same security groups as on the Lambda rotation function that is created as part of this stack.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVpcSecurityGroupIds() {
            return null;
        }

        /**
         * A comma separated list of VPC subnet IDs of the target database network.
         * <p>
         * The Lambda rotation function is in the same subnet group.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVpcSubnetIds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HostedRotationLambdaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HostedRotationLambdaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HostedRotationLambdaProperty> {
            java.lang.String rotationType;
            java.lang.String kmsKeyArn;
            java.lang.String masterSecretArn;
            java.lang.String masterSecretKmsKeyArn;
            java.lang.String rotationLambdaName;
            java.lang.String superuserSecretArn;
            java.lang.String superuserSecretKmsKeyArn;
            java.lang.String vpcSecurityGroupIds;
            java.lang.String vpcSubnetIds;

            /**
             * Sets the value of {@link HostedRotationLambdaProperty#getRotationType}
             * @param rotationType The type of rotation template to use. For more information, see [Secrets Manager rotation function templates](https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_available-rotation-templates.html) . This parameter is required.
             *                     You can specify one of the following <code>RotationTypes</code> :
             *                     <p>
             *                     <ul>
             *                     <li>MySQLSingleUser</li>
             *                     <li>MySQLMultiUser</li>
             *                     <li>PostgreSQLSingleUser</li>
             *                     <li>PostgreSQLMultiUser</li>
             *                     <li>OracleSingleUser</li>
             *                     <li>OracleMultiUser</li>
             *                     <li>MariaDBSingleUser</li>
             *                     <li>MariaDBMultiUser</li>
             *                     <li>SQLServerSingleUser</li>
             *                     <li>SQLServerMultiUser</li>
             *                     <li>RedshiftSingleUser</li>
             *                     <li>RedshiftMultiUser</li>
             *                     <li>MongoDBSingleUser</li>
             *                     <li>MongoDBMultiUser</li>
             *                     </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rotationType(java.lang.String rotationType) {
                this.rotationType = rotationType;
                return this;
            }

            /**
             * Sets the value of {@link HostedRotationLambdaProperty#getKmsKeyArn}
             * @param kmsKeyArn The ARN of the KMS key that Secrets Manager uses to encrypt the secret.
             *                  If you don't specify this value, then Secrets Manager uses the key <code>aws/secretsmanager</code> . If <code>aws/secretsmanager</code> doesn't yet exist, then Secrets Manager creates it for you automatically the first time it encrypts the secret value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKeyArn(java.lang.String kmsKeyArn) {
                this.kmsKeyArn = kmsKeyArn;
                return this;
            }

            /**
             * Sets the value of {@link HostedRotationLambdaProperty#getMasterSecretArn}
             * @param masterSecretArn The ARN of the secret that contains elevated credentials.
             *                        The Lambda rotation function uses this secret for the <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotating-secrets_strategies.html#rotating-secrets-two-users">Alternating users rotation strategy</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder masterSecretArn(java.lang.String masterSecretArn) {
                this.masterSecretArn = masterSecretArn;
                return this;
            }

            /**
             * Sets the value of {@link HostedRotationLambdaProperty#getMasterSecretKmsKeyArn}
             * @param masterSecretKmsKeyArn The ARN of the KMS key that Secrets Manager uses to encrypt the elevated secret if you use the [alternating users strategy](https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotating-secrets_strategies.html#rotating-secrets-two-users) . If you don't specify this value and you use the alternating users strategy, then Secrets Manager uses the key `aws/secretsmanager` . If `aws/secretsmanager` doesn't yet exist, then Secrets Manager creates it for you automatically the first time it encrypts the secret value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder masterSecretKmsKeyArn(java.lang.String masterSecretKmsKeyArn) {
                this.masterSecretKmsKeyArn = masterSecretKmsKeyArn;
                return this;
            }

            /**
             * Sets the value of {@link HostedRotationLambdaProperty#getRotationLambdaName}
             * @param rotationLambdaName The name of the Lambda rotation function.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rotationLambdaName(java.lang.String rotationLambdaName) {
                this.rotationLambdaName = rotationLambdaName;
                return this;
            }

            /**
             * Sets the value of {@link HostedRotationLambdaProperty#getSuperuserSecretArn}
             * @param superuserSecretArn The ARN of the secret that contains elevated credentials.
             *                           The Lambda rotation function uses this secret for the <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotating-secrets_strategies.html#rotating-secrets-two-users">Alternating users rotation strategy</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder superuserSecretArn(java.lang.String superuserSecretArn) {
                this.superuserSecretArn = superuserSecretArn;
                return this;
            }

            /**
             * Sets the value of {@link HostedRotationLambdaProperty#getSuperuserSecretKmsKeyArn}
             * @param superuserSecretKmsKeyArn The ARN of the KMS key that Secrets Manager uses to encrypt the elevated secret if you use the [alternating users strategy](https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotating-secrets_strategies.html#rotating-secrets-two-users) . If you don't specify this value and you use the alternating users strategy, then Secrets Manager uses the key `aws/secretsmanager` . If `aws/secretsmanager` doesn't yet exist, then Secrets Manager creates it for you automatically the first time it encrypts the secret value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder superuserSecretKmsKeyArn(java.lang.String superuserSecretKmsKeyArn) {
                this.superuserSecretKmsKeyArn = superuserSecretKmsKeyArn;
                return this;
            }

            /**
             * Sets the value of {@link HostedRotationLambdaProperty#getVpcSecurityGroupIds}
             * @param vpcSecurityGroupIds A comma-separated list of security group IDs applied to the target database.
             *                            The templates applies the same security groups as on the Lambda rotation function that is created as part of this stack.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcSecurityGroupIds(java.lang.String vpcSecurityGroupIds) {
                this.vpcSecurityGroupIds = vpcSecurityGroupIds;
                return this;
            }

            /**
             * Sets the value of {@link HostedRotationLambdaProperty#getVpcSubnetIds}
             * @param vpcSubnetIds A comma separated list of VPC subnet IDs of the target database network.
             *                     The Lambda rotation function is in the same subnet group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcSubnetIds(java.lang.String vpcSubnetIds) {
                this.vpcSubnetIds = vpcSubnetIds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HostedRotationLambdaProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HostedRotationLambdaProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HostedRotationLambdaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HostedRotationLambdaProperty {
            private final java.lang.String rotationType;
            private final java.lang.String kmsKeyArn;
            private final java.lang.String masterSecretArn;
            private final java.lang.String masterSecretKmsKeyArn;
            private final java.lang.String rotationLambdaName;
            private final java.lang.String superuserSecretArn;
            private final java.lang.String superuserSecretKmsKeyArn;
            private final java.lang.String vpcSecurityGroupIds;
            private final java.lang.String vpcSubnetIds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.rotationType = software.amazon.jsii.Kernel.get(this, "rotationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.kmsKeyArn = software.amazon.jsii.Kernel.get(this, "kmsKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.masterSecretArn = software.amazon.jsii.Kernel.get(this, "masterSecretArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.masterSecretKmsKeyArn = software.amazon.jsii.Kernel.get(this, "masterSecretKmsKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.rotationLambdaName = software.amazon.jsii.Kernel.get(this, "rotationLambdaName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.superuserSecretArn = software.amazon.jsii.Kernel.get(this, "superuserSecretArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.superuserSecretKmsKeyArn = software.amazon.jsii.Kernel.get(this, "superuserSecretKmsKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.vpcSecurityGroupIds = software.amazon.jsii.Kernel.get(this, "vpcSecurityGroupIds", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.vpcSubnetIds = software.amazon.jsii.Kernel.get(this, "vpcSubnetIds", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.rotationType = java.util.Objects.requireNonNull(builder.rotationType, "rotationType is required");
                this.kmsKeyArn = builder.kmsKeyArn;
                this.masterSecretArn = builder.masterSecretArn;
                this.masterSecretKmsKeyArn = builder.masterSecretKmsKeyArn;
                this.rotationLambdaName = builder.rotationLambdaName;
                this.superuserSecretArn = builder.superuserSecretArn;
                this.superuserSecretKmsKeyArn = builder.superuserSecretKmsKeyArn;
                this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
                this.vpcSubnetIds = builder.vpcSubnetIds;
            }

            @Override
            public final java.lang.String getRotationType() {
                return this.rotationType;
            }

            @Override
            public final java.lang.String getKmsKeyArn() {
                return this.kmsKeyArn;
            }

            @Override
            public final java.lang.String getMasterSecretArn() {
                return this.masterSecretArn;
            }

            @Override
            public final java.lang.String getMasterSecretKmsKeyArn() {
                return this.masterSecretKmsKeyArn;
            }

            @Override
            public final java.lang.String getRotationLambdaName() {
                return this.rotationLambdaName;
            }

            @Override
            public final java.lang.String getSuperuserSecretArn() {
                return this.superuserSecretArn;
            }

            @Override
            public final java.lang.String getSuperuserSecretKmsKeyArn() {
                return this.superuserSecretKmsKeyArn;
            }

            @Override
            public final java.lang.String getVpcSecurityGroupIds() {
                return this.vpcSecurityGroupIds;
            }

            @Override
            public final java.lang.String getVpcSubnetIds() {
                return this.vpcSubnetIds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("rotationType", om.valueToTree(this.getRotationType()));
                if (this.getKmsKeyArn() != null) {
                    data.set("kmsKeyArn", om.valueToTree(this.getKmsKeyArn()));
                }
                if (this.getMasterSecretArn() != null) {
                    data.set("masterSecretArn", om.valueToTree(this.getMasterSecretArn()));
                }
                if (this.getMasterSecretKmsKeyArn() != null) {
                    data.set("masterSecretKmsKeyArn", om.valueToTree(this.getMasterSecretKmsKeyArn()));
                }
                if (this.getRotationLambdaName() != null) {
                    data.set("rotationLambdaName", om.valueToTree(this.getRotationLambdaName()));
                }
                if (this.getSuperuserSecretArn() != null) {
                    data.set("superuserSecretArn", om.valueToTree(this.getSuperuserSecretArn()));
                }
                if (this.getSuperuserSecretKmsKeyArn() != null) {
                    data.set("superuserSecretKmsKeyArn", om.valueToTree(this.getSuperuserSecretKmsKeyArn()));
                }
                if (this.getVpcSecurityGroupIds() != null) {
                    data.set("vpcSecurityGroupIds", om.valueToTree(this.getVpcSecurityGroupIds()));
                }
                if (this.getVpcSubnetIds() != null) {
                    data.set("vpcSubnetIds", om.valueToTree(this.getVpcSubnetIds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_secretsmanager.CfnRotationSchedule.HostedRotationLambdaProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HostedRotationLambdaProperty.Jsii$Proxy that = (HostedRotationLambdaProperty.Jsii$Proxy) o;

                if (!rotationType.equals(that.rotationType)) return false;
                if (this.kmsKeyArn != null ? !this.kmsKeyArn.equals(that.kmsKeyArn) : that.kmsKeyArn != null) return false;
                if (this.masterSecretArn != null ? !this.masterSecretArn.equals(that.masterSecretArn) : that.masterSecretArn != null) return false;
                if (this.masterSecretKmsKeyArn != null ? !this.masterSecretKmsKeyArn.equals(that.masterSecretKmsKeyArn) : that.masterSecretKmsKeyArn != null) return false;
                if (this.rotationLambdaName != null ? !this.rotationLambdaName.equals(that.rotationLambdaName) : that.rotationLambdaName != null) return false;
                if (this.superuserSecretArn != null ? !this.superuserSecretArn.equals(that.superuserSecretArn) : that.superuserSecretArn != null) return false;
                if (this.superuserSecretKmsKeyArn != null ? !this.superuserSecretKmsKeyArn.equals(that.superuserSecretKmsKeyArn) : that.superuserSecretKmsKeyArn != null) return false;
                if (this.vpcSecurityGroupIds != null ? !this.vpcSecurityGroupIds.equals(that.vpcSecurityGroupIds) : that.vpcSecurityGroupIds != null) return false;
                return this.vpcSubnetIds != null ? this.vpcSubnetIds.equals(that.vpcSubnetIds) : that.vpcSubnetIds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.rotationType.hashCode();
                result = 31 * result + (this.kmsKeyArn != null ? this.kmsKeyArn.hashCode() : 0);
                result = 31 * result + (this.masterSecretArn != null ? this.masterSecretArn.hashCode() : 0);
                result = 31 * result + (this.masterSecretKmsKeyArn != null ? this.masterSecretKmsKeyArn.hashCode() : 0);
                result = 31 * result + (this.rotationLambdaName != null ? this.rotationLambdaName.hashCode() : 0);
                result = 31 * result + (this.superuserSecretArn != null ? this.superuserSecretArn.hashCode() : 0);
                result = 31 * result + (this.superuserSecretKmsKeyArn != null ? this.superuserSecretKmsKeyArn.hashCode() : 0);
                result = 31 * result + (this.vpcSecurityGroupIds != null ? this.vpcSecurityGroupIds.hashCode() : 0);
                result = 31 * result + (this.vpcSubnetIds != null ? this.vpcSubnetIds.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A structure that defines the rotation configuration for the secret.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.secretsmanager.*;
     * RotationRulesProperty rotationRulesProperty = RotationRulesProperty.builder()
     *         .automaticallyAfterDays(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_secretsmanager.CfnRotationSchedule.RotationRulesProperty")
    @software.amazon.jsii.Jsii.Proxy(RotationRulesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RotationRulesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the number of days between automatic scheduled rotations of the secret.
         * <p>
         * Secrets Manager schedules the next rotation when the previous one is complete. Secrets Manager schedules the date by adding the rotation interval (number of days) to the actual date of the last rotation. The service chooses the hour within that 24-hour date window randomly. The minute is also chosen somewhat randomly, but weighted towards the top of the hour and influenced by a variety of factors that help distribute load.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getAutomaticallyAfterDays() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RotationRulesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RotationRulesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RotationRulesProperty> {
            java.lang.Number automaticallyAfterDays;

            /**
             * Sets the value of {@link RotationRulesProperty#getAutomaticallyAfterDays}
             * @param automaticallyAfterDays Specifies the number of days between automatic scheduled rotations of the secret.
             *                               Secrets Manager schedules the next rotation when the previous one is complete. Secrets Manager schedules the date by adding the rotation interval (number of days) to the actual date of the last rotation. The service chooses the hour within that 24-hour date window randomly. The minute is also chosen somewhat randomly, but weighted towards the top of the hour and influenced by a variety of factors that help distribute load.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder automaticallyAfterDays(java.lang.Number automaticallyAfterDays) {
                this.automaticallyAfterDays = automaticallyAfterDays;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RotationRulesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RotationRulesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RotationRulesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RotationRulesProperty {
            private final java.lang.Number automaticallyAfterDays;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.automaticallyAfterDays = software.amazon.jsii.Kernel.get(this, "automaticallyAfterDays", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.automaticallyAfterDays = builder.automaticallyAfterDays;
            }

            @Override
            public final java.lang.Number getAutomaticallyAfterDays() {
                return this.automaticallyAfterDays;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAutomaticallyAfterDays() != null) {
                    data.set("automaticallyAfterDays", om.valueToTree(this.getAutomaticallyAfterDays()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_secretsmanager.CfnRotationSchedule.RotationRulesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RotationRulesProperty.Jsii$Proxy that = (RotationRulesProperty.Jsii$Proxy) o;

                return this.automaticallyAfterDays != null ? this.automaticallyAfterDays.equals(that.automaticallyAfterDays) : that.automaticallyAfterDays == null;
            }

            @Override
            public final int hashCode() {
                int result = this.automaticallyAfterDays != null ? this.automaticallyAfterDays.hashCode() : 0;
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.secretsmanager.CfnRotationSchedule}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.secretsmanager.CfnRotationSchedule> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.secretsmanager.CfnRotationScheduleProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.secretsmanager.CfnRotationScheduleProps.Builder();
        }

        /**
         * The ARN or name of the secret to rotate.
         * <p>
         * To reference a secret also created in this template, use the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-ref.html">Ref</a> function with the secret's logical ID.
         * <p>
         * @return {@code this}
         * @param secretId The ARN or name of the secret to rotate. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secretId(final java.lang.String secretId) {
            this.props.secretId(secretId);
            return this;
        }

        /**
         * To use these values, you must specify `Transform: AWS::SecretsManager-2020-07-23` at the beginning of the CloudFormation template.
         * <p>
         * When you enter valid values for <code>RotationSchedule.HostedRotationLambda</code> , Secrets Manager launches a Lambda that performs rotation on the secret specified in the <code>secret-id</code> property. The template creates a Lambda as part of a nested stack within the current stack.
         * <p>
         * @return {@code this}
         * @param hostedRotationLambda To use these values, you must specify `Transform: AWS::SecretsManager-2020-07-23` at the beginning of the CloudFormation template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostedRotationLambda(final software.amazon.awscdk.services.secretsmanager.CfnRotationSchedule.HostedRotationLambdaProperty hostedRotationLambda) {
            this.props.hostedRotationLambda(hostedRotationLambda);
            return this;
        }
        /**
         * To use these values, you must specify `Transform: AWS::SecretsManager-2020-07-23` at the beginning of the CloudFormation template.
         * <p>
         * When you enter valid values for <code>RotationSchedule.HostedRotationLambda</code> , Secrets Manager launches a Lambda that performs rotation on the secret specified in the <code>secret-id</code> property. The template creates a Lambda as part of a nested stack within the current stack.
         * <p>
         * @return {@code this}
         * @param hostedRotationLambda To use these values, you must specify `Transform: AWS::SecretsManager-2020-07-23` at the beginning of the CloudFormation template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostedRotationLambda(final software.amazon.awscdk.IResolvable hostedRotationLambda) {
            this.props.hostedRotationLambda(hostedRotationLambda);
            return this;
        }

        /**
         * The ARN of the Lambda function that can rotate the secret.
         * <p>
         * If you don't specify this parameter, then the secret must already have the ARN of a Lambda function configured.
         * <p>
         * To reference a Lambda function also created in this template, use the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-ref.html">Ref</a> function with the function's logical ID.
         * <p>
         * @return {@code this}
         * @param rotationLambdaArn The ARN of the Lambda function that can rotate the secret. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rotationLambdaArn(final java.lang.String rotationLambdaArn) {
            this.props.rotationLambdaArn(rotationLambdaArn);
            return this;
        }

        /**
         * A structure that defines the rotation configuration for this secret.
         * <p>
         * @return {@code this}
         * @param rotationRules A structure that defines the rotation configuration for this secret. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rotationRules(final software.amazon.awscdk.services.secretsmanager.CfnRotationSchedule.RotationRulesProperty rotationRules) {
            this.props.rotationRules(rotationRules);
            return this;
        }
        /**
         * A structure that defines the rotation configuration for this secret.
         * <p>
         * @return {@code this}
         * @param rotationRules A structure that defines the rotation configuration for this secret. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rotationRules(final software.amazon.awscdk.IResolvable rotationRules) {
            this.props.rotationRules(rotationRules);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.secretsmanager.CfnRotationSchedule}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.secretsmanager.CfnRotationSchedule build() {
            return new software.amazon.awscdk.services.secretsmanager.CfnRotationSchedule(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
