package software.amazon.awscdk.services.rum;

/**
 * Properties for defining a `CfnAppMonitor`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.rum.*;
 * CfnAppMonitorProps cfnAppMonitorProps = CfnAppMonitorProps.builder()
 *         .domain("domain")
 *         .name("name")
 *         // the properties below are optional
 *         .appMonitorConfiguration(AppMonitorConfigurationProperty.builder()
 *                 .allowCookies(false)
 *                 .enableXRay(false)
 *                 .excludedPages(List.of("excludedPages"))
 *                 .favoritePages(List.of("favoritePages"))
 *                 .guestRoleArn("guestRoleArn")
 *                 .identityPoolId("identityPoolId")
 *                 .includedPages(List.of("includedPages"))
 *                 .sessionSampleRate(123)
 *                 .telemetries(List.of("telemetries"))
 *                 .build())
 *         .cwLogEnabled(false)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-29T04:34:12.467Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rum.CfnAppMonitorProps")
@software.amazon.jsii.Jsii.Proxy(CfnAppMonitorProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnAppMonitorProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The top-level internet domain name for which your application has administrative authority.
     * <p>
     * This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDomain();

    /**
     * A name for the app monitor.
     * <p>
     * This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * A structure that contains much of the configuration data for the app monitor.
     * <p>
     * If you are using Amazon Cognito for authorization, you must include this structure in your request, and it must include the ID of the Amazon Cognito identity pool to use for authorization. If you don't include <code>AppMonitorConfiguration</code> , you must set up your own authorization method. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-get-started-authorization.html">Authorize your application to send data to AWS</a> .
     * <p>
     * If you omit this argument, the sample rate used for CloudWatch RUM is set to 10% of the user sessions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAppMonitorConfiguration() {
        return null;
    }

    /**
     * Data collected by CloudWatch RUM is kept by RUM for 30 days and then deleted.
     * <p>
     * This parameter specifies whether CloudWatch RUM sends a copy of this telemetry data to Amazon CloudWatch Logs in your account. This enables you to keep the telemetry data for more than 30 days, but it does incur Amazon CloudWatch Logs charges.
     * <p>
     * If you omit this parameter, the default is <code>false</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCwLogEnabled() {
        return null;
    }

    /**
     * Assigns one or more tags (key-value pairs) to the app monitor.
     * <p>
     * Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.
     * <p>
     * Tags don't have any semantic meaning to AWS and are interpreted strictly as strings of characters.
     * <p>
     * You can associate as many as 50 tags with an app monitor.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS resources</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnAppMonitorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnAppMonitorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnAppMonitorProps> {
        java.lang.String domain;
        java.lang.String name;
        java.lang.Object appMonitorConfiguration;
        java.lang.Object cwLogEnabled;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnAppMonitorProps#getDomain}
         * @param domain The top-level internet domain name for which your application has administrative authority. This parameter is required.
         *               This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domain(java.lang.String domain) {
            this.domain = domain;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppMonitorProps#getName}
         * @param name A name for the app monitor. This parameter is required.
         *             This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppMonitorProps#getAppMonitorConfiguration}
         * @param appMonitorConfiguration A structure that contains much of the configuration data for the app monitor.
         *                                If you are using Amazon Cognito for authorization, you must include this structure in your request, and it must include the ID of the Amazon Cognito identity pool to use for authorization. If you don't include <code>AppMonitorConfiguration</code> , you must set up your own authorization method. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-get-started-authorization.html">Authorize your application to send data to AWS</a> .
         *                                <p>
         *                                If you omit this argument, the sample rate used for CloudWatch RUM is set to 10% of the user sessions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder appMonitorConfiguration(software.amazon.awscdk.services.rum.CfnAppMonitor.AppMonitorConfigurationProperty appMonitorConfiguration) {
            this.appMonitorConfiguration = appMonitorConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppMonitorProps#getAppMonitorConfiguration}
         * @param appMonitorConfiguration A structure that contains much of the configuration data for the app monitor.
         *                                If you are using Amazon Cognito for authorization, you must include this structure in your request, and it must include the ID of the Amazon Cognito identity pool to use for authorization. If you don't include <code>AppMonitorConfiguration</code> , you must set up your own authorization method. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-get-started-authorization.html">Authorize your application to send data to AWS</a> .
         *                                <p>
         *                                If you omit this argument, the sample rate used for CloudWatch RUM is set to 10% of the user sessions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder appMonitorConfiguration(software.amazon.awscdk.IResolvable appMonitorConfiguration) {
            this.appMonitorConfiguration = appMonitorConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppMonitorProps#getCwLogEnabled}
         * @param cwLogEnabled Data collected by CloudWatch RUM is kept by RUM for 30 days and then deleted.
         *                     This parameter specifies whether CloudWatch RUM sends a copy of this telemetry data to Amazon CloudWatch Logs in your account. This enables you to keep the telemetry data for more than 30 days, but it does incur Amazon CloudWatch Logs charges.
         *                     <p>
         *                     If you omit this parameter, the default is <code>false</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cwLogEnabled(java.lang.Boolean cwLogEnabled) {
            this.cwLogEnabled = cwLogEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppMonitorProps#getCwLogEnabled}
         * @param cwLogEnabled Data collected by CloudWatch RUM is kept by RUM for 30 days and then deleted.
         *                     This parameter specifies whether CloudWatch RUM sends a copy of this telemetry data to Amazon CloudWatch Logs in your account. This enables you to keep the telemetry data for more than 30 days, but it does incur Amazon CloudWatch Logs charges.
         *                     <p>
         *                     If you omit this parameter, the default is <code>false</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cwLogEnabled(software.amazon.awscdk.IResolvable cwLogEnabled) {
            this.cwLogEnabled = cwLogEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppMonitorProps#getTags}
         * @param tags Assigns one or more tags (key-value pairs) to the app monitor.
         *             Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.
         *             <p>
         *             Tags don't have any semantic meaning to AWS and are interpreted strictly as strings of characters.
         *             <p>
         *             You can associate as many as 50 tags with an app monitor.
         *             <p>
         *             For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS resources</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnAppMonitorProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnAppMonitorProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnAppMonitorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnAppMonitorProps {
        private final java.lang.String domain;
        private final java.lang.String name;
        private final java.lang.Object appMonitorConfiguration;
        private final java.lang.Object cwLogEnabled;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.domain = software.amazon.jsii.Kernel.get(this, "domain", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.appMonitorConfiguration = software.amazon.jsii.Kernel.get(this, "appMonitorConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.cwLogEnabled = software.amazon.jsii.Kernel.get(this, "cwLogEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.domain = java.util.Objects.requireNonNull(builder.domain, "domain is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.appMonitorConfiguration = builder.appMonitorConfiguration;
            this.cwLogEnabled = builder.cwLogEnabled;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getDomain() {
            return this.domain;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getAppMonitorConfiguration() {
            return this.appMonitorConfiguration;
        }

        @Override
        public final java.lang.Object getCwLogEnabled() {
            return this.cwLogEnabled;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("domain", om.valueToTree(this.getDomain()));
            data.set("name", om.valueToTree(this.getName()));
            if (this.getAppMonitorConfiguration() != null) {
                data.set("appMonitorConfiguration", om.valueToTree(this.getAppMonitorConfiguration()));
            }
            if (this.getCwLogEnabled() != null) {
                data.set("cwLogEnabled", om.valueToTree(this.getCwLogEnabled()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rum.CfnAppMonitorProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnAppMonitorProps.Jsii$Proxy that = (CfnAppMonitorProps.Jsii$Proxy) o;

            if (!domain.equals(that.domain)) return false;
            if (!name.equals(that.name)) return false;
            if (this.appMonitorConfiguration != null ? !this.appMonitorConfiguration.equals(that.appMonitorConfiguration) : that.appMonitorConfiguration != null) return false;
            if (this.cwLogEnabled != null ? !this.cwLogEnabled.equals(that.cwLogEnabled) : that.cwLogEnabled != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.domain.hashCode();
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.appMonitorConfiguration != null ? this.appMonitorConfiguration.hashCode() : 0);
            result = 31 * result + (this.cwLogEnabled != null ? this.cwLogEnabled.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
