package software.amazon.awscdk.services.rds;

/**
 * A CloudFormation `AWS::RDS::DBParameterGroup`.
 * <p>
 * The <code>AWS::RDS::DBParameterGroup</code> resource creates a custom parameter group for an RDS database family.
 * <p>
 * This type can be declared in a template and referenced in the <code>DBParameterGroupName</code> property of an <code>[AWS::RDS::DBInstance](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html)</code> resource.
 * <p>
 * For information about configuring parameters for Amazon RDS DB instances, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithParamGroups.html">Working with DB parameter groups</a> in the <em>Amazon RDS User Guide</em> .
 * <p>
 * For information about configuring parameters for Amazon Aurora DB instances, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_WorkingWithParamGroups.html">Working with DB parameter groups and DB cluster parameter groups</a> in the <em>Amazon Aurora User Guide</em> .
 * <p>
 * <blockquote>
 * <p>
 * Applying a parameter group to a DB instance may require the DB instance to reboot, resulting in a database outage for the duration of the reboot.
 * <p>
 * </blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.rds.*;
 * CfnDBParameterGroup cfnDBParameterGroup = CfnDBParameterGroup.Builder.create(this, "MyCfnDBParameterGroup")
 *         .description("description")
 *         .family("family")
 *         // the properties below are optional
 *         .parameters(Map.of(
 *                 "parametersKey", "parameters"))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-29T04:34:12.163Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.CfnDBParameterGroup")
public class CfnDBParameterGroup extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnDBParameterGroup(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDBParameterGroup(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.CfnDBParameterGroup.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::RDS::DBParameterGroup`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDBParameterGroup(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.CfnDBParameterGroupProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tags to assign to the DB parameter group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * Provides the customer-specified description for this DB Parameter Group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Provides the customer-specified description for this DB Parameter Group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", java.util.Objects.requireNonNull(value, "description is required"));
    }

    /**
     * The DB parameter group family name.
     * <p>
     * A DB parameter group can be associated with one and only one DB parameter group family, and can be applied only to a DB instance running a DB engine and engine version compatible with that DB parameter group family.
     * <p>
     * <blockquote>
     * <p>
     * The DB parameter group family can't be changed when updating a DB parameter group.
     * <p>
     * </blockquote>
     * <p>
     * To list all of the available parameter group families, use the following command:
     * <p>
     * <code>aws rds describe-db-engine-versions --query "DBEngineVersions[].DBParameterGroupFamily"</code>
     * <p>
     * The output contains duplicates.
     * <p>
     * For more information, see <code>[CreateDBParameterGroup](https://docs.aws.amazon.com//AmazonRDS/latest/APIReference/API_CreateDBParameterGroup.html)</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getFamily() {
        return software.amazon.jsii.Kernel.get(this, "family", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The DB parameter group family name.
     * <p>
     * A DB parameter group can be associated with one and only one DB parameter group family, and can be applied only to a DB instance running a DB engine and engine version compatible with that DB parameter group family.
     * <p>
     * <blockquote>
     * <p>
     * The DB parameter group family can't be changed when updating a DB parameter group.
     * <p>
     * </blockquote>
     * <p>
     * To list all of the available parameter group families, use the following command:
     * <p>
     * <code>aws rds describe-db-engine-versions --query "DBEngineVersions[].DBParameterGroupFamily"</code>
     * <p>
     * The output contains duplicates.
     * <p>
     * For more information, see <code>[CreateDBParameterGroup](https://docs.aws.amazon.com//AmazonRDS/latest/APIReference/API_CreateDBParameterGroup.html)</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFamily(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "family", java.util.Objects.requireNonNull(value, "family is required"));
    }

    /**
     * An array of parameter names and values for the parameter update.
     * <p>
     * At least one parameter name and value must be supplied. Subsequent arguments are optional.
     * <p>
     * For more information about DB parameters and DB parameter groups for Amazon RDS DB engines, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithParamGroups.html">Working with DB Parameter Groups</a> in the <em>Amazon RDS User Guide</em> .
     * <p>
     * For more information about DB cluster and DB instance parameters and parameter groups for Amazon Aurora DB engines, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_WorkingWithParamGroups.html">Working with DB Parameter Groups and DB Cluster Parameter Groups</a> in the <em>Amazon Aurora User Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * AWS CloudFormation doesn't support specifying an apply method for each individual parameter. The default apply method for each parameter is used.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getParameters() {
        return software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An array of parameter names and values for the parameter update.
     * <p>
     * At least one parameter name and value must be supplied. Subsequent arguments are optional.
     * <p>
     * For more information about DB parameters and DB parameter groups for Amazon RDS DB engines, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithParamGroups.html">Working with DB Parameter Groups</a> in the <em>Amazon RDS User Guide</em> .
     * <p>
     * For more information about DB cluster and DB instance parameters and parameter groups for Amazon Aurora DB engines, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_WorkingWithParamGroups.html">Working with DB Parameter Groups and DB Cluster Parameter Groups</a> in the <em>Amazon Aurora User Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * AWS CloudFormation doesn't support specifying an apply method for each individual parameter. The default apply method for each parameter is used.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setParameters(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "parameters", value);
    }

    /**
     * An array of parameter names and values for the parameter update.
     * <p>
     * At least one parameter name and value must be supplied. Subsequent arguments are optional.
     * <p>
     * For more information about DB parameters and DB parameter groups for Amazon RDS DB engines, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithParamGroups.html">Working with DB Parameter Groups</a> in the <em>Amazon RDS User Guide</em> .
     * <p>
     * For more information about DB cluster and DB instance parameters and parameter groups for Amazon Aurora DB engines, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_WorkingWithParamGroups.html">Working with DB Parameter Groups and DB Cluster Parameter Groups</a> in the <em>Amazon Aurora User Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * AWS CloudFormation doesn't support specifying an apply method for each individual parameter. The default apply method for each parameter is used.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setParameters(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "parameters", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.rds.CfnDBParameterGroup}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.rds.CfnDBParameterGroup> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.rds.CfnDBParameterGroupProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.rds.CfnDBParameterGroupProps.Builder();
        }

        /**
         * Provides the customer-specified description for this DB Parameter Group.
         * <p>
         * @return {@code this}
         * @param description Provides the customer-specified description for this DB Parameter Group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The DB parameter group family name.
         * <p>
         * A DB parameter group can be associated with one and only one DB parameter group family, and can be applied only to a DB instance running a DB engine and engine version compatible with that DB parameter group family.
         * <p>
         * <blockquote>
         * <p>
         * The DB parameter group family can't be changed when updating a DB parameter group.
         * <p>
         * </blockquote>
         * <p>
         * To list all of the available parameter group families, use the following command:
         * <p>
         * <code>aws rds describe-db-engine-versions --query "DBEngineVersions[].DBParameterGroupFamily"</code>
         * <p>
         * The output contains duplicates.
         * <p>
         * For more information, see <code>[CreateDBParameterGroup](https://docs.aws.amazon.com//AmazonRDS/latest/APIReference/API_CreateDBParameterGroup.html)</code> .
         * <p>
         * @return {@code this}
         * @param family The DB parameter group family name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder family(final java.lang.String family) {
            this.props.family(family);
            return this;
        }

        /**
         * An array of parameter names and values for the parameter update.
         * <p>
         * At least one parameter name and value must be supplied. Subsequent arguments are optional.
         * <p>
         * For more information about DB parameters and DB parameter groups for Amazon RDS DB engines, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithParamGroups.html">Working with DB Parameter Groups</a> in the <em>Amazon RDS User Guide</em> .
         * <p>
         * For more information about DB cluster and DB instance parameters and parameter groups for Amazon Aurora DB engines, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_WorkingWithParamGroups.html">Working with DB Parameter Groups and DB Cluster Parameter Groups</a> in the <em>Amazon Aurora User Guide</em> .
         * <p>
         * <blockquote>
         * <p>
         * AWS CloudFormation doesn't support specifying an apply method for each individual parameter. The default apply method for each parameter is used.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param parameters An array of parameter names and values for the parameter update. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(final software.amazon.awscdk.IResolvable parameters) {
            this.props.parameters(parameters);
            return this;
        }
        /**
         * An array of parameter names and values for the parameter update.
         * <p>
         * At least one parameter name and value must be supplied. Subsequent arguments are optional.
         * <p>
         * For more information about DB parameters and DB parameter groups for Amazon RDS DB engines, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithParamGroups.html">Working with DB Parameter Groups</a> in the <em>Amazon RDS User Guide</em> .
         * <p>
         * For more information about DB cluster and DB instance parameters and parameter groups for Amazon Aurora DB engines, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_WorkingWithParamGroups.html">Working with DB Parameter Groups and DB Cluster Parameter Groups</a> in the <em>Amazon Aurora User Guide</em> .
         * <p>
         * <blockquote>
         * <p>
         * AWS CloudFormation doesn't support specifying an apply method for each individual parameter. The default apply method for each parameter is used.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param parameters An array of parameter names and values for the parameter update. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(final java.util.Map<java.lang.String, java.lang.String> parameters) {
            this.props.parameters(parameters);
            return this;
        }

        /**
         * Tags to assign to the DB parameter group.
         * <p>
         * @return {@code this}
         * @param tags Tags to assign to the DB parameter group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.rds.CfnDBParameterGroup}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.rds.CfnDBParameterGroup build() {
            return new software.amazon.awscdk.services.rds.CfnDBParameterGroup(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
