package software.amazon.awscdk.services.pinpoint;

/**
 * Properties for defining a `CfnCampaign`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.pinpoint.*;
 * Object attributes;
 * Object customConfig;
 * Object metrics;
 * Object tags;
 * CfnCampaignProps cfnCampaignProps = CfnCampaignProps.builder()
 *         .applicationId("applicationId")
 *         .messageConfiguration(MessageConfigurationProperty.builder()
 *                 .admMessage(MessageProperty.builder()
 *                         .action("action")
 *                         .body("body")
 *                         .imageIconUrl("imageIconUrl")
 *                         .imageSmallIconUrl("imageSmallIconUrl")
 *                         .imageUrl("imageUrl")
 *                         .jsonBody("jsonBody")
 *                         .mediaUrl("mediaUrl")
 *                         .rawContent("rawContent")
 *                         .silentPush(false)
 *                         .timeToLive(123)
 *                         .title("title")
 *                         .url("url")
 *                         .build())
 *                 .apnsMessage(MessageProperty.builder()
 *                         .action("action")
 *                         .body("body")
 *                         .imageIconUrl("imageIconUrl")
 *                         .imageSmallIconUrl("imageSmallIconUrl")
 *                         .imageUrl("imageUrl")
 *                         .jsonBody("jsonBody")
 *                         .mediaUrl("mediaUrl")
 *                         .rawContent("rawContent")
 *                         .silentPush(false)
 *                         .timeToLive(123)
 *                         .title("title")
 *                         .url("url")
 *                         .build())
 *                 .baiduMessage(MessageProperty.builder()
 *                         .action("action")
 *                         .body("body")
 *                         .imageIconUrl("imageIconUrl")
 *                         .imageSmallIconUrl("imageSmallIconUrl")
 *                         .imageUrl("imageUrl")
 *                         .jsonBody("jsonBody")
 *                         .mediaUrl("mediaUrl")
 *                         .rawContent("rawContent")
 *                         .silentPush(false)
 *                         .timeToLive(123)
 *                         .title("title")
 *                         .url("url")
 *                         .build())
 *                 .defaultMessage(MessageProperty.builder()
 *                         .action("action")
 *                         .body("body")
 *                         .imageIconUrl("imageIconUrl")
 *                         .imageSmallIconUrl("imageSmallIconUrl")
 *                         .imageUrl("imageUrl")
 *                         .jsonBody("jsonBody")
 *                         .mediaUrl("mediaUrl")
 *                         .rawContent("rawContent")
 *                         .silentPush(false)
 *                         .timeToLive(123)
 *                         .title("title")
 *                         .url("url")
 *                         .build())
 *                 .emailMessage(CampaignEmailMessageProperty.builder()
 *                         .body("body")
 *                         .fromAddress("fromAddress")
 *                         .htmlBody("htmlBody")
 *                         .title("title")
 *                         .build())
 *                 .gcmMessage(MessageProperty.builder()
 *                         .action("action")
 *                         .body("body")
 *                         .imageIconUrl("imageIconUrl")
 *                         .imageSmallIconUrl("imageSmallIconUrl")
 *                         .imageUrl("imageUrl")
 *                         .jsonBody("jsonBody")
 *                         .mediaUrl("mediaUrl")
 *                         .rawContent("rawContent")
 *                         .silentPush(false)
 *                         .timeToLive(123)
 *                         .title("title")
 *                         .url("url")
 *                         .build())
 *                 .inAppMessage(CampaignInAppMessageProperty.builder()
 *                         .content(List.of(InAppMessageContentProperty.builder()
 *                                 .backgroundColor("backgroundColor")
 *                                 .bodyConfig(InAppMessageBodyConfigProperty.builder()
 *                                         .alignment("alignment")
 *                                         .body("body")
 *                                         .textColor("textColor")
 *                                         .build())
 *                                 .headerConfig(InAppMessageHeaderConfigProperty.builder()
 *                                         .alignment("alignment")
 *                                         .header("header")
 *                                         .textColor("textColor")
 *                                         .build())
 *                                 .imageUrl("imageUrl")
 *                                 .primaryBtn(InAppMessageButtonProperty.builder()
 *                                         .android(OverrideButtonConfigurationProperty.builder()
 *                                                 .buttonAction("buttonAction")
 *                                                 .link("link")
 *                                                 .build())
 *                                         .defaultConfig(DefaultButtonConfigurationProperty.builder()
 *                                                 .backgroundColor("backgroundColor")
 *                                                 .borderRadius(123)
 *                                                 .buttonAction("buttonAction")
 *                                                 .link("link")
 *                                                 .text("text")
 *                                                 .textColor("textColor")
 *                                                 .build())
 *                                         .ios(OverrideButtonConfigurationProperty.builder()
 *                                                 .buttonAction("buttonAction")
 *                                                 .link("link")
 *                                                 .build())
 *                                         .web(OverrideButtonConfigurationProperty.builder()
 *                                                 .buttonAction("buttonAction")
 *                                                 .link("link")
 *                                                 .build())
 *                                         .build())
 *                                 .secondaryBtn(InAppMessageButtonProperty.builder()
 *                                         .android(OverrideButtonConfigurationProperty.builder()
 *                                                 .buttonAction("buttonAction")
 *                                                 .link("link")
 *                                                 .build())
 *                                         .defaultConfig(DefaultButtonConfigurationProperty.builder()
 *                                                 .backgroundColor("backgroundColor")
 *                                                 .borderRadius(123)
 *                                                 .buttonAction("buttonAction")
 *                                                 .link("link")
 *                                                 .text("text")
 *                                                 .textColor("textColor")
 *                                                 .build())
 *                                         .ios(OverrideButtonConfigurationProperty.builder()
 *                                                 .buttonAction("buttonAction")
 *                                                 .link("link")
 *                                                 .build())
 *                                         .web(OverrideButtonConfigurationProperty.builder()
 *                                                 .buttonAction("buttonAction")
 *                                                 .link("link")
 *                                                 .build())
 *                                         .build())
 *                                 .build()))
 *                         .customConfig(customConfig)
 *                         .layout("layout")
 *                         .build())
 *                 .smsMessage(CampaignSmsMessageProperty.builder()
 *                         .body("body")
 *                         .entityId("entityId")
 *                         .messageType("messageType")
 *                         .originationNumber("originationNumber")
 *                         .senderId("senderId")
 *                         .templateId("templateId")
 *                         .build())
 *                 .build())
 *         .name("name")
 *         .schedule(ScheduleProperty.builder()
 *                 .endTime("endTime")
 *                 .eventFilter(CampaignEventFilterProperty.builder()
 *                         .dimensions(EventDimensionsProperty.builder()
 *                                 .attributes(attributes)
 *                                 .eventType(SetDimensionProperty.builder()
 *                                         .dimensionType("dimensionType")
 *                                         .values(List.of("values"))
 *                                         .build())
 *                                 .metrics(metrics)
 *                                 .build())
 *                         .filterType("filterType")
 *                         .build())
 *                 .frequency("frequency")
 *                 .isLocalTime(false)
 *                 .quietTime(QuietTimeProperty.builder()
 *                         .end("end")
 *                         .start("start")
 *                         .build())
 *                 .startTime("startTime")
 *                 .timeZone("timeZone")
 *                 .build())
 *         .segmentId("segmentId")
 *         // the properties below are optional
 *         .additionalTreatments(List.of(WriteTreatmentResourceProperty.builder()
 *                 .messageConfiguration(MessageConfigurationProperty.builder()
 *                         .admMessage(MessageProperty.builder()
 *                                 .action("action")
 *                                 .body("body")
 *                                 .imageIconUrl("imageIconUrl")
 *                                 .imageSmallIconUrl("imageSmallIconUrl")
 *                                 .imageUrl("imageUrl")
 *                                 .jsonBody("jsonBody")
 *                                 .mediaUrl("mediaUrl")
 *                                 .rawContent("rawContent")
 *                                 .silentPush(false)
 *                                 .timeToLive(123)
 *                                 .title("title")
 *                                 .url("url")
 *                                 .build())
 *                         .apnsMessage(MessageProperty.builder()
 *                                 .action("action")
 *                                 .body("body")
 *                                 .imageIconUrl("imageIconUrl")
 *                                 .imageSmallIconUrl("imageSmallIconUrl")
 *                                 .imageUrl("imageUrl")
 *                                 .jsonBody("jsonBody")
 *                                 .mediaUrl("mediaUrl")
 *                                 .rawContent("rawContent")
 *                                 .silentPush(false)
 *                                 .timeToLive(123)
 *                                 .title("title")
 *                                 .url("url")
 *                                 .build())
 *                         .baiduMessage(MessageProperty.builder()
 *                                 .action("action")
 *                                 .body("body")
 *                                 .imageIconUrl("imageIconUrl")
 *                                 .imageSmallIconUrl("imageSmallIconUrl")
 *                                 .imageUrl("imageUrl")
 *                                 .jsonBody("jsonBody")
 *                                 .mediaUrl("mediaUrl")
 *                                 .rawContent("rawContent")
 *                                 .silentPush(false)
 *                                 .timeToLive(123)
 *                                 .title("title")
 *                                 .url("url")
 *                                 .build())
 *                         .defaultMessage(MessageProperty.builder()
 *                                 .action("action")
 *                                 .body("body")
 *                                 .imageIconUrl("imageIconUrl")
 *                                 .imageSmallIconUrl("imageSmallIconUrl")
 *                                 .imageUrl("imageUrl")
 *                                 .jsonBody("jsonBody")
 *                                 .mediaUrl("mediaUrl")
 *                                 .rawContent("rawContent")
 *                                 .silentPush(false)
 *                                 .timeToLive(123)
 *                                 .title("title")
 *                                 .url("url")
 *                                 .build())
 *                         .emailMessage(CampaignEmailMessageProperty.builder()
 *                                 .body("body")
 *                                 .fromAddress("fromAddress")
 *                                 .htmlBody("htmlBody")
 *                                 .title("title")
 *                                 .build())
 *                         .gcmMessage(MessageProperty.builder()
 *                                 .action("action")
 *                                 .body("body")
 *                                 .imageIconUrl("imageIconUrl")
 *                                 .imageSmallIconUrl("imageSmallIconUrl")
 *                                 .imageUrl("imageUrl")
 *                                 .jsonBody("jsonBody")
 *                                 .mediaUrl("mediaUrl")
 *                                 .rawContent("rawContent")
 *                                 .silentPush(false)
 *                                 .timeToLive(123)
 *                                 .title("title")
 *                                 .url("url")
 *                                 .build())
 *                         .inAppMessage(CampaignInAppMessageProperty.builder()
 *                                 .content(List.of(InAppMessageContentProperty.builder()
 *                                         .backgroundColor("backgroundColor")
 *                                         .bodyConfig(InAppMessageBodyConfigProperty.builder()
 *                                                 .alignment("alignment")
 *                                                 .body("body")
 *                                                 .textColor("textColor")
 *                                                 .build())
 *                                         .headerConfig(InAppMessageHeaderConfigProperty.builder()
 *                                                 .alignment("alignment")
 *                                                 .header("header")
 *                                                 .textColor("textColor")
 *                                                 .build())
 *                                         .imageUrl("imageUrl")
 *                                         .primaryBtn(InAppMessageButtonProperty.builder()
 *                                                 .android(OverrideButtonConfigurationProperty.builder()
 *                                                         .buttonAction("buttonAction")
 *                                                         .link("link")
 *                                                         .build())
 *                                                 .defaultConfig(DefaultButtonConfigurationProperty.builder()
 *                                                         .backgroundColor("backgroundColor")
 *                                                         .borderRadius(123)
 *                                                         .buttonAction("buttonAction")
 *                                                         .link("link")
 *                                                         .text("text")
 *                                                         .textColor("textColor")
 *                                                         .build())
 *                                                 .ios(OverrideButtonConfigurationProperty.builder()
 *                                                         .buttonAction("buttonAction")
 *                                                         .link("link")
 *                                                         .build())
 *                                                 .web(OverrideButtonConfigurationProperty.builder()
 *                                                         .buttonAction("buttonAction")
 *                                                         .link("link")
 *                                                         .build())
 *                                                 .build())
 *                                         .secondaryBtn(InAppMessageButtonProperty.builder()
 *                                                 .android(OverrideButtonConfigurationProperty.builder()
 *                                                         .buttonAction("buttonAction")
 *                                                         .link("link")
 *                                                         .build())
 *                                                 .defaultConfig(DefaultButtonConfigurationProperty.builder()
 *                                                         .backgroundColor("backgroundColor")
 *                                                         .borderRadius(123)
 *                                                         .buttonAction("buttonAction")
 *                                                         .link("link")
 *                                                         .text("text")
 *                                                         .textColor("textColor")
 *                                                         .build())
 *                                                 .ios(OverrideButtonConfigurationProperty.builder()
 *                                                         .buttonAction("buttonAction")
 *                                                         .link("link")
 *                                                         .build())
 *                                                 .web(OverrideButtonConfigurationProperty.builder()
 *                                                         .buttonAction("buttonAction")
 *                                                         .link("link")
 *                                                         .build())
 *                                                 .build())
 *                                         .build()))
 *                                 .customConfig(customConfig)
 *                                 .layout("layout")
 *                                 .build())
 *                         .smsMessage(CampaignSmsMessageProperty.builder()
 *                                 .body("body")
 *                                 .entityId("entityId")
 *                                 .messageType("messageType")
 *                                 .originationNumber("originationNumber")
 *                                 .senderId("senderId")
 *                                 .templateId("templateId")
 *                                 .build())
 *                         .build())
 *                 .schedule(ScheduleProperty.builder()
 *                         .endTime("endTime")
 *                         .eventFilter(CampaignEventFilterProperty.builder()
 *                                 .dimensions(EventDimensionsProperty.builder()
 *                                         .attributes(attributes)
 *                                         .eventType(SetDimensionProperty.builder()
 *                                                 .dimensionType("dimensionType")
 *                                                 .values(List.of("values"))
 *                                                 .build())
 *                                         .metrics(metrics)
 *                                         .build())
 *                                 .filterType("filterType")
 *                                 .build())
 *                         .frequency("frequency")
 *                         .isLocalTime(false)
 *                         .quietTime(QuietTimeProperty.builder()
 *                                 .end("end")
 *                                 .start("start")
 *                                 .build())
 *                         .startTime("startTime")
 *                         .timeZone("timeZone")
 *                         .build())
 *                 .sizePercent(123)
 *                 .treatmentDescription("treatmentDescription")
 *                 .treatmentName("treatmentName")
 *                 .build()))
 *         .campaignHook(CampaignHookProperty.builder()
 *                 .lambdaFunctionName("lambdaFunctionName")
 *                 .mode("mode")
 *                 .webUrl("webUrl")
 *                 .build())
 *         .description("description")
 *         .holdoutPercent(123)
 *         .isPaused(false)
 *         .limits(LimitsProperty.builder()
 *                 .daily(123)
 *                 .maximumDuration(123)
 *                 .messagesPerSecond(123)
 *                 .session(123)
 *                 .total(123)
 *                 .build())
 *         .priority(123)
 *         .segmentVersion(123)
 *         .tags(tags)
 *         .treatmentDescription("treatmentDescription")
 *         .treatmentName("treatmentName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-29T04:34:11.966Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpoint.CfnCampaignProps")
@software.amazon.jsii.Jsii.Proxy(CfnCampaignProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnCampaignProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The unique identifier for the Amazon Pinpoint application that the campaign is associated with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getApplicationId();

    /**
     * The message configuration settings for the campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getMessageConfiguration();

    /**
     * The name of the campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The schedule settings for the campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getSchedule();

    /**
     * The unique identifier for the segment to associate with the campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSegmentId();

    /**
     * An array of requests that defines additional treatments for the campaign, in addition to the default treatment for the campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAdditionalTreatments() {
        return null;
    }

    /**
     * Specifies the Lambda function to use as a code hook for a campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCampaignHook() {
        return null;
    }

    /**
     * A custom description of the campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The allocated percentage of users (segment members) who shouldn't receive messages from the campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getHoldoutPercent() {
        return null;
    }

    /**
     * Specifies whether to pause the campaign.
     * <p>
     * A paused campaign doesn't run unless you resume it by changing this value to <code>false</code> . If you restart a campaign, the campaign restarts from the beginning and not at the point you paused it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getIsPaused() {
        return null;
    }

    /**
     * The messaging limits for the campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLimits() {
        return null;
    }

    /**
     * An integer between 1 and 5, inclusive, that represents the priority of the in-app message campaign, where 1 is the highest priority and 5 is the lowest.
     * <p>
     * If there are multiple messages scheduled to be displayed at the same time, the priority determines the order in which those messages are displayed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPriority() {
        return null;
    }

    /**
     * The version of the segment to associate with the campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getSegmentVersion() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTags() {
        return null;
    }

    /**
     * A custom description of the default treatment for the campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTreatmentDescription() {
        return null;
    }

    /**
     * A custom name of the default treatment for the campaign, if the campaign has multiple treatments.
     * <p>
     * A <em>treatment</em> is a variation of a campaign that's used for A/B testing.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTreatmentName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnCampaignProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnCampaignProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnCampaignProps> {
        java.lang.String applicationId;
        java.lang.Object messageConfiguration;
        java.lang.String name;
        java.lang.Object schedule;
        java.lang.String segmentId;
        java.lang.Object additionalTreatments;
        java.lang.Object campaignHook;
        java.lang.String description;
        java.lang.Number holdoutPercent;
        java.lang.Object isPaused;
        java.lang.Object limits;
        java.lang.Number priority;
        java.lang.Number segmentVersion;
        java.lang.Object tags;
        java.lang.String treatmentDescription;
        java.lang.String treatmentName;

        /**
         * Sets the value of {@link CfnCampaignProps#getApplicationId}
         * @param applicationId The unique identifier for the Amazon Pinpoint application that the campaign is associated with. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationId(java.lang.String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        /**
         * Sets the value of {@link CfnCampaignProps#getMessageConfiguration}
         * @param messageConfiguration The message configuration settings for the campaign. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder messageConfiguration(software.amazon.awscdk.services.pinpoint.CfnCampaign.MessageConfigurationProperty messageConfiguration) {
            this.messageConfiguration = messageConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnCampaignProps#getMessageConfiguration}
         * @param messageConfiguration The message configuration settings for the campaign. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder messageConfiguration(software.amazon.awscdk.IResolvable messageConfiguration) {
            this.messageConfiguration = messageConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnCampaignProps#getName}
         * @param name The name of the campaign. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnCampaignProps#getSchedule}
         * @param schedule The schedule settings for the campaign. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedule(software.amazon.awscdk.services.pinpoint.CfnCampaign.ScheduleProperty schedule) {
            this.schedule = schedule;
            return this;
        }

        /**
         * Sets the value of {@link CfnCampaignProps#getSchedule}
         * @param schedule The schedule settings for the campaign. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedule(software.amazon.awscdk.IResolvable schedule) {
            this.schedule = schedule;
            return this;
        }

        /**
         * Sets the value of {@link CfnCampaignProps#getSegmentId}
         * @param segmentId The unique identifier for the segment to associate with the campaign. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder segmentId(java.lang.String segmentId) {
            this.segmentId = segmentId;
            return this;
        }

        /**
         * Sets the value of {@link CfnCampaignProps#getAdditionalTreatments}
         * @param additionalTreatments An array of requests that defines additional treatments for the campaign, in addition to the default treatment for the campaign.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder additionalTreatments(software.amazon.awscdk.IResolvable additionalTreatments) {
            this.additionalTreatments = additionalTreatments;
            return this;
        }

        /**
         * Sets the value of {@link CfnCampaignProps#getAdditionalTreatments}
         * @param additionalTreatments An array of requests that defines additional treatments for the campaign, in addition to the default treatment for the campaign.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder additionalTreatments(java.util.List<? extends java.lang.Object> additionalTreatments) {
            this.additionalTreatments = additionalTreatments;
            return this;
        }

        /**
         * Sets the value of {@link CfnCampaignProps#getCampaignHook}
         * @param campaignHook Specifies the Lambda function to use as a code hook for a campaign.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder campaignHook(software.amazon.awscdk.services.pinpoint.CfnCampaign.CampaignHookProperty campaignHook) {
            this.campaignHook = campaignHook;
            return this;
        }

        /**
         * Sets the value of {@link CfnCampaignProps#getCampaignHook}
         * @param campaignHook Specifies the Lambda function to use as a code hook for a campaign.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder campaignHook(software.amazon.awscdk.IResolvable campaignHook) {
            this.campaignHook = campaignHook;
            return this;
        }

        /**
         * Sets the value of {@link CfnCampaignProps#getDescription}
         * @param description A custom description of the campaign.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnCampaignProps#getHoldoutPercent}
         * @param holdoutPercent The allocated percentage of users (segment members) who shouldn't receive messages from the campaign.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder holdoutPercent(java.lang.Number holdoutPercent) {
            this.holdoutPercent = holdoutPercent;
            return this;
        }

        /**
         * Sets the value of {@link CfnCampaignProps#getIsPaused}
         * @param isPaused Specifies whether to pause the campaign.
         *                 A paused campaign doesn't run unless you resume it by changing this value to <code>false</code> . If you restart a campaign, the campaign restarts from the beginning and not at the point you paused it.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isPaused(java.lang.Boolean isPaused) {
            this.isPaused = isPaused;
            return this;
        }

        /**
         * Sets the value of {@link CfnCampaignProps#getIsPaused}
         * @param isPaused Specifies whether to pause the campaign.
         *                 A paused campaign doesn't run unless you resume it by changing this value to <code>false</code> . If you restart a campaign, the campaign restarts from the beginning and not at the point you paused it.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isPaused(software.amazon.awscdk.IResolvable isPaused) {
            this.isPaused = isPaused;
            return this;
        }

        /**
         * Sets the value of {@link CfnCampaignProps#getLimits}
         * @param limits The messaging limits for the campaign.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder limits(software.amazon.awscdk.services.pinpoint.CfnCampaign.LimitsProperty limits) {
            this.limits = limits;
            return this;
        }

        /**
         * Sets the value of {@link CfnCampaignProps#getLimits}
         * @param limits The messaging limits for the campaign.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder limits(software.amazon.awscdk.IResolvable limits) {
            this.limits = limits;
            return this;
        }

        /**
         * Sets the value of {@link CfnCampaignProps#getPriority}
         * @param priority An integer between 1 and 5, inclusive, that represents the priority of the in-app message campaign, where 1 is the highest priority and 5 is the lowest.
         *                 If there are multiple messages scheduled to be displayed at the same time, the priority determines the order in which those messages are displayed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder priority(java.lang.Number priority) {
            this.priority = priority;
            return this;
        }

        /**
         * Sets the value of {@link CfnCampaignProps#getSegmentVersion}
         * @param segmentVersion The version of the segment to associate with the campaign.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder segmentVersion(java.lang.Number segmentVersion) {
            this.segmentVersion = segmentVersion;
            return this;
        }

        /**
         * Sets the value of {@link CfnCampaignProps#getTags}
         * @param tags An array of key-value pairs to apply to this resource.
         *             For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.lang.Object tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnCampaignProps#getTreatmentDescription}
         * @param treatmentDescription A custom description of the default treatment for the campaign.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder treatmentDescription(java.lang.String treatmentDescription) {
            this.treatmentDescription = treatmentDescription;
            return this;
        }

        /**
         * Sets the value of {@link CfnCampaignProps#getTreatmentName}
         * @param treatmentName A custom name of the default treatment for the campaign, if the campaign has multiple treatments.
         *                      A <em>treatment</em> is a variation of a campaign that's used for A/B testing.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder treatmentName(java.lang.String treatmentName) {
            this.treatmentName = treatmentName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnCampaignProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnCampaignProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnCampaignProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnCampaignProps {
        private final java.lang.String applicationId;
        private final java.lang.Object messageConfiguration;
        private final java.lang.String name;
        private final java.lang.Object schedule;
        private final java.lang.String segmentId;
        private final java.lang.Object additionalTreatments;
        private final java.lang.Object campaignHook;
        private final java.lang.String description;
        private final java.lang.Number holdoutPercent;
        private final java.lang.Object isPaused;
        private final java.lang.Object limits;
        private final java.lang.Number priority;
        private final java.lang.Number segmentVersion;
        private final java.lang.Object tags;
        private final java.lang.String treatmentDescription;
        private final java.lang.String treatmentName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.applicationId = software.amazon.jsii.Kernel.get(this, "applicationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.messageConfiguration = software.amazon.jsii.Kernel.get(this, "messageConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.schedule = software.amazon.jsii.Kernel.get(this, "schedule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.segmentId = software.amazon.jsii.Kernel.get(this, "segmentId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.additionalTreatments = software.amazon.jsii.Kernel.get(this, "additionalTreatments", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.campaignHook = software.amazon.jsii.Kernel.get(this, "campaignHook", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.holdoutPercent = software.amazon.jsii.Kernel.get(this, "holdoutPercent", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.isPaused = software.amazon.jsii.Kernel.get(this, "isPaused", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.limits = software.amazon.jsii.Kernel.get(this, "limits", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.priority = software.amazon.jsii.Kernel.get(this, "priority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.segmentVersion = software.amazon.jsii.Kernel.get(this, "segmentVersion", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.treatmentDescription = software.amazon.jsii.Kernel.get(this, "treatmentDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.treatmentName = software.amazon.jsii.Kernel.get(this, "treatmentName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.applicationId = java.util.Objects.requireNonNull(builder.applicationId, "applicationId is required");
            this.messageConfiguration = java.util.Objects.requireNonNull(builder.messageConfiguration, "messageConfiguration is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.schedule = java.util.Objects.requireNonNull(builder.schedule, "schedule is required");
            this.segmentId = java.util.Objects.requireNonNull(builder.segmentId, "segmentId is required");
            this.additionalTreatments = builder.additionalTreatments;
            this.campaignHook = builder.campaignHook;
            this.description = builder.description;
            this.holdoutPercent = builder.holdoutPercent;
            this.isPaused = builder.isPaused;
            this.limits = builder.limits;
            this.priority = builder.priority;
            this.segmentVersion = builder.segmentVersion;
            this.tags = builder.tags;
            this.treatmentDescription = builder.treatmentDescription;
            this.treatmentName = builder.treatmentName;
        }

        @Override
        public final java.lang.String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final java.lang.Object getMessageConfiguration() {
            return this.messageConfiguration;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getSchedule() {
            return this.schedule;
        }

        @Override
        public final java.lang.String getSegmentId() {
            return this.segmentId;
        }

        @Override
        public final java.lang.Object getAdditionalTreatments() {
            return this.additionalTreatments;
        }

        @Override
        public final java.lang.Object getCampaignHook() {
            return this.campaignHook;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Number getHoldoutPercent() {
            return this.holdoutPercent;
        }

        @Override
        public final java.lang.Object getIsPaused() {
            return this.isPaused;
        }

        @Override
        public final java.lang.Object getLimits() {
            return this.limits;
        }

        @Override
        public final java.lang.Number getPriority() {
            return this.priority;
        }

        @Override
        public final java.lang.Number getSegmentVersion() {
            return this.segmentVersion;
        }

        @Override
        public final java.lang.Object getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getTreatmentDescription() {
            return this.treatmentDescription;
        }

        @Override
        public final java.lang.String getTreatmentName() {
            return this.treatmentName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("applicationId", om.valueToTree(this.getApplicationId()));
            data.set("messageConfiguration", om.valueToTree(this.getMessageConfiguration()));
            data.set("name", om.valueToTree(this.getName()));
            data.set("schedule", om.valueToTree(this.getSchedule()));
            data.set("segmentId", om.valueToTree(this.getSegmentId()));
            if (this.getAdditionalTreatments() != null) {
                data.set("additionalTreatments", om.valueToTree(this.getAdditionalTreatments()));
            }
            if (this.getCampaignHook() != null) {
                data.set("campaignHook", om.valueToTree(this.getCampaignHook()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getHoldoutPercent() != null) {
                data.set("holdoutPercent", om.valueToTree(this.getHoldoutPercent()));
            }
            if (this.getIsPaused() != null) {
                data.set("isPaused", om.valueToTree(this.getIsPaused()));
            }
            if (this.getLimits() != null) {
                data.set("limits", om.valueToTree(this.getLimits()));
            }
            if (this.getPriority() != null) {
                data.set("priority", om.valueToTree(this.getPriority()));
            }
            if (this.getSegmentVersion() != null) {
                data.set("segmentVersion", om.valueToTree(this.getSegmentVersion()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTreatmentDescription() != null) {
                data.set("treatmentDescription", om.valueToTree(this.getTreatmentDescription()));
            }
            if (this.getTreatmentName() != null) {
                data.set("treatmentName", om.valueToTree(this.getTreatmentName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pinpoint.CfnCampaignProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnCampaignProps.Jsii$Proxy that = (CfnCampaignProps.Jsii$Proxy) o;

            if (!applicationId.equals(that.applicationId)) return false;
            if (!messageConfiguration.equals(that.messageConfiguration)) return false;
            if (!name.equals(that.name)) return false;
            if (!schedule.equals(that.schedule)) return false;
            if (!segmentId.equals(that.segmentId)) return false;
            if (this.additionalTreatments != null ? !this.additionalTreatments.equals(that.additionalTreatments) : that.additionalTreatments != null) return false;
            if (this.campaignHook != null ? !this.campaignHook.equals(that.campaignHook) : that.campaignHook != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.holdoutPercent != null ? !this.holdoutPercent.equals(that.holdoutPercent) : that.holdoutPercent != null) return false;
            if (this.isPaused != null ? !this.isPaused.equals(that.isPaused) : that.isPaused != null) return false;
            if (this.limits != null ? !this.limits.equals(that.limits) : that.limits != null) return false;
            if (this.priority != null ? !this.priority.equals(that.priority) : that.priority != null) return false;
            if (this.segmentVersion != null ? !this.segmentVersion.equals(that.segmentVersion) : that.segmentVersion != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.treatmentDescription != null ? !this.treatmentDescription.equals(that.treatmentDescription) : that.treatmentDescription != null) return false;
            return this.treatmentName != null ? this.treatmentName.equals(that.treatmentName) : that.treatmentName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.applicationId.hashCode();
            result = 31 * result + (this.messageConfiguration.hashCode());
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.schedule.hashCode());
            result = 31 * result + (this.segmentId.hashCode());
            result = 31 * result + (this.additionalTreatments != null ? this.additionalTreatments.hashCode() : 0);
            result = 31 * result + (this.campaignHook != null ? this.campaignHook.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.holdoutPercent != null ? this.holdoutPercent.hashCode() : 0);
            result = 31 * result + (this.isPaused != null ? this.isPaused.hashCode() : 0);
            result = 31 * result + (this.limits != null ? this.limits.hashCode() : 0);
            result = 31 * result + (this.priority != null ? this.priority.hashCode() : 0);
            result = 31 * result + (this.segmentVersion != null ? this.segmentVersion.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.treatmentDescription != null ? this.treatmentDescription.hashCode() : 0);
            result = 31 * result + (this.treatmentName != null ? this.treatmentName.hashCode() : 0);
            return result;
        }
    }
}
