package software.amazon.awscdk.services.networkfirewall;

/**
 * A CloudFormation `AWS::NetworkFirewall::FirewallPolicy`.
 * <p>
 * Use the <code>FirewallPolicy</code> to define the stateless and stateful network traffic filtering behavior for your <code>Firewall</code> . You can use one firewall policy for multiple firewalls.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.networkfirewall.*;
 * CfnFirewallPolicy cfnFirewallPolicy = CfnFirewallPolicy.Builder.create(this, "MyCfnFirewallPolicy")
 *         .firewallPolicy(FirewallPolicyProperty.builder()
 *                 .statelessDefaultActions(List.of("statelessDefaultActions"))
 *                 .statelessFragmentDefaultActions(List.of("statelessFragmentDefaultActions"))
 *                 // the properties below are optional
 *                 .statefulDefaultActions(List.of("statefulDefaultActions"))
 *                 .statefulEngineOptions(StatefulEngineOptionsProperty.builder()
 *                         .ruleOrder("ruleOrder")
 *                         .build())
 *                 .statefulRuleGroupReferences(List.of(StatefulRuleGroupReferenceProperty.builder()
 *                         .resourceArn("resourceArn")
 *                         // the properties below are optional
 *                         .priority(123)
 *                         .build()))
 *                 .statelessCustomActions(List.of(CustomActionProperty.builder()
 *                         .actionDefinition(ActionDefinitionProperty.builder()
 *                                 .publishMetricAction(PublishMetricActionProperty.builder()
 *                                         .dimensions(List.of(DimensionProperty.builder()
 *                                                 .value("value")
 *                                                 .build()))
 *                                         .build())
 *                                 .build())
 *                         .actionName("actionName")
 *                         .build()))
 *                 .statelessRuleGroupReferences(List.of(StatelessRuleGroupReferenceProperty.builder()
 *                         .priority(123)
 *                         .resourceArn("resourceArn")
 *                         .build()))
 *                 .build())
 *         .firewallPolicyName("firewallPolicyName")
 *         // the properties below are optional
 *         .description("description")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-29T04:34:11.769Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_networkfirewall.CfnFirewallPolicy")
public class CfnFirewallPolicy extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnFirewallPolicy(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnFirewallPolicy(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.networkfirewall.CfnFirewallPolicy.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::NetworkFirewall::FirewallPolicy`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnFirewallPolicy(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.networkfirewall.CfnFirewallPolicyProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the `FirewallPolicy` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrFirewallPolicyArn() {
        return software.amazon.jsii.Kernel.get(this, "attrFirewallPolicyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique ID of the `FirewallPolicy` resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrFirewallPolicyId() {
        return software.amazon.jsii.Kernel.get(this, "attrFirewallPolicyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The traffic filtering behavior of a firewall policy, defined in a collection of stateless and stateful rule groups and other settings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getFirewallPolicy() {
        return software.amazon.jsii.Kernel.get(this, "firewallPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The traffic filtering behavior of a firewall policy, defined in a collection of stateless and stateful rule groups and other settings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFirewallPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.networkfirewall.CfnFirewallPolicy.FirewallPolicyProperty value) {
        software.amazon.jsii.Kernel.set(this, "firewallPolicy", java.util.Objects.requireNonNull(value, "firewallPolicy is required"));
    }

    /**
     * The traffic filtering behavior of a firewall policy, defined in a collection of stateless and stateful rule groups and other settings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFirewallPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "firewallPolicy", java.util.Objects.requireNonNull(value, "firewallPolicy is required"));
    }

    /**
     * The descriptive name of the firewall policy.
     * <p>
     * You can't change the name of a firewall policy after you create it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getFirewallPolicyName() {
        return software.amazon.jsii.Kernel.get(this, "firewallPolicyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The descriptive name of the firewall policy.
     * <p>
     * You can't change the name of a firewall policy after you create it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFirewallPolicyName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "firewallPolicyName", java.util.Objects.requireNonNull(value, "firewallPolicyName is required"));
    }

    /**
     * A description of the firewall policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A description of the firewall policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }
    /**
     * A custom action to use in stateless rule actions settings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.networkfirewall.*;
     * ActionDefinitionProperty actionDefinitionProperty = ActionDefinitionProperty.builder()
     *         .publishMetricAction(PublishMetricActionProperty.builder()
     *                 .dimensions(List.of(DimensionProperty.builder()
     *                         .value("value")
     *                         .build()))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_networkfirewall.CfnFirewallPolicy.ActionDefinitionProperty")
    @software.amazon.jsii.Jsii.Proxy(ActionDefinitionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ActionDefinitionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Stateless inspection criteria that publishes the specified metrics to Amazon CloudWatch for the matching packet.
         * <p>
         * This setting defines a CloudWatch dimension value to be published.
         * <p>
         * You can pair this custom action with any of the standard stateless rule actions. For example, you could pair this in a rule action with the standard action that forwards the packet for stateful inspection. Then, when a packet matches the rule, Network Firewall publishes metrics for the packet and forwards it.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPublishMetricAction() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ActionDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ActionDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ActionDefinitionProperty> {
            java.lang.Object publishMetricAction;

            /**
             * Sets the value of {@link ActionDefinitionProperty#getPublishMetricAction}
             * @param publishMetricAction Stateless inspection criteria that publishes the specified metrics to Amazon CloudWatch for the matching packet.
             *                            This setting defines a CloudWatch dimension value to be published.
             *                            <p>
             *                            You can pair this custom action with any of the standard stateless rule actions. For example, you could pair this in a rule action with the standard action that forwards the packet for stateful inspection. Then, when a packet matches the rule, Network Firewall publishes metrics for the packet and forwards it.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder publishMetricAction(software.amazon.awscdk.services.networkfirewall.CfnFirewallPolicy.PublishMetricActionProperty publishMetricAction) {
                this.publishMetricAction = publishMetricAction;
                return this;
            }

            /**
             * Sets the value of {@link ActionDefinitionProperty#getPublishMetricAction}
             * @param publishMetricAction Stateless inspection criteria that publishes the specified metrics to Amazon CloudWatch for the matching packet.
             *                            This setting defines a CloudWatch dimension value to be published.
             *                            <p>
             *                            You can pair this custom action with any of the standard stateless rule actions. For example, you could pair this in a rule action with the standard action that forwards the packet for stateful inspection. Then, when a packet matches the rule, Network Firewall publishes metrics for the packet and forwards it.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder publishMetricAction(software.amazon.awscdk.IResolvable publishMetricAction) {
                this.publishMetricAction = publishMetricAction;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ActionDefinitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ActionDefinitionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ActionDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ActionDefinitionProperty {
            private final java.lang.Object publishMetricAction;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.publishMetricAction = software.amazon.jsii.Kernel.get(this, "publishMetricAction", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.publishMetricAction = builder.publishMetricAction;
            }

            @Override
            public final java.lang.Object getPublishMetricAction() {
                return this.publishMetricAction;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPublishMetricAction() != null) {
                    data.set("publishMetricAction", om.valueToTree(this.getPublishMetricAction()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_networkfirewall.CfnFirewallPolicy.ActionDefinitionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ActionDefinitionProperty.Jsii$Proxy that = (ActionDefinitionProperty.Jsii$Proxy) o;

                return this.publishMetricAction != null ? this.publishMetricAction.equals(that.publishMetricAction) : that.publishMetricAction == null;
            }

            @Override
            public final int hashCode() {
                int result = this.publishMetricAction != null ? this.publishMetricAction.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * An optional, non-standard action to use for stateless packet handling.
     * <p>
     * You can define this in addition to the standard action that you must specify.
     * <p>
     * You define and name the custom actions that you want to be able to use, and then you reference them by name in your actions settings.
     * <p>
     * You can use custom actions in the following places:
     * <p>
     * <ul>
     * <li>In an <code>RuleGroup.StatelessRulesAndCustomActions</code> . The custom actions are available for use by name inside the <code>StatelessRulesAndCustomActions</code> where you define them. You can use them for your stateless rule actions to specify what to do with a packet that matches the rule's match attributes.</li>
     * <li>In an <code>FirewallPolicy</code> specification, in <code>StatelessCustomActions</code> . The custom actions are available for use inside the policy where you define them. You can use them for the policy's default stateless actions settings to specify what to do with packets that don't match any of the policy's stateless rules.</li>
     * </ul>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.networkfirewall.*;
     * CustomActionProperty customActionProperty = CustomActionProperty.builder()
     *         .actionDefinition(ActionDefinitionProperty.builder()
     *                 .publishMetricAction(PublishMetricActionProperty.builder()
     *                         .dimensions(List.of(DimensionProperty.builder()
     *                                 .value("value")
     *                                 .build()))
     *                         .build())
     *                 .build())
     *         .actionName("actionName")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_networkfirewall.CfnFirewallPolicy.CustomActionProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The custom action associated with the action name.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getActionDefinition();

        /**
         * The descriptive name of the custom action.
         * <p>
         * You can't change the name of a custom action after you create it.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getActionName();

        /**
         * @return a {@link Builder} of {@link CustomActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomActionProperty> {
            java.lang.Object actionDefinition;
            java.lang.String actionName;

            /**
             * Sets the value of {@link CustomActionProperty#getActionDefinition}
             * @param actionDefinition The custom action associated with the action name. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actionDefinition(software.amazon.awscdk.services.networkfirewall.CfnFirewallPolicy.ActionDefinitionProperty actionDefinition) {
                this.actionDefinition = actionDefinition;
                return this;
            }

            /**
             * Sets the value of {@link CustomActionProperty#getActionDefinition}
             * @param actionDefinition The custom action associated with the action name. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actionDefinition(software.amazon.awscdk.IResolvable actionDefinition) {
                this.actionDefinition = actionDefinition;
                return this;
            }

            /**
             * Sets the value of {@link CustomActionProperty#getActionName}
             * @param actionName The descriptive name of the custom action. This parameter is required.
             *                   You can't change the name of a custom action after you create it.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actionName(java.lang.String actionName) {
                this.actionName = actionName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomActionProperty {
            private final java.lang.Object actionDefinition;
            private final java.lang.String actionName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.actionDefinition = software.amazon.jsii.Kernel.get(this, "actionDefinition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.actionName = software.amazon.jsii.Kernel.get(this, "actionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.actionDefinition = java.util.Objects.requireNonNull(builder.actionDefinition, "actionDefinition is required");
                this.actionName = java.util.Objects.requireNonNull(builder.actionName, "actionName is required");
            }

            @Override
            public final java.lang.Object getActionDefinition() {
                return this.actionDefinition;
            }

            @Override
            public final java.lang.String getActionName() {
                return this.actionName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("actionDefinition", om.valueToTree(this.getActionDefinition()));
                data.set("actionName", om.valueToTree(this.getActionName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_networkfirewall.CfnFirewallPolicy.CustomActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomActionProperty.Jsii$Proxy that = (CustomActionProperty.Jsii$Proxy) o;

                if (!actionDefinition.equals(that.actionDefinition)) return false;
                return this.actionName.equals(that.actionName);
            }

            @Override
            public final int hashCode() {
                int result = this.actionDefinition.hashCode();
                result = 31 * result + (this.actionName.hashCode());
                return result;
            }
        }
    }
    /**
     * The value to use in an Amazon CloudWatch custom metric dimension.
     * <p>
     * This is used in the <code>PublishMetrics</code> custom action. A CloudWatch custom metric dimension is a name/value pair that's part of the identity of a metric.
     * <p>
     * AWS Network Firewall sets the dimension name to <code>CustomAction</code> and you provide the dimension value.
     * <p>
     * For more information about CloudWatch custom metric dimensions, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/publishingMetrics.html#usingDimensions">Publishing Custom Metrics</a> in the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/WhatIsCloudWatch.html">Amazon CloudWatch User Guide</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.networkfirewall.*;
     * DimensionProperty dimensionProperty = DimensionProperty.builder()
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_networkfirewall.CfnFirewallPolicy.DimensionProperty")
    @software.amazon.jsii.Jsii.Proxy(DimensionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DimensionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The value to use in the custom metric dimension.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link DimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DimensionProperty> {
            java.lang.String value;

            /**
             * Sets the value of {@link DimensionProperty#getValue}
             * @param value The value to use in the custom metric dimension. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DimensionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DimensionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DimensionProperty {
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_networkfirewall.CfnFirewallPolicy.DimensionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DimensionProperty.Jsii$Proxy that = (DimensionProperty.Jsii$Proxy) o;

                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.value.hashCode();
                return result;
            }
        }
    }
    /**
     * The traffic filtering behavior of a firewall policy, defined in a collection of stateless and stateful rule groups and other settings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.networkfirewall.*;
     * FirewallPolicyProperty firewallPolicyProperty = FirewallPolicyProperty.builder()
     *         .statelessDefaultActions(List.of("statelessDefaultActions"))
     *         .statelessFragmentDefaultActions(List.of("statelessFragmentDefaultActions"))
     *         // the properties below are optional
     *         .statefulDefaultActions(List.of("statefulDefaultActions"))
     *         .statefulEngineOptions(StatefulEngineOptionsProperty.builder()
     *                 .ruleOrder("ruleOrder")
     *                 .build())
     *         .statefulRuleGroupReferences(List.of(StatefulRuleGroupReferenceProperty.builder()
     *                 .resourceArn("resourceArn")
     *                 // the properties below are optional
     *                 .priority(123)
     *                 .build()))
     *         .statelessCustomActions(List.of(CustomActionProperty.builder()
     *                 .actionDefinition(ActionDefinitionProperty.builder()
     *                         .publishMetricAction(PublishMetricActionProperty.builder()
     *                                 .dimensions(List.of(DimensionProperty.builder()
     *                                         .value("value")
     *                                         .build()))
     *                                 .build())
     *                         .build())
     *                 .actionName("actionName")
     *                 .build()))
     *         .statelessRuleGroupReferences(List.of(StatelessRuleGroupReferenceProperty.builder()
     *                 .priority(123)
     *                 .resourceArn("resourceArn")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_networkfirewall.CfnFirewallPolicy.FirewallPolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(FirewallPolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FirewallPolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The actions to take on a packet if it doesn't match any of the stateless rules in the policy.
         * <p>
         * If you want non-matching packets to be forwarded for stateful inspection, specify <code>aws:forward_to_sfe</code> .
         * <p>
         * You must specify one of the standard actions: <code>aws:pass</code> , <code>aws:drop</code> , or <code>aws:forward_to_sfe</code> . In addition, you can specify custom actions that are compatible with your standard section choice.
         * <p>
         * For example, you could specify <code>["aws:pass"]</code> or you could specify <code>["aws:pass", “customActionName”]</code> . For information about compatibility, see the custom action descriptions.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getStatelessDefaultActions();

        /**
         * The actions to take on a fragmented packet if it doesn't match any of the stateless rules in the policy.
         * <p>
         * If you want non-matching fragmented packets to be forwarded for stateful inspection, specify <code>aws:forward_to_sfe</code> .
         * <p>
         * You must specify one of the standard actions: <code>aws:pass</code> , <code>aws:drop</code> , or <code>aws:forward_to_sfe</code> . In addition, you can specify custom actions that are compatible with your standard section choice.
         * <p>
         * For example, you could specify <code>["aws:pass"]</code> or you could specify <code>["aws:pass", “customActionName”]</code> . For information about compatibility, see the custom action descriptions.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getStatelessFragmentDefaultActions();

        /**
         * The default actions to take on a packet that doesn't match any stateful rules.
         * <p>
         * The stateful default action is optional, and is only valid when using the strict rule order.
         * <p>
         * Valid values of the stateful default action:
         * <p>
         * <ul>
         * <li>aws:drop_strict</li>
         * <li>aws:drop_established</li>
         * <li>aws:alert_strict</li>
         * <li>aws:alert_established</li>
         * </ul>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/suricata-rule-evaluation-order.html#suricata-strict-rule-evaluation-order.html">Strict evaluation order</a> in the <em>AWS Network Firewall Developer Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getStatefulDefaultActions() {
            return null;
        }

        /**
         * Additional options governing how Network Firewall handles stateful rules.
         * <p>
         * The stateful rule groups that you use in your policy must have stateful rule options settings that are compatible with these settings.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStatefulEngineOptions() {
            return null;
        }

        /**
         * References to the stateful rule groups that are used in the policy.
         * <p>
         * These define the inspection criteria in stateful rules.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStatefulRuleGroupReferences() {
            return null;
        }

        /**
         * The custom action definitions that are available for use in the firewall policy's `StatelessDefaultActions` setting.
         * <p>
         * You name each custom action that you define, and then you can use it by name in your default actions specifications.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStatelessCustomActions() {
            return null;
        }

        /**
         * References to the stateless rule groups that are used in the policy.
         * <p>
         * These define the matching criteria in stateless rules.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStatelessRuleGroupReferences() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FirewallPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FirewallPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FirewallPolicyProperty> {
            java.util.List<java.lang.String> statelessDefaultActions;
            java.util.List<java.lang.String> statelessFragmentDefaultActions;
            java.util.List<java.lang.String> statefulDefaultActions;
            java.lang.Object statefulEngineOptions;
            java.lang.Object statefulRuleGroupReferences;
            java.lang.Object statelessCustomActions;
            java.lang.Object statelessRuleGroupReferences;

            /**
             * Sets the value of {@link FirewallPolicyProperty#getStatelessDefaultActions}
             * @param statelessDefaultActions The actions to take on a packet if it doesn't match any of the stateless rules in the policy. This parameter is required.
             *                                If you want non-matching packets to be forwarded for stateful inspection, specify <code>aws:forward_to_sfe</code> .
             *                                <p>
             *                                You must specify one of the standard actions: <code>aws:pass</code> , <code>aws:drop</code> , or <code>aws:forward_to_sfe</code> . In addition, you can specify custom actions that are compatible with your standard section choice.
             *                                <p>
             *                                For example, you could specify <code>["aws:pass"]</code> or you could specify <code>["aws:pass", “customActionName”]</code> . For information about compatibility, see the custom action descriptions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statelessDefaultActions(java.util.List<java.lang.String> statelessDefaultActions) {
                this.statelessDefaultActions = statelessDefaultActions;
                return this;
            }

            /**
             * Sets the value of {@link FirewallPolicyProperty#getStatelessFragmentDefaultActions}
             * @param statelessFragmentDefaultActions The actions to take on a fragmented packet if it doesn't match any of the stateless rules in the policy. This parameter is required.
             *                                        If you want non-matching fragmented packets to be forwarded for stateful inspection, specify <code>aws:forward_to_sfe</code> .
             *                                        <p>
             *                                        You must specify one of the standard actions: <code>aws:pass</code> , <code>aws:drop</code> , or <code>aws:forward_to_sfe</code> . In addition, you can specify custom actions that are compatible with your standard section choice.
             *                                        <p>
             *                                        For example, you could specify <code>["aws:pass"]</code> or you could specify <code>["aws:pass", “customActionName”]</code> . For information about compatibility, see the custom action descriptions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statelessFragmentDefaultActions(java.util.List<java.lang.String> statelessFragmentDefaultActions) {
                this.statelessFragmentDefaultActions = statelessFragmentDefaultActions;
                return this;
            }

            /**
             * Sets the value of {@link FirewallPolicyProperty#getStatefulDefaultActions}
             * @param statefulDefaultActions The default actions to take on a packet that doesn't match any stateful rules.
             *                               The stateful default action is optional, and is only valid when using the strict rule order.
             *                               <p>
             *                               Valid values of the stateful default action:
             *                               <p>
             *                               <ul>
             *                               <li>aws:drop_strict</li>
             *                               <li>aws:drop_established</li>
             *                               <li>aws:alert_strict</li>
             *                               <li>aws:alert_established</li>
             *                               </ul>
             *                               <p>
             *                               For more information, see <a href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/suricata-rule-evaluation-order.html#suricata-strict-rule-evaluation-order.html">Strict evaluation order</a> in the <em>AWS Network Firewall Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statefulDefaultActions(java.util.List<java.lang.String> statefulDefaultActions) {
                this.statefulDefaultActions = statefulDefaultActions;
                return this;
            }

            /**
             * Sets the value of {@link FirewallPolicyProperty#getStatefulEngineOptions}
             * @param statefulEngineOptions Additional options governing how Network Firewall handles stateful rules.
             *                              The stateful rule groups that you use in your policy must have stateful rule options settings that are compatible with these settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statefulEngineOptions(software.amazon.awscdk.services.networkfirewall.CfnFirewallPolicy.StatefulEngineOptionsProperty statefulEngineOptions) {
                this.statefulEngineOptions = statefulEngineOptions;
                return this;
            }

            /**
             * Sets the value of {@link FirewallPolicyProperty#getStatefulEngineOptions}
             * @param statefulEngineOptions Additional options governing how Network Firewall handles stateful rules.
             *                              The stateful rule groups that you use in your policy must have stateful rule options settings that are compatible with these settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statefulEngineOptions(software.amazon.awscdk.IResolvable statefulEngineOptions) {
                this.statefulEngineOptions = statefulEngineOptions;
                return this;
            }

            /**
             * Sets the value of {@link FirewallPolicyProperty#getStatefulRuleGroupReferences}
             * @param statefulRuleGroupReferences References to the stateful rule groups that are used in the policy.
             *                                    These define the inspection criteria in stateful rules.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statefulRuleGroupReferences(software.amazon.awscdk.IResolvable statefulRuleGroupReferences) {
                this.statefulRuleGroupReferences = statefulRuleGroupReferences;
                return this;
            }

            /**
             * Sets the value of {@link FirewallPolicyProperty#getStatefulRuleGroupReferences}
             * @param statefulRuleGroupReferences References to the stateful rule groups that are used in the policy.
             *                                    These define the inspection criteria in stateful rules.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statefulRuleGroupReferences(java.util.List<? extends java.lang.Object> statefulRuleGroupReferences) {
                this.statefulRuleGroupReferences = statefulRuleGroupReferences;
                return this;
            }

            /**
             * Sets the value of {@link FirewallPolicyProperty#getStatelessCustomActions}
             * @param statelessCustomActions The custom action definitions that are available for use in the firewall policy's `StatelessDefaultActions` setting.
             *                               You name each custom action that you define, and then you can use it by name in your default actions specifications.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statelessCustomActions(software.amazon.awscdk.IResolvable statelessCustomActions) {
                this.statelessCustomActions = statelessCustomActions;
                return this;
            }

            /**
             * Sets the value of {@link FirewallPolicyProperty#getStatelessCustomActions}
             * @param statelessCustomActions The custom action definitions that are available for use in the firewall policy's `StatelessDefaultActions` setting.
             *                               You name each custom action that you define, and then you can use it by name in your default actions specifications.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statelessCustomActions(java.util.List<? extends java.lang.Object> statelessCustomActions) {
                this.statelessCustomActions = statelessCustomActions;
                return this;
            }

            /**
             * Sets the value of {@link FirewallPolicyProperty#getStatelessRuleGroupReferences}
             * @param statelessRuleGroupReferences References to the stateless rule groups that are used in the policy.
             *                                     These define the matching criteria in stateless rules.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statelessRuleGroupReferences(software.amazon.awscdk.IResolvable statelessRuleGroupReferences) {
                this.statelessRuleGroupReferences = statelessRuleGroupReferences;
                return this;
            }

            /**
             * Sets the value of {@link FirewallPolicyProperty#getStatelessRuleGroupReferences}
             * @param statelessRuleGroupReferences References to the stateless rule groups that are used in the policy.
             *                                     These define the matching criteria in stateless rules.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statelessRuleGroupReferences(java.util.List<? extends java.lang.Object> statelessRuleGroupReferences) {
                this.statelessRuleGroupReferences = statelessRuleGroupReferences;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FirewallPolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FirewallPolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FirewallPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FirewallPolicyProperty {
            private final java.util.List<java.lang.String> statelessDefaultActions;
            private final java.util.List<java.lang.String> statelessFragmentDefaultActions;
            private final java.util.List<java.lang.String> statefulDefaultActions;
            private final java.lang.Object statefulEngineOptions;
            private final java.lang.Object statefulRuleGroupReferences;
            private final java.lang.Object statelessCustomActions;
            private final java.lang.Object statelessRuleGroupReferences;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.statelessDefaultActions = software.amazon.jsii.Kernel.get(this, "statelessDefaultActions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.statelessFragmentDefaultActions = software.amazon.jsii.Kernel.get(this, "statelessFragmentDefaultActions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.statefulDefaultActions = software.amazon.jsii.Kernel.get(this, "statefulDefaultActions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.statefulEngineOptions = software.amazon.jsii.Kernel.get(this, "statefulEngineOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.statefulRuleGroupReferences = software.amazon.jsii.Kernel.get(this, "statefulRuleGroupReferences", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.statelessCustomActions = software.amazon.jsii.Kernel.get(this, "statelessCustomActions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.statelessRuleGroupReferences = software.amazon.jsii.Kernel.get(this, "statelessRuleGroupReferences", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.statelessDefaultActions = java.util.Objects.requireNonNull(builder.statelessDefaultActions, "statelessDefaultActions is required");
                this.statelessFragmentDefaultActions = java.util.Objects.requireNonNull(builder.statelessFragmentDefaultActions, "statelessFragmentDefaultActions is required");
                this.statefulDefaultActions = builder.statefulDefaultActions;
                this.statefulEngineOptions = builder.statefulEngineOptions;
                this.statefulRuleGroupReferences = builder.statefulRuleGroupReferences;
                this.statelessCustomActions = builder.statelessCustomActions;
                this.statelessRuleGroupReferences = builder.statelessRuleGroupReferences;
            }

            @Override
            public final java.util.List<java.lang.String> getStatelessDefaultActions() {
                return this.statelessDefaultActions;
            }

            @Override
            public final java.util.List<java.lang.String> getStatelessFragmentDefaultActions() {
                return this.statelessFragmentDefaultActions;
            }

            @Override
            public final java.util.List<java.lang.String> getStatefulDefaultActions() {
                return this.statefulDefaultActions;
            }

            @Override
            public final java.lang.Object getStatefulEngineOptions() {
                return this.statefulEngineOptions;
            }

            @Override
            public final java.lang.Object getStatefulRuleGroupReferences() {
                return this.statefulRuleGroupReferences;
            }

            @Override
            public final java.lang.Object getStatelessCustomActions() {
                return this.statelessCustomActions;
            }

            @Override
            public final java.lang.Object getStatelessRuleGroupReferences() {
                return this.statelessRuleGroupReferences;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("statelessDefaultActions", om.valueToTree(this.getStatelessDefaultActions()));
                data.set("statelessFragmentDefaultActions", om.valueToTree(this.getStatelessFragmentDefaultActions()));
                if (this.getStatefulDefaultActions() != null) {
                    data.set("statefulDefaultActions", om.valueToTree(this.getStatefulDefaultActions()));
                }
                if (this.getStatefulEngineOptions() != null) {
                    data.set("statefulEngineOptions", om.valueToTree(this.getStatefulEngineOptions()));
                }
                if (this.getStatefulRuleGroupReferences() != null) {
                    data.set("statefulRuleGroupReferences", om.valueToTree(this.getStatefulRuleGroupReferences()));
                }
                if (this.getStatelessCustomActions() != null) {
                    data.set("statelessCustomActions", om.valueToTree(this.getStatelessCustomActions()));
                }
                if (this.getStatelessRuleGroupReferences() != null) {
                    data.set("statelessRuleGroupReferences", om.valueToTree(this.getStatelessRuleGroupReferences()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_networkfirewall.CfnFirewallPolicy.FirewallPolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FirewallPolicyProperty.Jsii$Proxy that = (FirewallPolicyProperty.Jsii$Proxy) o;

                if (!statelessDefaultActions.equals(that.statelessDefaultActions)) return false;
                if (!statelessFragmentDefaultActions.equals(that.statelessFragmentDefaultActions)) return false;
                if (this.statefulDefaultActions != null ? !this.statefulDefaultActions.equals(that.statefulDefaultActions) : that.statefulDefaultActions != null) return false;
                if (this.statefulEngineOptions != null ? !this.statefulEngineOptions.equals(that.statefulEngineOptions) : that.statefulEngineOptions != null) return false;
                if (this.statefulRuleGroupReferences != null ? !this.statefulRuleGroupReferences.equals(that.statefulRuleGroupReferences) : that.statefulRuleGroupReferences != null) return false;
                if (this.statelessCustomActions != null ? !this.statelessCustomActions.equals(that.statelessCustomActions) : that.statelessCustomActions != null) return false;
                return this.statelessRuleGroupReferences != null ? this.statelessRuleGroupReferences.equals(that.statelessRuleGroupReferences) : that.statelessRuleGroupReferences == null;
            }

            @Override
            public final int hashCode() {
                int result = this.statelessDefaultActions.hashCode();
                result = 31 * result + (this.statelessFragmentDefaultActions.hashCode());
                result = 31 * result + (this.statefulDefaultActions != null ? this.statefulDefaultActions.hashCode() : 0);
                result = 31 * result + (this.statefulEngineOptions != null ? this.statefulEngineOptions.hashCode() : 0);
                result = 31 * result + (this.statefulRuleGroupReferences != null ? this.statefulRuleGroupReferences.hashCode() : 0);
                result = 31 * result + (this.statelessCustomActions != null ? this.statelessCustomActions.hashCode() : 0);
                result = 31 * result + (this.statelessRuleGroupReferences != null ? this.statelessRuleGroupReferences.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Stateless inspection criteria that publishes the specified metrics to Amazon CloudWatch for the matching packet.
     * <p>
     * This setting defines a CloudWatch dimension value to be published.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.networkfirewall.*;
     * PublishMetricActionProperty publishMetricActionProperty = PublishMetricActionProperty.builder()
     *         .dimensions(List.of(DimensionProperty.builder()
     *                 .value("value")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_networkfirewall.CfnFirewallPolicy.PublishMetricActionProperty")
    @software.amazon.jsii.Jsii.Proxy(PublishMetricActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PublishMetricActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnFirewallPolicy.PublishMetricActionProperty.Dimensions`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDimensions();

        /**
         * @return a {@link Builder} of {@link PublishMetricActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PublishMetricActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PublishMetricActionProperty> {
            java.lang.Object dimensions;

            /**
             * Sets the value of {@link PublishMetricActionProperty#getDimensions}
             * @param dimensions `CfnFirewallPolicy.PublishMetricActionProperty.Dimensions`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dimensions(software.amazon.awscdk.IResolvable dimensions) {
                this.dimensions = dimensions;
                return this;
            }

            /**
             * Sets the value of {@link PublishMetricActionProperty#getDimensions}
             * @param dimensions `CfnFirewallPolicy.PublishMetricActionProperty.Dimensions`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dimensions(java.util.List<? extends java.lang.Object> dimensions) {
                this.dimensions = dimensions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PublishMetricActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PublishMetricActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PublishMetricActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PublishMetricActionProperty {
            private final java.lang.Object dimensions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dimensions = software.amazon.jsii.Kernel.get(this, "dimensions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dimensions = java.util.Objects.requireNonNull(builder.dimensions, "dimensions is required");
            }

            @Override
            public final java.lang.Object getDimensions() {
                return this.dimensions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("dimensions", om.valueToTree(this.getDimensions()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_networkfirewall.CfnFirewallPolicy.PublishMetricActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PublishMetricActionProperty.Jsii$Proxy that = (PublishMetricActionProperty.Jsii$Proxy) o;

                return this.dimensions.equals(that.dimensions);
            }

            @Override
            public final int hashCode() {
                int result = this.dimensions.hashCode();
                return result;
            }
        }
    }
    /**
     * Configuration settings for the handling of the stateful rule groups in a firewall policy.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.networkfirewall.*;
     * StatefulEngineOptionsProperty statefulEngineOptionsProperty = StatefulEngineOptionsProperty.builder()
     *         .ruleOrder("ruleOrder")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_networkfirewall.CfnFirewallPolicy.StatefulEngineOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(StatefulEngineOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StatefulEngineOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates how to manage the order of stateful rule evaluation for the policy.
         * <p>
         * <code>DEFAULT_ACTION_ORDER</code> is the default behavior. Stateful rules are provided to the rule engine as Suricata compatible strings, and Suricata evaluates them based on certain settings. For more information, see <a href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/suricata-rule-evaluation-order.html">Evaluation order for stateful rules</a> in the <em>AWS Network Firewall Developer Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRuleOrder() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StatefulEngineOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StatefulEngineOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StatefulEngineOptionsProperty> {
            java.lang.String ruleOrder;

            /**
             * Sets the value of {@link StatefulEngineOptionsProperty#getRuleOrder}
             * @param ruleOrder Indicates how to manage the order of stateful rule evaluation for the policy.
             *                  <code>DEFAULT_ACTION_ORDER</code> is the default behavior. Stateful rules are provided to the rule engine as Suricata compatible strings, and Suricata evaluates them based on certain settings. For more information, see <a href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/suricata-rule-evaluation-order.html">Evaluation order for stateful rules</a> in the <em>AWS Network Firewall Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ruleOrder(java.lang.String ruleOrder) {
                this.ruleOrder = ruleOrder;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StatefulEngineOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StatefulEngineOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StatefulEngineOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StatefulEngineOptionsProperty {
            private final java.lang.String ruleOrder;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.ruleOrder = software.amazon.jsii.Kernel.get(this, "ruleOrder", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.ruleOrder = builder.ruleOrder;
            }

            @Override
            public final java.lang.String getRuleOrder() {
                return this.ruleOrder;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getRuleOrder() != null) {
                    data.set("ruleOrder", om.valueToTree(this.getRuleOrder()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_networkfirewall.CfnFirewallPolicy.StatefulEngineOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StatefulEngineOptionsProperty.Jsii$Proxy that = (StatefulEngineOptionsProperty.Jsii$Proxy) o;

                return this.ruleOrder != null ? this.ruleOrder.equals(that.ruleOrder) : that.ruleOrder == null;
            }

            @Override
            public final int hashCode() {
                int result = this.ruleOrder != null ? this.ruleOrder.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Identifier for a single stateful rule group, used in a firewall policy to refer to a rule group.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.networkfirewall.*;
     * StatefulRuleGroupReferenceProperty statefulRuleGroupReferenceProperty = StatefulRuleGroupReferenceProperty.builder()
     *         .resourceArn("resourceArn")
     *         // the properties below are optional
     *         .priority(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_networkfirewall.CfnFirewallPolicy.StatefulRuleGroupReferenceProperty")
    @software.amazon.jsii.Jsii.Proxy(StatefulRuleGroupReferenceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StatefulRuleGroupReferenceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the stateful rule group.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getResourceArn();

        /**
         * An integer setting that indicates the order in which to run the stateful rule groups in a single `FirewallPolicy` .
         * <p>
         * This setting only applies to firewall policies that specify the <code>STRICT_ORDER</code> rule order in the stateful engine options settings.
         * <p>
         * Network Firewall evalutes each stateful rule group against a packet starting with the group that has the lowest priority setting. You must ensure that the priority settings are unique within each policy.
         * <p>
         * You can change the priority settings of your rule groups at any time. To make it easier to insert rule groups later, number them so there's a wide range in between, for example use 100, 200, and so on.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPriority() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StatefulRuleGroupReferenceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StatefulRuleGroupReferenceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StatefulRuleGroupReferenceProperty> {
            java.lang.String resourceArn;
            java.lang.Number priority;

            /**
             * Sets the value of {@link StatefulRuleGroupReferenceProperty#getResourceArn}
             * @param resourceArn The Amazon Resource Name (ARN) of the stateful rule group. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceArn(java.lang.String resourceArn) {
                this.resourceArn = resourceArn;
                return this;
            }

            /**
             * Sets the value of {@link StatefulRuleGroupReferenceProperty#getPriority}
             * @param priority An integer setting that indicates the order in which to run the stateful rule groups in a single `FirewallPolicy` .
             *                 This setting only applies to firewall policies that specify the <code>STRICT_ORDER</code> rule order in the stateful engine options settings.
             *                 <p>
             *                 Network Firewall evalutes each stateful rule group against a packet starting with the group that has the lowest priority setting. You must ensure that the priority settings are unique within each policy.
             *                 <p>
             *                 You can change the priority settings of your rule groups at any time. To make it easier to insert rule groups later, number them so there's a wide range in between, for example use 100, 200, and so on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder priority(java.lang.Number priority) {
                this.priority = priority;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StatefulRuleGroupReferenceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StatefulRuleGroupReferenceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StatefulRuleGroupReferenceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StatefulRuleGroupReferenceProperty {
            private final java.lang.String resourceArn;
            private final java.lang.Number priority;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.resourceArn = software.amazon.jsii.Kernel.get(this, "resourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.priority = software.amazon.jsii.Kernel.get(this, "priority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.resourceArn = java.util.Objects.requireNonNull(builder.resourceArn, "resourceArn is required");
                this.priority = builder.priority;
            }

            @Override
            public final java.lang.String getResourceArn() {
                return this.resourceArn;
            }

            @Override
            public final java.lang.Number getPriority() {
                return this.priority;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("resourceArn", om.valueToTree(this.getResourceArn()));
                if (this.getPriority() != null) {
                    data.set("priority", om.valueToTree(this.getPriority()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_networkfirewall.CfnFirewallPolicy.StatefulRuleGroupReferenceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StatefulRuleGroupReferenceProperty.Jsii$Proxy that = (StatefulRuleGroupReferenceProperty.Jsii$Proxy) o;

                if (!resourceArn.equals(that.resourceArn)) return false;
                return this.priority != null ? this.priority.equals(that.priority) : that.priority == null;
            }

            @Override
            public final int hashCode() {
                int result = this.resourceArn.hashCode();
                result = 31 * result + (this.priority != null ? this.priority.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Identifier for a single stateless rule group, used in a firewall policy to refer to the rule group.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.networkfirewall.*;
     * StatelessRuleGroupReferenceProperty statelessRuleGroupReferenceProperty = StatelessRuleGroupReferenceProperty.builder()
     *         .priority(123)
     *         .resourceArn("resourceArn")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_networkfirewall.CfnFirewallPolicy.StatelessRuleGroupReferenceProperty")
    @software.amazon.jsii.Jsii.Proxy(StatelessRuleGroupReferenceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StatelessRuleGroupReferenceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An integer setting that indicates the order in which to run the stateless rule groups in a single `FirewallPolicy` .
         * <p>
         * Network Firewall applies each stateless rule group to a packet starting with the group that has the lowest priority setting. You must ensure that the priority settings are unique within each policy.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getPriority();

        /**
         * The Amazon Resource Name (ARN) of the stateless rule group.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getResourceArn();

        /**
         * @return a {@link Builder} of {@link StatelessRuleGroupReferenceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StatelessRuleGroupReferenceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StatelessRuleGroupReferenceProperty> {
            java.lang.Number priority;
            java.lang.String resourceArn;

            /**
             * Sets the value of {@link StatelessRuleGroupReferenceProperty#getPriority}
             * @param priority An integer setting that indicates the order in which to run the stateless rule groups in a single `FirewallPolicy` . This parameter is required.
             *                 Network Firewall applies each stateless rule group to a packet starting with the group that has the lowest priority setting. You must ensure that the priority settings are unique within each policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder priority(java.lang.Number priority) {
                this.priority = priority;
                return this;
            }

            /**
             * Sets the value of {@link StatelessRuleGroupReferenceProperty#getResourceArn}
             * @param resourceArn The Amazon Resource Name (ARN) of the stateless rule group. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceArn(java.lang.String resourceArn) {
                this.resourceArn = resourceArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StatelessRuleGroupReferenceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StatelessRuleGroupReferenceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StatelessRuleGroupReferenceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StatelessRuleGroupReferenceProperty {
            private final java.lang.Number priority;
            private final java.lang.String resourceArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.priority = software.amazon.jsii.Kernel.get(this, "priority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.resourceArn = software.amazon.jsii.Kernel.get(this, "resourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.priority = java.util.Objects.requireNonNull(builder.priority, "priority is required");
                this.resourceArn = java.util.Objects.requireNonNull(builder.resourceArn, "resourceArn is required");
            }

            @Override
            public final java.lang.Number getPriority() {
                return this.priority;
            }

            @Override
            public final java.lang.String getResourceArn() {
                return this.resourceArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("priority", om.valueToTree(this.getPriority()));
                data.set("resourceArn", om.valueToTree(this.getResourceArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_networkfirewall.CfnFirewallPolicy.StatelessRuleGroupReferenceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StatelessRuleGroupReferenceProperty.Jsii$Proxy that = (StatelessRuleGroupReferenceProperty.Jsii$Proxy) o;

                if (!priority.equals(that.priority)) return false;
                return this.resourceArn.equals(that.resourceArn);
            }

            @Override
            public final int hashCode() {
                int result = this.priority.hashCode();
                result = 31 * result + (this.resourceArn.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.networkfirewall.CfnFirewallPolicy}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.networkfirewall.CfnFirewallPolicy> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.networkfirewall.CfnFirewallPolicyProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.networkfirewall.CfnFirewallPolicyProps.Builder();
        }

        /**
         * The traffic filtering behavior of a firewall policy, defined in a collection of stateless and stateful rule groups and other settings.
         * <p>
         * @return {@code this}
         * @param firewallPolicy The traffic filtering behavior of a firewall policy, defined in a collection of stateless and stateful rule groups and other settings. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder firewallPolicy(final software.amazon.awscdk.services.networkfirewall.CfnFirewallPolicy.FirewallPolicyProperty firewallPolicy) {
            this.props.firewallPolicy(firewallPolicy);
            return this;
        }
        /**
         * The traffic filtering behavior of a firewall policy, defined in a collection of stateless and stateful rule groups and other settings.
         * <p>
         * @return {@code this}
         * @param firewallPolicy The traffic filtering behavior of a firewall policy, defined in a collection of stateless and stateful rule groups and other settings. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder firewallPolicy(final software.amazon.awscdk.IResolvable firewallPolicy) {
            this.props.firewallPolicy(firewallPolicy);
            return this;
        }

        /**
         * The descriptive name of the firewall policy.
         * <p>
         * You can't change the name of a firewall policy after you create it.
         * <p>
         * @return {@code this}
         * @param firewallPolicyName The descriptive name of the firewall policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder firewallPolicyName(final java.lang.String firewallPolicyName) {
            this.props.firewallPolicyName(firewallPolicyName);
            return this;
        }

        /**
         * A description of the firewall policy.
         * <p>
         * @return {@code this}
         * @param description A description of the firewall policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * An array of key-value pairs to apply to this resource.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * <p>
         * @return {@code this}
         * @param tags An array of key-value pairs to apply to this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.networkfirewall.CfnFirewallPolicy}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.networkfirewall.CfnFirewallPolicy build() {
            return new software.amazon.awscdk.services.networkfirewall.CfnFirewallPolicy(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
