package software.amazon.awscdk.services.logs;

/**
 * How long, in days, the log contents will be retained.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Function onEvent;
 * Function isComplete;
 * Role myRole;
 * Provider myProvider = Provider.Builder.create(this, "MyProvider")
 *         .onEventHandler(onEvent)
 *         .isCompleteHandler(isComplete) // optional async "waiter"
 *         .logRetention(RetentionDays.ONE_DAY) // default is INFINITE
 *         .role(myRole)
 *         .build();
 * CustomResource.Builder.create(this, "Resource1").serviceToken(myProvider.getServiceToken()).build();
 * CustomResource.Builder.create(this, "Resource2").serviceToken(myProvider.getServiceToken()).build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-29T04:34:11.473Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.RetentionDays")
public enum RetentionDays {
    /**
     * 1 day.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ONE_DAY,
    /**
     * 3 days.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    THREE_DAYS,
    /**
     * 5 days.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    FIVE_DAYS,
    /**
     * 1 week.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ONE_WEEK,
    /**
     * 2 weeks.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TWO_WEEKS,
    /**
     * 1 month.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ONE_MONTH,
    /**
     * 2 months.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TWO_MONTHS,
    /**
     * 3 months.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    THREE_MONTHS,
    /**
     * 4 months.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    FOUR_MONTHS,
    /**
     * 5 months.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    FIVE_MONTHS,
    /**
     * 6 months.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SIX_MONTHS,
    /**
     * 1 year.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ONE_YEAR,
    /**
     * 13 months.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    THIRTEEN_MONTHS,
    /**
     * 18 months.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    EIGHTEEN_MONTHS,
    /**
     * 2 years.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TWO_YEARS,
    /**
     * 5 years.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    FIVE_YEARS,
    /**
     * 10 years.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TEN_YEARS,
    /**
     * Retain logs forever.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    INFINITE,
}
