package software.amazon.awscdk.services.lambda.destinations;

/**
 * Options for a Lambda destination.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Auto-extract response payload with a lambda destination
 * Function destinationFn;
 * Function sourceFn = Function.Builder.create(this, "Source")
 *         .runtime(Runtime.NODEJS_12_X)
 *         .handler("index.handler")
 *         .code(Code.fromAsset(join(__dirname, "lambda-handler")))
 *         // auto-extract on success
 *         .onSuccess(LambdaDestination.Builder.create(destinationFn)
 *                 .responseOnly(true)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-29T04:34:11.249Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda_destinations.LambdaDestinationOptions")
@software.amazon.jsii.Jsii.Proxy(LambdaDestinationOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LambdaDestinationOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Whether the destination function receives only the `responsePayload` of the source function.
     * <p>
     * When set to <code>true</code> and used as <code>onSuccess</code> destination, the destination
     * function will be invoked with the payload returned by the source function.
     * <p>
     * When set to <code>true</code> and used as <code>onFailure</code> destination, the destination
     * function will be invoked with the error object returned by source function.
     * <p>
     * See the README of this module to see a full explanation of this option.
     * <p>
     * Default: false The destination function receives the full invocation record.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getResponseOnly() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link LambdaDestinationOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LambdaDestinationOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LambdaDestinationOptions> {
        java.lang.Boolean responseOnly;

        /**
         * Sets the value of {@link LambdaDestinationOptions#getResponseOnly}
         * @param responseOnly Whether the destination function receives only the `responsePayload` of the source function.
         *                     When set to <code>true</code> and used as <code>onSuccess</code> destination, the destination
         *                     function will be invoked with the payload returned by the source function.
         *                     <p>
         *                     When set to <code>true</code> and used as <code>onFailure</code> destination, the destination
         *                     function will be invoked with the error object returned by source function.
         *                     <p>
         *                     See the README of this module to see a full explanation of this option.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder responseOnly(java.lang.Boolean responseOnly) {
            this.responseOnly = responseOnly;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LambdaDestinationOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LambdaDestinationOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LambdaDestinationOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LambdaDestinationOptions {
        private final java.lang.Boolean responseOnly;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.responseOnly = software.amazon.jsii.Kernel.get(this, "responseOnly", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.responseOnly = builder.responseOnly;
        }

        @Override
        public final java.lang.Boolean getResponseOnly() {
            return this.responseOnly;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getResponseOnly() != null) {
                data.set("responseOnly", om.valueToTree(this.getResponseOnly()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lambda_destinations.LambdaDestinationOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LambdaDestinationOptions.Jsii$Proxy that = (LambdaDestinationOptions.Jsii$Proxy) o;

            return this.responseOnly != null ? this.responseOnly.equals(that.responseOnly) : that.responseOnly == null;
        }

        @Override
        public final int hashCode() {
            int result = this.responseOnly != null ? this.responseOnly.hashCode() : 0;
            return result;
        }
    }
}
