package software.amazon.awscdk.services.kendra;

/**
 * Properties for defining a `CfnDataSource`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.kendra.*;
 * CfnDataSourceProps cfnDataSourceProps = CfnDataSourceProps.builder()
 *         .indexId("indexId")
 *         .name("name")
 *         .type("type")
 *         // the properties below are optional
 *         .dataSourceConfiguration(DataSourceConfigurationProperty.builder()
 *                 .confluenceConfiguration(ConfluenceConfigurationProperty.builder()
 *                         .secretArn("secretArn")
 *                         .serverUrl("serverUrl")
 *                         .version("version")
 *                         // the properties below are optional
 *                         .attachmentConfiguration(ConfluenceAttachmentConfigurationProperty.builder()
 *                                 .attachmentFieldMappings(List.of(ConfluenceAttachmentToIndexFieldMappingProperty.builder()
 *                                         .dataSourceFieldName("dataSourceFieldName")
 *                                         .indexFieldName("indexFieldName")
 *                                         // the properties below are optional
 *                                         .dateFieldFormat("dateFieldFormat")
 *                                         .build()))
 *                                 .crawlAttachments(false)
 *                                 .build())
 *                         .blogConfiguration(ConfluenceBlogConfigurationProperty.builder()
 *                                 .blogFieldMappings(List.of(ConfluenceBlogToIndexFieldMappingProperty.builder()
 *                                         .dataSourceFieldName("dataSourceFieldName")
 *                                         .indexFieldName("indexFieldName")
 *                                         // the properties below are optional
 *                                         .dateFieldFormat("dateFieldFormat")
 *                                         .build()))
 *                                 .build())
 *                         .exclusionPatterns(List.of("exclusionPatterns"))
 *                         .inclusionPatterns(List.of("inclusionPatterns"))
 *                         .pageConfiguration(ConfluencePageConfigurationProperty.builder()
 *                                 .pageFieldMappings(List.of(ConfluencePageToIndexFieldMappingProperty.builder()
 *                                         .dataSourceFieldName("dataSourceFieldName")
 *                                         .indexFieldName("indexFieldName")
 *                                         // the properties below are optional
 *                                         .dateFieldFormat("dateFieldFormat")
 *                                         .build()))
 *                                 .build())
 *                         .spaceConfiguration(ConfluenceSpaceConfigurationProperty.builder()
 *                                 .crawlArchivedSpaces(false)
 *                                 .crawlPersonalSpaces(false)
 *                                 .excludeSpaces(List.of("excludeSpaces"))
 *                                 .includeSpaces(List.of("includeSpaces"))
 *                                 .spaceFieldMappings(List.of(ConfluenceSpaceToIndexFieldMappingProperty.builder()
 *                                         .dataSourceFieldName("dataSourceFieldName")
 *                                         .indexFieldName("indexFieldName")
 *                                         // the properties below are optional
 *                                         .dateFieldFormat("dateFieldFormat")
 *                                         .build()))
 *                                 .build())
 *                         .vpcConfiguration(DataSourceVpcConfigurationProperty.builder()
 *                                 .securityGroupIds(List.of("securityGroupIds"))
 *                                 .subnetIds(List.of("subnetIds"))
 *                                 .build())
 *                         .build())
 *                 .databaseConfiguration(DatabaseConfigurationProperty.builder()
 *                         .columnConfiguration(ColumnConfigurationProperty.builder()
 *                                 .changeDetectingColumns(List.of("changeDetectingColumns"))
 *                                 .documentDataColumnName("documentDataColumnName")
 *                                 .documentIdColumnName("documentIdColumnName")
 *                                 // the properties below are optional
 *                                 .documentTitleColumnName("documentTitleColumnName")
 *                                 .fieldMappings(List.of(DataSourceToIndexFieldMappingProperty.builder()
 *                                         .dataSourceFieldName("dataSourceFieldName")
 *                                         .indexFieldName("indexFieldName")
 *                                         // the properties below are optional
 *                                         .dateFieldFormat("dateFieldFormat")
 *                                         .build()))
 *                                 .build())
 *                         .connectionConfiguration(ConnectionConfigurationProperty.builder()
 *                                 .databaseHost("databaseHost")
 *                                 .databaseName("databaseName")
 *                                 .databasePort(123)
 *                                 .secretArn("secretArn")
 *                                 .tableName("tableName")
 *                                 .build())
 *                         .databaseEngineType("databaseEngineType")
 *                         // the properties below are optional
 *                         .aclConfiguration(AclConfigurationProperty.builder()
 *                                 .allowedGroupsColumnName("allowedGroupsColumnName")
 *                                 .build())
 *                         .sqlConfiguration(SqlConfigurationProperty.builder()
 *                                 .queryIdentifiersEnclosingOption("queryIdentifiersEnclosingOption")
 *                                 .build())
 *                         .vpcConfiguration(DataSourceVpcConfigurationProperty.builder()
 *                                 .securityGroupIds(List.of("securityGroupIds"))
 *                                 .subnetIds(List.of("subnetIds"))
 *                                 .build())
 *                         .build())
 *                 .googleDriveConfiguration(GoogleDriveConfigurationProperty.builder()
 *                         .secretArn("secretArn")
 *                         // the properties below are optional
 *                         .excludeMimeTypes(List.of("excludeMimeTypes"))
 *                         .excludeSharedDrives(List.of("excludeSharedDrives"))
 *                         .excludeUserAccounts(List.of("excludeUserAccounts"))
 *                         .exclusionPatterns(List.of("exclusionPatterns"))
 *                         .fieldMappings(List.of(DataSourceToIndexFieldMappingProperty.builder()
 *                                 .dataSourceFieldName("dataSourceFieldName")
 *                                 .indexFieldName("indexFieldName")
 *                                 // the properties below are optional
 *                                 .dateFieldFormat("dateFieldFormat")
 *                                 .build()))
 *                         .inclusionPatterns(List.of("inclusionPatterns"))
 *                         .build())
 *                 .oneDriveConfiguration(OneDriveConfigurationProperty.builder()
 *                         .oneDriveUsers(OneDriveUsersProperty.builder()
 *                                 .oneDriveUserList(List.of("oneDriveUserList"))
 *                                 .oneDriveUserS3Path(S3PathProperty.builder()
 *                                         .bucket("bucket")
 *                                         .key("key")
 *                                         .build())
 *                                 .build())
 *                         .secretArn("secretArn")
 *                         .tenantDomain("tenantDomain")
 *                         // the properties below are optional
 *                         .disableLocalGroups(false)
 *                         .exclusionPatterns(List.of("exclusionPatterns"))
 *                         .fieldMappings(List.of(DataSourceToIndexFieldMappingProperty.builder()
 *                                 .dataSourceFieldName("dataSourceFieldName")
 *                                 .indexFieldName("indexFieldName")
 *                                 // the properties below are optional
 *                                 .dateFieldFormat("dateFieldFormat")
 *                                 .build()))
 *                         .inclusionPatterns(List.of("inclusionPatterns"))
 *                         .build())
 *                 .s3Configuration(S3DataSourceConfigurationProperty.builder()
 *                         .bucketName("bucketName")
 *                         // the properties below are optional
 *                         .accessControlListConfiguration(AccessControlListConfigurationProperty.builder()
 *                                 .keyPath("keyPath")
 *                                 .build())
 *                         .documentsMetadataConfiguration(DocumentsMetadataConfigurationProperty.builder()
 *                                 .s3Prefix("s3Prefix")
 *                                 .build())
 *                         .exclusionPatterns(List.of("exclusionPatterns"))
 *                         .inclusionPatterns(List.of("inclusionPatterns"))
 *                         .inclusionPrefixes(List.of("inclusionPrefixes"))
 *                         .build())
 *                 .salesforceConfiguration(SalesforceConfigurationProperty.builder()
 *                         .secretArn("secretArn")
 *                         .serverUrl("serverUrl")
 *                         // the properties below are optional
 *                         .chatterFeedConfiguration(SalesforceChatterFeedConfigurationProperty.builder()
 *                                 .documentDataFieldName("documentDataFieldName")
 *                                 // the properties below are optional
 *                                 .documentTitleFieldName("documentTitleFieldName")
 *                                 .fieldMappings(List.of(DataSourceToIndexFieldMappingProperty.builder()
 *                                         .dataSourceFieldName("dataSourceFieldName")
 *                                         .indexFieldName("indexFieldName")
 *                                         // the properties below are optional
 *                                         .dateFieldFormat("dateFieldFormat")
 *                                         .build()))
 *                                 .includeFilterTypes(List.of("includeFilterTypes"))
 *                                 .build())
 *                         .crawlAttachments(false)
 *                         .excludeAttachmentFilePatterns(List.of("excludeAttachmentFilePatterns"))
 *                         .includeAttachmentFilePatterns(List.of("includeAttachmentFilePatterns"))
 *                         .knowledgeArticleConfiguration(SalesforceKnowledgeArticleConfigurationProperty.builder()
 *                                 .includedStates(List.of("includedStates"))
 *                                 // the properties below are optional
 *                                 .customKnowledgeArticleTypeConfigurations(List.of(SalesforceCustomKnowledgeArticleTypeConfigurationProperty.builder()
 *                                         .documentDataFieldName("documentDataFieldName")
 *                                         .name("name")
 *                                         // the properties below are optional
 *                                         .documentTitleFieldName("documentTitleFieldName")
 *                                         .fieldMappings(List.of(DataSourceToIndexFieldMappingProperty.builder()
 *                                                 .dataSourceFieldName("dataSourceFieldName")
 *                                                 .indexFieldName("indexFieldName")
 *                                                 // the properties below are optional
 *                                                 .dateFieldFormat("dateFieldFormat")
 *                                                 .build()))
 *                                         .build()))
 *                                 .standardKnowledgeArticleTypeConfiguration(SalesforceStandardKnowledgeArticleTypeConfigurationProperty.builder()
 *                                         .documentDataFieldName("documentDataFieldName")
 *                                         // the properties below are optional
 *                                         .documentTitleFieldName("documentTitleFieldName")
 *                                         .fieldMappings(List.of(DataSourceToIndexFieldMappingProperty.builder()
 *                                                 .dataSourceFieldName("dataSourceFieldName")
 *                                                 .indexFieldName("indexFieldName")
 *                                                 // the properties below are optional
 *                                                 .dateFieldFormat("dateFieldFormat")
 *                                                 .build()))
 *                                         .build())
 *                                 .build())
 *                         .standardObjectAttachmentConfiguration(SalesforceStandardObjectAttachmentConfigurationProperty.builder()
 *                                 .documentTitleFieldName("documentTitleFieldName")
 *                                 .fieldMappings(List.of(DataSourceToIndexFieldMappingProperty.builder()
 *                                         .dataSourceFieldName("dataSourceFieldName")
 *                                         .indexFieldName("indexFieldName")
 *                                         // the properties below are optional
 *                                         .dateFieldFormat("dateFieldFormat")
 *                                         .build()))
 *                                 .build())
 *                         .standardObjectConfigurations(List.of(SalesforceStandardObjectConfigurationProperty.builder()
 *                                 .documentDataFieldName("documentDataFieldName")
 *                                 .name("name")
 *                                 // the properties below are optional
 *                                 .documentTitleFieldName("documentTitleFieldName")
 *                                 .fieldMappings(List.of(DataSourceToIndexFieldMappingProperty.builder()
 *                                         .dataSourceFieldName("dataSourceFieldName")
 *                                         .indexFieldName("indexFieldName")
 *                                         // the properties below are optional
 *                                         .dateFieldFormat("dateFieldFormat")
 *                                         .build()))
 *                                 .build()))
 *                         .build())
 *                 .serviceNowConfiguration(ServiceNowConfigurationProperty.builder()
 *                         .hostUrl("hostUrl")
 *                         .secretArn("secretArn")
 *                         .serviceNowBuildVersion("serviceNowBuildVersion")
 *                         // the properties below are optional
 *                         .authenticationType("authenticationType")
 *                         .knowledgeArticleConfiguration(ServiceNowKnowledgeArticleConfigurationProperty.builder()
 *                                 .documentDataFieldName("documentDataFieldName")
 *                                 // the properties below are optional
 *                                 .crawlAttachments(false)
 *                                 .documentTitleFieldName("documentTitleFieldName")
 *                                 .excludeAttachmentFilePatterns(List.of("excludeAttachmentFilePatterns"))
 *                                 .fieldMappings(List.of(DataSourceToIndexFieldMappingProperty.builder()
 *                                         .dataSourceFieldName("dataSourceFieldName")
 *                                         .indexFieldName("indexFieldName")
 *                                         // the properties below are optional
 *                                         .dateFieldFormat("dateFieldFormat")
 *                                         .build()))
 *                                 .filterQuery("filterQuery")
 *                                 .includeAttachmentFilePatterns(List.of("includeAttachmentFilePatterns"))
 *                                 .build())
 *                         .serviceCatalogConfiguration(ServiceNowServiceCatalogConfigurationProperty.builder()
 *                                 .documentDataFieldName("documentDataFieldName")
 *                                 // the properties below are optional
 *                                 .crawlAttachments(false)
 *                                 .documentTitleFieldName("documentTitleFieldName")
 *                                 .excludeAttachmentFilePatterns(List.of("excludeAttachmentFilePatterns"))
 *                                 .fieldMappings(List.of(DataSourceToIndexFieldMappingProperty.builder()
 *                                         .dataSourceFieldName("dataSourceFieldName")
 *                                         .indexFieldName("indexFieldName")
 *                                         // the properties below are optional
 *                                         .dateFieldFormat("dateFieldFormat")
 *                                         .build()))
 *                                 .includeAttachmentFilePatterns(List.of("includeAttachmentFilePatterns"))
 *                                 .build())
 *                         .build())
 *                 .sharePointConfiguration(SharePointConfigurationProperty.builder()
 *                         .secretArn("secretArn")
 *                         .sharePointVersion("sharePointVersion")
 *                         .urls(List.of("urls"))
 *                         // the properties below are optional
 *                         .crawlAttachments(false)
 *                         .disableLocalGroups(false)
 *                         .documentTitleFieldName("documentTitleFieldName")
 *                         .exclusionPatterns(List.of("exclusionPatterns"))
 *                         .fieldMappings(List.of(DataSourceToIndexFieldMappingProperty.builder()
 *                                 .dataSourceFieldName("dataSourceFieldName")
 *                                 .indexFieldName("indexFieldName")
 *                                 // the properties below are optional
 *                                 .dateFieldFormat("dateFieldFormat")
 *                                 .build()))
 *                         .inclusionPatterns(List.of("inclusionPatterns"))
 *                         .sslCertificateS3Path(S3PathProperty.builder()
 *                                 .bucket("bucket")
 *                                 .key("key")
 *                                 .build())
 *                         .useChangeLog(false)
 *                         .vpcConfiguration(DataSourceVpcConfigurationProperty.builder()
 *                                 .securityGroupIds(List.of("securityGroupIds"))
 *                                 .subnetIds(List.of("subnetIds"))
 *                                 .build())
 *                         .build())
 *                 .webCrawlerConfiguration(WebCrawlerConfigurationProperty.builder()
 *                         .urls(WebCrawlerUrlsProperty.builder()
 *                                 .seedUrlConfiguration(WebCrawlerSeedUrlConfigurationProperty.builder()
 *                                         .seedUrls(List.of("seedUrls"))
 *                                         // the properties below are optional
 *                                         .webCrawlerMode("webCrawlerMode")
 *                                         .build())
 *                                 .siteMapsConfiguration(WebCrawlerSiteMapsConfigurationProperty.builder()
 *                                         .siteMaps(List.of("siteMaps"))
 *                                         .build())
 *                                 .build())
 *                         // the properties below are optional
 *                         .authenticationConfiguration(WebCrawlerAuthenticationConfigurationProperty.builder()
 *                                 .basicAuthentication(List.of(WebCrawlerBasicAuthenticationProperty.builder()
 *                                         .credentials("credentials")
 *                                         .host("host")
 *                                         .port(123)
 *                                         .build()))
 *                                 .build())
 *                         .crawlDepth(123)
 *                         .maxContentSizePerPageInMegaBytes(123)
 *                         .maxLinksPerPage(123)
 *                         .maxUrlsPerMinuteCrawlRate(123)
 *                         .proxyConfiguration(ProxyConfigurationProperty.builder()
 *                                 .host("host")
 *                                 .port(123)
 *                                 // the properties below are optional
 *                                 .credentials("credentials")
 *                                 .build())
 *                         .urlExclusionPatterns(List.of("urlExclusionPatterns"))
 *                         .urlInclusionPatterns(List.of("urlInclusionPatterns"))
 *                         .build())
 *                 .workDocsConfiguration(WorkDocsConfigurationProperty.builder()
 *                         .organizationId("organizationId")
 *                         // the properties below are optional
 *                         .crawlComments(false)
 *                         .exclusionPatterns(List.of("exclusionPatterns"))
 *                         .fieldMappings(List.of(DataSourceToIndexFieldMappingProperty.builder()
 *                                 .dataSourceFieldName("dataSourceFieldName")
 *                                 .indexFieldName("indexFieldName")
 *                                 // the properties below are optional
 *                                 .dateFieldFormat("dateFieldFormat")
 *                                 .build()))
 *                         .inclusionPatterns(List.of("inclusionPatterns"))
 *                         .useChangeLog(false)
 *                         .build())
 *                 .build())
 *         .description("description")
 *         .roleArn("roleArn")
 *         .schedule("schedule")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-29T04:34:10.925Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kendra.CfnDataSourceProps")
@software.amazon.jsii.Jsii.Proxy(CfnDataSourceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDataSourceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The identifier of the index that should be associated with this data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIndexId();

    /**
     * The name of the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The type of the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getType();

    /**
     * Configuration information for an Amazon Kendra data source.
     * <p>
     * The contents of the configuration depend on the type of data source. You can only specify one type of data source in the configuration. Choose from one of the following data sources.
     * <p>
     * <ul>
     * <li>Amazon S3</li>
     * <li>Confluence</li>
     * <li>Custom</li>
     * <li>Database</li>
     * <li>Microsoft OneDrive</li>
     * <li>Microsoft SharePoint</li>
     * <li>Salesforce</li>
     * <li>ServiceNow</li>
     * </ul>
     * <p>
     * You can't specify the <code>Configuration</code> parameter when the <code>Type</code> parameter is set to <code>CUSTOM</code> .
     * <p>
     * The <code>Configuration</code> parameter is required for all other data sources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDataSourceConfiguration() {
        return null;
    }

    /**
     * A description of the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of a role with permission to access the data source.
     * <p>
     * You can't specify the <code>RoleArn</code> parameter when the <code>Type</code> parameter is set to <code>CUSTOM</code> .
     * <p>
     * The <code>RoleArn</code> parameter is required for all other data sources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRoleArn() {
        return null;
    }

    /**
     * Sets the frequency that Amazon Kendra checks the documents in your data source and updates the index.
     * <p>
     * If you don't set a schedule, Amazon Kendra doesn't periodically update the index.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSchedule() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDataSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDataSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDataSourceProps> {
        java.lang.String indexId;
        java.lang.String name;
        java.lang.String type;
        java.lang.Object dataSourceConfiguration;
        java.lang.String description;
        java.lang.String roleArn;
        java.lang.String schedule;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnDataSourceProps#getIndexId}
         * @param indexId The identifier of the index that should be associated with this data source. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder indexId(java.lang.String indexId) {
            this.indexId = indexId;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getName}
         * @param name The name of the data source. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getType}
         * @param type The type of the data source. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(java.lang.String type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getDataSourceConfiguration}
         * @param dataSourceConfiguration Configuration information for an Amazon Kendra data source.
         *                                The contents of the configuration depend on the type of data source. You can only specify one type of data source in the configuration. Choose from one of the following data sources.
         *                                <p>
         *                                <ul>
         *                                <li>Amazon S3</li>
         *                                <li>Confluence</li>
         *                                <li>Custom</li>
         *                                <li>Database</li>
         *                                <li>Microsoft OneDrive</li>
         *                                <li>Microsoft SharePoint</li>
         *                                <li>Salesforce</li>
         *                                <li>ServiceNow</li>
         *                                </ul>
         *                                <p>
         *                                You can't specify the <code>Configuration</code> parameter when the <code>Type</code> parameter is set to <code>CUSTOM</code> .
         *                                <p>
         *                                The <code>Configuration</code> parameter is required for all other data sources.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataSourceConfiguration(software.amazon.awscdk.services.kendra.CfnDataSource.DataSourceConfigurationProperty dataSourceConfiguration) {
            this.dataSourceConfiguration = dataSourceConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getDataSourceConfiguration}
         * @param dataSourceConfiguration Configuration information for an Amazon Kendra data source.
         *                                The contents of the configuration depend on the type of data source. You can only specify one type of data source in the configuration. Choose from one of the following data sources.
         *                                <p>
         *                                <ul>
         *                                <li>Amazon S3</li>
         *                                <li>Confluence</li>
         *                                <li>Custom</li>
         *                                <li>Database</li>
         *                                <li>Microsoft OneDrive</li>
         *                                <li>Microsoft SharePoint</li>
         *                                <li>Salesforce</li>
         *                                <li>ServiceNow</li>
         *                                </ul>
         *                                <p>
         *                                You can't specify the <code>Configuration</code> parameter when the <code>Type</code> parameter is set to <code>CUSTOM</code> .
         *                                <p>
         *                                The <code>Configuration</code> parameter is required for all other data sources.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataSourceConfiguration(software.amazon.awscdk.IResolvable dataSourceConfiguration) {
            this.dataSourceConfiguration = dataSourceConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getDescription}
         * @param description A description of the data source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getRoleArn}
         * @param roleArn The Amazon Resource Name (ARN) of a role with permission to access the data source.
         *                You can't specify the <code>RoleArn</code> parameter when the <code>Type</code> parameter is set to <code>CUSTOM</code> .
         *                <p>
         *                The <code>RoleArn</code> parameter is required for all other data sources.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(java.lang.String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getSchedule}
         * @param schedule Sets the frequency that Amazon Kendra checks the documents in your data source and updates the index.
         *                 If you don't set a schedule, Amazon Kendra doesn't periodically update the index.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedule(java.lang.String schedule) {
            this.schedule = schedule;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getTags}
         * @param tags An array of key-value pairs to apply to this resource.
         *             For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDataSourceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDataSourceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDataSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDataSourceProps {
        private final java.lang.String indexId;
        private final java.lang.String name;
        private final java.lang.String type;
        private final java.lang.Object dataSourceConfiguration;
        private final java.lang.String description;
        private final java.lang.String roleArn;
        private final java.lang.String schedule;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.indexId = software.amazon.jsii.Kernel.get(this, "indexId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dataSourceConfiguration = software.amazon.jsii.Kernel.get(this, "dataSourceConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.schedule = software.amazon.jsii.Kernel.get(this, "schedule", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.indexId = java.util.Objects.requireNonNull(builder.indexId, "indexId is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            this.dataSourceConfiguration = builder.dataSourceConfiguration;
            this.description = builder.description;
            this.roleArn = builder.roleArn;
            this.schedule = builder.schedule;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getIndexId() {
            return this.indexId;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getType() {
            return this.type;
        }

        @Override
        public final java.lang.Object getDataSourceConfiguration() {
            return this.dataSourceConfiguration;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final java.lang.String getSchedule() {
            return this.schedule;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("indexId", om.valueToTree(this.getIndexId()));
            data.set("name", om.valueToTree(this.getName()));
            data.set("type", om.valueToTree(this.getType()));
            if (this.getDataSourceConfiguration() != null) {
                data.set("dataSourceConfiguration", om.valueToTree(this.getDataSourceConfiguration()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getRoleArn() != null) {
                data.set("roleArn", om.valueToTree(this.getRoleArn()));
            }
            if (this.getSchedule() != null) {
                data.set("schedule", om.valueToTree(this.getSchedule()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kendra.CfnDataSourceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDataSourceProps.Jsii$Proxy that = (CfnDataSourceProps.Jsii$Proxy) o;

            if (!indexId.equals(that.indexId)) return false;
            if (!name.equals(that.name)) return false;
            if (!type.equals(that.type)) return false;
            if (this.dataSourceConfiguration != null ? !this.dataSourceConfiguration.equals(that.dataSourceConfiguration) : that.dataSourceConfiguration != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.roleArn != null ? !this.roleArn.equals(that.roleArn) : that.roleArn != null) return false;
            if (this.schedule != null ? !this.schedule.equals(that.schedule) : that.schedule != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.indexId.hashCode();
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.type.hashCode());
            result = 31 * result + (this.dataSourceConfiguration != null ? this.dataSourceConfiguration.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.roleArn != null ? this.roleArn.hashCode() : 0);
            result = 31 * result + (this.schedule != null ? this.schedule.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
