package software.amazon.awscdk.services.iotwireless;

/**
 * A CloudFormation `AWS::IoTWireless::MulticastGroup`.
 * <p>
 * A multicast group.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iotwireless.*;
 * CfnMulticastGroup cfnMulticastGroup = CfnMulticastGroup.Builder.create(this, "MyCfnMulticastGroup")
 *         .loRaWan(LoRaWANProperty.builder()
 *                 .dlClass("dlClass")
 *                 .rfRegion("rfRegion")
 *                 // the properties below are optional
 *                 .numberOfDevicesInGroup(123)
 *                 .numberOfDevicesRequested(123)
 *                 .build())
 *         // the properties below are optional
 *         .associateWirelessDevice("associateWirelessDevice")
 *         .description("description")
 *         .disassociateWirelessDevice("disassociateWirelessDevice")
 *         .name("name")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-29T04:34:10.854Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotwireless.CfnMulticastGroup")
public class CfnMulticastGroup extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnMulticastGroup(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnMulticastGroup(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.iotwireless.CfnMulticastGroup.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::IoTWireless::MulticastGroup`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnMulticastGroup(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotwireless.CfnMulticastGroupProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ARN of the multicast group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the multicast group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The number of devices that are associated to the multicast group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrLoRaWanNumberOfDevicesInGroup() {
        return software.amazon.jsii.Kernel.get(this, "attrLoRaWanNumberOfDevicesInGroup", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The number of devices that are requested to be associated with the multicast group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrLoRaWanNumberOfDevicesRequested() {
        return software.amazon.jsii.Kernel.get(this, "attrLoRaWanNumberOfDevicesRequested", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The status of a multicast group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The tags are an array of key-value pairs to attach to the specified resource.
     * <p>
     * Tags can have a minimum of 0 and a maximum of 50 items.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The LoRaWAN information that is to be used with the multicast group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getLoRaWan() {
        return software.amazon.jsii.Kernel.get(this, "loRaWan", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The LoRaWAN information that is to be used with the multicast group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLoRaWan(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotwireless.CfnMulticastGroup.LoRaWANProperty value) {
        software.amazon.jsii.Kernel.set(this, "loRaWan", java.util.Objects.requireNonNull(value, "loRaWan is required"));
    }

    /**
     * The LoRaWAN information that is to be used with the multicast group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLoRaWan(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "loRaWan", java.util.Objects.requireNonNull(value, "loRaWan is required"));
    }

    /**
     * The ID of the wireless device to associate with a multicast group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAssociateWirelessDevice() {
        return software.amazon.jsii.Kernel.get(this, "associateWirelessDevice", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the wireless device to associate with a multicast group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAssociateWirelessDevice(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "associateWirelessDevice", value);
    }

    /**
     * The description of the multicast group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description of the multicast group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * The ID of the wireless device to disassociate from a multicast group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDisassociateWirelessDevice() {
        return software.amazon.jsii.Kernel.get(this, "disassociateWirelessDevice", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the wireless device to disassociate from a multicast group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDisassociateWirelessDevice(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "disassociateWirelessDevice", value);
    }

    /**
     * The name of the multicast group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the multicast group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }
    /**
     * The LoRaWAN information that is to be used with the multicast group.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotwireless.*;
     * LoRaWANProperty loRaWANProperty = LoRaWANProperty.builder()
     *         .dlClass("dlClass")
     *         .rfRegion("rfRegion")
     *         // the properties below are optional
     *         .numberOfDevicesInGroup(123)
     *         .numberOfDevicesRequested(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotwireless.CfnMulticastGroup.LoRaWANProperty")
    @software.amazon.jsii.Jsii.Proxy(LoRaWANProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LoRaWANProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * DlClass for LoRaWAN.
         * <p>
         * Valid values are ClassB and ClassC.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDlClass();

        /**
         * The frequency band (RFRegion) value.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRfRegion();

        /**
         * Number of devices that are associated to the multicast group.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getNumberOfDevicesInGroup() {
            return null;
        }

        /**
         * Number of devices that are requested to be associated with the multicast group.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getNumberOfDevicesRequested() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LoRaWANProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LoRaWANProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LoRaWANProperty> {
            java.lang.String dlClass;
            java.lang.String rfRegion;
            java.lang.Number numberOfDevicesInGroup;
            java.lang.Number numberOfDevicesRequested;

            /**
             * Sets the value of {@link LoRaWANProperty#getDlClass}
             * @param dlClass DlClass for LoRaWAN. This parameter is required.
             *                Valid values are ClassB and ClassC.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dlClass(java.lang.String dlClass) {
                this.dlClass = dlClass;
                return this;
            }

            /**
             * Sets the value of {@link LoRaWANProperty#getRfRegion}
             * @param rfRegion The frequency band (RFRegion) value. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rfRegion(java.lang.String rfRegion) {
                this.rfRegion = rfRegion;
                return this;
            }

            /**
             * Sets the value of {@link LoRaWANProperty#getNumberOfDevicesInGroup}
             * @param numberOfDevicesInGroup Number of devices that are associated to the multicast group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder numberOfDevicesInGroup(java.lang.Number numberOfDevicesInGroup) {
                this.numberOfDevicesInGroup = numberOfDevicesInGroup;
                return this;
            }

            /**
             * Sets the value of {@link LoRaWANProperty#getNumberOfDevicesRequested}
             * @param numberOfDevicesRequested Number of devices that are requested to be associated with the multicast group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder numberOfDevicesRequested(java.lang.Number numberOfDevicesRequested) {
                this.numberOfDevicesRequested = numberOfDevicesRequested;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LoRaWANProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LoRaWANProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LoRaWANProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LoRaWANProperty {
            private final java.lang.String dlClass;
            private final java.lang.String rfRegion;
            private final java.lang.Number numberOfDevicesInGroup;
            private final java.lang.Number numberOfDevicesRequested;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dlClass = software.amazon.jsii.Kernel.get(this, "dlClass", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.rfRegion = software.amazon.jsii.Kernel.get(this, "rfRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.numberOfDevicesInGroup = software.amazon.jsii.Kernel.get(this, "numberOfDevicesInGroup", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.numberOfDevicesRequested = software.amazon.jsii.Kernel.get(this, "numberOfDevicesRequested", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dlClass = java.util.Objects.requireNonNull(builder.dlClass, "dlClass is required");
                this.rfRegion = java.util.Objects.requireNonNull(builder.rfRegion, "rfRegion is required");
                this.numberOfDevicesInGroup = builder.numberOfDevicesInGroup;
                this.numberOfDevicesRequested = builder.numberOfDevicesRequested;
            }

            @Override
            public final java.lang.String getDlClass() {
                return this.dlClass;
            }

            @Override
            public final java.lang.String getRfRegion() {
                return this.rfRegion;
            }

            @Override
            public final java.lang.Number getNumberOfDevicesInGroup() {
                return this.numberOfDevicesInGroup;
            }

            @Override
            public final java.lang.Number getNumberOfDevicesRequested() {
                return this.numberOfDevicesRequested;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("dlClass", om.valueToTree(this.getDlClass()));
                data.set("rfRegion", om.valueToTree(this.getRfRegion()));
                if (this.getNumberOfDevicesInGroup() != null) {
                    data.set("numberOfDevicesInGroup", om.valueToTree(this.getNumberOfDevicesInGroup()));
                }
                if (this.getNumberOfDevicesRequested() != null) {
                    data.set("numberOfDevicesRequested", om.valueToTree(this.getNumberOfDevicesRequested()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotwireless.CfnMulticastGroup.LoRaWANProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LoRaWANProperty.Jsii$Proxy that = (LoRaWANProperty.Jsii$Proxy) o;

                if (!dlClass.equals(that.dlClass)) return false;
                if (!rfRegion.equals(that.rfRegion)) return false;
                if (this.numberOfDevicesInGroup != null ? !this.numberOfDevicesInGroup.equals(that.numberOfDevicesInGroup) : that.numberOfDevicesInGroup != null) return false;
                return this.numberOfDevicesRequested != null ? this.numberOfDevicesRequested.equals(that.numberOfDevicesRequested) : that.numberOfDevicesRequested == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dlClass.hashCode();
                result = 31 * result + (this.rfRegion.hashCode());
                result = 31 * result + (this.numberOfDevicesInGroup != null ? this.numberOfDevicesInGroup.hashCode() : 0);
                result = 31 * result + (this.numberOfDevicesRequested != null ? this.numberOfDevicesRequested.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.iotwireless.CfnMulticastGroup}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.iotwireless.CfnMulticastGroup> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.iotwireless.CfnMulticastGroupProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.iotwireless.CfnMulticastGroupProps.Builder();
        }

        /**
         * The LoRaWAN information that is to be used with the multicast group.
         * <p>
         * @return {@code this}
         * @param loRaWan The LoRaWAN information that is to be used with the multicast group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loRaWan(final software.amazon.awscdk.services.iotwireless.CfnMulticastGroup.LoRaWANProperty loRaWan) {
            this.props.loRaWan(loRaWan);
            return this;
        }
        /**
         * The LoRaWAN information that is to be used with the multicast group.
         * <p>
         * @return {@code this}
         * @param loRaWan The LoRaWAN information that is to be used with the multicast group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loRaWan(final software.amazon.awscdk.IResolvable loRaWan) {
            this.props.loRaWan(loRaWan);
            return this;
        }

        /**
         * The ID of the wireless device to associate with a multicast group.
         * <p>
         * @return {@code this}
         * @param associateWirelessDevice The ID of the wireless device to associate with a multicast group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder associateWirelessDevice(final java.lang.String associateWirelessDevice) {
            this.props.associateWirelessDevice(associateWirelessDevice);
            return this;
        }

        /**
         * The description of the multicast group.
         * <p>
         * @return {@code this}
         * @param description The description of the multicast group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The ID of the wireless device to disassociate from a multicast group.
         * <p>
         * @return {@code this}
         * @param disassociateWirelessDevice The ID of the wireless device to disassociate from a multicast group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disassociateWirelessDevice(final java.lang.String disassociateWirelessDevice) {
            this.props.disassociateWirelessDevice(disassociateWirelessDevice);
            return this;
        }

        /**
         * The name of the multicast group.
         * <p>
         * @return {@code this}
         * @param name The name of the multicast group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The tags are an array of key-value pairs to attach to the specified resource.
         * <p>
         * Tags can have a minimum of 0 and a maximum of 50 items.
         * <p>
         * @return {@code this}
         * @param tags The tags are an array of key-value pairs to attach to the specified resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.iotwireless.CfnMulticastGroup}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.iotwireless.CfnMulticastGroup build() {
            return new software.amazon.awscdk.services.iotwireless.CfnMulticastGroup(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
