package software.amazon.awscdk.services.guardduty;

/**
 * Properties for defining a `CfnMaster`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.guardduty.*;
 * CfnMasterProps cfnMasterProps = CfnMasterProps.builder()
 *         .detectorId("detectorId")
 *         .masterId("masterId")
 *         // the properties below are optional
 *         .invitationId("invitationId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-29T04:34:10.498Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_guardduty.CfnMasterProps")
@software.amazon.jsii.Jsii.Proxy(CfnMasterProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnMasterProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The unique ID of the detector of the GuardDuty member account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDetectorId();

    /**
     * The AWS account ID of the account designated as the  administrator account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getMasterId();

    /**
     * The ID of the invitation that is sent to the account designated as a member account.
     * <p>
     * You can find the invitation ID by using the ListInvitation action of the  API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getInvitationId() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnMasterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnMasterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnMasterProps> {
        java.lang.String detectorId;
        java.lang.String masterId;
        java.lang.String invitationId;

        /**
         * Sets the value of {@link CfnMasterProps#getDetectorId}
         * @param detectorId The unique ID of the detector of the GuardDuty member account. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder detectorId(java.lang.String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        /**
         * Sets the value of {@link CfnMasterProps#getMasterId}
         * @param masterId The AWS account ID of the account designated as the  administrator account. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder masterId(java.lang.String masterId) {
            this.masterId = masterId;
            return this;
        }

        /**
         * Sets the value of {@link CfnMasterProps#getInvitationId}
         * @param invitationId The ID of the invitation that is sent to the account designated as a member account.
         *                     You can find the invitation ID by using the ListInvitation action of the  API.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder invitationId(java.lang.String invitationId) {
            this.invitationId = invitationId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnMasterProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnMasterProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnMasterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnMasterProps {
        private final java.lang.String detectorId;
        private final java.lang.String masterId;
        private final java.lang.String invitationId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.detectorId = software.amazon.jsii.Kernel.get(this, "detectorId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.masterId = software.amazon.jsii.Kernel.get(this, "masterId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.invitationId = software.amazon.jsii.Kernel.get(this, "invitationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.detectorId = java.util.Objects.requireNonNull(builder.detectorId, "detectorId is required");
            this.masterId = java.util.Objects.requireNonNull(builder.masterId, "masterId is required");
            this.invitationId = builder.invitationId;
        }

        @Override
        public final java.lang.String getDetectorId() {
            return this.detectorId;
        }

        @Override
        public final java.lang.String getMasterId() {
            return this.masterId;
        }

        @Override
        public final java.lang.String getInvitationId() {
            return this.invitationId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("detectorId", om.valueToTree(this.getDetectorId()));
            data.set("masterId", om.valueToTree(this.getMasterId()));
            if (this.getInvitationId() != null) {
                data.set("invitationId", om.valueToTree(this.getInvitationId()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_guardduty.CfnMasterProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnMasterProps.Jsii$Proxy that = (CfnMasterProps.Jsii$Proxy) o;

            if (!detectorId.equals(that.detectorId)) return false;
            if (!masterId.equals(that.masterId)) return false;
            return this.invitationId != null ? this.invitationId.equals(that.invitationId) : that.invitationId == null;
        }

        @Override
        public final int hashCode() {
            int result = this.detectorId.hashCode();
            result = 31 * result + (this.masterId.hashCode());
            result = 31 * result + (this.invitationId != null ? this.invitationId.hashCode() : 0);
            return result;
        }
    }
}
