package software.amazon.awscdk.services.gamelift;

/**
 * Properties for defining a `CfnGameServerGroup`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.gamelift.*;
 * CfnGameServerGroupProps cfnGameServerGroupProps = CfnGameServerGroupProps.builder()
 *         .gameServerGroupName("gameServerGroupName")
 *         .instanceDefinitions(List.of(InstanceDefinitionProperty.builder()
 *                 .instanceType("instanceType")
 *                 // the properties below are optional
 *                 .weightedCapacity("weightedCapacity")
 *                 .build()))
 *         .launchTemplate(LaunchTemplateProperty.builder()
 *                 .launchTemplateId("launchTemplateId")
 *                 .launchTemplateName("launchTemplateName")
 *                 .version("version")
 *                 .build())
 *         .roleArn("roleArn")
 *         // the properties below are optional
 *         .autoScalingPolicy(AutoScalingPolicyProperty.builder()
 *                 .targetTrackingConfiguration(TargetTrackingConfigurationProperty.builder()
 *                         .targetValue(123)
 *                         .build())
 *                 // the properties below are optional
 *                 .estimatedInstanceWarmup(123)
 *                 .build())
 *         .balancingStrategy("balancingStrategy")
 *         .deleteOption("deleteOption")
 *         .gameServerProtectionPolicy("gameServerProtectionPolicy")
 *         .maxSize(123)
 *         .minSize(123)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .vpcSubnets(List.of("vpcSubnets"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-29T04:34:10.278Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_gamelift.CfnGameServerGroupProps")
@software.amazon.jsii.Jsii.Proxy(CfnGameServerGroupProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnGameServerGroupProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A developer-defined identifier for the game server group.
     * <p>
     * The name is unique for each Region in each AWS account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getGameServerGroupName();

    /**
     * The set of Amazon EC2 instance types that GameLift FleetIQ can use when balancing and automatically scaling instances in the corresponding Auto Scaling group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getInstanceDefinitions();

    /**
     * `AWS::GameLift::GameServerGroup.LaunchTemplate`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getLaunchTemplate();

    /**
     * The Amazon Resource Name ( [ARN](https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html) ) for an IAM role that allows Amazon Web Services to access your Amazon EC2 Auto Scaling groups.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

    /**
     * `AWS::GameLift::GameServerGroup.AutoScalingPolicy`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAutoScalingPolicy() {
        return null;
    }

    /**
     * Indicates how GameLift FleetIQ balances the use of Spot Instances and On-Demand Instances in the game server group.
     * <p>
     * Method options include the following:
     * <p>
     * <ul>
     * <li><code>SPOT_ONLY</code> - Only Spot Instances are used in the game server group. If Spot Instances are unavailable or not viable for game hosting, the game server group provides no hosting capacity until Spot Instances can again be used. Until then, no new instances are started, and the existing nonviable Spot Instances are terminated (after current gameplay ends) and are not replaced.</li>
     * <li><code>SPOT_PREFERRED</code> - (default value) Spot Instances are used whenever available in the game server group. If Spot Instances are unavailable, the game server group continues to provide hosting capacity by falling back to On-Demand Instances. Existing nonviable Spot Instances are terminated (after current gameplay ends) and are replaced with new On-Demand Instances.</li>
     * <li><code>ON_DEMAND_ONLY</code> - Only On-Demand Instances are used in the game server group. No Spot Instances are used, even when available, while this balancing strategy is in force.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getBalancingStrategy() {
        return null;
    }

    /**
     * `AWS::GameLift::GameServerGroup.DeleteOption`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDeleteOption() {
        return null;
    }

    /**
     * A flag that indicates whether instances in the game server group are protected from early termination.
     * <p>
     * Unprotected instances that have active game servers running might be terminated during a scale-down event, causing players to be dropped from the game. Protected instances cannot be terminated while there are active game servers running except in the event of a forced game server group deletion (see ). An exception to this is with Spot Instances, which can be terminated by AWS regardless of protection status.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getGameServerProtectionPolicy() {
        return null;
    }

    /**
     * `AWS::GameLift::GameServerGroup.MaxSize`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxSize() {
        return null;
    }

    /**
     * `AWS::GameLift::GameServerGroup.MinSize`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMinSize() {
        return null;
    }

    /**
     * `AWS::GameLift::GameServerGroup.Tags`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * `AWS::GameLift::GameServerGroup.VpcSubnets`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getVpcSubnets() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnGameServerGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnGameServerGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnGameServerGroupProps> {
        java.lang.String gameServerGroupName;
        java.lang.Object instanceDefinitions;
        java.lang.Object launchTemplate;
        java.lang.String roleArn;
        java.lang.Object autoScalingPolicy;
        java.lang.String balancingStrategy;
        java.lang.String deleteOption;
        java.lang.String gameServerProtectionPolicy;
        java.lang.Number maxSize;
        java.lang.Number minSize;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.util.List<java.lang.String> vpcSubnets;

        /**
         * Sets the value of {@link CfnGameServerGroupProps#getGameServerGroupName}
         * @param gameServerGroupName A developer-defined identifier for the game server group. This parameter is required.
         *                            The name is unique for each Region in each AWS account.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gameServerGroupName(java.lang.String gameServerGroupName) {
            this.gameServerGroupName = gameServerGroupName;
            return this;
        }

        /**
         * Sets the value of {@link CfnGameServerGroupProps#getInstanceDefinitions}
         * @param instanceDefinitions The set of Amazon EC2 instance types that GameLift FleetIQ can use when balancing and automatically scaling instances in the corresponding Auto Scaling group. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceDefinitions(software.amazon.awscdk.IResolvable instanceDefinitions) {
            this.instanceDefinitions = instanceDefinitions;
            return this;
        }

        /**
         * Sets the value of {@link CfnGameServerGroupProps#getInstanceDefinitions}
         * @param instanceDefinitions The set of Amazon EC2 instance types that GameLift FleetIQ can use when balancing and automatically scaling instances in the corresponding Auto Scaling group. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceDefinitions(java.util.List<? extends java.lang.Object> instanceDefinitions) {
            this.instanceDefinitions = instanceDefinitions;
            return this;
        }

        /**
         * Sets the value of {@link CfnGameServerGroupProps#getLaunchTemplate}
         * @param launchTemplate `AWS::GameLift::GameServerGroup.LaunchTemplate`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder launchTemplate(software.amazon.awscdk.services.gamelift.CfnGameServerGroup.LaunchTemplateProperty launchTemplate) {
            this.launchTemplate = launchTemplate;
            return this;
        }

        /**
         * Sets the value of {@link CfnGameServerGroupProps#getLaunchTemplate}
         * @param launchTemplate `AWS::GameLift::GameServerGroup.LaunchTemplate`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder launchTemplate(software.amazon.awscdk.IResolvable launchTemplate) {
            this.launchTemplate = launchTemplate;
            return this;
        }

        /**
         * Sets the value of {@link CfnGameServerGroupProps#getRoleArn}
         * @param roleArn The Amazon Resource Name ( [ARN](https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html) ) for an IAM role that allows Amazon Web Services to access your Amazon EC2 Auto Scaling groups. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(java.lang.String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnGameServerGroupProps#getAutoScalingPolicy}
         * @param autoScalingPolicy `AWS::GameLift::GameServerGroup.AutoScalingPolicy`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoScalingPolicy(software.amazon.awscdk.services.gamelift.CfnGameServerGroup.AutoScalingPolicyProperty autoScalingPolicy) {
            this.autoScalingPolicy = autoScalingPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnGameServerGroupProps#getAutoScalingPolicy}
         * @param autoScalingPolicy `AWS::GameLift::GameServerGroup.AutoScalingPolicy`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoScalingPolicy(software.amazon.awscdk.IResolvable autoScalingPolicy) {
            this.autoScalingPolicy = autoScalingPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnGameServerGroupProps#getBalancingStrategy}
         * @param balancingStrategy Indicates how GameLift FleetIQ balances the use of Spot Instances and On-Demand Instances in the game server group.
         *                          Method options include the following:
         *                          <p>
         *                          <ul>
         *                          <li><code>SPOT_ONLY</code> - Only Spot Instances are used in the game server group. If Spot Instances are unavailable or not viable for game hosting, the game server group provides no hosting capacity until Spot Instances can again be used. Until then, no new instances are started, and the existing nonviable Spot Instances are terminated (after current gameplay ends) and are not replaced.</li>
         *                          <li><code>SPOT_PREFERRED</code> - (default value) Spot Instances are used whenever available in the game server group. If Spot Instances are unavailable, the game server group continues to provide hosting capacity by falling back to On-Demand Instances. Existing nonviable Spot Instances are terminated (after current gameplay ends) and are replaced with new On-Demand Instances.</li>
         *                          <li><code>ON_DEMAND_ONLY</code> - Only On-Demand Instances are used in the game server group. No Spot Instances are used, even when available, while this balancing strategy is in force.</li>
         *                          </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder balancingStrategy(java.lang.String balancingStrategy) {
            this.balancingStrategy = balancingStrategy;
            return this;
        }

        /**
         * Sets the value of {@link CfnGameServerGroupProps#getDeleteOption}
         * @param deleteOption `AWS::GameLift::GameServerGroup.DeleteOption`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deleteOption(java.lang.String deleteOption) {
            this.deleteOption = deleteOption;
            return this;
        }

        /**
         * Sets the value of {@link CfnGameServerGroupProps#getGameServerProtectionPolicy}
         * @param gameServerProtectionPolicy A flag that indicates whether instances in the game server group are protected from early termination.
         *                                   Unprotected instances that have active game servers running might be terminated during a scale-down event, causing players to be dropped from the game. Protected instances cannot be terminated while there are active game servers running except in the event of a forced game server group deletion (see ). An exception to this is with Spot Instances, which can be terminated by AWS regardless of protection status.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gameServerProtectionPolicy(java.lang.String gameServerProtectionPolicy) {
            this.gameServerProtectionPolicy = gameServerProtectionPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnGameServerGroupProps#getMaxSize}
         * @param maxSize `AWS::GameLift::GameServerGroup.MaxSize`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxSize(java.lang.Number maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        /**
         * Sets the value of {@link CfnGameServerGroupProps#getMinSize}
         * @param minSize `AWS::GameLift::GameServerGroup.MinSize`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minSize(java.lang.Number minSize) {
            this.minSize = minSize;
            return this;
        }

        /**
         * Sets the value of {@link CfnGameServerGroupProps#getTags}
         * @param tags `AWS::GameLift::GameServerGroup.Tags`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnGameServerGroupProps#getVpcSubnets}
         * @param vpcSubnets `AWS::GameLift::GameServerGroup.VpcSubnets`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSubnets(java.util.List<java.lang.String> vpcSubnets) {
            this.vpcSubnets = vpcSubnets;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnGameServerGroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnGameServerGroupProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnGameServerGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnGameServerGroupProps {
        private final java.lang.String gameServerGroupName;
        private final java.lang.Object instanceDefinitions;
        private final java.lang.Object launchTemplate;
        private final java.lang.String roleArn;
        private final java.lang.Object autoScalingPolicy;
        private final java.lang.String balancingStrategy;
        private final java.lang.String deleteOption;
        private final java.lang.String gameServerProtectionPolicy;
        private final java.lang.Number maxSize;
        private final java.lang.Number minSize;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.util.List<java.lang.String> vpcSubnets;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.gameServerGroupName = software.amazon.jsii.Kernel.get(this, "gameServerGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.instanceDefinitions = software.amazon.jsii.Kernel.get(this, "instanceDefinitions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.launchTemplate = software.amazon.jsii.Kernel.get(this, "launchTemplate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.autoScalingPolicy = software.amazon.jsii.Kernel.get(this, "autoScalingPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.balancingStrategy = software.amazon.jsii.Kernel.get(this, "balancingStrategy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.deleteOption = software.amazon.jsii.Kernel.get(this, "deleteOption", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.gameServerProtectionPolicy = software.amazon.jsii.Kernel.get(this, "gameServerProtectionPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.maxSize = software.amazon.jsii.Kernel.get(this, "maxSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.minSize = software.amazon.jsii.Kernel.get(this, "minSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.vpcSubnets = software.amazon.jsii.Kernel.get(this, "vpcSubnets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.gameServerGroupName = java.util.Objects.requireNonNull(builder.gameServerGroupName, "gameServerGroupName is required");
            this.instanceDefinitions = java.util.Objects.requireNonNull(builder.instanceDefinitions, "instanceDefinitions is required");
            this.launchTemplate = java.util.Objects.requireNonNull(builder.launchTemplate, "launchTemplate is required");
            this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
            this.autoScalingPolicy = builder.autoScalingPolicy;
            this.balancingStrategy = builder.balancingStrategy;
            this.deleteOption = builder.deleteOption;
            this.gameServerProtectionPolicy = builder.gameServerProtectionPolicy;
            this.maxSize = builder.maxSize;
            this.minSize = builder.minSize;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.vpcSubnets = builder.vpcSubnets;
        }

        @Override
        public final java.lang.String getGameServerGroupName() {
            return this.gameServerGroupName;
        }

        @Override
        public final java.lang.Object getInstanceDefinitions() {
            return this.instanceDefinitions;
        }

        @Override
        public final java.lang.Object getLaunchTemplate() {
            return this.launchTemplate;
        }

        @Override
        public final java.lang.String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final java.lang.Object getAutoScalingPolicy() {
            return this.autoScalingPolicy;
        }

        @Override
        public final java.lang.String getBalancingStrategy() {
            return this.balancingStrategy;
        }

        @Override
        public final java.lang.String getDeleteOption() {
            return this.deleteOption;
        }

        @Override
        public final java.lang.String getGameServerProtectionPolicy() {
            return this.gameServerProtectionPolicy;
        }

        @Override
        public final java.lang.Number getMaxSize() {
            return this.maxSize;
        }

        @Override
        public final java.lang.Number getMinSize() {
            return this.minSize;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.util.List<java.lang.String> getVpcSubnets() {
            return this.vpcSubnets;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("gameServerGroupName", om.valueToTree(this.getGameServerGroupName()));
            data.set("instanceDefinitions", om.valueToTree(this.getInstanceDefinitions()));
            data.set("launchTemplate", om.valueToTree(this.getLaunchTemplate()));
            data.set("roleArn", om.valueToTree(this.getRoleArn()));
            if (this.getAutoScalingPolicy() != null) {
                data.set("autoScalingPolicy", om.valueToTree(this.getAutoScalingPolicy()));
            }
            if (this.getBalancingStrategy() != null) {
                data.set("balancingStrategy", om.valueToTree(this.getBalancingStrategy()));
            }
            if (this.getDeleteOption() != null) {
                data.set("deleteOption", om.valueToTree(this.getDeleteOption()));
            }
            if (this.getGameServerProtectionPolicy() != null) {
                data.set("gameServerProtectionPolicy", om.valueToTree(this.getGameServerProtectionPolicy()));
            }
            if (this.getMaxSize() != null) {
                data.set("maxSize", om.valueToTree(this.getMaxSize()));
            }
            if (this.getMinSize() != null) {
                data.set("minSize", om.valueToTree(this.getMinSize()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getVpcSubnets() != null) {
                data.set("vpcSubnets", om.valueToTree(this.getVpcSubnets()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_gamelift.CfnGameServerGroupProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnGameServerGroupProps.Jsii$Proxy that = (CfnGameServerGroupProps.Jsii$Proxy) o;

            if (!gameServerGroupName.equals(that.gameServerGroupName)) return false;
            if (!instanceDefinitions.equals(that.instanceDefinitions)) return false;
            if (!launchTemplate.equals(that.launchTemplate)) return false;
            if (!roleArn.equals(that.roleArn)) return false;
            if (this.autoScalingPolicy != null ? !this.autoScalingPolicy.equals(that.autoScalingPolicy) : that.autoScalingPolicy != null) return false;
            if (this.balancingStrategy != null ? !this.balancingStrategy.equals(that.balancingStrategy) : that.balancingStrategy != null) return false;
            if (this.deleteOption != null ? !this.deleteOption.equals(that.deleteOption) : that.deleteOption != null) return false;
            if (this.gameServerProtectionPolicy != null ? !this.gameServerProtectionPolicy.equals(that.gameServerProtectionPolicy) : that.gameServerProtectionPolicy != null) return false;
            if (this.maxSize != null ? !this.maxSize.equals(that.maxSize) : that.maxSize != null) return false;
            if (this.minSize != null ? !this.minSize.equals(that.minSize) : that.minSize != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.vpcSubnets != null ? this.vpcSubnets.equals(that.vpcSubnets) : that.vpcSubnets == null;
        }

        @Override
        public final int hashCode() {
            int result = this.gameServerGroupName.hashCode();
            result = 31 * result + (this.instanceDefinitions.hashCode());
            result = 31 * result + (this.launchTemplate.hashCode());
            result = 31 * result + (this.roleArn.hashCode());
            result = 31 * result + (this.autoScalingPolicy != null ? this.autoScalingPolicy.hashCode() : 0);
            result = 31 * result + (this.balancingStrategy != null ? this.balancingStrategy.hashCode() : 0);
            result = 31 * result + (this.deleteOption != null ? this.deleteOption.hashCode() : 0);
            result = 31 * result + (this.gameServerProtectionPolicy != null ? this.gameServerProtectionPolicy.hashCode() : 0);
            result = 31 * result + (this.maxSize != null ? this.maxSize.hashCode() : 0);
            result = 31 * result + (this.minSize != null ? this.minSize.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.vpcSubnets != null ? this.vpcSubnets.hashCode() : 0);
            return result;
        }
    }
}
